/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class IconManager {
    private HashMap written = null;
    private File directory = null;
    private int nextId = 1;

    public IconManager(File base) {
        this.directory = base;
    }

    public String getIcon(Image icon) {
        String name;
        if (this.written == null) {
            this.written = new HashMap(50);
        }
        if ((name = (String)this.written.get(icon)) == null) {
            BufferedImage image = IconManager.toBufferedImage(icon);
            File output = null;
            while ((output = new File(this.directory, name = "tasklist-html-" + this.nextId++ + ".png")).exists()) {
            }
            try {
                ImageIO.write((RenderedImage)image, "png", output);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            this.written.put(icon, name);
        }
        return name;
    }

    private static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = true;
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }
}

