/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import org.netbeans.api.debugger.jpda.JPDABreakpoint;

public class LineBreakpoint
extends JPDABreakpoint {
    public static final String PROP_LINE_NUMBER = new String("lineNumber");
    public static final String PROP_URL = new String("url");
    public static final String PROP_CONDITION = new String("condition");
    public static final String PROP_SOURCE_NAME = new String("sourceName");
    public static final String PROP_SOURCE_PATH = new String("sourcePath");
    public static final String PROP_STRATUM = new String("stratum");
    private String url = "";
    private int lineNumber;
    private String condition = "";
    private String sourceName = null;
    private String sourcePath = null;
    private String stratum = "Java";

    private LineBreakpoint() {
    }

    public static LineBreakpoint create(String url, int lineNumber) {
        LineBreakpointImpl b = new LineBreakpointImpl();
        b.setURL(url);
        b.setLineNumber(lineNumber);
        return b;
    }

    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String url) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (url == null) {
                url = "";
            }
            if (url == this.url || url != null && this.url != null && url.equals(this.url)) {
                return;
            }
            old = url;
            this.url = url;
        }
        this.firePropertyChange(PROP_URL, old, url);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLineNumber(int ln) {
        int old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (ln == this.lineNumber) {
                return;
            }
            old = this.lineNumber;
            this.lineNumber = ln;
        }
        this.firePropertyChange(PROP_LINE_NUMBER, new Integer(old), new Integer(ln));
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCondition(String c) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (c == null) {
                c = "";
            }
            if ((c = c.trim()) == this.condition || c != null && this.condition != null && this.condition.equals(c)) {
                return;
            }
            old = this.condition;
            this.condition = c;
        }
        this.firePropertyChange(PROP_CONDITION, old, c);
    }

    public String getStratum() {
        return this.stratum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStratum(String s) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (s == null) {
                s = "";
            }
            if ((s = s.trim()) == this.stratum || s != null && this.stratum != null && this.stratum.equals(s)) {
                return;
            }
            old = this.stratum;
            this.stratum = s;
        }
        this.firePropertyChange(PROP_CONDITION, old, s);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceName(String sn) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (sn != null) {
                sn = sn.trim();
            }
            if (sn == this.sourceName || sn != null && this.sourceName != null && this.sourceName.equals(sn)) {
                return;
            }
            old = this.sourceName;
            this.sourceName = sn;
        }
        this.firePropertyChange(PROP_SOURCE_NAME, old, sn);
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourcePath(String sp) {
        String old;
        LineBreakpoint lineBreakpoint = this;
        synchronized (lineBreakpoint) {
            if (sp != null) {
                sp = sp.trim();
            }
            if (sp == this.sourcePath || sp != null && sp.equals(this.sourcePath)) {
                return;
            }
            old = this.sourcePath;
            this.sourcePath = sp;
        }
        this.firePropertyChange(PROP_SOURCE_PATH, old, sp);
    }

    public String toString() {
        return "LineBreakpoint " + this.url + " : " + this.lineNumber;
    }

    private static class LineBreakpointImpl
    extends LineBreakpoint
    implements Comparable {
        public int compareTo(Object o) {
            if (o instanceof LineBreakpointImpl) {
                LineBreakpointImpl lbthis = this;
                LineBreakpoint lb = (LineBreakpoint)((Object)o);
                int uc = ((LineBreakpoint)lbthis).url.compareTo(lb.url);
                if (uc != 0) {
                    return uc;
                }
                return ((LineBreakpoint)lbthis).lineNumber - lb.lineNumber;
            }
            return -1;
        }
    }
}

