/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.debug.actions.MainProjectManager;
import org.netbeans.modules.web.debug.breakpoints.JspLineBreakpoint;
import org.netbeans.modules.web.debug.util.Utils;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.project.ActionProvider;
import org.openide.windows.TopComponent;

public class JspRunToCursorActionProvider
extends ActionsProviderSupport {
    private EditorContext editorContext = (EditorContext)DebuggerManager.getDebuggerManager().lookupFirst(null, EditorContext.class);
    private JspLineBreakpoint breakpoint;

    public JspRunToCursorActionProvider() {
        Listener listener = new Listener();
        MainProjectManager.getDefault().addPropertyChangeListener(listener);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)listener);
        DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)listener);
        this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, this.shouldBeEnabled());
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_TO_CURSOR);
    }

    public void doAction(Object action) {
        this.removeBreakpoint();
        this.createBreakpoint();
        ((ActionProvider)MainProjectManager.getDefault().getMainProject().getLookup().lookup(ActionProvider.class)).invokeAction("debug", MainProjectManager.getDefault().getMainProject().getLookup());
    }

    private boolean shouldBeEnabled() {
        int i;
        if (this.editorContext == null || !Utils.isJsp(this.editorContext.getCurrentURL())) {
            return false;
        }
        Project p = MainProjectManager.getDefault().getMainProject();
        if (p == null) {
            return false;
        }
        ActionProvider actionProvider = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] sa = actionProvider.getSupportedActions();
        int k = sa.length;
        for (i = 0; i < k && !"debug".equals(sa[i]); ++i) {
        }
        if (i == k) {
            return false;
        }
        return ((ActionProvider)p.getLookup().lookup(ActionProvider.class)).isActionEnabled("debug", p.getLookup());
    }

    private void createBreakpoint() {
        this.breakpoint = JspLineBreakpoint.create(this.editorContext.getCurrentURL(), this.editorContext.getCurrentLineNumber());
        this.breakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
    }

    private void removeBreakpoint() {
        if (this.breakpoint != null) {
            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)this.breakpoint);
            this.breakpoint = null;
        }
    }

    private class Listener
    implements PropertyChangeListener,
    DebuggerManagerListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e == null || "opened".equals(e.getPropertyName())) {
                return;
            }
            if (e.getPropertyName() == "state") {
                int state = (Integer)e.getNewValue();
                if (state == 4 || state == 3) {
                    JspRunToCursorActionProvider.this.removeBreakpoint();
                }
                return;
            }
            JspRunToCursorActionProvider.this.setEnabled(ActionsManager.ACTION_RUN_TO_CURSOR, JspRunToCursorActionProvider.this.shouldBeEnabled());
        }

        public void sessionRemoved(Session session) {
            JspRunToCursorActionProvider.this.removeBreakpoint();
        }

        public void breakpointAdded(Breakpoint breakpoint) {
        }

        public void breakpointRemoved(Breakpoint breakpoint) {
        }

        public Breakpoint[] initBreakpoints() {
            return new Breakpoint[0];
        }

        public void initWatches() {
        }

        public void sessionAdded(Session session) {
        }

        public void watchAdded(Watch watch) {
        }

        public void watchRemoved(Watch watch) {
        }

        public void engineAdded(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        }

        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
        }
    }
}

