/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.sun.api.Asenv;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.ide.Installer;
import org.netbeans.modules.j2ee.sun.ide.editors.CharsetDisplayPreferenceEditor;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Constants;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.netbeans.modules.j2ee.sun.share.CharsetMapping;
import org.netbeans.modules.j2ee.sun.share.SecurityMasterListModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PluginProperties {
    Logger jsr88Logger = Logger.getLogger("com.sun.enterprise.tools.jsr88.spi");
    private String[] userList = new String[0];
    private String logLevel = null;
    private boolean incrementalDeployPossible = true;
    private FileObject propertiesFile = null;
    private static final String PLUGIN_PROPERTIES_VERSION = "version";
    private static final String PLUGIN_CURRENT_VERSION = "5.5";
    private static final String INCREMENTAL = "incrementalDeploy";
    private static final String PRINCIPAL_PREFIX = "principalEntry.";
    private static final String GROUP_PREFIX = "groupEntry.";
    private static final String LOG_LEVEL_KEY = "logLevel";
    private static final String CHARSET_DISP_PREF_KEY = "charsetDisplayPreference";
    public static final String INSTALL_ROOT_PROP_NAME = "com.sun.aas.installRoot";
    public static String COBUNDLE_DEFAULT_INSTALL_PATH = "AS9.0";
    public static String COBUNDLE_DEFAULT_INSTALL_PATH2 = "AS8.2";
    private static PluginProperties thePluginProperties = null;
    private String ideHomeLocation = new File(Installer.ideHomeLocation).getParentFile().getAbsolutePath();
    private File rootInstallCandidate = null;
    private static Collection fileColl = new ArrayList();

    public static PluginProperties getDefault() {
        if (thePluginProperties == null) {
            thePluginProperties = new PluginProperties();
        }
        return thePluginProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginProperties() {
        InputStream inStream = null;
        try {
            try {
                this.propertiesFile = this.getPropertiesFile();
                if (null != this.propertiesFile) {
                    inStream = this.propertiesFile.getInputStream();
                }
            }
            catch (FileNotFoundException fnfe) {
                Constants.pluginLogger.info(NbBundle.getMessage(PluginProperties.class, (String)"INFO_NO_PROPERTY_FILE"));
            }
            catch (IOException ioe) {
                Constants.pluginLogger.info(NbBundle.getMessage(PluginProperties.class, (String)"ERR_READING_PROPERTIES"));
                Constants.pluginLogger.throwing(PluginProperties.class.getName(), "<init>", ioe);
            }
            finally {
                Properties inProps = new Properties();
                if (null != inStream) {
                    inProps.load(inStream);
                    inStream.close();
                }
                this.loadPluginProperties(inProps);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private FileObject getPropertiesFile() throws IOException {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject dir = fs.findResource("J2EE");
        FileObject retVal = null;
        if (null != dir && null == (retVal = dir.getFileObject("platform", "properties"))) {
            retVal = dir.createData("platform", "properties");
        }
        return retVal;
    }

    void loadPluginProperties(Properties inProps) {
        File platformRoot;
        this.logLevel = inProps.getProperty(LOG_LEVEL_KEY, Level.OFF.toString());
        String[] inputUsers = PluginProperties.getArrayPropertyValue(inProps, PRINCIPAL_PREFIX);
        String[] inputGroups = PluginProperties.getArrayPropertyValue(inProps, GROUP_PREFIX);
        this.setCharsetDisplayPreferenceStatic(Integer.valueOf(inProps.getProperty(CHARSET_DISP_PREF_KEY, "1")));
        String b = inProps.getProperty(INCREMENTAL, "true");
        this.incrementalDeployPossible = b.equals("true");
        String version = inProps.getProperty(PLUGIN_PROPERTIES_VERSION);
        boolean needToRegisterDefaultServer = false;
        this.rootInstallCandidate = new File(PluginProperties.getDefaultInstallRoot());
        if (version == null || version != PLUGIN_CURRENT_VERSION) {
            needToRegisterDefaultServer = true;
        }
        if (needToRegisterDefaultServer && PluginProperties.isGoodAppServerLocation(platformRoot = new File(PluginProperties.getDefaultInstallRoot()))) {
            PluginProperties.registerDefaultDomain(platformRoot);
            this.saveProperties();
        }
        this.setUserListStatic(inputUsers);
        this.setGroupListStatic(inputGroups);
        Constants.pluginLogger.setLevel(Level.ALL);
        this.jsr88Logger.setLevel(Level.ALL);
        Level parsed = null;
        try {
            parsed = Level.parse(this.logLevel);
            this.jsr88Logger.setLevel(parsed);
            Constants.pluginLogger.setLevel(parsed);
            Constants.pluginLogger.log(parsed, this.logLevel);
            this.jsr88Logger.log(parsed, this.logLevel);
        }
        catch (IllegalArgumentException iae) {
            this.logLevel = Level.ALL.toString();
            Constants.pluginLogger.severe(NbBundle.getMessage(PluginProperties.class, (String)"ERR_ILLEGAL_LEVEL_VALUE"));
        }
    }

    public static void configureDefaultServerInstance() {
        PluginProperties.getDefault();
    }

    public void setIncrementalDeploy(Boolean b) {
        this.incrementalDeployPossible = b;
        this.saveProperties();
    }

    public Boolean getIncrementalDeploy() {
        return new Boolean(this.incrementalDeployPossible);
    }

    public boolean isIncrementalDeploy() {
        return this.incrementalDeployPossible;
    }

    public String[] getUserList() {
        SecurityMasterListModel pModel = SecurityMasterListModel.getPrincipalMasterModel();
        String[] ss = this.masterListToStringArray(pModel);
        return ss;
    }

    public String[] getGroupList() {
        SecurityMasterListModel pModel = SecurityMasterListModel.getGroupMasterModel();
        return this.masterListToStringArray(pModel);
    }

    private String[] masterListToStringArray(SecurityMasterListModel pModel) {
        int len = pModel.getRowCount();
        String[] retVal = new String[len];
        for (int i = 0; i < len; ++i) {
            String foo;
            retVal[i] = foo = pModel.getRow(i).toString();
        }
        return retVal;
    }

    public boolean setUserListStatic(String[] list) {
        SecurityMasterListModel pModel = SecurityMasterListModel.getPrincipalMasterModel();
        boolean retVal = false;
        if (!this.containsSameElements(pModel, list)) {
            this.fillMasterList(pModel, list);
            retVal = true;
        }
        return retVal;
    }

    public void setUserList(String[] list) {
        if (this.setUserListStatic(list)) {
            this.saveProperties();
        }
    }

    public boolean setGroupListStatic(String[] list) {
        SecurityMasterListModel pModel = SecurityMasterListModel.getGroupMasterModel();
        boolean retVal = false;
        if (!this.containsSameElements(pModel, list)) {
            this.fillMasterList(pModel, list);
            retVal = true;
        }
        return retVal;
    }

    public void setGroupList(String[] list) {
        if (this.setGroupListStatic(list)) {
            this.saveProperties();
        }
    }

    boolean containsSameElements(SecurityMasterListModel pModel, String[] list) {
        int len = pModel.getRowCount();
        if (len != list.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (pModel.contains((Object)list[i])) continue;
            return false;
        }
        return true;
    }

    private void fillMasterList(SecurityMasterListModel pModel, String[] values) {
        int i;
        int len = values.length;
        for (i = pModel.getRowCount() - 1; i >= 0; --i) {
            pModel.removeElementAt(i);
        }
        for (i = 0; i < len; ++i) {
            if (pModel.contains((Object)values[i])) continue;
            pModel.addElement((Object)values[i]);
        }
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String ll) {
        String oll = this.logLevel;
        if (!oll.equals(ll)) {
            Level parsed = null;
            try {
                parsed = Level.parse(ll);
                this.jsr88Logger.setLevel(parsed);
                Constants.pluginLogger.setLevel(parsed);
                Constants.pluginLogger.log(parsed, ll);
                this.jsr88Logger.log(parsed, ll);
                this.logLevel = ll;
                this.saveProperties();
            }
            catch (IllegalArgumentException iae) {
                Constants.pluginLogger.severe(NbBundle.getMessage(PluginProperties.class, (String)"ERR_ILLEGAL_LEVEL_VALUE"));
            }
        }
    }

    public Integer getCharsetDisplayPreferenceStatic() {
        return CharsetMapping.getDisplayOption();
    }

    public void setCharsetDisplayPreferenceStatic(Integer displayPreference) {
        CharsetMapping.setDisplayOption((Integer)displayPreference);
    }

    public Integer getCharsetDisplayPreference() {
        return this.getCharsetDisplayPreferenceStatic();
    }

    public void setCharsetDisplayPreference(Integer displayPreference) {
        Integer oldDisplayPreference = this.getCharsetDisplayPreferenceStatic();
        if (!displayPreference.equals(oldDisplayPreference)) {
            this.setCharsetDisplayPreferenceStatic(displayPreference);
            Integer newDisplayPreference = this.getCharsetDisplayPreferenceStatic();
            this.saveProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties() {
        block12: {
            Properties outProp = new Properties();
            outProp.setProperty(PLUGIN_PROPERTIES_VERSION, PLUGIN_CURRENT_VERSION);
            PluginProperties.setArrayPropertyValue(outProp, PRINCIPAL_PREFIX, this.getUserList());
            PluginProperties.setArrayPropertyValue(outProp, GROUP_PREFIX, this.getGroupList());
            outProp.setProperty(INCREMENTAL, "" + this.incrementalDeployPossible);
            if (!this.logLevel.equals(Level.OFF.toString())) {
                outProp.setProperty(LOG_LEVEL_KEY, this.logLevel);
            }
            if (!this.getCharsetDisplayPreferenceStatic().equals(CharsetDisplayPreferenceEditor.DEFAULT_PREF_VAL)) {
                outProp.setProperty(CHARSET_DISP_PREF_KEY, this.getCharsetDisplayPreferenceStatic().toString());
            }
            FileLock l = null;
            OutputStream outStream = null;
            try {
                if (null == this.propertiesFile) break block12;
                try {
                    l = this.propertiesFile.lock();
                    outStream = this.propertiesFile.getOutputStream(l);
                    if (null != outStream) {
                        outProp.store(outStream, "");
                    }
                }
                catch (IOException ioe) {
                    Constants.pluginLogger.severe(NbBundle.getMessage(PluginProperties.class, (String)"ERR_SAVING_PROPERTIES"));
                    Constants.pluginLogger.throwing(PluginProperties.class.toString(), "saveChange", ioe);
                }
                finally {
                    if (null != outStream) {
                        outStream.close();
                    }
                    if (null != l) {
                        l.releaseLock();
                    }
                }
            }
            catch (IOException ioe) {
                Constants.pluginLogger.throwing(PluginProperties.class.toString(), "saveChange", ioe);
            }
        }
    }

    public static String getDefaultInstallRoot() {
        File f;
        String candidate = System.getProperty(INSTALL_ROOT_PROP_NAME);
        if (null != candidate && (f = new File(candidate)).exists()) {
            return candidate;
        }
        InstalledFileLocator fff = InstalledFileLocator.getDefault();
        File ff = new File(Installer.ideHomeLocation);
        File f3 = new File(ff.getParentFile(), COBUNDLE_DEFAULT_INSTALL_PATH);
        if (f3 != null && f3.exists()) {
            return f3.getAbsolutePath();
        }
        f3 = new File(ff.getParentFile(), COBUNDLE_DEFAULT_INSTALL_PATH2);
        if (f3 != null && f3.exists()) {
            return f3.getAbsolutePath();
        }
        return "";
    }

    static boolean hasRequiredChildren(File candidate, Collection requiredChildren) {
        if (null == candidate) {
            return false;
        }
        String[] children = candidate.list();
        if (null == children) {
            return false;
        }
        if (null == requiredChildren) {
            return true;
        }
        List<String> kidsList = Arrays.asList(children);
        return kidsList.containsAll(requiredChildren);
    }

    private static boolean isGoodAppServerLocation(File candidate) {
        if (!(null != candidate && candidate.exists() && candidate.canRead() && candidate.isDirectory() && PluginProperties.hasRequiredChildren(candidate, fileColl))) {
            return false;
        }
        if (ServerLocationManager.isGlassFish((File)candidate)) {
            return true;
        }
        return true;
    }

    private static void registerDefaultDomain(File platformRoot) {
        String username = "admin";
        String password = "adminadmin";
        File f = new File(System.getProperty("user.home") + "/.asadminprefs");
        try {
            FileInputStream fis = new FileInputStream(f);
            Properties p = new Properties();
            p.load(fis);
            fis.close();
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String v = (String)e.nextElement();
                if (v.equals("AS_ADMIN_USER")) {
                    username = p.getProperty(v);
                    continue;
                }
                if (!v.equals("AS_ADMIN_PASSWORD")) continue;
                password = p.getProperty(v);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String ext = File.separatorChar == '/' ? "conf" : "bat";
        File asenv = new File(platformRoot, "config/asenv." + ext);
        Asenv asenvContent = new Asenv(asenv);
        String defDomainsDirName = asenvContent.get("AS_DEF_DOMAINS_PATH");
        File domains = new File(defDomainsDirName);
        if (domains.exists() && domains.isDirectory()) {
            File[] domainsList = domains.listFiles();
            if (domainsList == null) {
                return;
            }
            for (int i = 0; i < domainsList.length; ++i) {
                try {
                    String hp;
                    File confDir = new File(domainsList[i].getAbsolutePath() + "/config");
                    if (!confDir.exists() || !confDir.isDirectory() || !confDir.canWrite() || (hp = Util.getHostPort(domainsList[i], platformRoot)) == null) continue;
                    String dmUrl = "[" + platformRoot.getAbsolutePath() + "]" + "deployer:Sun:AppServer::" + hp;
                    String displayName = NbBundle.getMessage(PluginProperties.class, (String)"OpenIDE-Module-Name");
                    if (ServerLocationManager.isGlassFish((File)platformRoot)) {
                        displayName = displayName + " 9";
                    }
                    if (i != 0) {
                        displayName = domainsList[i].getName();
                    }
                    Repository rep = (Repository)Lookup.getDefault().lookup(Repository.class);
                    FileObject dir = rep.getDefaultFileSystem().findResource("/J2EE/InstalledServers");
                    FileObject[] instanceFOs = dir.getChildren();
                    FileObject instanceFO = null;
                    for (int j = 0; j < instanceFOs.length; ++j) {
                        if (!dmUrl.equals(instanceFOs[j].getAttribute("url"))) continue;
                        instanceFO = instanceFOs[j];
                    }
                    if (instanceFO == null) {
                        String name = FileUtil.findFreeFileName((FileObject)dir, (String)"instance", null);
                        instanceFO = dir.createData(name);
                    }
                    instanceFO.setAttribute("url", (Object)dmUrl);
                    instanceFO.setAttribute("username", (Object)username);
                    instanceFO.setAttribute("password", (Object)password);
                    instanceFO.setAttribute("displayName", (Object)displayName);
                    instanceFO.setAttribute("DOMAIN", (Object)domainsList[i].getName());
                    instanceFO.setAttribute("LOCATION", (Object)asenvContent.get("AS_DEF_DOMAINS_PATH"));
                    continue;
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
        }
    }

    private static String[] getArrayPropertyValue(Properties inProps, String prefix) {
        String[] prototype = new String[]{};
        ArrayList<String> l = new ArrayList<String>();
        int index = 0;
        String entry = null;
        do {
            entry = inProps.getProperty(prefix + index);
            ++index;
            if (null == entry) continue;
            l.add(entry);
        } while (null != entry);
        String[] retVal = l.toArray(prototype);
        return retVal;
    }

    private static void setArrayPropertyValue(Properties props, String prefix, String[] values) {
        int len = 0;
        if (null != values) {
            len = values.length;
        }
        int index = 0;
        for (int i = 0; i < len; ++i) {
            if (null == values[i]) continue;
            props.setProperty(prefix + index, values[i]);
            ++index;
        }
    }

    static {
        fileColl.add("bin");
        fileColl.add("lib");
        fileColl.add("config");
    }
}

