/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Ant;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class FixDependencies
extends Task {
    private ArrayList replaces = new ArrayList();
    private FileSet set;
    private String target;
    private String clean;
    private String ant;
    private boolean onlyChanged;
    private boolean fail;

    public Replace createReplace() {
        Replace r = new Replace();
        this.replaces.add(r);
        return r;
    }

    public FileSet createFileset() throws BuildException {
        if (this.set != null) {
            throw new BuildException("Only one file set is allowed");
        }
        this.set = new FileSet();
        return this.set;
    }

    public void setBuildTarget(String s) {
        this.target = s;
    }

    public void setCleanTarget(String s) {
        this.clean = s;
    }

    public void setAntFile(String r) {
        this.ant = r;
    }

    public void setStripOnlyChanged(boolean b) {
        this.onlyChanged = b;
    }

    public void setFailOnError(boolean b) {
        this.fail = b;
    }

    public void execute() throws BuildException {
        DirectoryScanner scan = this.set.getDirectoryScanner(this.getProject());
        File dir = scan.getBasedir();
        String[] kids = scan.getIncludedFiles();
        for (int i = 0; i < kids.length; ++i) {
            File xml = new File(dir, kids[i]);
            if (!xml.exists()) {
                throw new BuildException("File does not exist: " + xml, this.getLocation());
            }
            this.log("Fixing " + xml, 2);
            File script = null;
            Ant task = null;
            Ant cleanTask = null;
            if (this.ant != null && this.target != null) {
                task = (Ant)this.getProject().createTask("ant");
                script = FileUtils.newFileUtils().resolveFile(xml, this.ant);
                if (!script.exists()) {
                    String msg = "Skipping. Cannot find file " + this.ant + " from + " + xml;
                    if (this.fail) {
                        throw new BuildException(msg);
                    }
                    this.log(msg, 0);
                    continue;
                }
                task.setAntfile(script.getPath());
                task.setDir(script.getParentFile());
                task.setTarget(this.target);
                if (this.clean != null) {
                    cleanTask = (Ant)this.getProject().createTask("ant");
                    cleanTask.setAntfile(script.getPath());
                    cleanTask.setDir(script.getParentFile());
                    cleanTask.setTarget(this.clean);
                }
                try {
                    if (cleanTask != null) {
                        this.log("Cleaning " + this.clean + " in " + script, 2);
                        cleanTask.execute();
                    }
                    this.log("Sanity check executes " + this.target + " in " + script, 2);
                    task.execute();
                }
                catch (BuildException ex) {
                    if (this.fail) {
                        throw ex;
                    }
                    this.log("Skipping. Could not execute " + this.target + " in " + script, 0);
                    continue;
                }
            }
            try {
                boolean change = this.fix(xml);
                if (this.onlyChanged && !change) continue;
                this.simplify(xml, script, task, cleanTask);
                continue;
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex, this.getLocation());
            }
        }
    }

    private boolean fix(File file) throws IOException, BuildException {
        String stream;
        byte[] data;
        FileInputStream is;
        int s = (int)file.length();
        if (s != (is = new FileInputStream(file)).read(data = new byte[s])) {
            is.close();
            throw new BuildException("Cannot read " + file);
        }
        is.close();
        String old = stream = new String(data);
        data = null;
        for (Replace r : this.replaces) {
            int idx = stream.indexOf("<code-name-base>" + r.codeNameBase + "</code-name-base>");
            if (idx == -1) continue;
            int from = stream.lastIndexOf("<dependency>", idx);
            if (from == -1) {
                throw new BuildException("No <dependency> tag before index " + idx);
            }
            int after = stream.indexOf("</dependency>", idx);
            if (after == -1) {
                throw new BuildException("No </dependency> tag after index " + idx);
            }
            after = FixDependencies.findNonSpace(stream, after + "</dependency>".length());
            String remove = stream.substring(from, after);
            if (r.addCompileTime && remove.indexOf("compile-dependency") == -1) {
                int fromAfter = "<dependency>".length();
                int nonSpace = FixDependencies.findNonSpace(remove, fromAfter);
                String spaces = remove.substring(fromAfter, nonSpace);
                remove = remove.substring(0, fromAfter) + spaces + "<compile-dependency/>" + remove.substring(fromAfter);
            }
            StringBuffer sb = new StringBuffer();
            sb.append(stream.substring(0, from));
            for (Module m : r.modules) {
                if (stream.indexOf("<code-name-base>" + m.codeNameBase + "</code-name-base>") != -1) continue;
                int beg = remove.indexOf(r.codeNameBase);
                int aft = beg + r.codeNameBase.length();
                sb.append(remove.substring(0, beg));
                sb.append(m.codeNameBase);
                String a = remove.substring(aft);
                if (m.specVersion != null) {
                    a = a.replaceAll("<specification-version>[0-9\\.]*</specification-version>", "<specification-version>" + m.specVersion + "</specification-version>");
                }
                if (m.releaseVersion == null) {
                    a = a.replaceAll("<release-version>[0-9]*</release-version>[\n\r ]*", "");
                }
                sb.append(a);
            }
            sb.append(stream.substring(after));
            stream = sb.toString();
        }
        if (!old.equals(stream)) {
            FileWriter fw = new FileWriter(file);
            fw.write(stream);
            fw.close();
            return true;
        }
        return false;
    }

    private void simplify(File file, File script, Ant task, Ant cleanTask) throws IOException, BuildException {
        String stream;
        byte[] data;
        FileInputStream is;
        if (this.ant == null || this.target == null) {
            return;
        }
        int s = (int)file.length();
        if (s != (is = new FileInputStream(file)).read(data = new byte[s])) {
            is.close();
            throw new BuildException("Cannot read " + file);
        }
        is.close();
        String old = stream = new String(data);
        int first = -1;
        int last = -1;
        int begin = -1;
        StringBuffer success = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        while (true) {
            String result;
            int after;
            int from;
            if (cleanTask != null) {
                this.log("Cleaning " + this.clean + " in " + script, 2);
                cleanTask.execute();
            }
            if ((from = stream.indexOf("<dependency>", begin)) == -1) break;
            if (first == -1) {
                first = from;
            }
            if ((after = stream.indexOf("</dependency>", from)) == -1) {
                throw new BuildException("No </dependency> tag after index " + from);
            }
            begin = last = (after = FixDependencies.findNonSpace(stream, after + "</dependency>".length()));
            FileWriter fw = new FileWriter(file);
            fw.write(stream.substring(0, from) + stream.substring(after));
            fw.close();
            String dep = stream.substring(from, after);
            if (dep.indexOf("compile-dependency") == -1) {
                sb.append(stream.substring(from, after));
                continue;
            }
            int cnbBeg = dep.indexOf("<code-name-base>");
            int cnbEnd = dep.indexOf("</code-name-base>");
            if (cnbBeg != -1 && cnbEnd != -1) {
                dep = dep.substring(cnbBeg + "<code-name-base>".length(), cnbEnd);
            }
            try {
                this.log("Executing target " + this.target + " in " + script, 2);
                task.execute();
                result = "Ok";
                success.append(dep);
                success.append("\n");
            }
            catch (BuildException ex) {
                result = "Failure";
                sb.append(stream.substring(from, after));
            }
            this.log("Removing dependency " + dep + ": " + result, 2);
        }
        if (first != -1) {
            FileWriter fw = new FileWriter(file);
            fw.write(stream.substring(0, first) + sb.toString() + stream.substring(last));
            fw.close();
        }
        this.log("Final verification runs " + this.target + " in " + script, 2);
        task.execute();
        if (success.length() == 0) {
            this.log("No dependencies removed from " + script);
        } else {
            this.log("Removed dependencies from " + script + ":\n" + success);
        }
    }

    private static int findNonSpace(String where, int from) {
        while (from < where.length() && Character.isWhitespace(where.charAt(from))) {
            ++from;
        }
        return from;
    }

    public static final class Module {
        String codeNameBase;
        String specVersion;
        String releaseVersion;

        public void setCodeNameBase(String s) {
            this.codeNameBase = s;
        }

        public void setSpec(String s) {
            this.specVersion = s;
        }

        public void setRelease(String r) {
            this.releaseVersion = r;
        }
    }

    public static final class Replace {
        String codeNameBase;
        ArrayList modules = new ArrayList();
        boolean addCompileTime;

        public void setCodeNameBase(String s) {
            this.codeNameBase = s;
        }

        public void setAddCompileTime(boolean b) {
            this.addCompileTime = b;
        }

        public Module createModule() {
            Module m = new Module();
            this.modules.add(m);
            return m;
        }
    }
}

