/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.project.WebProjectType;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ClassPathSupport {
    private PropertyEvaluator evaluator;
    private ReferenceHelper referenceHelper;
    private AntProjectHelper antProjectHelper;
    private Set wellKnownPaths;
    private String libraryPrefix;
    private String librarySuffix;
    private String antArtifactPrefix;
    public static final String TAG_WEB_MODULE_LIBRARIES = "web-module-libraries";
    public static final String TAG_WEB_MODULE__ADDITIONAL_LIBRARIES = "web-module-additional-libraries";
    private static final String TAG_PATH_IN_WAR = "path-in-war";
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";
    private static final String LIBRARY_PREFIX = "${libs.";
    private static final String ANT_ARTIFACT_PREFIX = "${reference.";

    public ClassPathSupport(PropertyEvaluator evaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] wellKnownPaths, String libraryPrefix, String librarySuffix, String antArtifactPrefix) {
        this.evaluator = evaluator;
        this.referenceHelper = referenceHelper;
        this.antProjectHelper = antProjectHelper;
        this.wellKnownPaths = wellKnownPaths == null ? null : new HashSet<String>(Arrays.asList(wellKnownPaths));
        this.libraryPrefix = libraryPrefix;
        this.librarySuffix = librarySuffix;
        this.antArtifactPrefix = antArtifactPrefix;
    }

    public Iterator itemsIterator(String propertyValue, String webModuleLibraries) {
        return this.itemsList(propertyValue, webModuleLibraries).iterator();
    }

    public List itemsList(String propertyValue, String webModuleLibraries) {
        Map warMap = webModuleLibraries != null ? ClassPathSupport.createWarIncludesMap(this.antProjectHelper, webModuleLibraries) : new LinkedHashMap();
        String[] pe = PropertyUtils.tokenizePath((String)(propertyValue == null ? "" : propertyValue));
        ArrayList<Item> items = new ArrayList<Item>(pe.length);
        for (int i = 0; i < pe.length; ++i) {
            Item item;
            String property = WebProjectProperties.getAntPropertyName(pe[i]);
            if (this.isWellKnownPath(pe[i])) {
                item = Item.create(pe[i], Item.PATH_IN_WAR_NONE);
            } else if (this.isLibrary(pe[i])) {
                String libraryName = pe[i].substring(this.libraryPrefix.length(), pe[i].lastIndexOf(46));
                Library library = LibraryManager.getDefault().getLibrary(libraryName);
                item = library == null ? Item.createBroken(1, pe[i], (String)warMap.get(property)) : Item.create(library, pe[i], (String)warMap.get(property));
            } else if (this.isAntArtifact(pe[i])) {
                Object[] ret = this.referenceHelper.findArtifactAndLocation(pe[i]);
                if (ret[0] == null || ret[1] == null) {
                    item = Item.createBroken(2, pe[i], (String)warMap.get(property));
                } else {
                    File artifactFile;
                    AntArtifact artifact = (AntArtifact)ret[0];
                    URI uri = (URI)ret[1];
                    File usedFile = this.antProjectHelper.resolveFile(this.evaluator.evaluate(pe[i]));
                    item = usedFile.equals(artifactFile = new File(artifact.getScriptLocation().toURI().resolve(uri).normalize())) ? Item.create(artifact, uri, pe[i], (String)warMap.get(property)) : Item.createBroken(2, pe[i], (String)warMap.get(property));
                }
            } else {
                String eval = this.evaluator.evaluate(pe[i]);
                File f = null;
                if (eval != null) {
                    f = this.antProjectHelper.resolveFile(eval);
                }
                item = f == null || !f.exists() ? Item.createBroken(0, pe[i], (String)warMap.get(property)) : Item.create(f, pe[i], (String)warMap.get(property));
            }
            items.add(item);
        }
        return items;
    }

    public String[] encodeToStrings(Iterator classpath, String webModuleLibraries) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> includedLibraries = new ArrayList<String>();
        LinkedList<Item> cp = new LinkedList<Item>();
        while (classpath.hasNext()) {
            Item item = (Item)classpath.next();
            cp.add(item);
            String reference = null;
            switch (item.getType()) {
                case 0: {
                    reference = item.getReference();
                    if (item.isBroken() || reference != null) break;
                    File file = item.getFile();
                    reference = this.referenceHelper.createForeignFileReference(file, null);
                    item.setReference(reference);
                    break;
                }
                case 1: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    Library library = item.getLibrary();
                    if (reference != null || library == null) break;
                    reference = this.getLibraryReference(item);
                    item.setReference(reference);
                    break;
                }
                case 2: {
                    reference = item.getReference();
                    if (item.isBroken()) break;
                    AntArtifact artifact = item.getArtifact();
                    if (reference != null || artifact == null) break;
                    reference = this.referenceHelper.addReference(item.getArtifact(), item.getArtifactURI());
                    item.setReference(reference);
                    break;
                }
                case 3: {
                    reference = item.getReference();
                }
            }
            if (reference == null) continue;
            result.add(reference);
            if (webModuleLibraries == null) continue;
            includedLibraries.add(WebProjectProperties.getAntPropertyName(reference));
        }
        if (webModuleLibraries != null) {
            ClassPathSupport.putIncludedLibraries(includedLibraries, cp, this.antProjectHelper, webModuleLibraries);
        }
        String[] items = new String[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            items[i] = i < result.size() - 1 ? result.get(i) + ":" : (String)result.get(i);
        }
        return items;
    }

    public String getLibraryReference(Item item) {
        if (item.getType() != 1) {
            throw new IllegalArgumentException("Item must be of type LIBRARY");
        }
        return this.libraryPrefix + item.getLibrary().getName() + this.librarySuffix;
    }

    private boolean isWellKnownPath(String property) {
        return this.wellKnownPaths == null ? false : this.wellKnownPaths.contains(property);
    }

    private boolean isAntArtifact(String property) {
        return this.antArtifactPrefix == null ? false : property.startsWith(this.antArtifactPrefix);
    }

    private boolean isLibrary(String property) {
        if (this.libraryPrefix != null && property.startsWith(this.libraryPrefix)) {
            return this.librarySuffix == null ? true : property.endsWith(this.librarySuffix);
        }
        return false;
    }

    private static Map createWarIncludesMap(AntProjectHelper uh, String webModuleLibraries) {
        LinkedHashMap<String, String> warIncludesMap = new LinkedHashMap<String, String>();
        for (int idx = WebProjectType.PROJECT_CONFIGURATION_NAMESPACE_LIST.length - 1; idx >= 0; --idx) {
            Element webModuleLibs;
            String ns = WebProjectType.PROJECT_CONFIGURATION_NAMESPACE_LIST[idx];
            Element data = uh.createAuxiliaryConfiguration().getConfigurationFragment("data", ns, true);
            if (data == null || (webModuleLibs = (Element)data.getElementsByTagNameNS(ns, webModuleLibraries).item(0)) == null) continue;
            NodeList ch = webModuleLibs.getChildNodes();
            for (int i = 0; i < ch.getLength(); ++i) {
                if (ch.item(i).getNodeType() != 1) continue;
                Element library = (Element)ch.item(i);
                Node webFile = library.getElementsByTagNameNS(ns, TAG_FILE).item(0);
                NodeList pathInWarElements = library.getElementsByTagNameNS(ns, TAG_PATH_IN_WAR);
                String webFileText = ClassPathSupport.findText(webFile);
                webFileText = webFileText.substring(2, webFileText.length() - 1);
                warIncludesMap.put(webFileText, pathInWarElements.getLength() > 0 ? ClassPathSupport.findText((Element)pathInWarElements.item(0)) : Item.PATH_IN_WAR_NONE);
            }
            return warIncludesMap;
        }
        return warIncludesMap;
    }

    private static void putIncludedLibraries(List libraries, List classpath, AntProjectHelper antProjectHelper, String webModuleLibraries) {
        assert (libraries != null);
        assert (antProjectHelper != null);
        assert (webModuleLibraries != null);
        Element data = antProjectHelper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element webModuleLibs = (Element)data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", webModuleLibraries).item(0);
        if (webModuleLibs == null) {
            webModuleLibs = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", webModuleLibraries);
            data.appendChild(webModuleLibs);
        }
        while (webModuleLibs.hasChildNodes()) {
            webModuleLibs.removeChild(webModuleLibs.getChildNodes().item(0));
        }
        Iterator cp = classpath.iterator();
        Iterator i = libraries.iterator();
        while (i.hasNext()) {
            webModuleLibs.appendChild(ClassPathSupport.createLibraryElement(doc, (String)i.next(), (Item)cp.next()));
        }
        antProjectHelper.putPrimaryConfigurationData(data, true);
    }

    private static Element createLibraryElement(Document doc, String pathItem, Item item) {
        Element libraryElement = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", TAG_LIBRARY);
        ArrayList files = new ArrayList();
        ArrayList dirs = new ArrayList();
        WebProjectProperties.getFilesForItem(item, files, dirs);
        if (files.size() > 0) {
            libraryElement.setAttribute(ATTR_FILES, "" + files.size());
        }
        if (dirs.size() > 0) {
            libraryElement.setAttribute(ATTR_DIRS, "" + dirs.size());
        }
        Element webFile = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", TAG_FILE);
        libraryElement.appendChild(webFile);
        webFile.appendChild(doc.createTextNode("${" + pathItem + "}"));
        if (item.getPathInWAR() != null) {
            Element pathInWar = doc.createElementNS("http://www.netbeans.org/ns/web-project/3", TAG_PATH_IN_WAR);
            pathInWar.appendChild(doc.createTextNode(item.getPathInWAR()));
            libraryElement.appendChild(pathInWar);
        }
        return libraryElement;
    }

    private static String findText(Element parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    private static String findText(Node parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static class Item {
        public static final int TYPE_JAR = 0;
        public static final int TYPE_LIBRARY = 1;
        public static final int TYPE_ARTIFACT = 2;
        public static final int TYPE_CLASSPATH = 3;
        public static final String PATH_IN_WAR_LIB = "WEB-INF/lib";
        public static final String PATH_IN_WAR_DIR = "WEB-INF/classes";
        public static final String PATH_IN_WAR_APPLET = "";
        public static final String PATH_IN_WAR_NONE = null;
        private static final String BROKEN = "BrokenReference";
        private Object object;
        private URI artifactURI;
        private int type;
        private String property;
        private String pathInWar;
        private String raw;
        private String eval;

        private Item(int type, Object object, String raw, String eval, String property, String pathInWar) {
            this.type = type;
            this.object = object;
            if (!(object == null || type == 3 || object == BROKEN || type == 0 && object instanceof File || type == 2 && object instanceof AntArtifact || type == 1 && object instanceof Library)) {
                throw new IllegalArgumentException("invalid classpath item, type=" + type + " object type:" + object.getClass().getName());
            }
            this.raw = raw;
            this.eval = eval;
            this.property = property;
            this.pathInWar = pathInWar;
        }

        private Item(int type, Object object, String raw, String eval, URI artifactURI, String property, String pathInWar) {
            this(type, object, raw, eval, property, pathInWar);
            this.artifactURI = artifactURI;
        }

        public String getPathInWAR() {
            return this.pathInWar;
        }

        public void setPathInWAR(String pathInWar) {
            this.pathInWar = pathInWar;
        }

        public void setRaw(String raw) {
            this.raw = raw;
        }

        public String getRaw() {
            return this.raw;
        }

        public String getEvaluated() {
            return this.eval == null ? this.getRaw() : this.eval;
        }

        public static Item create(Library library, String property, String pathInWar) {
            if (library == null) {
                throw new IllegalArgumentException("library must not be null");
            }
            String libraryName = library.getName();
            return new Item(1, library, ClassPathSupport.LIBRARY_PREFIX + libraryName + ".classpath}", libraryName, property, pathInWar);
        }

        public static Item create(AntArtifact artifact, URI artifactURI, String property, String pathInWar) {
            if (artifactURI == null) {
                throw new IllegalArgumentException("artifactURI must not be null");
            }
            if (artifact == null) {
                throw new IllegalArgumentException("artifact must not be null");
            }
            return new Item(2, artifact, null, artifact.getArtifactLocations()[0].toString(), artifactURI, property, pathInWar);
        }

        public static Item create(File file, String property, String pathInWar) {
            if (file == null) {
                throw new IllegalArgumentException("file must not be null");
            }
            return new Item(0, file, null, file.getPath(), property, pathInWar);
        }

        public static Item create(String property, String pathInWar) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null");
            }
            return new Item(3, null, null, null, property, pathInWar);
        }

        public static Item createBroken(int type, String property, String pathInWar) {
            if (property == null) {
                throw new IllegalArgumentException("property must not be null in broken items");
            }
            return new Item(type, BROKEN, null, null, property, pathInWar);
        }

        public int getType() {
            return this.type;
        }

        public Library getLibrary() {
            if (this.getType() != 1) {
                throw new IllegalArgumentException("Item is not of required type - LIBRARY");
            }
            if (this.isBroken()) {
                return null;
            }
            return (Library)this.object;
        }

        public File getFile() {
            if (this.getType() != 0) {
                throw new IllegalArgumentException("Item is not of required type - JAR");
            }
            if (this.isBroken()) {
                return null;
            }
            return (File)this.object;
        }

        public AntArtifact getArtifact() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            if (this.isBroken()) {
                return null;
            }
            return (AntArtifact)this.object;
        }

        public URI getArtifactURI() {
            if (this.getType() != 2) {
                throw new IllegalArgumentException("Item is not of required type - ARTIFACT");
            }
            return this.artifactURI;
        }

        public Object getObject() {
            return this.object;
        }

        public boolean canDelete() {
            return this.getType() != 3;
        }

        public String getReference() {
            return this.property;
        }

        public void setReference(String property) {
            this.property = property;
        }

        public boolean isBroken() {
            return this.object == BROKEN;
        }

        public int hashCode() {
            int hash = this.getType();
            if (this.object == BROKEN) {
                return BROKEN.hashCode();
            }
            switch (this.getType()) {
                case 2: {
                    hash += this.getArtifact().getType().hashCode();
                    hash += this.getArtifact().getScriptLocation().hashCode();
                    hash += this.getArtifactURI().hashCode();
                    break;
                }
                case 3: {
                    hash += this.property.hashCode();
                    break;
                }
                default: {
                    hash += this.object.hashCode();
                }
            }
            return hash;
        }

        public boolean equals(Object itemObject) {
            if (!(itemObject instanceof Item)) {
                return false;
            }
            Item item = (Item)itemObject;
            if (this.getType() != item.getType()) {
                return false;
            }
            if (this.isBroken() != item.isBroken()) {
                return false;
            }
            if (this.isBroken()) {
                return this.getReference().equals(item.getReference());
            }
            switch (this.getType()) {
                case 2: {
                    if (this.getArtifact().getType() != item.getArtifact().getType()) {
                        return false;
                    }
                    if (!this.getArtifact().getScriptLocation().equals(item.getArtifact().getScriptLocation())) {
                        return false;
                    }
                    return this.getArtifactURI().equals(item.getArtifactURI());
                }
                case 3: {
                    return this.property.equals(item.property);
                }
            }
            return this.object.equals(item.object);
        }

        public String toString() {
            return "artifactURI=" + this.artifactURI + ", type=" + this.type + ", property=" + this.property + ", pathInWar=" + this.pathInWar + ", raw=" + this.raw + ", eval=" + this.eval + ", object=" + this.object;
        }
    }
}

