/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.ProjectWebModuleProvider;
import org.netbeans.modules.web.project.ProjectWebServicesSupportProvider;
import org.netbeans.modules.web.project.SourceRoots;
import org.netbeans.modules.web.project.UpdateHelper;
import org.netbeans.modules.web.project.Utils;
import org.netbeans.modules.web.project.WebActionProvider;
import org.netbeans.modules.web.project.WebContainerImpl;
import org.netbeans.modules.web.project.WebFileBuiltQuery;
import org.netbeans.modules.web.project.WebPersistenceProvider;
import org.netbeans.modules.web.project.WebProjectOperations;
import org.netbeans.modules.web.project.WebProjectWebServicesClientSupport;
import org.netbeans.modules.web.project.WebProjectWebServicesSupport;
import org.netbeans.modules.web.project.WebSharabilityQuery;
import org.netbeans.modules.web.project.WebSources;
import org.netbeans.modules.web.project.classpath.ClassPathProviderImpl;
import org.netbeans.modules.web.project.classpath.WebProjectClassPathExtender;
import org.netbeans.modules.web.project.jaxws.WebJAXWSMetadataFinder;
import org.netbeans.modules.web.project.jaxws.WebProjectJAXWSClientSupport;
import org.netbeans.modules.web.project.jaxws.WebProjectJAXWSSupport;
import org.netbeans.modules.web.project.queries.CompiledSourceForBinaryQuery;
import org.netbeans.modules.web.project.queries.JavadocForBinaryQueryImpl;
import org.netbeans.modules.web.project.queries.SourceLevelQueryImpl;
import org.netbeans.modules.web.project.queries.UnitTestForSourceQueryImpl;
import org.netbeans.modules.web.project.ui.WebPhysicalViewProvider;
import org.netbeans.modules.web.project.ui.customizer.CustomizerProviderImpl;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.web.spi.webmodule.WebModuleFactory;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.GeneratedFilesHelper;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportFactory;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportImpl;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportFactory;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportFactory;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.netbeans.modules.websvc.spi.webservices.WebServicesSupportFactory;
import org.netbeans.modules.websvc.spi.webservices.WebServicesSupportImpl;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class WebProject
implements Project,
AntProjectListener,
FileChangeListener,
PropertyChangeListener {
    private static final Icon WEB_PROJECT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/web/project/ui/resources/webProjectIcon.gif"));
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private final ProjectWebModule webModule;
    private FileObject libFolder = null;
    private CopyOnSaveSupport css;
    private WebModule apiWebModule;
    private WebProjectWebServicesSupport webProjectWebServicesSupport;
    private WebProjectWebServicesClientSupport webProjectWebServicesClientSupport;
    private WebServicesSupport apiWebServicesSupport;
    private JAXWSSupport apiJaxwsSupport;
    private WebProjectJAXWSSupport jaxwsSupport;
    private WebServicesClientSupport apiWebServicesClientSupport;
    private WebProjectJAXWSClientSupport jaxWsClientSupport;
    private JAXWSClientSupport apiJAXWSClientSupport;
    private WebContainerImpl enterpriseResourceSupport;
    private FileWatch webPagesFileWatch;
    private PropertyChangeListener j2eePlatformListener;
    private SourceRoots sourceRoots;
    private SourceRoots testRoots;
    private final UpdateHelper updateHelper;
    private final AuxiliaryConfiguration aux;
    private final WebProjectClassPathExtender classPathExtender;
    private PropertyChangeListener evalListener;
    private JaxWsModel jaxWsModel;
    private JaxWsListener jaxWsListener;
    private FileObject jaxWsFo;
    private JaxWsModel.ServiceListener jaxWsServiceListener;
    private static long brokenAlertLastTime = 0L;
    private static boolean brokenAlertShown = false;
    private static int BROKEN_ALERT_TIMEOUT = 1000;
    private static final String[] TYPES = new String[]{"java-classes", "java-main-class", "java-beans", "persistence", "oasis-XML-catalogs", "XML", "ant-script", "ant-task", "servlet-types", "web-types", "web-types-server", "web-services", "web-service-clients", "wsdl", "j2ee-types", "junit", "simple-files"};
    private static final String[] TYPES_ARCHIVE = new String[]{"deployment-descriptor", "XML"};
    private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/JSP_Servlet/JSP.jsp", "Templates/JSP_Servlet/Html.html", "Templates/JSP_Servlet/Servlet.java", "Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/WebServices/WebService.java", "Templates/WebServices/WebServiceClient", "Templates/Other/Folder"};
    private static final String[] PRIVILEGED_NAMES_EE5 = new String[]{"Templates/JSP_Servlet/JSP.jsp", "Templates/JSP_Servlet/Html.html", "Templates/JSP_Servlet/Servlet.java", "Templates/Classes/Class.java", "Templates/Classes/Package", "Templates/Persistence/Entity.java", "Templates/Persistence/RelatedCMP", "Templates/Persistence/JsfFromDB", "Templates/WebServices/WebService.java", "Templates/WebServices/WebServiceFromWSDL.java", "Templates/WebServices/WebServiceClient", "Templates/Other/Folder"};
    private static final String[] PRIVILEGED_NAMES_ARCHIVE = new String[]{"Templates/JSP_Servlet/webXml"};

    WebProject(AntProjectHelper helper) throws IOException {
        this.helper = helper;
        this.eval = this.createEvaluator();
        this.aux = helper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(helper, this.aux, this.eval);
        this.genFilesHelper = new GeneratedFilesHelper(helper);
        this.updateHelper = new UpdateHelper(this, this.helper, this.aux, this.genFilesHelper, UpdateHelper.createDefaultNotifier());
        this.webModule = new ProjectWebModule(this, this.updateHelper);
        this.apiWebModule = WebModuleFactory.createWebModule((WebModuleImplementation)this.webModule);
        this.webProjectWebServicesSupport = new WebProjectWebServicesSupport(this, helper, this.refHelper);
        this.jaxwsSupport = new WebProjectJAXWSSupport(this, helper);
        this.jaxWsClientSupport = new WebProjectJAXWSClientSupport(this);
        this.webProjectWebServicesClientSupport = new WebProjectWebServicesClientSupport(this, helper, this.refHelper);
        this.apiWebServicesSupport = WebServicesSupportFactory.createWebServicesSupport((WebServicesSupportImpl)this.webProjectWebServicesSupport);
        this.apiJaxwsSupport = JAXWSSupportFactory.createJAXWSSupport((JAXWSSupportImpl)this.jaxwsSupport);
        this.apiWebServicesClientSupport = WebServicesClientSupportFactory.createWebServicesClientSupport((WebServicesClientSupportImpl)this.webProjectWebServicesClientSupport);
        this.apiJAXWSClientSupport = JAXWSClientSupportFactory.createJAXWSClientSupport((JAXWSClientSupportImpl)this.jaxWsClientSupport);
        this.enterpriseResourceSupport = new WebContainerImpl(this, this.refHelper, helper);
        this.classPathExtender = new WebProjectClassPathExtender(this, this.updateHelper, this.evaluator(), this.refHelper);
        this.lookup = this.createLookup(this.aux);
        helper.addAntProjectListener((AntProjectListener)this);
        this.css = new CopyOnSaveSupport();
        this.webPagesFileWatch = new FileWatch("web.docbase.dir");
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public UpdateHelper getUpdateHelper() {
        return this.updateHelper;
    }

    public String toString() {
        return "WebProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        PropertyEvaluator e = this.helper.getStandardPropertyEvaluator();
        PropertyChangeListener evalListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)e);
        e.addPropertyChangeListener(evalListener);
        return e;
    }

    PropertyEvaluator evaluator() {
        return this.eval;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    private Lookup createLookup(AuxiliaryConfiguration aux) {
        SubprojectProvider spp = this.refHelper.createSubprojectProvider();
        return Lookups.fixed((Object[])new Object[]{new Info(), aux, this.helper.createCacheDirectoryProvider(), spp, new ProjectWebModuleProvider(), new ProjectWebServicesSupportProvider(), this.webModule, this.enterpriseResourceSupport, new WebActionProvider(this, this.updateHelper), new WebPhysicalViewProvider(this, this.updateHelper, this.evaluator(), spp, this.refHelper), new CustomizerProviderImpl(this, this.updateHelper, this.evaluator(), this.refHelper), new ClassPathProviderImpl(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new CompiledSourceForBinaryQuery(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new JavadocForBinaryQueryImpl(this.helper, this.evaluator()), new AntArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), new ProjectOpenedHookImpl(), new UnitTestForSourceQueryImpl(this.getSourceRoots(), this.getTestSourceRoots()), new SourceLevelQueryImpl(this.evaluator()), new WebSources(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new WebSharabilityQuery(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), new RecommendedTemplatesImpl(this.updateHelper), new WebFileBuiltQuery(this.helper, this.evaluator(), this.getSourceRoots(), this.getTestSourceRoots()), this.classPathExtender, new WebProjectOperations(this), new WebPersistenceProvider(this, this.evaluator()), new WebJAXWSMetadataFinder(this), this.getJaxWsModel()});
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        if (ev.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    String getBuildXmlName() {
        String storedName = this.helper.getStandardPropertyEvaluator().getProperty("buildfile");
        return storedName == null ? "build.xml" : storedName;
    }

    public synchronized SourceRoots getSourceRoots() {
        if (this.sourceRoots == null) {
            this.sourceRoots = new SourceRoots(this.updateHelper, this.evaluator(), this.getReferenceHelper(), "source-roots", false, "src.{0}{1}.dir");
        }
        return this.sourceRoots;
    }

    public synchronized SourceRoots getTestSourceRoots() {
        if (this.testRoots == null) {
            this.testRoots = new SourceRoots(this.updateHelper, this.evaluator(), this.getReferenceHelper(), "test-roots", true, "test.{0}{1}.dir");
        }
        return this.testRoots;
    }

    File getTestClassesDirectory() {
        String testClassesDir = this.evaluator().getProperty("build.test.classes.dir");
        if (testClassesDir == null) {
            return null;
        }
        return this.helper.resolveFile(testClassesDir);
    }

    public ProjectWebModule getWebModule() {
        return this.webModule;
    }

    public WebModule getAPIWebModule() {
        return this.apiWebModule;
    }

    WebServicesSupport getAPIWebServicesSupport() {
        return this.apiWebServicesSupport;
    }

    JAXWSSupport getAPIJAXWSSupport() {
        return this.apiJaxwsSupport;
    }

    WebServicesClientSupport getAPIWebServicesClientSupport() {
        return this.apiWebServicesClientSupport;
    }

    JAXWSClientSupport getAPIJAXWSClientSupport() {
        return this.apiJAXWSClientSupport;
    }

    public void fileAttributeChanged(FileAttributeEvent fe) {
    }

    public void fileChanged(FileEvent fe) {
    }

    public void fileDataCreated(FileEvent fe) {
        FileObject fo = fe.getFile();
        this.checkLibraryFolder(fo);
    }

    public void fileDeleted(FileEvent fe) {
    }

    public void fileFolderCreated(FileEvent fe) {
    }

    public void fileRenamed(FileRenameEvent fe) {
        FileObject fo = fe.getFile();
        this.checkLibraryFolder(fo);
    }

    public WebProjectProperties getWebProjectProperties() {
        return new WebProjectProperties(this, this.updateHelper, this.eval, this.refHelper);
    }

    private void checkLibraryFolder(FileObject fo) {
        if (!FileUtil.isArchiveFile((FileObject)fo)) {
            return;
        }
        if (fo.getParent().equals(this.libFolder)) {
            try {
                this.classPathExtender.addArchiveFile(fo);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element data = WebProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "name");
                if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                    return ((Text)nl.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setName(final String name) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element nameEl;
                Element data = WebProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "name");
                if (nl.getLength() == 1) {
                    nameEl = (Element)nl.item(0);
                    NodeList deadKids = nameEl.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameEl.removeChild(deadKids.item(0));
                    }
                } else {
                    nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/web-project/3", "name");
                    data.insertBefore(nameEl, data.getChildNodes().item(0));
                }
                nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                WebProject.this.helper.putPrimaryConfigurationData(data, true);
                return null;
            }
        });
    }

    public void registerJ2eePlatformListener(final J2eePlatform platform) {
        this.j2eePlatformListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("classpath")) {
                    ProjectManager.mutex().writeAccess(new Mutex.Action(){

                        public Object run() {
                            EditableProperties ep = WebProject.this.helper.getProperties("nbproject/private/private.properties");
                            String classpath = Utils.toClasspathString(platform.getClasspathEntries());
                            ep.setProperty("j2ee.platform.classpath", classpath);
                            WebProject.this.helper.putProperties("nbproject/private/private.properties", ep);
                            try {
                                ProjectManager.getDefault().saveProject((Project)WebProject.this);
                            }
                            catch (IOException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                            return null;
                        }
                    });
                }
            }
        };
        platform.addPropertyChangeListener(this.j2eePlatformListener);
    }

    public void unregisterJ2eePlatformListener(J2eePlatform platform) {
        if (this.j2eePlatformListener != null) {
            platform.removePropertyChangeListener(this.j2eePlatformListener);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("javac.classpath") || evt.getPropertyName().equals("war.content.additional")) {
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                public void run() {
                    if (ProjectManager.getDefault().isValid(((ProjectInformation)WebProject.this.getLookup().lookup(ProjectInformation.class)).getProject())) {
                        EditableProperties props = WebProject.this.helper.getProperties("nbproject/project.properties");
                        EditableProperties privateProps = WebProject.this.helper.getProperties("nbproject/private/private.properties");
                        ArrayList l = new ArrayList();
                        l.addAll(WebProject.this.classPathExtender.getClassPathSupport().itemsList(props.getProperty("javac.classpath"), "web-module-libraries"));
                        l.addAll(WebProject.this.classPathExtender.getClassPathSupport().itemsList(props.getProperty("war.content.additional"), "web-module-additional-libraries"));
                        WebProjectProperties.storeLibrariesLocations(l.iterator(), privateProps);
                        WebProject.this.helper.putProperties("nbproject/private/private.properties", privateProps);
                    }
                }
            });
        }
    }

    public void createJaxWsFileObject() throws IOException {
        FileObject projectDir = this.helper.getProjectDirectory();
        WSUtils.retrieveJaxWsFromResource((FileObject)projectDir);
        this.jaxWsFo = this.findJaxWsFileObject(projectDir);
        if (this.jaxWsFo != null) {
            this.jaxWsListener = new JaxWsListener();
            this.jaxWsFo.addFileChangeListener((FileChangeListener)this.jaxWsListener);
            if (this.jaxWsModel != null) {
                this.jaxWsModel.setJaxWsFile(this.jaxWsFo);
            } else {
                this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(this.jaxWsFo);
                if (this.jaxWsModel != null) {
                    this.attachServiceListener(this.jaxWsModel);
                }
            }
        }
    }

    public FileObject findJaxWsFileObject() {
        return this.findJaxWsFileObject(this.helper.getProjectDirectory());
    }

    private FileObject findJaxWsFileObject(FileObject projectDir) {
        return projectDir.getFileObject("nbproject/jax-ws.xml");
    }

    private JaxWsModel getJaxWsModel() {
        if (this.jaxWsModel == null) {
            try {
                final FileObject projectDir = this.helper.getProjectDirectory();
                this.jaxWsFo = this.findJaxWsFileObject(projectDir);
                if (this.jaxWsFo == null) {
                    this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml"));
                    this.jaxWsModel.setJaxWsFile(projectDir);
                } else {
                    this.jaxWsListener = new JaxWsListener();
                    try {
                        this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(this.jaxWsFo);
                        this.jaxWsFo.addFileChangeListener((FileChangeListener)this.jaxWsListener);
                    }
                    catch (RuntimeException ex) {
                        this.jaxWsModel = JaxWsModelProvider.getDefault().getJaxWsModel(WSUtils.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml"));
                        this.jaxWsModel.setJaxWsFile(projectDir);
                        final FileObject oldJaxWsFo = this.jaxWsFo;
                        this.jaxWsFo = null;
                        final RuntimeException exception = ex;
                        RequestProcessor.getDefault().post(new Runnable(){

                            public void run() {
                                try {
                                    WebProject.this.jaxWsFo = WSUtils.backupAndGenerateJaxWs((FileObject)projectDir, (FileObject)oldJaxWsFo, (RuntimeException)exception);
                                    if (WebProject.this.jaxWsFo != null) {
                                        WebProject.this.jaxWsModel.setJaxWsFile(WebProject.this.jaxWsFo);
                                        WebProject.this.jaxWsFo.addFileChangeListener((FileChangeListener)WebProject.this.jaxWsListener);
                                    }
                                }
                                catch (IOException ex) {
                                    ErrorManager.getDefault().log(ex.getLocalizedMessage());
                                }
                            }
                        });
                    }
                }
                if (this.jaxWsModel != null) {
                    this.attachServiceListener(this.jaxWsModel);
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return this.jaxWsModel;
    }

    private void attachServiceListener(JaxWsModel jaxWsModel) {
        this.jaxWsServiceListener = new JaxWsModel.ServiceListener(){

            public void serviceAdded(String name, String implementationClass) {
                WebProject.this.getAPIJAXWSSupport().addService(name, implementationClass, WebProject.this.isJsr109Supported() && WebProject.this.isJavaEE5(WebProject.this));
            }

            public void serviceRemoved(String name) {
                WebProject.this.getAPIJAXWSSupport().serviceFromJavaRemoved(name);
            }
        };
        jaxWsModel.addServiceListener(this.jaxWsServiceListener);
    }

    public boolean isJavaEE5(Project project) {
        return "1.5".equals(this.getAPIWebModule().getJ2eePlatformVersion());
    }

    private boolean isJsr109Supported() {
        J2eePlatform j2eePlatform;
        boolean jsr109Supported = true;
        String serverInstance = this.evaluator().getProperty("j2ee.server.instance");
        if (serverInstance != null && (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstance)) != null) {
            jsr109Supported = j2eePlatform.isToolSupported("jsr109");
        }
        return jsr109Supported;
    }

    private class JaxWsListener
    extends FileChangeAdapter {
        private JaxWsListener() {
        }

        public void fileChanged(FileEvent fe) {
            try {
                final JaxWsModel newModel = JaxWsModelProvider.getDefault().getJaxWsModel(fe.getFile());
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (WebProject.this.jaxWsModel != null && newModel != null) {
                            WebProject.this.jaxWsModel.merge(newModel);
                        }
                        try {
                            WebProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", WebProject.class.getResource("resources/build-impl.xsl"), WebProject.this.jaxWsFo, false);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class CopyOnSaveSupport
    extends FileChangeAdapter
    implements PropertyChangeListener {
        private FileObject docBase = null;

        public void initialize() throws FileStateInvalidException {
            this.docBase = WebProject.this.getWebModule().getDocumentBase();
            if (this.docBase != null) {
                this.docBase.getFileSystem().addFileChangeListener((FileChangeListener)this);
            }
            ProjectInformation info = (ProjectInformation)WebProject.this.getLookup().lookup(ProjectInformation.class);
            info.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public void cleanup() throws FileStateInvalidException {
            if (this.docBase != null) {
                this.docBase.getFileSystem().removeFileChangeListener((FileChangeListener)this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("web.docbase.dir")) {
                try {
                    this.cleanup();
                    this.initialize();
                }
                catch (FileStateInvalidException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
            }
        }

        public void fileChanged(FileEvent fe) {
            try {
                this.handleCopyFileToDestDir(fe.getFile());
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        public void fileDataCreated(FileEvent fe) {
            try {
                this.handleCopyFileToDestDir(fe.getFile());
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            try {
                FileObject fo = fe.getFile();
                FileObject docBase = WebProject.this.getWebModule().getDocumentBase();
                if (docBase != null && FileUtil.isParentOf((FileObject)docBase, (FileObject)fo)) {
                    this.handleCopyFileToDestDir(fo);
                    FileObject parent = fo.getParent();
                    String path = FileUtil.isParentOf((FileObject)docBase, (FileObject)parent) ? FileUtil.getRelativePath((FileObject)docBase, (FileObject)fo.getParent()) + "/" + fe.getName() + "." + fe.getExt() : fe.getName() + "." + fe.getExt();
                    if (!this.isSynchronizationAppropriate(path)) {
                        return;
                    }
                    this.handleDeleteFileInDestDir(path);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        public void fileDeleted(FileEvent fe) {
            try {
                FileObject fo = fe.getFile();
                FileObject docBase = WebProject.this.getWebModule().getDocumentBase();
                if (docBase != null && FileUtil.isParentOf((FileObject)docBase, (FileObject)fo)) {
                    String path = FileUtil.getRelativePath((FileObject)docBase, (FileObject)fo);
                    if (!this.isSynchronizationAppropriate(path)) {
                        return;
                    }
                    this.handleDeleteFileInDestDir(path);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }

        private boolean isSynchronizationAppropriate(String filePath) {
            if (filePath.startsWith("WEB-INF/classes")) {
                return false;
            }
            if (filePath.startsWith("WEB-INF/src")) {
                return false;
            }
            return !filePath.startsWith("WEB-INF/lib");
        }

        private void handleDeleteFileInDestDir(String resourcePath) throws IOException {
            FileObject toDelete;
            FileObject webBuildBase = WebProject.this.getWebModule().getContentDirectory();
            if (webBuildBase != null && (toDelete = webBuildBase.getFileObject(resourcePath)) != null) {
                toDelete.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleCopyFileToDestDir(FileObject fo) throws IOException {
            FileObject docBase;
            if (!fo.isVirtual() && (docBase = WebProject.this.getWebModule().getDocumentBase()) != null && FileUtil.isParentOf((FileObject)docBase, (FileObject)fo)) {
                String path = FileUtil.getRelativePath((FileObject)docBase, (FileObject)fo);
                if (!this.isSynchronizationAppropriate(path)) {
                    return;
                }
                FileObject webBuildBase = WebProject.this.getWebModule().getContentDirectory();
                if (webBuildBase != null) {
                    if (FileUtil.isParentOf((FileObject)docBase, (FileObject)webBuildBase) || FileUtil.isParentOf((FileObject)webBuildBase, (FileObject)docBase)) {
                        return;
                    }
                    FileObject destFile = this.ensureDestinationFileExists(webBuildBase, path, fo.isFolder());
                    if (!fo.isFolder()) {
                        InputStream is = null;
                        OutputStream os = null;
                        FileLock fl = null;
                        try {
                            is = fo.getInputStream();
                            fl = destFile.lock();
                            os = destFile.getOutputStream(fl);
                            FileUtil.copy((InputStream)is, (OutputStream)os);
                        }
                        finally {
                            if (is != null) {
                                is.close();
                            }
                            if (os != null) {
                                os.close();
                            }
                            if (fl != null) {
                                fl.releaseLock();
                            }
                        }
                    }
                }
            }
        }

        private FileObject ensureDestinationFileExists(FileObject webBuildBase, String path, boolean isFolder) throws IOException {
            FileObject current = webBuildBase;
            StringTokenizer st = new StringTokenizer(path, "/");
            while (st.hasMoreTokens()) {
                String pathItem = st.nextToken();
                FileObject newCurrent = current.getFileObject(pathItem);
                if (newCurrent == null) {
                    newCurrent = isFolder || st.hasMoreTokens() ? FileUtil.createFolder((FileObject)current, (String)pathItem) : FileUtil.createData((FileObject)current, (String)pathItem);
                }
                current = newCurrent;
            }
            return current;
        }
    }

    private final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private UpdateHelper helper;
        private boolean isEE5 = false;
        private boolean checked = false;
        private boolean isArchive = false;

        RecommendedTemplatesImpl(UpdateHelper helper) {
            this.helper = helper;
        }

        public String[] getRecommendedTypes() {
            String[] retVal = null;
            this.checkEnvironment();
            retVal = this.isArchive ? TYPES_ARCHIVE : TYPES;
            return retVal;
        }

        public String[] getPrivilegedTemplates() {
            String[] retVal = null;
            this.checkEnvironment();
            retVal = this.isArchive ? PRIVILEGED_NAMES_ARCHIVE : (this.isEE5 ? PRIVILEGED_NAMES_EE5 : PRIVILEGED_NAMES);
            return retVal;
        }

        private void checkEnvironment() {
            if (!this.checked) {
                String srcType = this.helper.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("java.source.based");
                if ("false".equals(srcType)) {
                    this.isArchive = true;
                }
                this.isEE5 = "1.5".equals(WebProject.this.getAPIWebModule().getJ2eePlatformVersion());
                this.checked = true;
            }
        }
    }

    private final class AntArtifactProviderImpl
    implements AntArtifactProvider {
        private AntArtifactProviderImpl() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{WebProject.this.helper.createSimpleAntArtifact("war", "dist.war", WebProject.this.evaluator(), "dist", "clean"), WebProject.this.helper.createSimpleAntArtifact("j2ee_ear_archive", "dist.ear.war", WebProject.this.evaluator(), "dist-ear", "clean-ear")};
        }
    }

    final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            WebPhysicalViewProvider physicalViewProvider;
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    EditableProperties ep = WebProject.this.updateHelper.getProperties("nbproject/private/private.properties");
                    File buildProperties = new File(System.getProperty("netbeans.user"), "build.properties");
                    ep.setProperty("user.properties.file", buildProperties.getAbsolutePath());
                    EditableProperties props = WebProject.this.updateHelper.getProperties("nbproject/project.properties");
                    if (props.getProperty("war.package") == null) {
                        props.setProperty("war.package", "true");
                    }
                    ArrayList l = new ArrayList();
                    l.addAll(WebProject.this.classPathExtender.getClassPathSupport().itemsList(props.getProperty("javac.classpath"), "web-module-libraries"));
                    l.addAll(WebProject.this.classPathExtender.getClassPathSupport().itemsList(props.getProperty("war.content.additional"), "web-module-additional-libraries"));
                    WebProjectProperties.storeLibrariesLocations(l.iterator(), ep);
                    WebProject.this.updateHelper.putProperties("nbproject/private/private.properties", ep);
                    WebProject.this.updateHelper.putProperties("nbproject/project.properties", props);
                    try {
                        ProjectManager.getDefault().saveProject((Project)WebProject.this);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                    return null;
                }
            });
            try {
                String libFolderName = WebProject.this.helper.getStandardPropertyEvaluator().getProperty("lib.dir");
                try {
                    FileObject ddFO = WebProject.this.webModule.getDeploymentDescriptor();
                    if (ddFO != null) {
                        DataObject dobj = DataObject.find((FileObject)ddFO);
                    }
                }
                catch (DataObjectNotFoundException ex) {
                    // empty catch block
                }
                if (libFolderName != null && WebProject.this.helper.resolveFile(libFolderName).isDirectory()) {
                    WebProject.this.libFolder = WebProject.this.helper.resolveFileObject(libFolderName);
                    FileObject[] children = WebProject.this.libFolder.getChildren();
                    LinkedList<FileObject> libs = new LinkedList<FileObject>();
                    for (int i = 0; i < children.length; ++i) {
                        if (!FileUtil.isArchiveFile((FileObject)children[i])) continue;
                        libs.add(children[i]);
                    }
                    FileObject[] libsArray = new FileObject[libs.size()];
                    libs.toArray(libsArray);
                    WebProject.this.classPathExtender.addArchiveFiles("javac.classpath", libsArray, "web-module-libraries");
                    WebProject.this.libFolder.addFileChangeListener((FileChangeListener)WebProject.this);
                }
                WebProject.this.css.initialize();
                if (WebProject.this.updateHelper.isCurrent()) {
                    int flags = WebProject.this.genFilesHelper.getBuildScriptState("nbproject/build-impl.xml", WebProject.class.getResource("resources/build-impl.xsl"), WebProject.this.jaxWsFo);
                    if ((flags & 4) != 0 && (flags & 0x48) != 0) {
                        JButton updateOption = new JButton(NbBundle.getMessage(WebProject.class, (String)"CTL_Regenerate"));
                        if (DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(WebProject.class, (String)"TXT_BuildImplRegenerate"), NbBundle.getMessage(WebProject.class, (String)"TXT_BuildImplRegenerateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption) {
                            WebProject.this.genFilesHelper.generateBuildScriptFromStylesheet("nbproject/build-impl.xml", WebProject.class.getResource("resources/build-impl.xsl"), WebProject.this.jaxWsFo);
                        }
                    } else {
                        WebProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", WebProject.class.getResource("resources/build-impl.xsl"), WebProject.this.jaxWsFo, true);
                    }
                    WebProject.this.genFilesHelper.refreshBuildScript(WebProject.this.getBuildXmlName(), WebProject.class.getResource("resources/build.xsl"), WebProject.this.jaxWsFo, true);
                    WebProjectProperties wpp = WebProject.this.getWebProjectProperties();
                    String servInstID = (String)wpp.get("j2ee.server.instance");
                    J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(servInstID);
                    if (platform != null) {
                        WebProjectProperties.setServerInstance(WebProject.this, WebProject.this.updateHelper, servInstID);
                    } else {
                        String[] servInstIDs;
                        String serverType = (String)wpp.get("j2ee.server.type");
                        if (serverType != null && (servInstIDs = Deployment.getDefault().getInstancesOfServer(serverType)).length > 0) {
                            WebProjectProperties.setServerInstance(WebProject.this, WebProject.this.updateHelper, servInstIDs[0]);
                            platform = Deployment.getDefault().getJ2eePlatform(servInstIDs[0]);
                        }
                        if (platform == null) {
                            BrokenServerSupport.showAlert();
                        }
                    }
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)WebProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().register("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().register("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
            GlobalPathRegistry.getDefault().register("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
            WebProject.this.webModule.getConfigSupport().ensureConfigurationReady();
            String ctxRoot = WebProject.this.webModule.getContextPath();
            if (ctxRoot == null) {
                String sysName = WebProject.this.getProjectDirectory().getName();
                sysName = Utils.createDefaultContext(sysName);
                WebProject.this.webModule.setContextPath(sysName);
            }
            if ((physicalViewProvider = (WebPhysicalViewProvider)WebProject.this.getLookup().lookup(WebPhysicalViewProvider.class)) != null && physicalViewProvider.hasBrokenLinks()) {
                BrokenReferencesSupport.showAlert();
            }
            WebProject.this.webPagesFileWatch.init();
            if (WebProject.this.getWebProjectProperties().get("jsf.pagebean.package") != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebProject.class, (String)"MSG_Creator_Project"), 2));
                    }
                });
            }
        }

        protected void projectClosed() {
            WebProject.this.webPagesFileWatch.reset();
            WebProjectProperties wpp = WebProject.this.getWebProjectProperties();
            String servInstID = (String)wpp.get("j2ee.server.instance");
            J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(servInstID);
            if (platform != null) {
                WebProject.this.unregisterJ2eePlatformListener(platform);
            }
            if (WebProject.this.evalListener != null) {
                WebProject.this.evaluator().removePropertyChangeListener(WebProject.this.evalListener);
            }
            if (WebProject.this.jaxWsFo != null) {
                WebProject.this.jaxWsFo.removeFileChangeListener((FileChangeListener)WebProject.this.jaxWsListener);
            }
            if (WebProject.this.jaxWsModel != null) {
                WebProject.this.jaxWsModel.removeServiceListener(WebProject.this.jaxWsServiceListener);
            }
            try {
                ProjectManager.getDefault().saveProject((Project)WebProject.this);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
            try {
                WebProject.this.css.cleanup();
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            ClassPathProviderImpl cpProvider = (ClassPathProviderImpl)WebProject.this.lookup.lookup(ClassPathProviderImpl.class);
            GlobalPathRegistry.getDefault().unregister("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
            GlobalPathRegistry.getDefault().unregister("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
            GlobalPathRegistry.getDefault().unregister("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
            int flags = WebProject.this.genFilesHelper.getBuildScriptState("nbproject/build-impl.xml", WebProject.class.getResource("resources/build-impl.xsl"), WebProject.this.jaxWsFo);
            if ((flags & 4) != 0) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        JButton updateOption = new JButton(NbBundle.getMessage(WebProject.class, (String)"CTL_Regenerate"));
                        if (DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(WebProject.class, (String)"TXT_BuildImplRegenerate"), NbBundle.getMessage(WebProject.class, (String)"TXT_BuildImplRegenerateTitle"), -1, 2, new Object[]{updateOption, NotifyDescriptor.CANCEL_OPTION}, (Object)updateOption)) == updateOption) {
                            try {
                                WebProject.this.genFilesHelper.generateBuildScriptFromStylesheet("nbproject/build-impl.xml", WebProject.class.getResource("resources/build-impl.xsl"), WebProject.this.jaxWsFo);
                            }
                            catch (IOException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                            catch (IllegalStateException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                        }
                    }
                });
            } else {
                WebProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", WebProject.class.getResource("resources/build-impl.xsl"), WebProject.this.jaxWsFo, false);
            }
            WebProject.this.genFilesHelper.refreshBuildScript(WebProject.this.getBuildXmlName(), WebProject.class.getResource("resources/build.xsl"), WebProject.this.jaxWsFo, false);
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String prop) {
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            return WebProject.this.getName();
        }

        public String getDisplayName() {
            return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

                public Object run() {
                    Element data = WebProject.this.updateHelper.getPrimaryConfigurationData(true);
                    NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/web-project/3", "name");
                    if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                        return ((Text)nl.item(0)).getNodeValue();
                    }
                    return "???";
                }
            });
        }

        public Icon getIcon() {
            return WEB_PROJECT_ICON;
        }

        public Project getProject() {
            return WebProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    private class FileWatch
    implements AntProjectListener,
    FileChangeListener {
        private String propertyName;
        private FileObject fileObject = null;
        private boolean watchRename = false;

        public FileWatch(String property) {
            this.propertyName = property;
        }

        public void init() {
            WebProject.this.helper.addAntProjectListener((AntProjectListener)this);
            this.updateFileChangeListener();
        }

        public void reset() {
            WebProject.this.helper.removeAntProjectListener((AntProjectListener)this);
            this.setFileObject(null);
        }

        public void updateFileChangeListener() {
            FileObject fo = null;
            String propertyValue = WebProject.this.helper.getStandardPropertyEvaluator().getProperty(this.propertyName);
            if (propertyValue != null) {
                String resolvedPath = WebProject.this.helper.resolvePath(propertyValue);
                File resolvedFile = new File(resolvedPath).getAbsoluteFile();
                if (resolvedFile != null) {
                    File f;
                    for (f = resolvedFile; f != null && (fo = FileUtil.toFileObject((File)f)) == null; f = f.getParentFile()) {
                    }
                    this.watchRename = f == resolvedFile;
                } else {
                    this.watchRename = false;
                }
            } else {
                Object resolvedFile = null;
                this.watchRename = false;
            }
            this.setFileObject(fo);
        }

        private void setFileObject(FileObject fo) {
            if (!this.isEqual(fo, this.fileObject)) {
                if (this.fileObject != null) {
                    this.fileObject.removeFileChangeListener((FileChangeListener)this);
                }
                this.fileObject = fo;
                if (this.fileObject != null) {
                    this.fileObject.addFileChangeListener((FileChangeListener)this);
                }
            }
        }

        private boolean isEqual(Object object1, Object object2) {
            if (object1 == object2) {
                return true;
            }
            if (object1 == null) {
                return false;
            }
            return object1.equals(object2);
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            this.updateFileChangeListener();
        }

        public void propertiesChanged(AntProjectEvent ev) {
            this.updateFileChangeListener();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.updateFileChangeListener();
        }

        public void fileDataCreated(FileEvent fe) {
            this.updateFileChangeListener();
        }

        public void fileChanged(FileEvent fe) {
            this.updateFileChangeListener();
        }

        public void fileDeleted(FileEvent fe) {
            this.updateFileChangeListener();
        }

        public void fileRenamed(FileRenameEvent fe) {
            File f;
            if (this.watchRename && this.fileObject.isValid() && (f = new File(WebProject.this.helper.getStandardPropertyEvaluator().getProperty(this.propertyName))).getName().equals(fe.getName())) {
                EditableProperties properties = new EditableProperties(true);
                properties.setProperty(this.propertyName, new File(f.getParentFile(), fe.getFile().getName()).getPath());
                Utils.updateProperties(WebProject.this.helper, "nbproject/project.properties", properties);
                WebProject.this.getWebProjectProperties().store();
            }
            this.updateFileChangeListener();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

