/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.core.ui;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditor;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.websvc.customization.multiview.WSCustomizationTopComponent;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JaxWsRefreshCookie;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizationWSEditor
implements WSEditor {
    private Stack<UndoableEdit> undoableEdits;
    private WSCustomizationTopComponent wsTopComponent;
    private boolean wsdlIsDirty;
    private boolean jaxwsDirty;
    private Definitions primaryDefinitions;
    private Map<WSDLModel, Boolean> wsdlModels = new HashMap<WSDLModel, Boolean>();

    private void saveAndRefresh(Node node, JaxWsModel jaxWsModel) {
        Collection<SaveableSectionInnerPanel> panels = this.wsTopComponent.getPanels();
        for (SaveableSectionInnerPanel panel : panels) {
            panel.save();
            if (!this.wsdlIsDirty) {
                this.wsdlIsDirty = panel.wsdlIsDirty();
            }
            if (this.jaxwsDirty) continue;
            this.jaxwsDirty = panel.jaxwsIsDirty();
        }
        try {
            if (this.wsdlIsDirty) {
                Set<WSDLModel> modelSet = this.wsdlModels.keySet();
                for (WSDLModel wsdlModel : modelSet) {
                    ModelSource ms = wsdlModel.getModelSource();
                    FileObject fo = (FileObject)ms.getLookup().lookup(FileObject.class);
                    DataObject wsdlDO = DataObject.find((FileObject)fo);
                    SaveCookie wsdlSaveCookie = (SaveCookie)wsdlDO.getCookie(SaveCookie.class);
                    if (wsdlSaveCookie == null) continue;
                    wsdlSaveCookie.save();
                }
            }
            if (this.jaxwsDirty) {
                jaxWsModel.write();
            }
            if (this.wsdlIsDirty || this.jaxwsDirty) {
                JaxWsRefreshCookie refreshCookie = (JaxWsRefreshCookie)node.getCookie(JaxWsRefreshCookie.class);
                refreshCookie.refreshService(false);
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public void save(final Node node, final JaxWsModel jaxWsModel) {
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CustomizationWSEditor.class, (String)"TXT_Refreshing"));
        handle.start(100);
        handle.switchToIndeterminate();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    CustomizationWSEditor.this.saveAndRefresh(node, jaxWsModel);
                }
                finally {
                    handle.finish();
                }
            }
        };
        RequestProcessor.getDefault().post(r);
    }

    public JComponent createWSEditorComponent(Node node, JaxWsModel jaxWsModel) {
        try {
            this.initializeModels(node);
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        this.wsTopComponent = new WSCustomizationTopComponent(node, this.getWSDLModels(), this.primaryDefinitions, jaxWsModel);
        return this.wsTopComponent;
    }

    public String getTitle() {
        return NbBundle.getMessage(CustomizationWSEditor.class, (String)"TITLE_WSDL_CUSTOMIZATION");
    }

    public Set<WSDLModel> getWSDLModels() {
        return this.wsdlModels.keySet();
    }

    private void initializeModels(Node node) throws Exception {
        if (this.wsdlModels.isEmpty()) {
            WSUndoableEditListener listener = new WSUndoableEditListener();
            WSDLModel primaryModel = this.getPrimaryModel(node);
            this.populateAllModels(primaryModel);
            Set<WSDLModel> modelSet = this.wsdlModels.keySet();
            for (WSDLModel wsdlModel : modelSet) {
                wsdlModel.addUndoableEditListener((UndoableEditListener)listener);
            }
        }
    }

    private DataObject getDataObjectOfModel(WSDLModel wsdlModel) {
        ModelSource ms = wsdlModel.getModelSource();
        return (DataObject)ms.getLookup().lookup(DataObject.class);
    }

    private boolean modelExists(WSDLModel wsdlModel) {
        if (this.wsdlModels.size() == 0) {
            return false;
        }
        DataObject modelDobj = this.getDataObjectOfModel(wsdlModel);
        if (!modelDobj.isValid()) {
            return true;
        }
        Set<WSDLModel> wsdls = this.wsdlModels.keySet();
        for (WSDLModel wsdl : wsdls) {
            DataObject dobj = this.getDataObjectOfModel(wsdl);
            if (!dobj.isValid() || !modelDobj.equals(dobj)) continue;
            return true;
        }
        return false;
    }

    private void populateAllModels(WSDLModel wsdlModel) throws Exception {
        if (this.modelExists(wsdlModel)) {
            return;
        }
        DataObject dobj = this.getDataObjectOfModel(wsdlModel);
        if (!dobj.isValid()) {
            return;
        }
        Definitions definitions = wsdlModel.getDefinitions();
        if (definitions.getImports().size() == 0) {
            this.wsdlModels.put(wsdlModel, dobj.isModified());
            return;
        }
        this.wsdlModels.put(wsdlModel, dobj.isModified());
        Set<WSDLModel> modelSet = this.getImportedModels(definitions);
        for (WSDLModel wModel : modelSet) {
            this.populateAllModels(wModel);
        }
    }

    private Set<WSDLModel> getImportedModels(Definitions definitions) throws CatalogModelException {
        HashSet<WSDLModel> importedModels = new HashSet<WSDLModel>();
        Collection importedWsdls = definitions.getImports();
        for (Import importedWsdl : importedWsdls) {
            WSDLModel wsdlModel = importedWsdl.getImportedWSDLModel();
            importedModels.add(wsdlModel);
        }
        return importedModels;
    }

    private WSDLModel getPrimaryModel(Node node) throws MalformedURLException, Exception {
        JAXWSClientSupport support;
        this.undoableEdits = new Stack();
        WSDLModel model = null;
        Client client = (Client)node.getLookup().lookup(Client.class);
        Service service = (Service)node.getLookup().lookup(Service.class);
        FileObject srcRoot = (FileObject)node.getLookup().lookup(FileObject.class);
        assert (srcRoot != null);
        FileObject wsdlFO = null;
        if (client != null) {
            support = JAXWSClientSupport.getJaxWsClientSupport((FileObject)srcRoot);
            wsdlFO = support.getLocalWsdlFolderForClient(client.getName(), false).getFileObject(client.getLocalWsdlFile());
        } else if (service != null && service.getWsdlUrl() != null) {
            support = JAXWSSupport.getJAXWSSupport((FileObject)srcRoot);
            wsdlFO = support.getLocalWsdlFolderForService(service.getName(), false).getFileObject(service.getLocalWsdlFile());
        } else {
            throw new Exception("Unable to identify node type");
        }
        if (wsdlFO == null) {
            throw new Exception("WSDL file not found");
        }
        ModelSource ms = Utilities.getModelSource((FileObject)wsdlFO, (boolean)true);
        model = WSDLModelFactory.getDefault().getModel(ms);
        this.primaryDefinitions = model.getDefinitions();
        return model;
    }

    public void cancel(Node node, JaxWsModel jaxWsModel) {
        while (!this.undoableEdits.empty()) {
            UndoableEdit ue = this.undoableEdits.pop();
            ue.undo();
        }
        try {
            Set<WSDLModel> modelSet = this.wsdlModels.keySet();
            for (WSDLModel wsdlModel : modelSet) {
                ModelSource ms = wsdlModel.getModelSource();
                FileObject fo = (FileObject)ms.getLookup().lookup(FileObject.class);
                DataObject wsdlDobj = DataObject.find((FileObject)fo);
                wsdlDobj.setModified(this.wsdlModels.get(wsdlModel).booleanValue());
            }
        }
        catch (DataObjectNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    class WSUndoableEditListener
    implements UndoableEditListener {
        WSUndoableEditListener() {
        }

        public void undoableEditHappened(UndoableEditEvent e) {
            CustomizationWSEditor.this.undoableEdits.push(e.getEdit());
        }
    }
}

