/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.monitor.client.Controller;
import org.netbeans.modules.web.monitor.client.EditPanelCookies;
import org.netbeans.modules.web.monitor.client.EditPanelHeaders;
import org.netbeans.modules.web.monitor.client.EditPanelQuery;
import org.netbeans.modules.web.monitor.client.EditPanelRequest;
import org.netbeans.modules.web.monitor.client.EditPanelServer;
import org.netbeans.modules.web.monitor.client.MonitorAction;
import org.netbeans.modules.web.monitor.client.TransactionNode;
import org.netbeans.modules.web.monitor.client.Util;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class EditPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final boolean debug = false;
    private int displayType = 0;
    private static final int DISPLAY_TYPE_QUERY = 0;
    private static final int DISPLAY_TYPE_REQUEST = 1;
    private static final int DISPLAY_TYPE_COOKIES = 2;
    private static final int DISPLAY_TYPE_SERVER = 3;
    private static final int DISPLAY_TYPE_HEADERS = 4;
    private transient Dimension tabD = new Dimension(450, 280);
    private EditPanelQuery queryPanel;
    private EditPanelRequest requestPanel;
    private EditPanelCookies cookiesPanel;
    private EditPanelServer serverPanel;
    private EditPanelHeaders headersPanel;
    private MonitorData monitorData = null;
    private Dialog dialog = null;
    private DialogDescriptor editDialog = null;
    private JButton sendButton;
    private JButton okButton;
    private JButton cancelButton;
    static final String METHOD = "method";
    static final String GET = "GET";
    static final String POST = "POST";
    static final String PUT = "PUT";
    private static EditPanel instance = null;

    static void displayEditPanel(TransactionNode node) {
        MonitorData md = null;
        md = Controller.getInstance().getMonitorData(node, false, false);
        if (md == null) {
            String msg = NbBundle.getMessage((Class)EditPanel.class, (String)"MSG_NoMonitorData");
            ErrorManager.getDefault().log(1, msg);
            return;
        }
        if (md.getRequestData().getAttributeValue(METHOD).equals(POST)) {
            Util.removeParametersFromQuery(md.getRequestData());
        }
        md.getRequestData().deleteCookie("jsessionid");
        if (instance == null) {
            instance = new EditPanel();
        }
        instance.showDialog(md);
    }

    static synchronized EditPanel getInstance() {
        if (instance == null) {
            instance = new EditPanel();
        }
        return instance;
    }

    private EditPanel() {
        this.createDialogButtons();
        this.setLayout(new BoxLayout(this, 1));
        this.queryPanel = new EditPanelQuery();
        this.requestPanel = new EditPanelRequest();
        this.cookiesPanel = new EditPanelCookies();
        this.serverPanel = new EditPanelServer();
        this.headersPanel = new EditPanelHeaders();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)EditPanel.class, (String)"ACS_MON_Replay_panel"));
        JTabbedPane tabs = new JTabbedPane();
        tabs.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_Replay_tabsName"));
        tabs.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_Replay_tabsDesc"));
        tabs.setPreferredSize(this.tabD);
        tabs.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Query_Panel_Tab"), this.queryPanel);
        tabs.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Request_Panel_Tab"), this.requestPanel);
        tabs.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Cookies_Panel_Tab"), this.cookiesPanel);
        tabs.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Server_Panel_Tab"), this.serverPanel);
        tabs.addTab(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Headers_Panel_Tab"), this.headersPanel);
        tabs.addChangeListener(this);
        this.add(tabs);
        this.add(Box.createGlue());
        this.add(Box.createVerticalStrut(5));
        this.setMaximumSize(this.getPreferredSize());
    }

    void showDialog(MonitorData md) {
        this.monitorData = md;
        this.queryPanel.setData(this.monitorData);
        this.requestPanel.setData(this.monitorData);
        this.cookiesPanel.setData(this.monitorData);
        this.serverPanel.setData(this.monitorData);
        this.headersPanel.setData(this.monitorData);
        Object[] options = new Object[]{this.sendButton, this.cancelButton};
        this.editDialog = new DialogDescriptor((Object)this, NbBundle.getBundle((Class)EditPanel.class).getString("MON_EditReplay_panel"), false, options, options[0], 0, new HelpCtx("monitor_resend"), (ActionListener)this);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.editDialog);
        this.dialog.pack();
        this.dialog.show();
    }

    public void actionPerformed(ActionEvent e) {
        boolean debug = false;
        if (debug) {
            EditPanel.log("actionPerformed()");
        }
        String str = new String();
        Object value = this.editDialog.getValue();
        if (value == null) {
            return;
        }
        str = value instanceof JButton ? ((JButton)value).getText() : value.toString();
        if (str.equals(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Send"))) {
            String method;
            if (debug) {
                EditPanel.log(" got SEND");
            }
            if ((method = this.monitorData.getRequestData().getAttributeValue(METHOD)).equals(GET)) {
                Util.composeQueryString(this.monitorData.getRequestData());
            }
            try {
                MonitorAction.getController().replayTransaction(this.monitorData);
                this.dialog.dispose();
            }
            catch (UnknownHostException uhe) {
                Object[] options = new Object[]{this.okButton};
                NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)NbBundle.getMessage((Class)EditPanel.class, (String)"MON_Exec_server_wrong", (Object)this.monitorData.getServerName()), NbBundle.getBundle((Class)EditPanel.class).getString("MON_Exec_server"), -1, 1, options, options[0]);
                DialogDisplayer.getDefault().notify(noServerDialog);
                this.displayType = 3;
                this.showData();
            }
            catch (IOException ioe) {
                Object[] options = new Object[]{NbBundle.getBundle((Class)EditPanel.class).getString("MON_OK")};
                Object[] args = new Object[]{this.monitorData.getServerName(), this.monitorData.getServerPortAsString()};
                NotifyDescriptor noServerDialog = new NotifyDescriptor((Object)NbBundle.getMessage((Class)EditPanel.class, (String)"MON_Exec_server_start", (Object[])args), NbBundle.getBundle((Class)EditPanel.class).getString("MON_Exec_server"), -1, 1, options, options[0]);
                DialogDisplayer.getDefault().notify(noServerDialog);
            }
        } else if (str.equals(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Cancel"))) {
            this.dialog.dispose();
        }
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane p = (JTabbedPane)e.getSource();
        this.displayType = p.getSelectedIndex();
        this.showData();
    }

    void showData() {
        if (this.displayType == 0) {
            this.queryPanel.setData(this.monitorData);
        } else if (this.displayType == 1) {
            this.requestPanel.setData(this.monitorData);
        } else if (this.displayType == 2) {
            this.cookiesPanel.setData(this.monitorData);
        } else if (this.displayType == 3) {
            this.serverPanel.setData(this.monitorData);
        } else if (this.displayType == 4) {
            this.headersPanel.setData(this.monitorData);
        }
    }

    private void createDialogButtons() {
        this.sendButton = new JButton(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Send"));
        this.sendButton.setMnemonic(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Send_Mnemonic").charAt(0));
        this.sendButton.setToolTipText(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_SendA11yDesc"));
        this.okButton = new JButton(NbBundle.getBundle((Class)EditPanel.class).getString("MON_OK"));
        this.okButton.setMnemonic(NbBundle.getBundle((Class)EditPanel.class).getString("MON_OK_Mnemonic").charAt(0));
        this.okButton.setToolTipText(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_OKA11yDesc"));
        this.cancelButton = new JButton(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Cancel"));
        this.cancelButton.setMnemonic(NbBundle.getBundle((Class)EditPanel.class).getString("MON_Cancel_Mnemonic").charAt(0));
        this.cancelButton.setToolTipText(NbBundle.getBundle((Class)EditPanel.class).getString("ACS_MON_CancelA11yDesc"));
    }

    private Component createSeparator() {
        JPanel sep = new JPanel(){

            public float getAlignmentX() {
                return 0.0f;
            }

            public float getAlignmentY() {
                return 0.0f;
            }
        };
        sep.setMinimumSize(new Dimension(10, 10));
        return sep;
    }

    private static void log(String s) {
        System.out.println("EditPanel::" + s);
    }
}

