/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.util.List;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Lookup;
import org.netbeans.api.debugger.Session;

public final class DebuggerEngine {
    private Lookup lookup;
    private ActionsManager actionsManager;

    DebuggerEngine(String typeID, Session s, Object[] services, Lookup sessionLookup) {
        Object[] services1 = new Object[services.length + 1];
        System.arraycopy(services, 0, services1, 0, services.length);
        services1[services1.length - 1] = this;
        Lookup privateLookup = services == null ? new Lookup.MetaInf(typeID) : new Lookup.Compound(new Lookup.Instance(services1), new Lookup.MetaInf(typeID));
        this.lookup = new Lookup.Compound(privateLookup, sessionLookup);
    }

    public List lookup(String folder, Class service) {
        return this.lookup.lookup(folder, service);
    }

    public Object lookupFirst(String folder, Class service) {
        return this.lookup.lookupFirst(folder, service);
    }

    public synchronized ActionsManager getActionsManager() {
        if (this.actionsManager == null) {
            this.actionsManager = new ActionsManager(this.lookup);
        }
        return this.actionsManager;
    }

    public class Destructor {
        public void killEngine() {
            Session[] ss = DebuggerManager.getDebuggerManager().getSessions();
            int k = ss.length;
            for (int i = 0; i < k; ++i) {
                ss[i].removeEngine(DebuggerEngine.this);
            }
            DebuggerEngine.this.getActionsManager().destroy();
        }

        public void killLanguage(Session s, String language) {
            s.removeLanguage(language, DebuggerEngine.this);
            DebuggerEngine.this.getActionsManager().destroy();
        }
    }
}

