/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.wsdlmodel;

import com.sun.tools.ws.processor.model.Operation;
import com.sun.tools.ws.processor.model.Port;
import com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import com.sun.xml.ws.encoding.soap.SOAPVersion;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlPort {
    public static final String STYLE_DOCUMENT = "document";
    public static final String STYLE_RPC = "rpc";
    public static final String SOAP_VERSION_11 = "http://schemas.xmlsoap.org/wsdl/soap/http";
    public static final String SOAP_VERSION_12 = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    private Port port;

    WsdlPort(Port port) {
        this.port = port;
    }

    public Object getInternalJAXWSPort() {
        return this.port;
    }

    public List<WsdlOperation> getOperations() {
        ArrayList<WsdlOperation> wsdlOperations = new ArrayList<WsdlOperation>();
        if (this.port == null) {
            return wsdlOperations;
        }
        List operations = this.port.getOperations();
        for (Operation op : operations) {
            wsdlOperations.add(new WsdlOperation(op));
        }
        return wsdlOperations;
    }

    public String getName() {
        if (this.port == null) {
            return null;
        }
        return this.port.getName().getLocalPart();
    }

    public String getNamespaceURI() {
        return this.port.getName().getNamespaceURI();
    }

    public String getJavaName() {
        if (this.port == null) {
            return null;
        }
        return this.port.getJavaInterface().getName();
    }

    public String getPortGetter() {
        if (this.port == null) {
            return null;
        }
        return this.port.getPortGetter();
    }

    public String getSOAPVersion() {
        SOAPVersion soapVersion = this.port.getSOAPVersion();
        if (SOAPVersion.SOAP_12.equals(soapVersion)) {
            return SOAP_VERSION_12;
        }
        return SOAP_VERSION_11;
    }

    public void setSOAPVersion(String soapVersion) {
        if (SOAP_VERSION_12.equals(soapVersion)) {
            this.port.setSOAPVersion(SOAPVersion.SOAP_12);
        } else {
            this.port.setSOAPVersion(SOAPVersion.SOAP_11);
        }
    }

    public String getStyle() {
        SOAPStyle style = this.port.getStyle();
        if (SOAPStyle.DOCUMENT.equals(style)) {
            return STYLE_DOCUMENT;
        }
        if (SOAPStyle.RPC.equals(style)) {
            return STYLE_RPC;
        }
        return null;
    }

    public boolean isProvider() {
        return this.port.isProvider();
    }
}

