/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProjectUtil;
import org.netbeans.modules.j2ee.ejbjarproject.UpdateHelper;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class SourceRoots {
    public static final String PROP_ROOT_PROPERTIES = "rootProperties";
    public static final String PROP_ROOTS = "roots";
    public static final String DEFAULT_SOURCE_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_src.dir");
    public static final String DEFAULT_TEST_LABEL = NbBundle.getMessage(SourceRoots.class, (String)"NAME_test.src.dir");
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper refHelper;
    private final String elementName;
    private final String newRootNameTemplate;
    private List sourceRootProperties;
    private List sourceRootNames;
    private List sourceRoots;
    private List sourceRootURLs;
    private final PropertyChangeSupport support;
    private final ProjectMetadataListener listener;
    private final boolean isTest;
    private final File projectDir;

    SourceRoots(UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper refHelper, String elementName, boolean isTest, String newRootNameTemplate) {
        assert (helper != null && evaluator != null && refHelper != null && elementName != null && newRootNameTemplate != null);
        this.helper = helper;
        this.evaluator = evaluator;
        this.refHelper = refHelper;
        this.elementName = elementName;
        this.isTest = isTest;
        this.newRootNameTemplate = newRootNameTemplate;
        this.projectDir = FileUtil.toFile((FileObject)this.helper.getAntProjectHelper().getProjectDirectory());
        this.support = new PropertyChangeSupport(this);
        this.listener = new ProjectMetadataListener();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)this.evaluator));
        this.helper.getAntProjectHelper().addAntProjectListener((AntProjectListener)WeakListeners.create(AntProjectListener.class, (EventListener)this.listener, (Object)this.helper));
    }

    public String[] getRootNames() {
        return (String[])ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootNames == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                }
                return SourceRoots.this.sourceRootNames.toArray(new String[SourceRoots.this.sourceRootNames.size()]);
            }
        });
    }

    public String[] getRootProperties() {
        return (String[])ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                SourceRoots sourceRoots = SourceRoots.this;
                synchronized (sourceRoots) {
                    if (SourceRoots.this.sourceRootProperties == null) {
                        SourceRoots.this.readProjectMetadata();
                    }
                }
                return SourceRoots.this.sourceRootProperties.toArray(new String[SourceRoots.this.sourceRootProperties.size()]);
            }
        });
    }

    public FileObject[] getRoots() {
        return (FileObject[])ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                3 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRoots == null) {
                        String[] srcProps = SourceRoots.this.getRootProperties();
                        ArrayList<FileObject> result = new ArrayList<FileObject>();
                        for (int i = 0; i < srcProps.length; ++i) {
                            FileObject f;
                            String prop = SourceRoots.this.evaluator.getProperty(srcProps[i]);
                            if (prop == null || (f = SourceRoots.this.helper.getAntProjectHelper().resolveFileObject(prop)) == null) continue;
                            if (FileUtil.isArchiveFile((FileObject)f)) {
                                f = FileUtil.getArchiveRoot((FileObject)f);
                            }
                            result.add(f);
                        }
                        SourceRoots.this.sourceRoots = Collections.unmodifiableList(result);
                    }
                }
                return SourceRoots.this.sourceRoots.toArray(new FileObject[SourceRoots.this.sourceRoots.size()]);
            }
        });
    }

    public URL[] getRootURLs() {
        return (URL[])ProjectManager.mutex().readAccess(new Mutex.Action(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                4 var1_1 = this;
                synchronized (var1_1) {
                    if (SourceRoots.this.sourceRootURLs == null) {
                        String[] srcProps = SourceRoots.this.getRootProperties();
                        ArrayList<URL> result = new ArrayList<URL>();
                        for (int i = 0; i < srcProps.length; ++i) {
                            String prop = SourceRoots.this.evaluator.getProperty(srcProps[i]);
                            if (prop == null) continue;
                            File f = SourceRoots.this.helper.getAntProjectHelper().resolveFile(prop);
                            try {
                                result.add(EjbJarProjectUtil.getRootURL(f, null));
                                continue;
                            }
                            catch (MalformedURLException e) {
                                ErrorManager.getDefault().notify((Throwable)e);
                            }
                        }
                        SourceRoots.this.sourceRootURLs = Collections.unmodifiableList(result);
                    }
                }
                return SourceRoots.this.sourceRootURLs.toArray(new URL[SourceRoots.this.sourceRootURLs.size()]);
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void putRoots(final URL[] roots, final String[] labels) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                String[] originalProps = SourceRoots.this.getRootProperties();
                URL[] originalRoots = SourceRoots.this.getRootURLs();
                HashMap<URL, String> oldRoots2props = new HashMap<URL, String>();
                for (int i = 0; i < originalProps.length; ++i) {
                    oldRoots2props.put(originalRoots[i], originalProps[i]);
                }
                HashMap<URL, String> newRoots2lab = new HashMap<URL, String>();
                for (int i = 0; i < roots.length; ++i) {
                    newRoots2lab.put(roots[i], labels[i]);
                }
                Element cfgEl = SourceRoots.this.helper.getPrimaryConfigurationData(true);
                NodeList nl = cfgEl.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", SourceRoots.this.elementName);
                assert (nl.getLength() == 1) : "Illegal project.xml";
                Element ownerElement = (Element)nl.item(0);
                NodeList rootsNodes = ownerElement.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                while (rootsNodes.getLength() > 0) {
                    Element root = (Element)rootsNodes.item(0);
                    ownerElement.removeChild(root);
                }
                List<URL> newRoots = Arrays.asList(roots);
                HashMap propsToRemove = new HashMap(oldRoots2props);
                propsToRemove.keySet().removeAll(newRoots);
                EditableProperties props = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                for (String propName : propsToRemove.values()) {
                    props.remove((Object)propName);
                }
                SourceRoots.this.helper.putProperties("nbproject/project.properties", props);
                Document doc = ownerElement.getOwnerDocument();
                oldRoots2props.keySet().retainAll(newRoots);
                for (URL newRoot : newRoots) {
                    String rootName = (String)oldRoots2props.get(newRoot);
                    if (rootName == null) {
                        String prjPath;
                        props = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        String[] names = newRoot.getPath().split("/");
                        rootName = MessageFormat.format(SourceRoots.this.newRootNameTemplate, names[names.length - 1], "");
                        int rootIndex = 1;
                        while (props.containsKey((Object)rootName)) {
                            rootName = MessageFormat.format(SourceRoots.this.newRootNameTemplate, names[names.length - 1], new Integer(++rootIndex));
                        }
                        File f = FileUtil.normalizeFile((File)new File(URI.create(newRoot.toExternalForm())));
                        File projDir = FileUtil.toFile((FileObject)SourceRoots.this.helper.getAntProjectHelper().getProjectDirectory());
                        String path = f.getAbsolutePath();
                        if (path.startsWith(prjPath = projDir.getAbsolutePath() + File.separatorChar)) {
                            path = path.substring(prjPath.length());
                        } else {
                            path = SourceRoots.this.refHelper.createForeignFileReference(f, "java");
                            props = SourceRoots.this.helper.getProperties("nbproject/project.properties");
                        }
                        props.put((Object)rootName, (Object)path);
                        SourceRoots.this.helper.putProperties("nbproject/project.properties", props);
                    }
                    Element newRootNode = doc.createElementNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
                    newRootNode.setAttribute("id", rootName);
                    String label = (String)newRoots2lab.get(newRoot);
                    if (label != null && label.length() > 0 && !label.equals(SourceRoots.this.getRootDisplayName(null, rootName))) {
                        newRootNode.setAttribute("name", label);
                    }
                    ownerElement.appendChild(newRootNode);
                }
                SourceRoots.this.helper.putPrimaryConfigurationData(cfgEl, true);
                return null;
            }
        });
    }

    public String getRootDisplayName(String rootName, String propName) {
        if (rootName == null || rootName.length() == 0) {
            if (this.isTest && "test.src.dir".equals(propName)) {
                rootName = DEFAULT_TEST_LABEL;
            } else if (!this.isTest && "src.dir".equals(propName)) {
                rootName = DEFAULT_SOURCE_LABEL;
            } else {
                String propValue = this.evaluator.getProperty(propName);
                File sourceRoot = propValue == null ? null : this.helper.getAntProjectHelper().resolveFile(propValue);
                rootName = this.createInitialDisplayName(sourceRoot);
            }
        }
        return rootName;
    }

    public String createInitialDisplayName(File sourceRoot) {
        String pdPath;
        String srPath;
        String rootName = sourceRoot != null ? ((srPath = sourceRoot.getAbsolutePath()).startsWith(pdPath = this.projectDir.getAbsolutePath() + File.separatorChar) ? srPath.substring(pdPath.length()) : sourceRoot.getAbsolutePath()) : (this.isTest ? DEFAULT_TEST_LABEL : DEFAULT_SOURCE_LABEL);
        return rootName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetCache(boolean isXMLChange, String propName) {
        boolean fire = false;
        SourceRoots sourceRoots = this;
        synchronized (sourceRoots) {
            if (isXMLChange) {
                this.sourceRootProperties = null;
                this.sourceRootNames = null;
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                fire = true;
            } else if (propName == null || this.sourceRootProperties != null && this.sourceRootProperties.contains(propName)) {
                this.sourceRoots = null;
                this.sourceRootURLs = null;
                fire = true;
            }
        }
        if (fire) {
            if (isXMLChange) {
                this.support.firePropertyChange(PROP_ROOT_PROPERTIES, null, null);
            }
            this.support.firePropertyChange(PROP_ROOTS, null, null);
        }
    }

    private void readProjectMetadata() {
        Element cfgEl = this.helper.getPrimaryConfigurationData(true);
        NodeList nl = cfgEl.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", this.elementName);
        assert (nl.getLength() == 0 || nl.getLength() == 1) : "Illegal project.xml";
        ArrayList<String> rootProps = new ArrayList<String>();
        ArrayList<String> rootNames = new ArrayList<String>();
        if (nl.getLength() == 1) {
            NodeList roots = ((Element)nl.item(0)).getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-ejbjarproject/3", "root");
            for (int i = 0; i < roots.getLength(); ++i) {
                Element root = (Element)roots.item(i);
                String value = root.getAttribute("id");
                assert (value.length() > 0) : "Illegal project.xml";
                rootProps.add(value);
                value = root.getAttribute("name");
                rootNames.add(value);
            }
        }
        this.sourceRootProperties = Collections.unmodifiableList(rootProps);
        this.sourceRootNames = Collections.unmodifiableList(rootNames);
    }

    public boolean isTest() {
        return this.isTest;
    }

    private class ProjectMetadataListener
    implements PropertyChangeListener,
    AntProjectListener {
        private ProjectMetadataListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SourceRoots.this.resetCache(false, evt.getPropertyName());
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            SourceRoots.this.resetCache(true, null);
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }
    }
}

