/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.java;

import java.io.IOException;
import org.netbeans.modules.i18n.ResourceHolder;
import org.netbeans.modules.i18n.java.Util;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesStructure;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JavaResourceHolder
extends ResourceHolder {
    public JavaResourceHolder() {
        super(new Class[]{PropertiesDataObject.class});
    }

    public String[] getAllKeys() {
        if (this.resource == null) {
            return new String[0];
        }
        return ((PropertiesDataObject)this.resource).getBundleStructure().getKeys();
    }

    public String getValueForKey(String key) {
        if (this.resource == null) {
            return null;
        }
        Element.ItemElem item = this.getItem(key);
        return item == null ? null : item.getValue();
    }

    public String getCommentForKey(String key) {
        if (this.resource == null) {
            return null;
        }
        Element.ItemElem item = this.getItem(key);
        return item == null ? null : item.getComment();
    }

    private Element.ItemElem getItem(String key) {
        BundleStructure bundleStructure = ((PropertiesDataObject)this.resource).getBundleStructure();
        if (bundleStructure == null) {
            return null;
        }
        for (int i = 0; i < bundleStructure.getEntryCount(); ++i) {
            Element.ItemElem item = bundleStructure.getItem(i, key);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public void addProperty(Object key, Object value, String comment, boolean forceNewValue) {
        if (this.resource == null || key == null) {
            return;
        }
        String keyValue = key.toString();
        String valueValue = value == null ? "" : value.toString();
        String commentValue = comment;
        BundleStructure bundleStructure = ((PropertiesDataObject)this.resource).getBundleStructure();
        PropertiesStructure propStructure = bundleStructure.getNthEntry(0).getHandler().getStructure();
        Element.ItemElem item = propStructure.getItem(keyValue);
        if (item == null) {
            propStructure.addItem(keyValue, valueValue, commentValue);
        } else if (!item.getValue().equals(valueValue) && forceNewValue) {
            item.setValue(valueValue);
            item.setComment(commentValue);
        }
    }

    protected DataObject createTemplate(Class clazz) throws IOException {
        FileSystem defaultFS = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = defaultFS.findResource("Templates/Other/properties.properties");
        if (fileObject == null) {
            throw new IOException(Util.getString("EXC_TemplateNotFound"));
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException e) {
            throw new IOException(Util.getString("EXC_TemplateNotFound"));
        }
    }
}

