/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dataview.DataViewWindow;
import org.netbeans.modules.db.explorer.infos.ColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.TableNodeInfo;
import org.netbeans.modules.db.explorer.infos.ViewColumnNodeInfo;
import org.netbeans.modules.db.explorer.infos.ViewNodeInfo;
import org.netbeans.modules.db.explorer.sql.editor.SQLEditorSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class ViewDataAction
extends DatabaseAction {
    static final long serialVersionUID = -894644054833609687L;
    private String quoteStr;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport((Object)this);
    private Node[] nodes;
    private DataViewWindow win;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$ViewColumnNodeInfo;

    public ViewDataAction() {
        this.propertySupport.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("retrieved")) {
                    ViewDataAction.this.finishAction();
                }
            }
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes != null) {
            if (activatedNodes.length == 1) {
                return true;
            }
            if (activatedNodes.length > 0) {
                int t = 0;
                int v = 0;
                for (int i = 0; i < activatedNodes.length; ++i) {
                    if (activatedNodes[i].getCookie(class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo == null ? ViewDataAction.class$("org.netbeans.modules.db.explorer.infos.ColumnNodeInfo") : class$org$netbeans$modules$db$explorer$infos$ColumnNodeInfo) != null) {
                        ++t;
                        continue;
                    }
                    if (activatedNodes[i].getCookie(class$org$netbeans$modules$db$explorer$infos$ViewColumnNodeInfo == null ? ViewDataAction.class$("org.netbeans.modules.db.explorer.infos.ViewColumnNodeInfo") : class$org$netbeans$modules$db$explorer$infos$ViewColumnNodeInfo) == null) continue;
                    ++v;
                }
                return t == activatedNodes.length || v == activatedNodes.length;
            }
            return false;
        }
        return false;
    }

    public void performAction(Node[] activatedNodes) {
        if (activatedNodes != null && activatedNodes.length > 0) {
            this.nodes = activatedNodes;
            final DatabaseNodeInfo info = (DatabaseNodeInfo)activatedNodes[0].getCookie(DatabaseNodeInfo.class);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        DatabaseMetaData dmd = info.getConnection().getMetaData();
                        ViewDataAction.this.quoteStr = dmd.getIdentifierQuoteString();
                        if (ViewDataAction.this.quoteStr == null) {
                            ViewDataAction.this.quoteStr = "";
                        } else {
                            ViewDataAction.this.quoteStr.trim();
                        }
                        ViewDataAction.this.propertySupport.firePropertyChange("retrieved", null, null);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }, 0);
        }
    }

    private void finishAction() {
        String expression = "";
        StringBuffer cols = new StringBuffer();
        try {
            Node node = this.nodes[0];
            DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
            String schema = info.getSchema();
            schema = schema == null ? "" : schema.trim();
            if (info instanceof TableNodeInfo || info instanceof ViewNodeInfo) {
                String onome = this.quote(info.getName());
                if (!schema.equals("")) {
                    onome = this.quote(schema) + "." + onome;
                }
                expression = "select * from " + onome;
            } else if (info instanceof ColumnNodeInfo || info instanceof ViewColumnNodeInfo) {
                String onome = this.quote(info instanceof ViewColumnNodeInfo ? info.getView() : info.getTable());
                if (!schema.equals("")) {
                    onome = this.quote(schema) + "." + onome;
                }
                for (int i = 0; i < this.nodes.length; ++i) {
                    node = this.nodes[i];
                    info = (DatabaseNodeInfo)node.getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? ViewDataAction.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo") : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
                    if (!(info instanceof ColumnNodeInfo) && !(info instanceof ViewColumnNodeInfo)) continue;
                    if (cols.length() > 0) {
                        cols.append(", ");
                    }
                    cols.append(this.quote(info.getName()));
                }
                expression = "select " + cols.toString() + " from " + onome;
            }
            String name = info.getDatabaseConnection().getName();
            SQLEditorSupport.openSQLEditor(ConnectionManager.getDefault().getConnection(name), expression, true);
        }
        catch (Exception exc) {
            String message = MessageFormat.format(ViewDataAction.bundle().getString("ShowDataError"), exc.getMessage());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
        }
    }

    private String quote(String name) {
        return this.quoteStr + name + this.quoteStr;
    }
}

