/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.module.ui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.netbeans.progress.module.InternalHandle;
import org.netbeans.progress.module.ProgressEvent;
import org.netbeans.progress.module.ProgressUIWorker;
import org.netbeans.progress.module.ui.StatusLineComponent;

public class NbProgressBar
extends JProgressBar
implements ProgressUIWorker {
    boolean isSetup = false;
    boolean usedInStatusBar = false;

    public NbProgressBar() {
        Color bg;
        this.setOrientation(0);
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        Color fg = UIManager.getColor("nbProgressBar.Foreground");
        if (fg != null) {
            this.setForeground(fg);
        }
        if ((bg = UIManager.getColor("nbProgressBar.Background")) != null) {
            this.setBackground(bg);
        }
    }

    public void setUseInStatusBar(boolean use) {
        this.usedInStatusBar = use;
    }

    public Dimension getPreferredSize() {
        Dimension supers = super.getPreferredSize();
        if (this.usedInStatusBar) {
            supers.width = 133;
        }
        return supers;
    }

    public void processProgressEvent(ProgressEvent event) {
        if (event.getType() == 0 || !this.isSetup || event.isSwitched()) {
            NbProgressBar.setupBar(event.getSource(), this);
            this.isSetup = true;
        }
        if (event.getType() == 1) {
            if (event.getWorkunitsDone() > 0) {
                this.setValue(event.getWorkunitsDone());
            }
            this.setString(StatusLineComponent.getBarString(event.getPercentageDone(), event.getEstimatedCompletion()));
        } else if (event.getType() == 4) {
            boolean wasIndetermenite = this.isIndeterminate();
            this.setIndeterminate(false);
            this.setMaximum(event.getSource().getTotalUnits());
            this.setValue(event.getSource().getTotalUnits());
            if (wasIndetermenite) {
                this.setStringPainted(false);
            } else {
                this.setString(StatusLineComponent.getBarString(100, -1L));
            }
        }
    }

    public void processSelectedProgressEvent(ProgressEvent event) {
    }

    static void setupBar(InternalHandle handle, NbProgressBar bar) {
        int total = handle.getTotalUnits();
        if (total < 1) {
            bar.setValue(bar.getMaximum());
            bar.setIndeterminate(true);
            bar.setStringPainted(false);
        } else {
            bar.setStringPainted(true);
            bar.setIndeterminate(false);
            bar.setMaximum(total);
            bar.setMinimum(0);
            bar.setValue(0);
        }
        bar.setString(" ");
    }
}

