/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.spi.editor.completion.CompletionItem;

public class CompletionJList
extends JList {
    private static final int DARKER_COLOR_COMPONENT = 5;
    private final RenderComponent renderComponent;
    private Graphics cellPreferredSizeGraphics;
    private int fixedItemHeight;
    private int maxVisibleRowCount;
    static /* synthetic */ Class class$org$netbeans$modules$editor$completion$CompletionJList;

    public CompletionJList(int maxVisibleRowCount, MouseListener mouseListener) {
        this.maxVisibleRowCount = maxVisibleRowCount;
        this.addMouseListener(mouseListener);
        this.setLayoutOrientation(0);
        this.fixedItemHeight = Math.max(16, this.getFontMetrics(this.getFont()).getHeight());
        this.setFixedCellHeight(this.fixedItemHeight);
        this.setModel(new Model(Collections.EMPTY_LIST));
        this.renderComponent = new RenderComponent();
        this.setSelectionMode(0);
        this.setCellRenderer(new ListCellRenderer(){
            private ListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof CompletionItem) {
                    Color fgColor;
                    Color bgColor;
                    CompletionItem item = (CompletionItem)value;
                    CompletionJList.this.renderComponent.setItem(item);
                    CompletionJList.this.renderComponent.setSelected(isSelected);
                    if (isSelected) {
                        bgColor = list.getSelectionBackground();
                        fgColor = list.getSelectionForeground();
                    } else {
                        bgColor = list.getBackground();
                        if (index % 2 == 0) {
                            bgColor = new Color(Math.abs(bgColor.getRed() - 5), Math.abs(bgColor.getGreen() - 5), Math.abs(bgColor.getBlue() - 5));
                        }
                        fgColor = list.getForeground();
                    }
                    if (CompletionJList.this.renderComponent.getBackground() != bgColor) {
                        CompletionJList.this.renderComponent.setBackground(bgColor);
                    }
                    if (CompletionJList.this.renderComponent.getForeground() != fgColor) {
                        CompletionJList.this.renderComponent.setForeground(fgColor);
                    }
                    return CompletionJList.this.renderComponent;
                }
                return this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString((String)"ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_CompletionView"));
    }

    void setData(List data) {
        if (data != null) {
            int visibleRowCount;
            int itemCount = data.size();
            ((Model)this.getModel()).setData(data);
            if (itemCount > 0) {
                this.setSelectedIndex(0);
            }
            if (itemCount > (visibleRowCount = this.getVisibleRowCount())) {
                visibleRowCount = Math.min(itemCount, this.maxVisibleRowCount);
            } else if (itemCount < visibleRowCount && itemCount < visibleRowCount * 2 / 3) {
                visibleRowCount = itemCount;
            }
            this.setVisibleRowCount(visibleRowCount);
        }
    }

    public void up() {
        int size = this.getModel().getSize();
        if (size > 0) {
            this.setSelectedIndex((this.getSelectedIndex() - 1 + size) % size);
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    public void down() {
        int size = this.getModel().getSize();
        if (size > 0) {
            this.setSelectedIndex((this.getSelectedIndex() + 1) % size);
            this.ensureIndexIsVisible(this.getSelectedIndex());
        }
    }

    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int pageSize = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int ind = Math.max(this.getSelectedIndex() - pageSize, 0);
            this.setSelectedIndex(ind);
            this.ensureIndexIsVisible(ind);
        }
    }

    public void pageDown() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            int pageSize = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            int ind = Math.min(this.getSelectedIndex() + pageSize, lastInd);
            this.setSelectedIndex(ind);
            this.ensureIndexIsVisible(ind);
        }
    }

    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    public void end() {
        int lastInd = this.getModel().getSize() - 1;
        if (lastInd >= 0) {
            this.setSelectedIndex(lastInd);
            this.ensureIndexIsVisible(lastInd);
        }
    }

    private final class RenderComponent
    extends JComponent {
        private CompletionItem item;
        private boolean selected;
        static final /* synthetic */ boolean $assertionsDisabled;

        private RenderComponent() {
        }

        void setItem(CompletionItem item) {
            this.item = item;
        }

        void setSelected(boolean selected) {
            this.selected = selected;
        }

        private void clearItem() {
            this.item = this.item;
        }

        public void paintComponent(Graphics g) {
            int itemRenderWidth = ((JViewport)CompletionJList.this.getParent()).getWidth();
            Color bgColor = this.getBackground();
            Color fgColor = this.getForeground();
            int height = this.getHeight();
            g.setColor(bgColor);
            g.fillRect(0, 0, itemRenderWidth, height);
            g.setColor(fgColor);
            this.item.render(g, this.getFont(), this.getForeground(), bgColor, itemRenderWidth, this.getHeight(), this.selected);
        }

        public Dimension getPreferredSize() {
            if (CompletionJList.this.cellPreferredSizeGraphics == null) {
                CompletionJList.this.cellPreferredSizeGraphics = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1).getGraphics();
                if (!$assertionsDisabled && CompletionJList.this.cellPreferredSizeGraphics == null) {
                    throw new AssertionError();
                }
            }
            return new Dimension(this.item.getPreferredWidth(CompletionJList.this.cellPreferredSizeGraphics, this.getFont()), CompletionJList.this.fixedItemHeight);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$editor$completion$CompletionJList == null ? (class$org$netbeans$modules$editor$completion$CompletionJList = CompletionJList.class$("org.netbeans.modules.editor.completion.CompletionJList")) : class$org$netbeans$modules$editor$completion$CompletionJList).desiredAssertionStatus();
        }
    }

    static class Model
    extends AbstractListModel {
        List data;
        static final long serialVersionUID = 3292276783870598274L;

        public Model(List data) {
            this.data = data;
        }

        public void setData(List data) {
            List oldData = this.data;
            this.data = data;
            this.fireContentsChanged(this, 0, oldData.size());
        }

        public int getSize() {
            return this.data.size();
        }

        public Object getElementAt(int index) {
            return index >= 0 && index < this.data.size() ? this.data.get(index) : null;
        }

        List getData() {
            return this.data;
        }
    }
}

