/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.tools.wscompile;

import com.sun.xml.rpc.processor.Processor;
import com.sun.xml.rpc.processor.config.J2EEModelInfo;
import com.sun.xml.rpc.processor.config.parser.Constants;
import com.sun.xml.rpc.processor.config.parser.J2EEModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.ModelInfoParser;
import com.sun.xml.rpc.processor.config.parser.ModelInfoPlugin;
import com.sun.xml.rpc.processor.generator.JaxRpcMappingGenerator;
import com.sun.xml.rpc.processor.modeler.j2ee.JaxRpcMappingXml;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.spi.tools.ModelInfo;
import com.sun.xml.rpc.tools.plugin.ToolPlugin;
import com.sun.xml.rpc.tools.wscompile.ProcessorActionsIf;
import com.sun.xml.rpc.tools.wscompile.UsageIf;
import com.sun.xml.rpc.util.localization.Localizable;
import com.sun.xml.rpc.util.localization.LocalizableMessageFactory;
import com.sun.xml.rpc.util.localization.Localizer;
import java.io.File;
import java.net.URL;
import javax.xml.namespace.QName;

public class J2EEToolPlugin
extends ToolPlugin
implements UsageIf,
ModelInfoPlugin,
ProcessorActionsIf {
    private LocalizableMessageFactory messageFactory;
    protected Localizer localizer = new Localizer();
    protected File mappingFile = null;

    public J2EEToolPlugin() {
        this.messageFactory = new LocalizableMessageFactory("com.sun.xml.rpc.resources.j2ee");
    }

    public void registerActions(Processor processor) {
        if (this.mappingFile != null) {
            processor.add(new JaxRpcMappingGenerator(this.mappingFile));
        }
    }

    public ModelInfo createModelInfo() {
        return new J2EEModelInfo();
    }

    public Localizable getExamplesUsage() {
        return null;
    }

    public Localizable getFeaturesUsage() {
        return null;
    }

    public Localizable getInternalUsage() {
        return null;
    }

    public Localizable getOptionsUsage() {
        return this.messageFactory.getMessage("j2ee.usage.options", (Object[])null);
    }

    public QName getModelInfoName() {
        return Constants.QNAME_J2EE_MAPPING_FILE;
    }

    public ModelInfoParser createModelInfoParser(ProcessorEnvironment env) {
        return new J2EEModelInfoParser(env);
    }

    public ModelInfo createModelInfo(URL mappingFile) throws Exception {
        JaxRpcMappingXml mapping = new JaxRpcMappingXml(mappingFile.toExternalForm());
        J2EEModelInfo modelInfo = new J2EEModelInfo(mapping);
        return modelInfo;
    }

    public boolean parseArguments(String[] args, UsageIf.UsageError err) {
        this.mappingFile = null;
        int i = 0;
        while (i < args.length) {
            if (args[i] != null && args[i].equals("-mapping")) {
                if (i + 1 < args.length) {
                    if (this.mappingFile != null) {
                        err.msg = this.messageFactory.getMessage("j2ee.duplicateOption", new Object[]{"-mapping"});
                        return false;
                    }
                    args[i] = null;
                    this.mappingFile = new File(args[++i]);
                    args[i] = null;
                } else {
                    err.msg = this.messageFactory.getMessage("j2ee.missingOptionArgument", new Object[]{"-mapping"});
                    return false;
                }
            }
            ++i;
        }
        return true;
    }
}

