/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.customizer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.jboss4.customizer.CustomizerSupport;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.ErrorManager;

public class CustomizerDataSupport {
    private DefaultComboBoxModel jvmModel;
    private Document javaOptsModel;
    private ButtonModel proxyModel;
    private CustomizerSupport.PathModel sourceModel;
    private CustomizerSupport.PathModel classModel;
    private CustomizerSupport.PathModel javadocModel;
    private boolean jvmModelFlag;
    private boolean javaOptsModelFlag;
    private boolean proxyModelFlag;
    private boolean sourceModelFlag;
    private boolean javadocModelFlag;
    private JBProperties properties;

    public CustomizerDataSupport(JBProperties properties) {
        this.properties = properties;
        this.init();
    }

    private void init() {
        this.jvmModel = new DefaultComboBoxModel();
        this.loadJvmModel();
        this.jvmModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                CustomizerDataSupport.this.jvmModelFlag = true;
                CustomizerDataSupport.this.store();
            }

            public void intervalAdded(ListDataEvent e) {
            }

            public void intervalRemoved(ListDataEvent e) {
            }
        });
        this.javaOptsModel = this.createDocument(this.properties.getJavaOpts());
        this.javaOptsModel.addDocumentListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.javaOptsModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.proxyModel = this.createToggleButtonModel(this.properties.getProxyEnabled());
        this.proxyModel.addItemListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.proxyModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.classModel = new CustomizerSupport.PathModel(this.properties.getClasses());
        this.sourceModel = new CustomizerSupport.PathModel(this.properties.getSources());
        this.sourceModel.addListDataListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.sourceModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.javadocModel = new CustomizerSupport.PathModel(this.properties.getJavadocs());
        this.javadocModel.addListDataListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.javadocModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
    }

    public void loadJvmModel() {
        int i;
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatformAdapter curJvm = (JavaPlatformAdapter)this.jvmModel.getSelectedItem();
        String curPlatformName = null;
        curPlatformName = curJvm != null ? curJvm.getName() : (String)this.properties.getJavaPlatform().getProperties().get("platform.ant.name");
        this.jvmModel.removeAllElements();
        JavaPlatform[] j2sePlatforms = jpm.getPlatforms(null, new Specification("J2SE", null));
        Object[] platformAdapters = new JavaPlatformAdapter[j2sePlatforms.length];
        for (i = 0; i < platformAdapters.length; ++i) {
            platformAdapters[i] = new JavaPlatformAdapter(j2sePlatforms[i]);
        }
        Arrays.sort(platformAdapters);
        for (i = 0; i < platformAdapters.length; ++i) {
            Object platformAdapter = platformAdapters[i];
            this.jvmModel.addElement(platformAdapter);
            if (curPlatformName == null || !curPlatformName.equals(((JavaPlatformAdapter)platformAdapter).getName())) continue;
            this.jvmModel.setSelectedItem(platformAdapter);
        }
    }

    public DefaultComboBoxModel getJvmModel() {
        return this.jvmModel;
    }

    public Document getJavaOptsModel() {
        return this.javaOptsModel;
    }

    public ButtonModel getProxyModel() {
        return this.proxyModel;
    }

    public CustomizerSupport.PathModel getClassModel() {
        return this.classModel;
    }

    public CustomizerSupport.PathModel getSourceModel() {
        return this.sourceModel;
    }

    public CustomizerSupport.PathModel getJavadocsModel() {
        return this.javadocModel;
    }

    private void store() {
        if (this.jvmModelFlag) {
            JavaPlatformAdapter platformAdapter = (JavaPlatformAdapter)this.jvmModel.getSelectedItem();
            this.properties.setJavaPlatform(platformAdapter.getJavaPlatform());
            this.jvmModelFlag = false;
        }
        if (this.javaOptsModelFlag) {
            this.properties.setJavaOpts(this.getText(this.javaOptsModel));
            this.javaOptsModelFlag = false;
        }
        if (this.proxyModelFlag) {
            this.properties.setProxyEnabled(this.proxyModel.isSelected());
            this.proxyModelFlag = false;
        }
        if (this.sourceModelFlag) {
            this.properties.setSources(this.sourceModel.getData());
            this.sourceModelFlag = false;
        }
        if (this.javadocModelFlag) {
            this.properties.setJavadocs(this.javadocModel.getData());
            this.javadocModelFlag = false;
        }
    }

    private Document createDocument(String text) {
        PlainDocument doc = new PlainDocument();
        if (text != null) {
            try {
                doc.insertString(0, text, null);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        return doc;
    }

    private String getText(Document doc) {
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    private JToggleButton.ToggleButtonModel createToggleButtonModel(boolean selected) {
        JToggleButton.ToggleButtonModel model = new JToggleButton.ToggleButtonModel();
        model.setSelected(selected);
        return model;
    }

    private static class JavaPlatformAdapter
    implements Comparable {
        private JavaPlatform platform;

        public JavaPlatformAdapter(JavaPlatform platform) {
            this.platform = platform;
        }

        public JavaPlatform getJavaPlatform() {
            return this.platform;
        }

        public String getName() {
            return (String)this.platform.getProperties().get("platform.ant.name");
        }

        public String toString() {
            return this.platform.getDisplayName();
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }

    private abstract class ModelChangeAdapter
    implements ListDataListener,
    DocumentListener,
    ItemListener,
    ChangeListener {
        private ModelChangeAdapter() {
        }

        public abstract void modelChanged();

        public void contentsChanged(ListDataEvent e) {
            this.modelChanged();
        }

        public void intervalAdded(ListDataEvent e) {
            this.modelChanged();
        }

        public void intervalRemoved(ListDataEvent e) {
            this.modelChanged();
        }

        public void changedUpdate(DocumentEvent e) {
            this.modelChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.modelChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.modelChanged();
        }

        public void itemStateChanged(ItemEvent e) {
            this.modelChanged();
        }

        public void stateChanged(ChangeEvent e) {
            this.modelChanged();
        }
    }
}

