/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.model.XpathListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.jboss4.config.JBDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.JbossDataSourceRefModifier;
import org.netbeans.modules.j2ee.jboss4.config.JbossEjbRefModifier;
import org.netbeans.modules.j2ee.jboss4.config.JbossMsgDestRefModifier;
import org.netbeans.modules.j2ee.jboss4.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.gen.EnterpriseBeans;
import org.netbeans.modules.j2ee.jboss4.config.gen.Jboss;
import org.netbeans.modules.j2ee.jboss4.config.gen.MessageDriven;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public class EjbDeploymentConfiguration
extends JBDeploymentConfiguration
implements PropertyChangeListener,
XpathListener {
    private static final String SESSION_RESOURCE_REF = "/ejb-jar/enterprise-beans/session/resource-ref";
    private static final String ENTITY_RESOURCE_REF = "/ejb-jar/enterprise-beans/entity/resource-ref";
    private static final String MSGDRV_RESOURCE_REF = "/ejb-jar/enterprise-beans/message-driven/resource-ref";
    private static final String SESSION_EJB_REF = "/ejb-jar/enterprise-beans/session/ejb-ref";
    private static final String ENTITY_EJB_REF = "/ejb-jar/enterprise-beans/entity/ejb-ref";
    private static final String MSGDRV_EJB_REF = "/ejb-jar/enterprise-beans/message-driven/ejb-ref";
    private static final String MSGDRV = "/ejb-jar/enterprise-beans/message-driven";
    private static final String MSGDRV_MSG_DEST = "/ejb-jar/enterprise-beans/message-driven/message-destination-link";
    private static final String SESSION_MSG_DEST_REF = "/ejb-jar/enterprise-beans/session/message-destination-ref";
    private static final String ENTITY_MSG_DEST_REF = "/ejb-jar/enterprise-beans/entity/message-destination-ref";
    private static final String MSGDRV_MSG_DEST_REF = "/ejb-jar/enterprise-beans/message-driven/message-destination-ref";
    private File jbossFile;
    private Jboss jboss;
    private String tempEjbName;
    private final boolean isEJB3;

    public EjbDeploymentConfiguration(DeployableObject deployableObject) {
        super(deployableObject);
        this.isEJB3 = "3.0".equals(deployableObject.getDDBeanRoot().getDDBeanRootVersion());
    }

    public void init(File file, File resourceDir) {
        super.init(resourceDir);
        this.jbossFile = file;
        this.getJboss();
        if (this.deploymentDescriptorDO == null) {
            try {
                this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossFile));
                this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException donfe) {
                ErrorManager.getDefault().notify((Throwable)donfe);
            }
        }
        this.deplObj.getDDBeanRoot().addXpathListener(SESSION_RESOURCE_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(ENTITY_RESOURCE_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(SESSION_EJB_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(ENTITY_EJB_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(MSGDRV_RESOURCE_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(MSGDRV_EJB_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(MSGDRV, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(MSGDRV_MSG_DEST, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(SESSION_MSG_DEST_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(ENTITY_MSG_DEST_REF, (XpathListener)this);
        this.deplObj.getDDBeanRoot().addXpathListener(MSGDRV_MSG_DEST_REF, (XpathListener)this);
    }

    public synchronized Jboss getJboss() {
        if (this.jboss == null) {
            try {
                if (this.jbossFile.exists()) {
                    try {
                        this.jboss = Jboss.createGraph(this.jbossFile);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify((Throwable)ioe);
                    }
                    catch (RuntimeException re) {}
                } else {
                    this.jboss = this.generateJboss();
                    this.writefile(this.jbossFile, this.jboss);
                }
            }
            catch (ConfigurationException ce) {
                ErrorManager.getDefault().notify((Throwable)ce);
            }
        }
        return this.jboss;
    }

    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "modified" && evt.getNewValue() == Boolean.FALSE) {
            if (evt.getSource() == this.deploymentDescriptorDO) {
                this.jboss = null;
            } else {
                super.propertyChange(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireXpathEvent(XpathEvent xpe) {
        block50: {
            if (!xpe.isAddEvent()) {
                return;
            }
            DDBean eventDDBean = xpe.getBean();
            if (SESSION_RESOURCE_REF.equals(eventDDBean.getXpath()) || ENTITY_RESOURCE_REF.equals(eventDDBean.getXpath()) || MSGDRV_RESOURCE_REF.equals(eventDDBean.getXpath())) {
                String[] desc = eventDDBean.getText("description");
                String[] name = eventDDBean.getText("res-ref-name");
                String[] type = eventDDBean.getText("res-type");
                if (name.length > 0 && type.length > 0) {
                    try {
                        BEAN_TYPE beanType;
                        BEAN_TYPE bEAN_TYPE = SESSION_RESOURCE_REF.equals(eventDDBean.getXpath()) ? BEAN_TYPE.SESSION : (beanType = ENTITY_RESOURCE_REF.equals(eventDDBean.getXpath()) ? BEAN_TYPE.ENTITY : BEAN_TYPE.MSGDRV);
                        if (beanType != BEAN_TYPE.MSGDRV) {
                            Set beanNames = null;
                            if (desc.length > 0 && "javax.sql.DataSource".equals(type[0])) {
                                beanNames = this.getRelevantBeansDataRef(desc[0], name[0], eventDDBean.getRoot(), beanType);
                                this.addResReference(desc[0], name[0], beanNames, beanType);
                            } else if ("javax.mail.Session".equals(type[0])) {
                                beanNames = this.getRelevantBeansMailRef(name[0], eventDDBean.getRoot(), beanType);
                                this.addMailReference(name[0], beanNames, beanType);
                            } else if ("javax.jms.ConnectionFactory".equals(type[0])) {
                                beanNames = this.getRelevantBeansConnectionFactoryRef(name[0], eventDDBean.getRoot(), beanType);
                                this.addConnectionFactoryReference(name[0], beanNames, beanType);
                            }
                        } else {
                            Map beans = null;
                            if (desc.length > 0 && "javax.sql.DataSource".equals(type[0])) {
                                beans = this.getRelevantMsgDrvBeansDataRef(desc[0], name[0], eventDDBean.getRoot());
                                this.addMsgDrvResReference(desc[0], name[0], beans);
                            }
                            if ("javax.mail.Session".equals(type[0])) {
                                beans = this.getRelevantMsgDrvBeansMailRef(name[0], eventDDBean.getRoot());
                                this.addMsgDrvMailReference(name[0], beans);
                            } else if ("javax.jms.ConnectionFactory".equals(type[0])) {
                                beans = this.getRelevantMsgDrvBeansConnectionFactoryRef(name[0], eventDDBean.getRoot());
                                this.addMsgDrvConnectionFactoryReference(name[0], beans);
                            }
                        }
                    }
                    catch (ConfigurationException ce) {
                        ErrorManager.getDefault().notify((Throwable)ce);
                    }
                }
            } else if (SESSION_EJB_REF.equals(eventDDBean.getXpath()) || ENTITY_EJB_REF.equals(eventDDBean.getXpath()) || MSGDRV_EJB_REF.equals(eventDDBean.getXpath())) {
                String[] name = eventDDBean.getText("ejb-ref-name");
                String[] type = eventDDBean.getText("ejb-ref-type");
                if (name.length > 0 && type.length > 0 && ("Session".equals(type[0]) || "Entity".equals(type[0]))) {
                    try {
                        BEAN_TYPE beanType;
                        BEAN_TYPE bEAN_TYPE = SESSION_EJB_REF.equals(eventDDBean.getXpath()) ? BEAN_TYPE.SESSION : (beanType = ENTITY_EJB_REF.equals(eventDDBean.getXpath()) ? BEAN_TYPE.ENTITY : BEAN_TYPE.MSGDRV);
                        if (beanType != BEAN_TYPE.MSGDRV) {
                            Set beanNames = this.getRelevantBeansEjbRef(name[0], eventDDBean.getRoot(), beanType);
                            this.addEjbReference(name[0], beanNames, beanType);
                            break block50;
                        }
                        Map beans = this.getRelevantMsgDrvBeansEjbRef(name[0], eventDDBean.getRoot());
                        this.addMsgDrvEjbReference(name[0], beans);
                    }
                    catch (ConfigurationException ce) {
                        ErrorManager.getDefault().notify((Throwable)ce);
                    }
                }
            } else if (MSGDRV.equals(eventDDBean.getXpath())) {
                if (this.isEJB3) {
                    return;
                }
                String[] name = eventDDBean.getText("ejb-name");
                String[] type = eventDDBean.getText("message-destination-type");
                String[] dest = eventDDBean.getText("message-destination-link");
                if (name.length == 0) {
                    return;
                }
                if (dest.length == 0) {
                    this.tempEjbName = name[0];
                } else {
                    try {
                        this.addMDB(name[0], dest[0]);
                    }
                    catch (ConfigurationException ce) {
                        ErrorManager.getDefault().notify((Throwable)ce);
                    }
                }
            } else if (MSGDRV_MSG_DEST.equals(eventDDBean.getXpath())) {
                if (this.isEJB3) {
                    return;
                }
                if (this.tempEjbName == null) {
                    return;
                }
                try {
                    String dest = xpe.getBean().getText();
                    this.addMDB(this.tempEjbName, dest);
                }
                catch (ConfigurationException ce) {
                    ErrorManager.getDefault().notify((Throwable)ce);
                }
                finally {
                    this.tempEjbName = null;
                }
            } else if (SESSION_MSG_DEST_REF.equals(eventDDBean.getXpath()) || ENTITY_MSG_DEST_REF.equals(eventDDBean.getXpath()) || MSGDRV_MSG_DEST_REF.equals(eventDDBean.getXpath())) {
                String[] name = eventDDBean.getText("message-destination-ref-name");
                String[] type = eventDDBean.getText("message-destination-type");
                if (name.length > 0) {
                    String destPrefix = "";
                    if (type.length > 0) {
                        if (type[0].equals("javax.jms.Queue")) {
                            destPrefix = "queue/";
                        } else if (type[0].equals("javax.jms.Topic")) {
                            destPrefix = "topic/";
                        }
                    }
                    try {
                        BEAN_TYPE beanType;
                        BEAN_TYPE bEAN_TYPE = SESSION_MSG_DEST_REF.equals(eventDDBean.getXpath()) ? BEAN_TYPE.SESSION : (beanType = ENTITY_MSG_DEST_REF.equals(eventDDBean.getXpath()) ? BEAN_TYPE.ENTITY : BEAN_TYPE.MSGDRV);
                        if (beanType != BEAN_TYPE.MSGDRV) {
                            Set beanNames = this.getRelevantBeansMsgDestRef(name[0], eventDDBean.getRoot(), beanType);
                            this.addMsgDestReference(name[0], destPrefix, beanNames, beanType);
                        } else {
                            Map beans = this.getRelevantMsgDrvBeansMsgDestRef(name[0], eventDDBean.getRoot());
                            this.addMsgDrvMsgDestReference(name[0], destPrefix, beans);
                        }
                    }
                    catch (ConfigurationException ce) {
                        ErrorManager.getDefault().notify((Throwable)ce);
                    }
                }
            }
        }
    }

    private Set getRelevantBeansDataRef(String desc, String resRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] descs = resRefs[j].getText("description");
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (descs.length <= 0 || names.length <= 0 || types.length <= 0 || !descs[0].equals(desc) || !names[0].equals(resRefName) || !"javax.sql.DataSource".equals(types[0])) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansDataRef(String desc, String resRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] descs = resRefs[j].getText("description");
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (descs.length <= 0 || names.length <= 0 || types.length <= 0 || !descs[0].equals(desc) || !names[0].equals(resRefName) || !"javax.sql.DataSource".equals(types[0])) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    private Set getRelevantBeansEjbRef(String ejbRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] ejbRefs = bean.getChildBean("ejb-ref");
            for (int j = 0; ejbRefs != null && j < ejbRefs.length; ++j) {
                String[] names = ejbRefs[j].getText("ejb-ref-name");
                String[] types = ejbRefs[j].getText("ejb-ref-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(ejbRefName) || !"Session".equals(types[0]) && !"Entity".equals(types[0])) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansEjbRef(String ejbRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] ejbRefs = bean.getChildBean("ejb-ref");
            for (int j = 0; ejbRefs != null && j < ejbRefs.length; ++j) {
                String[] names = ejbRefs[j].getText("ejb-ref-name");
                String[] types = ejbRefs[j].getText("ejb-ref-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(ejbRefName) || !"Session".equals(types[0]) && !"Entity".equals(types[0])) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    private Set getRelevantBeansMailRef(String resRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(resRefName) || !"javax.mail.Session".equals(types[0])) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansMailRef(String resRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(resRefName) || !"javax.mail.Session".equals(types[0])) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    private Set getRelevantBeansConnectionFactoryRef(String resRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(resRefName) || !"javax.jms.ConnectionFactory".equals(types[0])) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansConnectionFactoryRef(String resRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] resRefs = bean.getChildBean("resource-ref");
            for (int j = 0; resRefs != null && j < resRefs.length; ++j) {
                String[] names = resRefs[j].getText("res-ref-name");
                String[] types = resRefs[j].getText("res-type");
                if (names.length <= 0 || types.length <= 0 || !names[0].equals(resRefName) || !"javax.jms.ConnectionFactory".equals(types[0])) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    private Set getRelevantBeansMsgDestRef(String msgDestRefName, DDBeanRoot root, BEAN_TYPE beanType) {
        HashSet<String> beanNames = new HashSet<String>();
        DDBean[] beans = root.getChildBean("/ejb-jar/enterprise-beans/" + beanType.getType());
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] msgDestRefs = bean.getChildBean("message-destination-ref");
            for (int j = 0; msgDestRefs != null && j < msgDestRefs.length; ++j) {
                String[] names = msgDestRefs[j].getText("message-destination-ref-name");
                if (names.length <= 0 || !names[0].equals(msgDestRefName)) continue;
                beanNames.add(bean.getChildBean("ejb-name")[0].getText());
                continue block0;
            }
        }
        return beanNames;
    }

    private Map getRelevantMsgDrvBeansMsgDestRef(String msgDestRefName, DDBeanRoot root) {
        HashMap<String, String> beanMap = new HashMap<String, String>();
        DDBean[] beans = root.getChildBean(MSGDRV);
        block0: for (int i = 0; i < beans.length; ++i) {
            DDBean bean = beans[i];
            DDBean[] msgDestRefs = bean.getChildBean("message-destination-ref");
            for (int j = 0; msgDestRefs != null && j < msgDestRefs.length; ++j) {
                String[] names = msgDestRefs[j].getText("message-destination-ref-name");
                if (names.length <= 0 || !names[0].equals(msgDestRefName)) continue;
                String key = bean.getChildBean("ejb-name")[0].getText();
                String value = "";
                if (bean.getChildBean("message-destination-link").length > 0) {
                    value = bean.getChildBean("message-destination-link")[0].getText();
                }
                beanMap.put(key, value);
                continue block0;
            }
        }
        return beanMap;
    }

    private void addResReference(String desc, final String resRefName, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                String jndiName = "java:" + resRefName;
                JbossDataSourceRefModifier.modify(modifiedJboss, resRefName, beanNames, beanType, jndiName);
            }
        });
    }

    private void addMsgDrvResReference(String desc, final String resRefName, final Map beans) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                String jndiName = "java:" + resRefName;
                JbossDataSourceRefModifier.modifyMsgDrv(modifiedJboss, resRefName, beans, jndiName);
            }
        });
    }

    private void addEjbReference(final String ejbRefName, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                JbossEjbRefModifier.modify(modifiedJboss, ejbRefName, beanNames, beanType);
            }
        });
    }

    private void addMsgDrvEjbReference(final String ejbRefName, final Map beans) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                JbossEjbRefModifier.modifyMsgDrv(modifiedJboss, ejbRefName, beans);
            }
        });
    }

    private void addMailReference(final String resRefName, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                String jndiName = "java:Mail";
                JbossDataSourceRefModifier.modify(modifiedJboss, resRefName, beanNames, beanType, jndiName);
            }
        });
    }

    private void addMsgDrvMailReference(final String resRefName, final Map beans) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                String jndiName = "java:Mail";
                JbossDataSourceRefModifier.modifyMsgDrv(modifiedJboss, resRefName, beans, jndiName);
            }
        });
    }

    private void addMDB(final String name, final String dest) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                EnterpriseBeans eb = modifiedJboss.getEnterpriseBeans();
                if (eb == null) {
                    eb = new EnterpriseBeans();
                    modifiedJboss.setEnterpriseBeans(eb);
                }
                MessageDriven[] mdbs = eb.getMessageDriven();
                for (int i = 0; i < mdbs.length; ++i) {
                    String en = mdbs[i].getEjbName();
                    if (!name.equals(en)) continue;
                    return;
                }
                MessageDriven mdb = new MessageDriven();
                mdb.setEjbName(name);
                mdb.setDestinationJndiName(dest);
                eb.addMessageDriven(mdb);
            }
        });
    }

    private void addConnectionFactoryReference(final String resRefName, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                String jndiName = "ConnectionFactory";
                JbossDataSourceRefModifier.modify(modifiedJboss, resRefName, beanNames, beanType, jndiName);
            }
        });
    }

    private void addMsgDrvConnectionFactoryReference(final String resRefName, final Map beans) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                String jndiName = "ConnectionFactory";
                JbossDataSourceRefModifier.modifyMsgDrv(modifiedJboss, resRefName, beans, jndiName);
            }
        });
    }

    private void addMsgDestReference(final String msgDestRefName, final String destPrefix, final Set beanNames, final BEAN_TYPE beanType) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                JbossMsgDestRefModifier.modify(modifiedJboss, msgDestRefName, beanNames, beanType, destPrefix);
            }
        });
    }

    private void addMsgDrvMsgDestReference(final String msgDestRefName, final String destPrefix, final Map beans) throws ConfigurationException {
        this.modifyJboss(new JbossModifier(){

            public void modify(Jboss modifiedJboss) {
                JbossMsgDestRefModifier.modifyMsgDrv(modifiedJboss, msgDestRefName, beans, destPrefix);
            }
        });
    }

    private void modifyJboss(JbossModifier modifier) throws ConfigurationException {
        assert (this.deploymentDescriptorDO != null) : "DataObject has not been initialized yet";
        try {
            EditorCookie editor = (EditorCookie)this.deploymentDescriptorDO.getCookie(EditorCookie.class);
            StyledDocument doc = editor.getDocument();
            if (doc == null) {
                doc = editor.openDocument();
            }
            Jboss newJboss = null;
            try {
                byte[] docString = doc.getText(0, doc.getLength()).getBytes();
                newJboss = Jboss.createGraph(new ByteArrayInputStream(docString));
            }
            catch (RuntimeException e) {
                Jboss oldJboss = this.getJboss();
                if (oldJboss == null) {
                    throw new ConfigurationException(NbBundle.getMessage(JBDeploymentConfiguration.class, (String)"MSG_jbossXmlCannotParse", (Object)"jboss.xml"));
                }
                NotifyDescriptor.Confirmation notDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_jbossXmlNotValid", (Object)"jboss.xml"), 2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)notDesc);
                if (result == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                newJboss = oldJboss;
            }
            modifier.modify(newJboss);
            boolean modified = this.deploymentDescriptorDO.isModified();
            this.replaceDocument(doc, newJboss);
            if (!modified) {
                SaveCookie cookie = (SaveCookie)this.deploymentDescriptorDO.getCookie(SaveCookie.class);
                cookie.save();
            }
            this.jboss = newJboss;
        }
        catch (BadLocationException ble) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ble);
        }
        catch (IOException ioe) {
            throw (ConfigurationException)new ConfigurationException().initCause((Throwable)ioe);
        }
    }

    public void save(OutputStream os) throws ConfigurationException {
        Jboss jboss = this.getJboss();
        if (jboss == null) {
            throw new ConfigurationException("Cannot read configuration, it is probably in an inconsistent state.");
        }
        try {
            jboss.write(os);
        }
        catch (IOException ioe) {
            throw new ConfigurationException(ioe.getLocalizedMessage());
        }
    }

    private Jboss generateJboss() {
        return new Jboss();
    }

    static interface JbossModifier {
        public void modify(Jboss var1);
    }

    static class BEAN_TYPE {
        private String type;
        static final BEAN_TYPE SESSION = new BEAN_TYPE("session");
        static final BEAN_TYPE ENTITY = new BEAN_TYPE("entity");
        static final BEAN_TYPE MSGDRV = new BEAN_TYPE("message-driven");

        private BEAN_TYPE(String type) {
            this.type = type;
        }

        String getType() {
            return this.type;
        }
    }
}

