/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.JBTargetModuleID;
import org.netbeans.modules.j2ee.jboss4.config.gen.JbossWeb;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JBDeployer
implements ProgressObject,
Runnable {
    private static final int TIMEOUT = 60000;
    JBDeploymentManager dm;
    File file;
    String uri;
    JBTargetModuleID module_id;
    private Vector listeners = new Vector();
    private DeploymentStatus deploymentStatus;

    public JBDeployer(String serverUri, JBDeploymentManager dm) {
        this.uri = serverUri;
        this.dm = dm;
    }

    public ProgressObject deploy(Target[] target, File file, File file2, String host, int port) {
        this.module_id = new JBTargetModuleID(target[0], file.getName());
        try {
            String server_url = "http://" + host + ":" + port;
            if (file.getName().endsWith(".war")) {
                this.module_id.setContextURL(server_url + JbossWeb.createGraph(file2).getContextRoot());
            } else if (file.getName().endsWith(".ear")) {
                JarFileSystem jfs = new JarFileSystem();
                jfs.setJarFile(file);
                FileObject appXml = jfs.getRoot().getFileObject("META-INF/application.xml");
                if (appXml != null) {
                    Application ear = DDProvider.getDefault().getDDRoot(appXml);
                    Module[] modules = ear.getModule();
                    for (int i = 0; i < modules.length; ++i) {
                        JBTargetModuleID mod_id = new JBTargetModuleID(target[0]);
                        if (modules[i].getWeb() != null) {
                            mod_id.setContextURL(server_url + modules[i].getWeb().getContextRoot());
                        }
                        this.module_id.addChild(mod_id);
                    }
                } else {
                    System.out.println("Cannot file META-INF/application.xml in " + file);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        this.file = file;
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    public ProgressObject redeploy(TargetModuleID[] module_id, File file, File file2) {
        this.file = file;
        this.module_id = (JBTargetModuleID)module_id[0];
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    public void run() {
        String deployDir = InstanceProperties.getInstanceProperties((String)this.uri).getProperty("deploy-dir");
        FileObject foIn = FileUtil.toFileObject((File)this.file);
        FileObject foDestDir = FileUtil.toFileObject((File)new File(deployDir));
        String fileName = this.file.getName();
        File toDeploy = new File(deployDir + File.separator + fileName);
        if (toDeploy.exists()) {
            toDeploy.delete();
        }
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        String msg = NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)this.file.getAbsolutePath());
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, msg));
        try {
            this.wait(2000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, msg));
        try {
            TargetModuleID[] ch;
            FileUtil.copyFile((FileObject)foIn, (FileObject)foDestDir, (String)fileName);
            JBTargetModuleID moduleID = this.module_id;
            String webUrl = this.module_id.getWebURL();
            if (webUrl == null && (ch = this.module_id.getChildTargetModuleID()) != null) {
                for (int i = 0; i < ch.length; ++i) {
                    webUrl = ch[i].getWebURL();
                    if (webUrl == null) continue;
                    moduleID = ch[i];
                    break;
                }
            }
            if (webUrl != null) {
                URL url = new URL(webUrl);
                String waitingMsg = NbBundle.getMessage(JBDeployer.class, (String)"MSG_Waiting_For_Url", (Object)url);
                this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, waitingMsg));
                for (int i = 0; i < 3; ++i) {
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
                this.checkUrlReady(moduleID);
            }
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (MissingResourceException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, "Applicaton Deployed"));
    }

    private void checkUrlReady(TargetModuleID moduleID) {
        try {
            String warName = moduleID.getModuleID();
            ObjectName searchPattern = new ObjectName("jboss.web.deployment:war=" + warName + ",*");
            Object server = Util.getRMIServer(this.dm);
            long start = System.currentTimeMillis();
            Set managedObj = Collections.emptySet();
            while (managedObj.size() == 0 && System.currentTimeMillis() - start < 60000L) {
                managedObj = (Set)server.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class).invoke(server, searchPattern, null);
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.module_id};
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent evt = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        this.deploymentStatus = deploymentStatus;
        Vector targets = null;
        JBDeployer jBDeployer = this;
        synchronized (jBDeployer) {
            if (this.listeners != null) {
                targets = (Vector)this.listeners.clone();
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                ProgressListener target = (ProgressListener)targets.elementAt(i);
                target.handleProgressEvent(evt);
            }
        }
    }
}

