/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.client;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.client.WebServicesClientSupportAccessor;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class WebServicesClientSupport {
    public static final String WSCLIENTUPTODATE_CLASSPATH = "wsclientuptodate.classpath";
    private WebServicesClientSupportImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(WebServicesClientSupportProvider.class));

    private WebServicesClientSupport(WebServicesClientSupportImpl impl) {
        if (impl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = impl;
    }

    public static WebServicesClientSupport getWebServicesClientSupport(FileObject f) {
        if (f == null) {
            throw new NullPointerException("Passed null to WebServicesClientSupport.getWebServicesClientSupport(FileObject)");
        }
        Iterator it = implementations.allInstances().iterator();
        while (it.hasNext()) {
            WebServicesClientSupportProvider impl = (WebServicesClientSupportProvider)it.next();
            WebServicesClientSupport wscs = impl.findWebServicesClientSupport(f);
            if (wscs == null) continue;
            return wscs;
        }
        return null;
    }

    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor) {
        this.impl.addServiceClient(serviceName, packageName, sourceUrl, configFile, stubDescriptor);
    }

    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor, String[] wscompileFeatures) {
        this.impl.addServiceClient(serviceName, packageName, sourceUrl, configFile, stubDescriptor, wscompileFeatures);
    }

    public void addServiceClientReference(String serviceName, String fqServiceName, String relativeWsdlPath, String mappingPath, String[] portSEIInfo) {
        this.impl.addServiceClientReference(serviceName, fqServiceName, relativeWsdlPath, mappingPath, portSEIInfo);
    }

    public void removeServiceClient(String serviceName) {
        this.impl.removeServiceClient(serviceName);
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        return this.impl.getWsdlFolder(create);
    }

    public FileObject getWsdlFolder() {
        FileObject result = null;
        try {
            result = this.impl.getWsdlFolder(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public FileObject getDeploymentDescriptor() {
        return this.impl.getDeploymentDescriptor();
    }

    public List getStubDescriptors() {
        return this.impl.getStubDescriptors();
    }

    public List getServiceClients() {
        return this.impl.getServiceClients();
    }

    public String getWsdlSource(String serviceName) {
        return this.impl.getWsdlSource(serviceName);
    }

    public void setWsdlSource(String serviceName, String wsdlSource) {
        this.impl.setWsdlSource(serviceName, wsdlSource);
    }

    public void setProxyJVMOptions(String proxyHost, String proxyPort) {
        this.impl.setProxyJVMOptions(proxyHost, proxyPort);
    }

    public String getServiceRefName(String serviceName) {
        return this.impl.getServiceRefName(serviceName);
    }

    static {
        WebServicesClientSupportAccessor.DEFAULT = new WebServicesClientSupportAccessor(){

            public WebServicesClientSupport createWebServicesClientSupport(WebServicesClientSupportImpl spiWebServicesClientSupport) {
                return new WebServicesClientSupport(spiWebServicesClientSupport);
            }

            public WebServicesClientSupportImpl getWebServicesClientSupportImpl(WebServicesClientSupport wscs) {
                return wscs == null ? null : wscs.impl;
            }
        };
    }
}

