/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.codetemplates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.openide.ErrorManager;

public final class SyncDocumentRegion {
    private Document doc;
    private List regions;
    private List sortedRegions;
    private boolean regionsSortPerformed;

    public SyncDocumentRegion(Document doc, List regions) {
        this.doc = doc;
        this.regions = regions;
        this.regionsSortPerformed = PositionRegion.isRegionsSorted((List)regions);
        if (this.regionsSortPerformed) {
            this.sortedRegions = regions;
        } else {
            this.sortedRegions = new ArrayList(regions);
            Collections.sort(this.sortedRegions, PositionRegion.getComparator());
        }
    }

    public int getRegionCount() {
        return this.regions.size();
    }

    public MutablePositionRegion getRegion(int regionIndex) {
        return (MutablePositionRegion)this.regions.get(regionIndex);
    }

    public int getFirstRegionStartOffset() {
        return this.getRegion(0).getStartOffset();
    }

    public int getFirstRegionEndOffset() {
        return this.getRegion(0).getEndOffset();
    }

    public int getFirstRegionLength() {
        return this.getFirstRegionEndOffset() - this.getFirstRegionStartOffset();
    }

    public MutablePositionRegion getSortedRegion(int regionIndex) {
        return (MutablePositionRegion)this.sortedRegions.get(regionIndex);
    }

    public void sync(int moveStartDownLength) {
        String firstRegionText;
        if (moveStartDownLength != 0) {
            MutablePositionRegion firstRegion = this.getRegion(0);
            try {
                Position newStartPos = this.doc.createPosition(firstRegion.getStartOffset() - moveStartDownLength);
                firstRegion.setStartPosition(newStartPos);
            }
            catch (BadLocationException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if ((firstRegionText = this.getFirstRegionText()) != null) {
            int regionCount = this.getRegionCount();
            for (int i = 1; i < regionCount; ++i) {
                MutablePositionRegion region = this.getRegion(i);
                int offset = region.getStartOffset();
                int length = region.getEndOffset() - offset;
                try {
                    if (!firstRegionText.equals(this.doc.getText(offset, length))) {
                        this.doc.remove(offset, length);
                        if (firstRegionText.length() > 0) {
                            this.doc.insertString(offset, firstRegionText, null);
                        }
                    }
                    Position newStartPos = this.doc.createPosition(offset);
                    region.setStartPosition(newStartPos);
                    continue;
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
    }

    private String getFirstRegionText() {
        return this.getRegionText(0);
    }

    private String getRegionText(int regionIndex) {
        try {
            MutablePositionRegion region = this.getRegion(regionIndex);
            int offset = region.getStartOffset();
            int length = region.getEndOffset() - offset;
            return this.doc.getText(offset, length);
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }
}

