/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;

public class BeanTreeView
extends TreeView {
    static final long serialVersionUID = 3841322840231536380L;

    public BeanTreeView() {
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    void initializeTree() {
        super.initializeTree();
    }

    protected NodeTreeModel createModel() {
        return new NodeTreeModel();
    }

    protected boolean selectionAccept(Node[] nodes) {
        return true;
    }

    protected void showSelection(TreePath[] treePaths) {
        this.tree.getSelectionModel().setSelectionPaths(treePaths);
        if (treePaths.length == 1) {
            this.showPathWithoutExpansion(treePaths[0]);
        }
    }

    protected void selectionChanged(Node[] nodes, ExplorerManager em) throws PropertyVetoException {
        if (nodes.length > 0) {
            Node context = nodes[0].getParentNode();
            for (int i = 1; i < nodes.length; ++i) {
                if (context == nodes[i].getParentNode()) continue;
                em.setSelectedNodes(nodes);
                return;
            }
            if (em.getRootContext().getParentNode() == context) {
                em.setExploredContextAndSelection(null, nodes);
            } else {
                em.setExploredContextAndSelection(context, nodes);
            }
        } else {
            em.setSelectedNodes(nodes);
        }
    }

    protected void showPath(TreePath path) {
        this.tree.expandPath(path);
        this.showPathWithoutExpansion(path);
    }

    private void showPathWithoutExpansion(TreePath path) {
        Rectangle rect = this.tree.getPathBounds(path);
        if (rect != null) {
            this.tree.scrollRectToVisible(rect);
        }
    }

    public void setEnabled(boolean enabled) {
        this.tree.setEnabled(enabled);
    }

    public boolean isEnabled() {
        if (this.tree == null) {
            return true;
        }
        return this.tree.isEnabled();
    }
}

