/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.io.IOException;
import java.io.Reader;
import org.netbeans.modules.javacore.JMManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;

public class Util {
    static final String ATTR_FILE_ENCODING = "Content-Encoding";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String getFileEncoding(FileObject someFile) {
        String enc = (String)someFile.getAttribute(ATTR_FILE_ENCODING);
        if (enc == null) {
            enc = JMManager.getDefaultEncoding();
        }
        if ("".equals(enc)) {
            return null;
        }
        return enc;
    }

    public static String readContents(Reader r, long size) throws IOException {
        long read;
        if (!$assertionsDisabled && size >= Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        char[] buffer = new char[(int)size];
        int offset = 0;
        while (offset < buffer.length && (read = (long)r.read(buffer, offset, buffer.length - offset)) != -1L) {
            offset = (int)((long)offset + read);
        }
        return new String(buffer, 0, offset);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Node.Cookie obj = dob.getCookie(CloneableEditorSupport.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getCookie(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    public static boolean isModified(FileObject fo) {
        return Util.getModifiedDataObject(fo) != null;
    }

    public static DataObject getModifiedDataObject(FileObject fo) {
        DataObject[] dobjs = DataObject.getRegistry().getModified();
        for (int i = 0; i < dobjs.length; ++i) {
            FileObject fobj = dobjs[i].getPrimaryFile();
            if (fobj == null || !fobj.isValid() || !fobj.equals(fo)) continue;
            return dobjs[i];
        }
        JMManager.ModifiedDOProvider p = JMManager.ModifiedDOProvider.getModifiedDOProvider();
        if (p != null) {
            return p.getModifiedDataObject(fo);
        }
        return null;
    }

    static {
        $assertionsDisabled = !Util.class.desiredAssertionStatus();
    }
}

