/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.TypeMismatchException;
import org.netbeans.api.mdr.events.AssociationEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.mdr.handlers.AssociationHandler;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.util.EventNotifier;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.javacore.jmiimpl.javamodel.TypeVerifier;

public class ReferenceColWrapper
implements Collection {
    protected final MdrStorage storage;
    protected final AssociationHandler source;
    protected final EventNotifier.Association notifier;
    protected final RefObject fixed;
    protected final String endName;
    private Collection inner;
    private int modCount = 0;
    protected final MetadataElement parent;
    protected final int changeMask;
    private TypeVerifier typeVerifier;

    public ReferenceColWrapper(MdrStorage storage, AssociationHandler source, RefObject fixed, String endName, MetadataElement parent, int changeMask, Collection inner) {
        this(storage, source, fixed, endName, parent, changeMask);
        this.setInnerList(inner);
    }

    protected ReferenceColWrapper(MdrStorage storage, AssociationHandler source, RefObject fixed, String endName, MetadataElement parent, int changeMask) {
        this.storage = storage;
        this.source = source;
        this.notifier = storage == null ? null : storage.getEventNotifier().ASSOCIATION;
        this.fixed = fixed;
        this.endName = endName;
        this.parent = parent;
        this.changeMask = changeMask;
    }

    public void setInnerList(Collection inner) {
        ++this.modCount;
        this.inner = inner;
        if (inner instanceof TypeVerifier) {
            this.typeVerifier = (TypeVerifier)((Object)inner);
        }
    }

    public Collection getInnerCollection() {
        return this.inner;
    }

    protected int getModCount() {
        return this.modCount;
    }

    protected void objectChanged(Object obj) {
        if (this.parent == null) {
            if (obj instanceof MetadataElement) {
                ((MetadataElement)((Object)obj)).objectChanged(this.changeMask);
            }
        } else {
            this.parent.objectChanged(this.changeMask);
        }
    }

    public void setTypeVerifier(TypeVerifier newTypeVerifier) {
        this.typeVerifier = newTypeVerifier;
    }

    protected void lock(boolean writeAccess) {
        this.storage.getRepository().beginTrans(writeAccess);
    }

    protected void unlock() {
        this.storage.getRepository().endTrans();
    }

    protected void unlock(boolean fail) {
        this.storage.getRepository().endTrans(fail);
    }

    protected void checkType(Object obj) throws TypeMismatchException {
        if (this.typeVerifier != null) {
            this.typeVerifier.checkType(obj);
        }
    }

    protected void checkWrite() {
        if (this.source == null) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object obj) {
        this.lock(false);
        try {
            boolean bl = this.inner.contains(obj);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        this.lock(false);
        try {
            ReferenceIteratorWrapper referenceIteratorWrapper = new ReferenceIteratorWrapper(this.inner.iterator());
            return referenceIteratorWrapper;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.lock(false);
        try {
            int n = this.inner.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.lock(false);
        try {
            boolean bl = this.inner.isEmpty();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        this.lock(false);
        try {
            boolean bl = this.inner.containsAll(collection);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] obj) {
        this.lock(false);
        try {
            Object[] value = this.inner.toArray();
            Object[] result = obj;
            if (value.length > result.length) {
                result = (Object[])Array.newInstance(obj.getClass().getComponentType(), value.length);
            } else if (value.length < result.length) {
                result[value.length] = null;
            }
            System.arraycopy(value, 0, result, 0, value.length);
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            this.unlock();
        }
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Collection)) {
            return false;
        }
        this.lock(false);
        try {
            Iterator it1 = this.iterator();
            Iterator it2 = ((Collection)object).iterator();
            while (it1.hasNext() && it2.hasNext()) {
                Object o1 = it1.next();
                Object o2 = it2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = !it1.hasNext() && !it2.hasNext();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.lock(false);
        try {
            int hashCode = 1;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            int n = hashCode;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.checkWrite();
        boolean fail = true;
        this.lock(true);
        try {
            Object[] elements = this.inner.toArray();
            for (int i = 0; i < elements.length; ++i) {
                this.remove(elements[i]);
            }
            fail = false;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        this.checkWrite();
        boolean fail = true;
        this.lock(true);
        try {
            boolean result = false;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                result |= this.add(it.next());
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection collection) {
        this.checkWrite();
        boolean fail = true;
        this.lock(true);
        try {
            boolean result = false;
            Object[] elements = this.inner.toArray();
            for (int i = 0; i < elements.length; ++i) {
                Object o = elements[i];
                if (collection.contains(o)) continue;
                this.remove(o);
                result = true;
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        this.checkWrite();
        boolean fail = true;
        this.lock(true);
        try {
            boolean result = false;
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                result |= this.remove(it.next());
            }
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object obj) {
        this.checkWrite();
        this.checkType(obj);
        boolean fail = true;
        this.lock(true);
        try {
            if (this.storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent((RefAssociation)this.source, 0x4010004, this.fixed, this.endName, (RefObject)obj, null, -1);
                this.notifier.firePlannedChange((Object)this.source, (MDRChangeEvent)event);
            }
            boolean result = this.inner.remove(obj);
            this.objectChanged(obj);
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object obj) {
        this.checkWrite();
        this.checkType(obj);
        boolean fail = true;
        this.lock(true);
        try {
            if (this.storage.eventsEnabled()) {
                AssociationEvent event = new AssociationEvent((RefAssociation)this.source, 67174402, this.fixed, this.endName, null, (RefObject)obj, -1);
                this.notifier.firePlannedChange((Object)this.source, (MDRChangeEvent)event);
            }
            boolean result = this.inner.add(obj);
            this.objectChanged(obj);
            fail = false;
            boolean bl = result;
            return bl;
        }
        finally {
            this.unlock(fail);
        }
    }

    protected class ReferenceIteratorWrapper
    implements Iterator {
        protected Iterator innerIterator;
        protected Object lastRead = null;
        protected final int modCount;

        public ReferenceIteratorWrapper(Iterator innerIterator) {
            this.innerIterator = innerIterator;
            this.modCount = this.getParentModCount();
        }

        protected int getParentModCount() {
            return ReferenceColWrapper.this.getModCount();
        }

        protected void testModCount() throws ConcurrentModificationException {
            if (this.modCount != this.getParentModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            this.testModCount();
            ReferenceColWrapper.this.lock(false);
            try {
                boolean bl = this.innerIterator.hasNext();
                return bl;
            }
            finally {
                ReferenceColWrapper.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            this.testModCount();
            ReferenceColWrapper.this.lock(false);
            try {
                this.lastRead = this.innerIterator.next();
                Object e = this.lastRead;
                return e;
            }
            finally {
                ReferenceColWrapper.this.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove() {
            ReferenceColWrapper.this.checkWrite();
            this.testModCount();
            boolean fail = true;
            ReferenceColWrapper.this.lock(true);
            try {
                if (ReferenceColWrapper.this.storage.eventsEnabled()) {
                    AssociationEvent event = new AssociationEvent((RefAssociation)ReferenceColWrapper.this.source, 0x4010004, ReferenceColWrapper.this.fixed, ReferenceColWrapper.this.endName, (RefObject)this.lastRead, null, -1);
                    ReferenceColWrapper.this.notifier.firePlannedChange((Object)ReferenceColWrapper.this.source, (MDRChangeEvent)event);
                }
                this.innerIterator.remove();
                ReferenceColWrapper.this.objectChanged(this.lastRead);
                fail = false;
            }
            finally {
                ReferenceColWrapper.this.unlock(fail);
            }
        }
    }
}

