/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.jmi.reflect.InvalidObjectException;
import javax.jmi.reflect.RefBaseObject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.mdr.MDRepository;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.ResourceClass;
import org.netbeans.lib.java.parser.Factory;
import org.netbeans.lib.java.parser.JScanner;
import org.netbeans.mdr.NBMDRepositoryImpl;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.util.IOUtils;
import org.netbeans.modules.javacore.ClassIndexStorage;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.LazyImmutableList;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.jmiimpl.javamodel.JavaClassImpl;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.JarFileSystem;

public class ClassIndex {
    private static final boolean DEBUG = false;
    private static final Map codebaseIndexes = Collections.synchronizedMap(new HashMap());
    private static boolean shutdownListenerRegistered = false;
    private static final ShutdownL shutdownListener = new ShutdownL();
    private final ClassIndexStorage storage;
    private final String storageId;
    private final NBMDRepositoryImpl rep;
    private long lastSaved;
    private HashMap changeLogSN;
    private HashMap changeLogFQN;
    private HashMap changeLogI;
    static /* synthetic */ Class class$org$netbeans$modules$javacore$ClassIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassIndex(String file, String storageId) {
        this.storageId = storageId;
        this.rep = (NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository();
        this.storage = new CISImpl(file);
        if (!shutdownListenerRegistered) {
            ShutdownL shutdownL = shutdownListener;
            synchronized (shutdownL) {
                if (!shutdownListenerRegistered) {
                    ((NBMDRepositoryImpl)JavaMetamodel.getDefaultRepository()).addShutdownListener((NBMDRepositoryImpl.ShutdownListener)shutdownListener);
                    shutdownListenerRegistered = true;
                }
            }
        }
    }

    static void commit() {
        Iterator it = codebaseIndexes.values().iterator();
        while (it.hasNext()) {
            ((ClassIndex)it.next()).commitChanges();
        }
    }

    static void rollback() {
        Iterator it = codebaseIndexes.values().iterator();
        while (it.hasNext()) {
            ((ClassIndex)it.next()).rollbackChanges();
        }
    }

    private void commitChanges() {
        this.changeLogSN = null;
        this.changeLogFQN = null;
        this.changeLogI = null;
    }

    private void rollbackChanges() {
        JavaClass cls;
        long mofId;
        Map.Entry entry;
        Iterator it;
        if (this.changeLogSN != null) {
            it = this.changeLogSN.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                it.remove();
                mofId = (Long)entry.getKey();
                if (entry.getValue() == null) {
                    cls = (JavaClass)this.rep.getByMofId(this.makeMofId(mofId));
                    if (cls == null) continue;
                    this.addClass(cls, cls.getName(), cls.getSimpleName());
                    continue;
                }
                this.removeFromIndex(true, (String)entry.getValue(), mofId);
            }
        }
        if (this.changeLogFQN != null) {
            it = this.changeLogFQN.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                it.remove();
                mofId = (Long)entry.getKey();
                cls = (JavaClass)this.rep.getByMofId(this.makeMofId(mofId));
                if (entry.getValue() != null) {
                    this.removeFromIndex(false, (String)entry.getValue(), mofId);
                }
                if (cls == null) continue;
                this.addClass(cls, cls.getName(), cls.getSimpleName());
            }
        }
        if (this.changeLogI != null) {
            it = this.changeLogI.entrySet().iterator();
            while (it.hasNext()) {
                entry = it.next();
                it.remove();
                this.storage.setIdentifiers((Long)entry.getKey(), (int[])entry.getValue());
            }
        }
    }

    public static ClassIndex getIndex(JavaModelPackage mofPackage) {
        return (ClassIndex)codebaseIndexes.get(mofPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveAllIndexes() {
        MDRepository rep = JavaMetamodel.getDefaultRepository();
        rep.beginTrans(false);
        try {
            Map map = codebaseIndexes;
            synchronized (map) {
                Iterator indexIt = codebaseIndexes.values().iterator();
                while (indexIt.hasNext()) {
                    ClassIndex index = (ClassIndex)indexIt.next();
                    index.storage.unmount();
                }
            }
        }
        finally {
            rep.endTrans();
        }
    }

    static void removeIndex(JavaModelPackage mofPackage) {
        ClassIndex index = (ClassIndex)codebaseIndexes.remove(mofPackage);
        index.storage.unmount();
    }

    static ClassIndex addIndex(JavaModelPackage mofPackage, String filename) {
        ClassIndex index = new ClassIndex(filename, ((BaseObjectHandler)mofPackage)._getDelegate().getMofId().getStorageID());
        codebaseIndexes.put(mofPackage, index);
        return index;
    }

    static boolean loadIndex(String filename, JavaModelPackage mofPackage) {
        ClassIndex index = ClassIndex.addIndex(mofPackage, filename);
        return index.storage.mount();
    }

    public void renameClass(JavaClass jcls, String newName) {
        long mofId = this.getMofId(jcls);
        String name = jcls.getName();
        String simpleName = jcls.getSimpleName();
        String newSimpleName = JavaClassImpl.getSimpleName(newName);
        if (JMManager.INCONSISTENCY_DEBUG) {
            System.err.println("ClassIndex: Renaming class: " + name + " to: " + newName + " MOFID: " + jcls.refMofId());
        }
        this.removeFromIndex(false, name, mofId);
        Long objMofId = new Long(mofId);
        this.logFQNChange(objMofId, newName);
        if (!simpleName.equals(newSimpleName)) {
            this.removeFromIndex(true, simpleName, mofId);
            this.logSNChange(objMofId, newSimpleName);
        }
        this.addClass(jcls, newName, newSimpleName);
    }

    private static HashMap logChange(HashMap map, Long mofId, Object value) {
        if (map == null) {
            map = new HashMap<Long, Object>();
        }
        map.put(mofId, value);
        return map;
    }

    private void logFQNChange(Long mofId, String name) {
        this.changeLogFQN = ClassIndex.logChange(this.changeLogFQN, mofId, name);
    }

    private void logSNChange(Long mofId, String name) {
        this.changeLogSN = ClassIndex.logChange(this.changeLogSN, mofId, name);
    }

    public void addClass(JavaClass jcls, String fqn, String simpleName) {
        if (JMManager.INCONSISTENCY_DEBUG) {
            System.err.println("ClassIndex: Adding class " + fqn + " MOFID: " + jcls.refMofId());
        }
        long mofId = this.getMofId(jcls);
        this.addToIndex(true, simpleName, mofId);
        this.addToIndex(false, fqn, mofId);
    }

    public long getTimestamp() {
        return this.lastSaved;
    }

    public void setTimestamp() {
        this.lastSaved = System.currentTimeMillis();
    }

    public Set getClassesByFqn(String fqn) {
        HashSet<JavaClass> result = new HashSet<JavaClass>();
        long[] classes = this.storage.getIDsForName(fqn, false);
        if (classes != null) {
            Object cls = null;
            int j = 0;
            for (int i = 0; i < classes.length; ++i) {
                JavaClass temp = (JavaClass)this.rep.getByMofId(this.makeMofId(classes[i]));
                if (temp == null) {
                    this.logFQNChange(new Long(classes[i]), null);
                    continue;
                }
                classes[j] = classes[i];
                ++j;
                result.add(temp);
            }
            if (j == 0) {
                this.storage.setIDsForName(fqn, false, null);
            } else if (j < classes.length) {
                long[] newValue = new long[j];
                System.arraycopy(classes, 0, newValue, 0, j);
                this.storage.setIDsForName(fqn, false, newValue);
            }
        }
        return result;
    }

    public JavaClass getClassByFqn(String fqn) {
        JavaClass oldCls;
        JavaClass cls = null;
        do {
            oldCls = cls;
        } while ((cls = this.tryToGetClassByFqn(fqn)) != null && !cls.isValid() && oldCls != cls);
        if (cls != null && oldCls == cls) {
            try {
                JMManager.getLog().notify(1, (Throwable)new RuntimeException("Class was not cleaned from index: " + cls.getName()));
            }
            catch (InvalidObjectException e) {
                JMManager.getLog().notify(1, (Throwable)e);
            }
            cls = null;
        }
        return cls;
    }

    private JavaClass tryToGetClassByFqn(String fqn) {
        long[] classes = this.storage.getIDsForName(fqn, false);
        if (classes != null) {
            JavaClass result = null;
            JavaClass sureResult = null;
            int j = 0;
            for (int i = 0; i < classes.length; ++i) {
                JavaClass temp = (JavaClass)this.rep.getByMofId(this.makeMofId(classes[i]));
                if (temp == null) {
                    this.logFQNChange(new Long(classes[i]), null);
                    continue;
                }
                classes[j] = classes[i];
                ++j;
                result = temp;
            }
            if (j == 0) {
                this.storage.setIDsForName(fqn, false, null);
            } else if (j < classes.length) {
                long[] newValue = new long[j];
                System.arraycopy(classes, 0, newValue, 0, j);
                this.storage.setIDsForName(fqn, false, newValue);
            }
            return sureResult == null ? result : sureResult;
        }
        return null;
    }

    public LazyImmutableList getClassesByFQNPrefix(String fqnPrefix) {
        return new LazyImmutableList(new ClassesByFQNPrefixIterator(this.storage.getFirstForNamePrefix(fqnPrefix, false)));
    }

    public LazyImmutableList getClassesByFQNPrefix(String fqnPrefix, boolean caseSensitive) {
        if (caseSensitive) {
            return this.getClassesByFQNPrefix(fqnPrefix);
        }
        int dot = fqnPrefix.lastIndexOf(46);
        String packagePart = fqnPrefix.substring(0, dot + 1);
        return new LazyImmutableList(new ClassesByFQNPrefixCIIterator(this.storage.getFirstForNamePrefix(packagePart, false), fqnPrefix));
    }

    public LazyImmutableList getClassesBySNPrefix(String snPrefix) {
        return this.getClassesBySNPrefix(snPrefix, true);
    }

    public LazyImmutableList getClassesBySNPrefix(String snPrefix, boolean caseSensitive) {
        boolean camelCase;
        ClassIndexStorage.QueryItem query;
        if (snPrefix.length() > 1 && snPrefix.equals(snPrefix.toUpperCase())) {
            query = this.storage.getFirstForNamePrefix(snPrefix.substring(0, 1), true);
            camelCase = true;
        } else {
            query = this.storage.getFirstForNamePrefix(snPrefix.toUpperCase(), true);
            camelCase = false;
        }
        return new LazyImmutableList(new ClassesBySNPrefixIterator(query, snPrefix, caseSensitive, camelCase));
    }

    public boolean doesnotExist(String fqn) {
        return !this.storage.existsFQN(fqn);
    }

    public boolean hasClass(String fqn) {
        return this.getClassByFqn(fqn) != null;
    }

    public Collection getClassesBySimpleName(String simpleName) {
        return this.getClassesBySimpleName(simpleName, true);
    }

    public Collection getClassesBySimpleName(String simpleName, boolean caseSensitive) {
        String simpleUpper = simpleName.toUpperCase();
        long[] value = this.storage.getIDsForName(simpleUpper, true);
        ArrayList<JavaClass> res = new ArrayList<JavaClass>();
        if (value != null) {
            int j = 0;
            for (int i = 0; i < value.length; ++i) {
                JavaClass cls = (JavaClass)this.rep.getByMofId(this.makeMofId(value[i]));
                if (cls == null) {
                    this.logSNChange(new Long(value[i]), null);
                    continue;
                }
                value[j] = value[i];
                ++j;
                if (caseSensitive && !simpleName.equals(cls.getSimpleName())) continue;
                res.add(cls);
            }
            if (j == 0) {
                this.storage.setIDsForName(simpleUpper, true, null);
            } else if (j < value.length) {
                long[] newValue = new long[j];
                System.arraycopy(value, 0, newValue, 0, j);
                this.storage.setIDsForName(simpleUpper, true, newValue);
            }
        }
        return res;
    }

    public static boolean hasClass(String fqn, ClassPath classPath) {
        FileObject[] roots = classPath.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            JavaModelPackage mofPackage = JavaMetamodel.getManager().getJavaExtent(roots[i]);
            if (mofPackage == null || !ClassIndex.getIndex(mofPackage).hasClass(fqn)) continue;
            return true;
        }
        return false;
    }

    public static JavaClass getClassByFqn(String fqn, ClassPath classPath) {
        FileObject[] roots = classPath.getRoots();
        for (int i = 0; i < roots.length; ++i) {
            JavaClass cls;
            ClassIndex index;
            JavaModelPackage mofPackage = JavaMetamodel.getManager().getJavaExtent(roots[i]);
            if (mofPackage == null || (index = ClassIndex.getIndex(mofPackage)) == null || (cls = index.getClassByFqn(fqn)) == null) continue;
            return cls;
        }
        return null;
    }

    public void setIdentifiers(Resource rsc, int[] identifiers) {
        Arrays.sort(identifiers);
        this.storage.setIdentifiers(this.getMofId(rsc), identifiers);
    }

    private long getMofId(Object obj) {
        return ((BaseObjectHandler)obj)._getMofId().getSerialNumber();
    }

    private MOFID makeMofId(long mofId) {
        return new MOFID(mofId, this.storageId);
    }

    public void removeResource(Resource rsc) {
        long mofId = this.getMofId(rsc);
        int[] o = this.storage.removeIdentifiers(mofId);
        this.changeLogI = ClassIndex.logChange(this.changeLogI, new Long(mofId), o);
    }

    void updateIdentifiersInResource(Resource rsc, String sourceText) {
        FileObject file = JavaMetamodel.getManager().getFileObject(rsc);
        String sourceLevel = SourceLevelQuery.getSourceLevel((FileObject)file);
        JScanner scanner = Factory.getDefault().getScanner(new StringReader(sourceText), sourceLevel);
        int[] identifiers = this.storage.getIdentifiers(this.getMofId(rsc));
        ArrayList<String> newIds = new ArrayList<String>(10);
        try {
            int token;
            while ((token = scanner.yylex()) != 0) {
                String text;
                int hash;
                if (token != 361 || Arrays.binarySearch(identifiers, hash = (text = scanner.yytext()).hashCode()) >= 0) continue;
                newIds.add(text);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        int newIdSize = newIds.size();
        if (newIdSize > 0) {
            int[] ids = new int[identifiers.length + newIdSize];
            String[] newIdArr = newIds.toArray(new String[newIdSize]);
            for (int i = 0; i < newIdSize; ++i) {
                ids[i] = newIdArr[i].hashCode();
            }
            System.arraycopy(identifiers, 0, ids, newIdSize, identifiers.length);
            this.setIdentifiers(rsc, ids);
        }
    }

    public Collection findResourcesForIdent(String identifier) {
        long[] ids = this.storage.getIDsForIdentifier(identifier.hashCode());
        ArrayList<RefBaseObject> res = new ArrayList<RefBaseObject>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            RefBaseObject obj = this.rep.getByMofId(this.makeMofId(ids[i]));
            if (obj == null) {
                this.storage.removeIdentifiers(ids[i]);
                continue;
            }
            res.add(obj);
        }
        return res;
    }

    public static Resource[] findResourcesForIdentifier(String identifier, boolean includeLibraries) {
        JMManager cfr_ignored_0 = (JMManager)JavaMetamodel.getManager();
        List cp = JMManager.getTransactionMutex().getSearchScope();
        FileObject[] roots = cp == null ? JavaMetamodel.getManager().getClassPath().getRoots() : (cp.size() == 1 ? ((ClassPath)cp.get(0)).getRoots() : ClassPathSupport.createProxyClassPath((ClassPath[])cp.toArray(new ClassPath[cp.size()])).getRoots());
        ArrayList resources = new ArrayList();
        HashSet<FileObject> visitedRoots = new HashSet<FileObject>((int)((double)roots.length / 0.7));
        JavaMetamodel manager = JavaMetamodel.getManager();
        boolean isJavaDocTag = identifier.startsWith("@");
        for (int i = 0; i < roots.length; ++i) {
            FileObject root = roots[i];
            if (!visitedRoots.add(root)) continue;
            try {
                JavaModelPackage mofPackage;
                if (!includeLibraries && root.getFileSystem() instanceof JarFileSystem || (mofPackage = manager.getJavaExtent(root)) == null) continue;
                if (isJavaDocTag) {
                    ResourceClass resourceClass = mofPackage.getResource();
                    resources.addAll(resourceClass.refAllOfClass());
                    continue;
                }
                resources.addAll(ClassIndex.getIndex(mofPackage).findResourcesForIdent(identifier));
                continue;
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public static Resource[] findResourcesForIdentifier(String identifier) {
        return ClassIndex.findResourcesForIdentifier(identifier, false);
    }

    public static void updateIdentifiers(Resource rsc, String sourceText) {
        JavaModelPackage mofPackage = (JavaModelPackage)rsc.refOutermostPackage();
        ClassIndex.getIndex(mofPackage).updateIdentifiersInResource(rsc, sourceText);
    }

    public static boolean containsIdentifier(Resource rsc, int identifier) {
        JavaModelPackage mofPackage = (JavaModelPackage)rsc.refOutermostPackage();
        ClassIndex index = ClassIndex.getIndex(mofPackage);
        int[] idents = index.storage.getIdentifiers(index.getMofId(rsc));
        if (idents == null) {
            JMManager.getLog().log("ids is null for " + rsc.getName());
            return false;
        }
        return Arrays.binarySearch(idents, identifier) >= 0;
    }

    private void addToIndex(boolean isSimpleName, String name, long value) {
        long[] newValue;
        int len;
        long[] temp;
        if (isSimpleName) {
            name = name.toUpperCase();
        }
        if ((temp = this.storage.getIDsForName(name, isSimpleName)) == null) {
            len = 0;
            newValue = new long[len + 1];
        } else {
            long[] oldValue = temp;
            len = oldValue.length;
            newValue = new long[len + 1];
            for (int i = 0; i < len; ++i) {
                if (oldValue[i] == value) {
                    newValue = oldValue;
                    break;
                }
                newValue[i] = oldValue[i];
            }
        }
        if (newValue != temp) {
            newValue[len] = value;
            this.storage.setIDsForName(name, isSimpleName, newValue);
        }
    }

    private void removeFromIndex(boolean isSimpleName, String name, long value) {
        long[] temp;
        if (isSimpleName) {
            name = name.toUpperCase();
        }
        if ((temp = this.storage.getIDsForName(name, isSimpleName)) != null) {
            int i;
            long[] oldValue = temp;
            int len = oldValue.length;
            long[] newValue = new long[len - 1];
            int j = 0;
            for (i = 0; i < len && j < len - 1; ++i) {
                if (oldValue[i] == value) continue;
                newValue[j++] = oldValue[i];
            }
            if (i < len && oldValue[i] != value) {
                if (j < len - 1) {
                    newValue[j] = oldValue[i];
                } else {
                    newValue = oldValue;
                }
            }
            if (oldValue != newValue) {
                if (newValue.length == 0) {
                    newValue = null;
                }
                this.storage.setIDsForName(name, isSimpleName, newValue);
            }
        }
    }

    private class StreamBasedSortedMap
    implements SortedMap {
        private int size;
        InputStream stream;

        private StreamBasedSortedMap(InputStream indexStream) throws IOException {
            this.stream = indexStream;
            this.size = IOUtils.readInt((InputStream)this.stream);
        }

        public Comparator comparator() {
            return null;
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            throw new UnsupportedOperationException();
        }

        public SortedMap headMap(Object toKey) {
            throw new UnsupportedOperationException();
        }

        public SortedMap tailMap(Object fromKey) {
            throw new UnsupportedOperationException();
        }

        public Object firstKey() {
            throw new UnsupportedOperationException();
        }

        public Object lastKey() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.size;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public boolean containsKey(Object key) {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public Object get(Object key) {
            throw new UnsupportedOperationException();
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            throw new UnsupportedOperationException();
        }

        public Set entrySet() {
            return new EntrySet();
        }

        private class EntrySet
        extends AbstractSet {
            private EntrySet() {
            }

            public Iterator iterator() {
                return new EntrySetIterator();
            }

            public int size() {
                return StreamBasedSortedMap.this.size;
            }

            private class EntrySetIterator
            implements Iterator,
            Map.Entry {
                private int index;
                private String key;
                private long[] value;

                private EntrySetIterator() {
                }

                public boolean hasNext() {
                    return this.index < StreamBasedSortedMap.this.size;
                }

                public Object next() {
                    try {
                        this.key = IOUtils.readString((InputStream)((EntrySet)EntrySet.this).StreamBasedSortedMap.this.stream);
                        int count = IOUtils.readInt((InputStream)((EntrySet)EntrySet.this).StreamBasedSortedMap.this.stream);
                        this.value = new long[count];
                        for (int j = 0; j < count; ++j) {
                            this.value[j] = IOUtils.readLong((InputStream)((EntrySet)EntrySet.this).StreamBasedSortedMap.this.stream);
                        }
                        ++this.index;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        this.index = StreamBasedSortedMap.this.size;
                    }
                    return this;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }

                public Object getKey() {
                    return this.key;
                }

                public Object getValue() {
                    return this.value;
                }

                public Object setValue(Object value) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private class CISImpl
    implements ClassIndexStorage {
        private static final int VERSION = 2;
        private static final String INDEX_SUFFIX = ".cdx";
        private final SortedMap fqnMap;
        private final SortedMap simpleMap;
        private Map identifiersMap;
        private final String filename;
        private transient boolean isDirty;
        static final /* synthetic */ boolean $assertionsDisabled;

        CISImpl(String filename) {
            this.filename = filename;
            this.fqnMap = new TreeMap();
            this.simpleMap = new TreeMap();
            this.identifiersMap = new HashMap();
            this.isDirty = true;
        }

        private ClassIndexStorage.QueryItem createNextCIIImpl(Iterator it, int length) throws ConcurrentModificationException {
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (((String)entry.getKey()).lastIndexOf(46) >= length) continue;
                return new CIIImpl(it, entry, length);
            }
            return null;
        }

        public ClassIndexStorage.QueryItem createNextCIISNImpl(Iterator it) throws ConcurrentModificationException {
            if (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                return new CIISNImpl(it, entry);
            }
            return null;
        }

        public ClassIndexStorage.QueryItem getFirstForNamePrefix(String prefix, boolean isSimpleName) {
            SortedMap map = prefix == null || prefix.length() == 0 ? (isSimpleName ? this.simpleMap : this.fqnMap) : (isSimpleName ? this.simpleMap : this.fqnMap).subMap(prefix, prefix + '\uffff');
            if (isSimpleName) {
                return this.createNextCIISNImpl(map.entrySet().iterator());
            }
            int length = prefix.length();
            return this.createNextCIIImpl(map.entrySet().iterator(), length);
        }

        public boolean existsFQN(String fqn) {
            return this.fqnMap.get(fqn) != null;
        }

        public void setIdentifiers(long resourceId, int[] hashCodes) {
            if (!$assertionsDisabled && hashCodes == null) {
                throw new AssertionError();
            }
            this.isDirty = true;
            this.identifiersMap.put(new Long(resourceId), hashCodes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean mount() {
            long t = 0L;
            try {
                if (JMManager.PERF_DEBUG) {
                    t = System.currentTimeMillis();
                }
                File indexFile = new File(this.filename.concat(INDEX_SUFFIX));
                BufferedInputStream indexStream = new BufferedInputStream(new FileInputStream(indexFile), 65536);
                try {
                    this.read(indexStream);
                }
                finally {
                    ((InputStream)indexStream).close();
                }
                this.isDirty = false;
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                JMManager.getLog().notify(1, (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                if (JMManager.PERF_DEBUG) {
                    System.err.println("loading index " + this.filename + " took: " + (System.currentTimeMillis() - t) + "ms");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unmount() {
            if (!this.isDirty) {
                return;
            }
            if (JMManager.PERF_DEBUG) {
                System.err.println("saving index " + this.filename);
            }
            ClassIndex.this.rep.beginTrans(false);
            try {
                FileOutputStream fos = new FileOutputStream(this.filename.concat(INDEX_SUFFIX));
                BufferedOutputStream indexStream = new BufferedOutputStream(fos, 65536);
                try {
                    this.write(indexStream);
                }
                finally {
                    indexStream.close();
                }
                this.isDirty = false;
            }
            catch (Exception ex) {
                JMManager.getLog().notify(1, (Throwable)ex);
            }
            finally {
                ClassIndex.this.rep.endTrans();
            }
        }

        private void read(InputStream indexStream) throws IOException {
            if (2 != IOUtils.readInt((InputStream)indexStream)) {
                return;
            }
            if (!ClassIndex.this.storageId.equals(IOUtils.readString((InputStream)indexStream))) {
                return;
            }
            this.readMap(indexStream, this.fqnMap);
            this.readMap(indexStream, this.simpleMap);
            int count = IOUtils.readInt((InputStream)indexStream);
            this.identifiersMap = new HashMap(count * 4 / 3 + 1);
            for (int i = 0; i < count; ++i) {
                Long key = new Long(IOUtils.readLong((InputStream)indexStream));
                int count2 = IOUtils.readInt((InputStream)indexStream);
                int[] value = new int[count2];
                for (int j = 0; j < count2; ++j) {
                    value[j] = IOUtils.readInt((InputStream)indexStream);
                }
                this.identifiersMap.put(key, value);
            }
            ClassIndex.this.lastSaved = IOUtils.readLong((InputStream)indexStream);
        }

        private void write(OutputStream indexStream) throws IOException {
            if (JMManager.PERF_DEBUG) {
                System.err.println("fqnMap: " + this.fqnMap.size() + " records; identifiersMap: " + this.identifiersMap.size() + "records");
            }
            IOUtils.writeInt((OutputStream)indexStream, (int)2);
            IOUtils.writeString((OutputStream)indexStream, (String)ClassIndex.this.storageId);
            this.writeMap(indexStream, this.fqnMap);
            this.writeMap(indexStream, this.simpleMap);
            IOUtils.writeInt((OutputStream)indexStream, (int)this.identifiersMap.size());
            Iterator it = this.identifiersMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                IOUtils.writeLong((OutputStream)indexStream, (long)((Long)entry.getKey()));
                int[] array = (int[])entry.getValue();
                IOUtils.writeInt((OutputStream)indexStream, (int)array.length);
                for (int i = 0; i < array.length; ++i) {
                    IOUtils.writeInt((OutputStream)indexStream, (int)array[i]);
                }
            }
            IOUtils.writeLong((OutputStream)indexStream, (long)System.currentTimeMillis());
        }

        private void readMap(InputStream indexStream, Map map) throws IOException {
            map.putAll(new StreamBasedSortedMap(indexStream));
        }

        private void writeMap(OutputStream indexStream, Map map) throws IOException {
            IOUtils.writeInt((OutputStream)indexStream, (int)map.size());
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                IOUtils.writeString((OutputStream)indexStream, (String)((String)entry.getKey()));
                long[] array = (long[])entry.getValue();
                IOUtils.writeInt((OutputStream)indexStream, (int)array.length);
                for (int i = 0; i < array.length; ++i) {
                    IOUtils.writeLong((OutputStream)indexStream, (long)array[i]);
                }
            }
        }

        public long[] getIDsForName(String name, boolean isSimpleName) {
            return (long[])(isSimpleName ? this.simpleMap : this.fqnMap).get(name);
        }

        public long[] getIDsForIdentifier(int hashCode) {
            Iterator it = this.identifiersMap.entrySet().iterator();
            ArrayList result = new ArrayList(50);
            while (it.hasNext()) {
                Map.Entry en = it.next();
                int[] ids = (int[])en.getValue();
                if (ids == null) {
                    this.isDirty = true;
                    it.remove();
                    continue;
                }
                if (Arrays.binarySearch(ids, hashCode) < 0) continue;
                result.add(en.getKey());
            }
            long[] res = new long[result.size()];
            it = result.iterator();
            int i = 0;
            while (it.hasNext()) {
                res[i] = (Long)((Object)it.next());
                ++i;
            }
            return res;
        }

        public void setIDsForName(String name, boolean isSimpleName, long[] classIDs) {
            SortedMap map;
            this.isDirty = true;
            SortedMap sortedMap = map = isSimpleName ? this.simpleMap : this.fqnMap;
            if (classIDs == null || classIDs.length == 0) {
                map.remove(name);
            } else {
                map.put(name, classIDs);
            }
        }

        public int[] getIdentifiers(long resourceId) {
            return (int[])this.identifiersMap.get(new Long(resourceId));
        }

        public int[] removeIdentifiers(long resourceId) {
            this.isDirty = true;
            return (int[])this.identifiersMap.remove(new Long(resourceId));
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$javacore$ClassIndex == null ? (class$org$netbeans$modules$javacore$ClassIndex = ClassIndex.class$("org.netbeans.modules.javacore.ClassIndex")) : class$org$netbeans$modules$javacore$ClassIndex).desiredAssertionStatus();
        }

        private class CIISNImpl
        extends AbstractCIIImpl {
            CIISNImpl(Iterator it, Map.Entry entry) {
                super(it, entry);
            }

            protected ClassIndexStorage.QueryItem createNext(Iterator it) throws ConcurrentModificationException {
                return CISImpl.this.createNextCIISNImpl(it);
            }

            protected void remove() {
                CISImpl.this.setIDsForName(this.getName(), true, null);
            }
        }

        private class CIIImpl
        extends AbstractCIIImpl {
            private final int length;

            CIIImpl(Iterator it, Map.Entry entry, int length) {
                super(it, entry);
                this.length = length;
            }

            protected ClassIndexStorage.QueryItem createNext(Iterator it) throws ConcurrentModificationException {
                return CISImpl.this.createNextCIIImpl(it, this.length);
            }

            protected void remove() {
                CISImpl.this.setIDsForName(this.getName(), false, null);
            }
        }

        private abstract class AbstractCIIImpl
        implements ClassIndexStorage.QueryItem {
            private Iterator it;
            private final Map.Entry entry;
            private ClassIndexStorage.QueryItem next;

            AbstractCIIImpl(Iterator it, Map.Entry entry) {
                this.it = it;
                this.entry = entry;
            }

            public final void setIDs(long[] ids) throws ConcurrentModificationException {
                CISImpl.this.isDirty = true;
                this.entry.setValue(ids);
                if (ids == null) {
                    if (this.it == null) {
                        for (ClassIndexStorage.QueryItem item = this.getNext(); item != null; item = item.getNext()) {
                        }
                        this.remove();
                    } else {
                        this.it.remove();
                    }
                }
            }

            public final String getName() {
                return (String)this.entry.getKey();
            }

            public final long[] getIDs() {
                return (long[])this.entry.getValue();
            }

            public final ClassIndexStorage.QueryItem getNext() throws ConcurrentModificationException {
                if (this.it != null) {
                    this.next = this.createNext(this.it);
                    this.it = null;
                }
                return this.next;
            }

            protected abstract ClassIndexStorage.QueryItem createNext(Iterator var1) throws ConcurrentModificationException;

            protected abstract void remove();
        }
    }

    private static class ShutdownL
    implements NBMDRepositoryImpl.ShutdownListener {
        private ShutdownL() {
        }

        public void shutdown() {
            ClassIndex.saveAllIndexes();
        }

        public void stepFinished() {
        }
    }

    private class ClassesByFQNPrefixCIIterator
    extends ClassesByFQNPrefixIterator {
        private final String namePrefix;

        ClassesByFQNPrefixCIIterator(ClassIndexStorage.QueryItem item, String namePrefix) {
            super(item);
            this.namePrefix = namePrefix.toUpperCase();
        }

        protected boolean accept(ClassIndexStorage.QueryItem item) {
            return this.namePrefix.length() == 0 || item.getName().toUpperCase().startsWith(this.namePrefix);
        }
    }

    private class ClassesByFQNPrefixIterator
    extends ClassesByPrefixIterator {
        ClassesByFQNPrefixIterator(ClassIndexStorage.QueryItem item) {
            super(item);
        }

        protected int evaluateItem(long[] value, int i, int j, JavaClass cls, Collection result) {
            if (cls == null) {
                ClassIndex.this.logFQNChange(new Long(value[i]), null);
                return 0;
            }
            if (((JavaClassImpl)cls).hasComposite()) {
                result.add(cls);
            } else {
                JMManager.getTransactionMutex().invalidateAtCommit((Element)cls);
            }
            value[j] = value[i];
            return 1;
        }
    }

    private class ClassesBySNPrefixIterator
    extends ClassesByPrefixIterator {
        private final String prefix;
        private final boolean matchName;
        private final boolean camelCase;

        ClassesBySNPrefixIterator(ClassIndexStorage.QueryItem item, String prefix, boolean caseSensitive, boolean camelCase) {
            super(item);
            this.prefix = prefix;
            this.matchName = caseSensitive && prefix.length() > 0;
            this.camelCase = camelCase;
        }

        protected boolean accept(ClassIndexStorage.QueryItem item) {
            return !this.camelCase || item.getName().startsWith(this.prefix) || this.matchIndexEntry(item.getName());
        }

        private boolean matchIndexEntry(String indexEntryName) {
            int index = -1;
            for (int i = 0; i < this.prefix.length(); ++i) {
                index = indexEntryName.indexOf(this.prefix.charAt(i), index + 1);
                if (index >= 0) continue;
                return false;
            }
            return true;
        }

        private boolean matchName(String simpleName) {
            if (!this.matchName && simpleName.toUpperCase().startsWith(this.prefix)) {
                return true;
            }
            int pi = 0;
            for (int sni = 0; sni < simpleName.length() && pi < this.prefix.length(); ++sni) {
                char ch = simpleName.charAt(sni);
                if (!Character.isUpperCase(ch) || ch == this.prefix.charAt(pi++)) continue;
                return false;
            }
            return pi == this.prefix.length();
        }

        protected int evaluateItem(long[] value, int i, int j, JavaClass cls, Collection result) {
            if (cls == null) {
                ClassIndex.this.logSNChange(new Long(value[i]), null);
                return 0;
            }
            value[j] = value[i];
            if (!this.matchName && !this.camelCase || this.matchName && cls.getSimpleName().startsWith(this.prefix) || this.camelCase && this.matchName(cls.getSimpleName())) {
                if (((JavaClassImpl)cls).hasComposite()) {
                    result.add(cls);
                } else {
                    JMManager.getTransactionMutex().invalidateAtCommit((Element)cls);
                }
            }
            return 1;
        }
    }

    private abstract class ClassesByPrefixIterator
    extends LazyImmutableList.LazyIterator {
        private int maxSize = -1;
        private int currentSize = 0;
        protected ClassIndexStorage.QueryItem currentItem;
        private Object next;
        private boolean hasNext = true;
        private Iterator inner = Collections.EMPTY_LIST.iterator();

        ClassesByPrefixIterator(ClassIndexStorage.QueryItem item) {
            this.currentItem = item;
        }

        public final Object next() {
            if (this.next == null) {
                this.findNext();
            }
            Object result = this.next;
            this.next = null;
            return result;
        }

        public final boolean hasNext() {
            this.findNext();
            return this.hasNext;
        }

        protected final int maxEstimatedSize() {
            if (this.maxSize == -1) {
                this.computeSize();
            }
            return this.maxSize;
        }

        private void computeSize() {
            this.maxSize = this.currentSize;
            for (ClassIndexStorage.QueryItem item = this.currentItem; item != null; item = item.getNext()) {
                this.maxSize += item.getIDs().length;
            }
        }

        private void findNext() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            while (this.next == null && this.hasNext) {
                if (this.inner.hasNext()) {
                    this.next = this.inner.next();
                    continue;
                }
                while (this.currentItem != null && !this.accept(this.currentItem)) {
                    this.currentItem = this.currentItem.getNext();
                }
                if (this.currentItem != null) {
                    this.inner = this.getClassesByPrefix().iterator();
                    continue;
                }
                this.hasNext = false;
            }
        }

        private Collection getClassesByPrefix() {
            ArrayList result = new ArrayList();
            long[] value = this.currentItem.getIDs();
            this.currentSize += value.length;
            int j = 0;
            for (int i = 0; i < value.length; ++i) {
                JavaClass cls = (JavaClass)ClassIndex.this.rep.getByMofId(ClassIndex.this.makeMofId(value[i]));
                j += this.evaluateItem(value, i, j, cls, result);
            }
            if (j == 0) {
                this.currentItem.setIDs(null);
            } else if (j < value.length) {
                long[] newValue = new long[j];
                System.arraycopy(value, 0, newValue, 0, j);
                this.currentItem.setIDs(newValue);
            }
            this.currentItem = this.currentItem.getNext();
            return result;
        }

        protected boolean accept(ClassIndexStorage.QueryItem item) {
            return true;
        }

        protected abstract int evaluateItem(long[] var1, int var2, int var3, JavaClass var4, Collection var5);
    }
}

