/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.soap.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPBody;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPComponent;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.SOAPQName;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.impl.PartReference;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.impl.SOAPAttribute;
import org.netbeans.modules.xml.wsdl.model.extensions.soap.impl.SOAPMessageBaseImpl;
import org.netbeans.modules.xml.wsdl.model.impl.Util;
import org.netbeans.modules.xml.xam.Reference;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPBodyImpl
extends SOAPMessageBaseImpl
implements SOAPBody {
    public SOAPBodyImpl(WSDLModel model, Element e) {
        super(model, e);
    }

    public SOAPBodyImpl(WSDLModel model) {
        this(model, SOAPBodyImpl.createPrefixedElement(SOAPQName.BODY.getQName(), model));
    }

    @Override
    public void accept(SOAPComponent.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<String> getParts() {
        String s = this.getAttribute(SOAPAttribute.PARTS);
        return s == null ? null : Util.parse(s);
    }

    @Override
    public List<Reference<Part>> getPartRefs() {
        String s = this.getAttribute(SOAPAttribute.PARTS);
        return s == null ? null : this.parseParts(s);
    }

    @Override
    public void addPart(String part) {
        String parts = this.getAttribute(SOAPAttribute.PARTS);
        parts = parts == null ? part : parts.trim() + " " + part;
        this.setAttribute("parts", SOAPAttribute.PARTS, parts);
    }

    @Override
    public void addPartRef(Reference<Part> partRef) {
        this.addPart(partRef.getRefString());
    }

    @Override
    public void addPart(int index, String part) {
        List<String> parts = this.getParts();
        if (parts != null) {
            parts.add(index, part);
        } else {
            parts = Collections.singletonList(part);
        }
        this.setAttribute("parts", SOAPAttribute.PARTS, Util.toString(parts));
    }

    @Override
    public void addPartRef(int index, Reference<Part> partRef) {
        this.addPart(index, partRef.getRefString());
    }

    @Override
    public void removePart(String part) {
        List<String> parts = this.getParts();
        if (parts != null && parts.remove(part)) {
            this.setAttribute("parts", SOAPAttribute.PARTS, Util.toString(parts));
        }
    }

    @Override
    public void removePartRef(Reference<Part> partRef) {
        this.removePart(partRef.getRefString());
    }

    @Override
    public void setParts(List<String> parts) {
        this.setAttribute("parts", SOAPAttribute.PARTS, Util.toString(parts));
    }

    @Override
    public void setPartRefs(List<Reference<Part>> parts) {
        String value = null;
        if (parts != null && !parts.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Reference<Part> ref : parts) {
                sb.append(ref.getRefString());
            }
            value = sb.toString();
        }
        this.setAttribute("parts", SOAPAttribute.PARTS, value);
    }

    private List<Reference<Part>> parseParts(String s) {
        ArrayList<Reference<Part>> ret = new ArrayList<Reference<Part>>();
        for (String part : Util.parse(s)) {
            ret.add(new PartReference(this, part));
        }
        return ret;
    }
}

