/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.impl;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.CatalogFactory;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.Processor;
import org.apache.shale.remoting.impl.ChainContext;

public class ChainProcessor
implements Processor {
    private transient Log log = null;

    public void process(FacesContext context, String resourceId) throws IOException {
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Translated resource id '" + resourceId + "' to catalog '" + this.mapCatalog(context, resourceId) + "' and command '" + this.mapCommand(context, resourceId) + "'"));
        }
        String catalogName = this.mapCatalog(context, resourceId);
        Catalog catalog = CatalogFactory.getInstance().getCatalog(catalogName);
        if (catalog == null) {
            if (this.log().isErrorEnabled()) {
                this.log().error((Object)("Cannot find catalog '" + catalogName + "' for resource '" + resourceId + "'"));
            }
            this.sendNotFound(context, resourceId);
            context.responseComplete();
            return;
        }
        String commandName = this.mapCommand(context, resourceId);
        Command command = catalog.getCommand(commandName);
        if (command == null) {
            if (this.log().isErrorEnabled()) {
                this.log().error((Object)("Cannot find command '" + commandName + "' in catalog '" + catalogName + "' for resource '" + resourceId + "'"));
            }
            this.sendNotFound(context, resourceId);
            context.responseComplete();
            return;
        }
        try {
            command.execute(this.createContext(context, resourceId));
        }
        catch (Exception e) {
            if (this.log().isErrorEnabled()) {
                this.log().error((Object)("Exception executing command '" + commandName + "' from catalog '" + catalogName + "' for resource '" + resourceId + "'"), (Throwable)e);
            }
            this.sendServerError(context, resourceId, e);
        }
        context.responseComplete();
    }

    protected Context createContext(FacesContext context, String resourceId) {
        return new ChainContext(context);
    }

    protected String mapCatalog(FacesContext context, String resourceId) {
        return "remoting";
    }

    protected String mapCommand(FacesContext context, String resourceId) {
        if (resourceId.startsWith("/")) {
            resourceId = resourceId.substring(1);
        }
        resourceId = resourceId.replace('/', '.');
        return resourceId;
    }

    protected void sendNotFound(FacesContext context, String resourceId) throws IOException {
        if (!this.servletRequest(context)) {
            throw new IllegalArgumentException(resourceId);
        }
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.sendError(404, resourceId);
    }

    protected void sendServerError(FacesContext context, String resourceId, Exception e) throws IOException {
        if (!this.servletRequest(context)) {
            throw new FacesException(resourceId);
        }
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.sendError(500, resourceId);
    }

    protected boolean servletRequest(FacesContext context) {
        return context.getExternalContext().getContext() instanceof ServletContext;
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)ChainProcessor.class);
        }
        return this.log;
    }
}

