/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.patterns;

import java.io.IOException;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.ejbcore.api.codegeneration.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.gen.Bean;
import org.netbeans.modules.j2ee.ejbcore.patterns.DTOHelper;
import org.openide.filesystems.FileObject;

public class DTOGenerator {
    private EjbGenerationUtil genUtil = new EjbGenerationUtil();
    private static final String DTO_TEMPLATE = "/org/netbeans/modules/j2ee/ejbcore/ejb/wizard/xsl/DTO.xml";
    private static final String DTO_SUFIX = "DTO";
    private int indexField;
    private Bean b;
    private DTOHelper dtoHelp;

    private static String toFirstUpper(String str) {
        StringBuffer buffer = new StringBuffer(str);
        buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
        return buffer.toString();
    }

    private static String getDTOName(String beanName) {
        return EjbGenerationUtil.getEjbNameBase(beanName) + DTO_SUFIX;
    }

    private static String getDTOFullName(String pkgName, String beanName) {
        return pkgName + "." + DTOGenerator.getDTOName(beanName);
    }

    public void generateDTO(DTOHelper dtoHelp, FileObject pkg, boolean generateCmrFields) throws IOException {
        CmrField[] cmrs;
        String pkgName;
        this.dtoHelp = dtoHelp;
        if (pkg != null) {
            pkgName = EjbGenerationUtil.getSelectedPackageName(pkg, dtoHelp.getProject());
        } else {
            pkgName = dtoHelp.getPackage();
            pkg = EjbGenerationUtil.getPackageFileObject(dtoHelp.getSourceGroup(), pkgName, dtoHelp.getProject());
        }
        String dtoName = dtoHelp.getEntityName();
        this.b = this.genUtil.getDefaultBean();
        this.b.setClassname(true);
        this.b.setClassnameName(DTOGenerator.getDTOName(dtoName));
        this.b.setCommentDataEjbName(dtoHelp.getLocalName());
        if (pkgName != null) {
            this.b.setClassnamePackage(pkgName);
        }
        this.b.setKey(true);
        this.b.setKeyFullname(DTOGenerator.getDTOFullName(pkgName, dtoName));
        CmpField[] cmps = dtoHelp.getCmpFields();
        this.addCmpFields(cmps);
        if (generateCmrFields && (cmrs = dtoHelp.getCmrFields()) != null) {
            this.addCmrFields(cmrs);
        }
        this.genUtil.generateBeanClass(DTO_TEMPLATE, this.b, pkgName, pkg, true);
    }

    private void addField(int index, String fieldName, String cmFieldClassName) {
        this.b.addCmField(true);
        this.b.setCmFieldMethodName(index, DTOGenerator.toFirstUpper(fieldName));
        this.b.setCmFieldClassname(index, cmFieldClassName);
        this.b.addCmFieldName(fieldName);
    }

    private void addCmpFields(CmpField[] cmps) {
        for (int i = 0; i < cmps.length; ++i) {
            if (cmps[i] == null) continue;
            String fieldName = cmps[i].getFieldName();
            this.addField(this.indexField, fieldName, this.dtoHelp.getFieldType(fieldName));
            this.b.setCmFieldInKey(this.indexField, fieldName);
            ++this.indexField;
        }
    }

    private void addCmrFields(CmrField[] cmrs) {
        for (int i = 0; i < cmrs.length; ++i) {
            int fieldIndex;
            String cmFieldCmrField;
            String fieldClassName;
            if (cmrs[i] == null) continue;
            String fieldName = cmrs[i].getCmrFieldName();
            ++this.indexField;
            boolean isMultiplicity = this.dtoHelp.isMultiple(cmrs[i]);
            if (isMultiplicity) {
                fieldClassName = this.dtoHelp.getFieldType(fieldName);
                cmFieldCmrField = this.dtoHelp.getOppositeFieldType(cmrs[i]);
            } else {
                fieldClassName = DTOGenerator.getDTOName(this.dtoHelp.findEntityNameByLocalInt(this.dtoHelp.getFieldType(fieldName)));
                cmFieldCmrField = fieldName;
            }
            this.addField(fieldIndex, fieldName, fieldClassName);
            this.b.setCmFieldCmrField(fieldIndex, cmFieldCmrField);
            if (!isMultiplicity) continue;
            this.b.setCmFieldCascadeDelete(fieldIndex, DTOGenerator.getDTOName(this.dtoHelp.findEntityNameByLocalInt(cmFieldCmrField)));
        }
    }
}

