/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.safedelete;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.refactoring.DefaultPositionBoundsResolver;
import org.netbeans.modules.j2ee.refactoring.J2EERefactoring;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.safedelete.AbstractSafeDeleteRefactoringElement;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebXmlSafeDeleteRefactoring
implements J2EERefactoring {
    private JavaClass javaClass;
    private SafeDeleteRefactoring safeDeleteRefactoring;

    public WebXmlSafeDeleteRefactoring(SafeDeleteRefactoring safeDeleteRefactoring, JavaClass javaClass) {
        this.javaClass = javaClass;
        this.safeDeleteRefactoring = safeDeleteRefactoring;
    }

    private List<FileObject> getDeploymentDescriptors() {
        Collection modules = Utility.getRelevantWebModules((Element)this.javaClass);
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (WebModule each : modules) {
            FileObject webXmlFo = each.getDeploymentDescriptor();
            if (webXmlFo == null) continue;
            result.add(webXmlFo);
        }
        return result;
    }

    private void processServlets(WebApp webXmlDD, FileObject webXmlFO, RefactoringElementsBag refactoringElements) {
        Servlet[] servlets = webXmlDD.getServlet();
        for (int s = 0; s < servlets.length; ++s) {
            final Servlet servlet = servlets[s];
            final String servletClass = servlet.getServletClass();
            if (servletClass == null || !servletClass.equals(this.javaClass.getName())) continue;
            final List<ServletMapping> mappings = this.getServletMappings(webXmlDD, servlet);
            WebXmlSafeDeleteRefactoringElement elem = new WebXmlSafeDeleteRefactoringElement(webXmlFO, webXmlDD, servletClass){

                protected void doChange() {
                    this.webApp.removeServlet(servlet);
                    for (ServletMapping elem : mappings) {
                        this.webApp.removeServletMapping(elem);
                    }
                }

                protected void undoChange() {
                    this.webApp.addServlet(servlet);
                    for (ServletMapping elem : mappings) {
                        this.webApp.addServletMapping(elem);
                    }
                }

                public String getDisplayText() {
                    return NbBundle.getMessage(WebXmlSafeDeleteRefactoring.class, (String)"TXT_WebXmlServletSafeDelete", (Object)servletClass);
                }
            };
            refactoringElements.add((AbstractRefactoring)this.safeDeleteRefactoring, (RefactoringElementImplementation)elem);
        }
    }

    private List<ServletMapping> getServletMappings(WebApp webApp, Servlet servlet) {
        ServletMapping[] mappings = webApp.getServletMapping();
        ArrayList<ServletMapping> result = new ArrayList<ServletMapping>();
        for (int i = 0; i < mappings.length; ++i) {
            if (!servlet.getServletName().equals(mappings[i].getServletName())) continue;
            result.add(mappings[i]);
        }
        return result;
    }

    private void processFilters(WebApp webXmlDD, FileObject webXmlFO, RefactoringElementsBag refactoringElements) {
        Filter[] filters = webXmlDD.getFilter();
        for (int i = 0; i < filters.length; ++i) {
            final Filter filter = filters[i];
            final String filterClass = filter.getFilterClass();
            if (filterClass == null || !filterClass.equals(this.javaClass.getName())) continue;
            final List<FilterMapping> mappings = this.getFilterMappings(webXmlDD, filter);
            WebXmlSafeDeleteRefactoringElement elem = new WebXmlSafeDeleteRefactoringElement(webXmlFO, webXmlDD, filterClass){

                protected void doChange() {
                    this.webApp.removeFilter(filter);
                    for (FilterMapping elem : mappings) {
                        this.webApp.removeFilterMapping(elem);
                    }
                }

                protected void undoChange() {
                    this.webApp.addFilter(filter);
                    for (FilterMapping elem : mappings) {
                        this.webApp.addFilterMapping(elem);
                    }
                }

                public String getDisplayText() {
                    return NbBundle.getMessage(WebXmlSafeDeleteRefactoring.class, (String)"TXT_WebXmlFilterSafeDelete", (Object)filterClass);
                }
            };
            refactoringElements.add((AbstractRefactoring)this.safeDeleteRefactoring, (RefactoringElementImplementation)elem);
        }
    }

    private List<FilterMapping> getFilterMappings(WebApp webApp, Filter filter) {
        FilterMapping[] mappings = webApp.getFilterMapping();
        ArrayList<FilterMapping> result = new ArrayList<FilterMapping>();
        for (int i = 0; i < mappings.length; ++i) {
            if (!filter.getFilterName().equals(mappings[i].getFilterName())) continue;
            result.add(mappings[i]);
        }
        return result;
    }

    private void processListeners(WebApp webXmlDD, FileObject webXmlFO, RefactoringElementsBag refactoringElements) {
        Listener[] listeners = webXmlDD.getListener();
        for (int i = 0; i < listeners.length; ++i) {
            final Listener listener = listeners[i];
            final String listenerClass = listener.getListenerClass();
            if (listenerClass == null || !listenerClass.equals(this.javaClass.getName())) continue;
            WebXmlSafeDeleteRefactoringElement elem = new WebXmlSafeDeleteRefactoringElement(webXmlFO, webXmlDD, listenerClass){

                protected void doChange() {
                    this.webApp.removeListener(listener);
                }

                protected void undoChange() {
                    this.webApp.addListener(listener);
                }

                public String getDisplayText() {
                    return NbBundle.getMessage(WebXmlSafeDeleteRefactoring.class, (String)"TXT_WebXmlListenerSafeDelete", (Object)listenerClass);
                }
            };
            refactoringElements.add((AbstractRefactoring)this.safeDeleteRefactoring, (RefactoringElementImplementation)elem);
        }
    }

    @Override
    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        List<FileObject> webXmlDDs = this.getDeploymentDescriptors();
        for (FileObject webXmlFO : webXmlDDs) {
            WebApp webXmlDD = null;
            try {
                webXmlDD = DDProvider.getDefault().getDDRoot(webXmlFO);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
            if (webXmlDD != null && webXmlDD.getStatus() != 2) {
                this.processServlets(webXmlDD, webXmlFO, refactoringElements);
                this.processFilters(webXmlDD, webXmlFO, refactoringElements);
                this.processListeners(webXmlDD, webXmlFO, refactoringElements);
                continue;
            }
            Problem newProblem = new Problem(false, NbBundle.getMessage(WebXmlSafeDeleteRefactoring.class, (String)"TXT_WebXmlInvalidProblem", (Object)webXmlFO.getPath()));
            problem = Utility.addProblemsToEnd(problem, newProblem);
        }
        return problem;
    }

    @Override
    public Problem preCheck() {
        return null;
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        return null;
    }

    private static abstract class WebXmlSafeDeleteRefactoringElement
    extends AbstractSafeDeleteRefactoringElement
    implements ExternalChange {
        protected WebApp webApp;
        private String className;

        public WebXmlSafeDeleteRefactoringElement(FileObject parentFile, WebApp webApp, String className) {
            super(parentFile);
            this.webApp = webApp;
            this.className = className;
        }

        public final void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        protected abstract void doChange();

        protected abstract void undoChange();

        public final void performExternalChange() {
            this.doChange();
            try {
                this.webApp.write(this.parentFile);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }

        public final void undoExternalChange() {
            this.undoChange();
            try {
                this.webApp.write(this.parentFile);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }

        public PositionBounds getPosition() {
            try {
                return new DefaultPositionBoundsResolver(DataObject.find((FileObject)this.getParentFile()), this.className).getPositionBounds();
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return null;
            }
        }
    }
}

