/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring.moveclass;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponent;
import org.netbeans.modules.j2ee.dd.api.webservices.PortComponentHandler;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.refactoring.Utility;
import org.netbeans.modules.j2ee.refactoring.moveclass.AbstractMoveClassRefactoringElement;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.ExternalChange;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveClassRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.wsdl.WsCompileConfigDataObject;
import org.netbeans.modules.websvc.wsdl.config.api.Configuration;
import org.netbeans.modules.websvc.wsdl.config.api.DDProvider;
import org.netbeans.modules.websvc.wsdl.config.api.Interface;
import org.netbeans.modules.websvc.wsdl.config.api.Service;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

public final class WebservicesXmlMoveClassRefactoring {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.j2ee.refactoring.rename");

    public Problem prepare(MoveClassRefactoring moveClassRefactor, Collection resources, RefactoringElementsBag refactoringElements) {
        Problem problem = null;
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            boolean isSEIMove = false;
            Resource resource = (Resource)i.next();
            FileObject fo = JavaModel.getFileObject((Resource)resource);
            err.log("resource package name:  " + resource.getPackageName());
            err.log("resource: name " + resource.getName());
            WebServicesSupport wsm = WebServicesSupport.getWebServicesSupport((FileObject)fo);
            if (wsm == null) continue;
            FileObject webservicesXmlFO = wsm.getWebservicesDD();
            Webservices webservicesXmlDD = null;
            try {
                webservicesXmlDD = org.netbeans.modules.j2ee.dd.api.webservices.DDProvider.getDefault().getDDRoot(webservicesXmlFO);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            if (webservicesXmlDD != null && webservicesXmlDD.getStatus() != 2) {
                List classes = resource.getClassifiers();
                err.log("Classes in resource: " + classes);
                for (int j = 0; j < classes.size(); ++j) {
                    JavaClass jClass = (JavaClass)classes.get(j);
                    err.log("javaclass: " + jClass);
                    String name = jClass.getName();
                    err.log("name: " + name);
                    String oldPackage = name.substring(0, name.lastIndexOf(46));
                    err.log("oldPackage: " + oldPackage);
                    String targetPackage = moveClassRefactor.getTargetPackageName(resource);
                    err.log("targetPackage: " + targetPackage);
                    String newName = targetPackage + "." + jClass.getSimpleName();
                    err.log("newname: " + newName);
                    WebserviceDescription[] wservices = webservicesXmlDD.getWebserviceDescription();
                    err.log("Web Services: " + wservices);
                    if (wservices == null || wservices.length <= 0) continue;
                    for (int w = 0; w < wservices.length; ++w) {
                        WebserviceDescription webService = wservices[w];
                        err.log("Web Service: " + webService);
                        PortComponent[] ports = webService.getPortComponent();
                        err.log("Ports: " + ports);
                        if (ports == null || ports.length <= 0) continue;
                        for (int p = 0; p < ports.length; ++p) {
                            PortComponent portComponent = ports[p];
                            err.log("Port Component: " + portComponent);
                            String serviceEndpointInterface = portComponent.getServiceEndpointInterface();
                            err.log("serviceEndpointInterface: " + serviceEndpointInterface);
                            PortComponentHandler[] handlers = portComponent.getHandler();
                            for (int k = 0; k < handlers.length; ++k) {
                                if (!name.equals(handlers[k].getHandlerClass())) continue;
                                WebservicesHandlerMoveClassRefactoringElement elem = new WebservicesHandlerMoveClassRefactoringElement(webservicesXmlDD, name, newName, handlers[k], webservicesXmlFO);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                            }
                            if (serviceEndpointInterface != null && serviceEndpointInterface.equals(name)) {
                                isSEIMove = true;
                                WebservicesSEIMoveClassRefactoringElement elem = new WebservicesSEIMoveClassRefactoringElement(webservicesXmlDD, name, newName, portComponent, webservicesXmlFO);
                                refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                            }
                            String portName = portComponent.getPortComponentName();
                            Project project = FileOwnerQuery.getOwner((FileObject)webservicesXmlFO);
                            err.log("Project: " + project);
                            Map properties = wsm.getAntProjectHelper().getStandardPropertyEvaluator().getProperties();
                            if (err.isLoggable(1)) {
                                err.log("Properties: " + properties);
                            }
                            String propertyName = portName + ".config.name";
                            err.log("Property name: " + propertyName);
                            String propertyValue = (String)properties.get(propertyName);
                            err.log("Property value: " + propertyValue);
                            if (propertyValue == null) continue;
                            FileObject wsConfigXmlFO = null;
                            File f = new File(propertyValue);
                            wsConfigXmlFO = f.isAbsolute() ? FileUtil.toFileObject((File)f) : project.getProjectDirectory().getFileObject(propertyValue);
                            if (wsConfigXmlFO == null) continue;
                            Configuration wsConfigXmlDD = null;
                            try {
                                wsConfigXmlDD = DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                            }
                            catch (IOException ioe) {
                                // empty catch block
                            }
                            DataObject data = null;
                            try {
                                data = DataObject.find((FileObject)wsConfigXmlFO);
                            }
                            catch (DataObjectNotFoundException notfoundexc) {
                                // empty catch block
                            }
                            err.log("DataObject: " + data);
                            if (data != null && wsConfigXmlDD != null) {
                                Interface[] interfaces;
                                Service service = wsConfigXmlDD.getService();
                                if (service == null) continue;
                                String packageName = service.getPackageName();
                                err.log("Package name: " + packageName);
                                if (packageName != null && packageName.equals(oldPackage) && isSEIMove) {
                                    if (!this.isConfigXmlAlreadyMoved(refactoringElements, wsConfigXmlFO)) {
                                        WebservicesConfigXmlMoveClassRefactoringElement elemFile = new WebservicesConfigXmlMoveClassRefactoringElement(data, moveClassRefactor.getTargetClassPathRoot(), moveClassRefactor.getTargetPackageName(fo));
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elemFile);
                                    }
                                    WebservicesConfigXmlPackageMoveClassRefactoringElement elemPkg = new WebservicesConfigXmlPackageMoveClassRefactoringElement(data, jClass.getResource().getPackageName(), targetPackage);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elemPkg);
                                    targetPackage = targetPackage.replace('.', '/');
                                    Sources srcs = ProjectUtils.getSources((Project)project);
                                    if (srcs != null) {
                                        SourceGroup[] sourceGroups = srcs.getSourceGroups("java");
                                        SourceGroup srcGroup = null;
                                        boolean found = false;
                                        for (int k = 0; k < sourceGroups.length; ++k) {
                                            srcGroup = sourceGroups[k];
                                            if (!FileUtil.isParentOf((FileObject)srcGroup.getRootFolder(), (FileObject)wsConfigXmlFO)) continue;
                                            found = true;
                                            break;
                                        }
                                        if (found) {
                                            String relativePath = FileUtil.getRelativePath((FileObject)srcGroup.getRootFolder(), (FileObject)wsConfigXmlFO);
                                            int index = propertyValue.indexOf(relativePath);
                                            String newValue = propertyValue.substring(0, 9) + propertyValue.substring(index, propertyValue.length()).replaceFirst(packageName, targetPackage);
                                            err.log("newvalue: " + newValue);
                                            err.log("moving SEI, so move the config xml file with it, too");
                                            WebservicesProjectMoveClassRefactoringElement elem2 = new WebservicesProjectMoveClassRefactoringElement(data, wsm.getAntProjectHelper(), propertyName, propertyValue, newValue, targetPackage);
                                            refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem2);
                                        }
                                    }
                                }
                                if ((interfaces = service.getInterface()) == null || interfaces.length <= 0) continue;
                                for (int ii = 0; ii < interfaces.length; ++ii) {
                                    Interface iface = interfaces[ii];
                                    String servant = iface.getServantName();
                                    String iname = iface.getName();
                                    err.log("Servant: " + servant);
                                    err.log("Interface: " + iname);
                                    if (servant != null && servant.equals(name)) {
                                        WebservicesConfigXmlServantMoveClassRefactoringElement elem = new WebservicesConfigXmlServantMoveClassRefactoringElement(data, name, newName);
                                        refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                                    }
                                    if (iname == null || !iname.equals(name)) continue;
                                    WebservicesConfigXmlInterfaceMoveClassRefactoringElement elem = new WebservicesConfigXmlInterfaceMoveClassRefactoringElement(data, name, newName);
                                    refactoringElements.add((AbstractRefactoring)moveClassRefactor, (RefactoringElementImplementation)elem);
                                }
                                continue;
                            }
                            Object[] args = new Object[]{wsConfigXmlFO.getPath()};
                            String msg = MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, (String)"TXT_WebservicesConfigXmlMoveClassInvalidProblem"), args);
                            Problem newProblem = new Problem(false, msg);
                            problem = Utility.addProblemsToEnd(problem, newProblem);
                        }
                    }
                }
                continue;
            }
            if (webservicesXmlDD == null) continue;
            Problem newProblem = new Problem(false, NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, (String)"TXT_WebservicesXmlMoveClassInvalidProblem"));
            if (problem == null) {
                problem = newProblem;
                continue;
            }
            if (newProblem == null) continue;
            problem.setNext(newProblem);
        }
        return problem;
    }

    private boolean isConfigXmlAlreadyMoved(RefactoringElementsBag refactoringElements, FileObject file) {
        Collection c = refactoringElements.getSession().getRefactoringElements();
        for (RefactoringElement refElem : c) {
            FileObject f = refElem.getParentFile();
            if (f == null) continue;
            DataObject d = null;
            try {
                d = DataObject.find((FileObject)f);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (d == null || !(d instanceof WsCompileConfigDataObject)) continue;
            return file.equals(((WsCompileConfigDataObject)d).getPrimaryFile());
        }
        return false;
    }

    public final class WebservicesProjectMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        private DataObject data = null;
        private AntProjectHelper helper;
        private String propertyName;
        private String propertyValue;
        private String targetPackage;
        private String newValue;

        public WebservicesProjectMoveClassRefactoringElement(DataObject data, AntProjectHelper helper, String propertyName, String propertyValue, String newValue, String targetPackage) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
            this.targetPackage = targetPackage;
            this.data = data;
            this.newValue = newValue;
            this.helper = helper;
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.propertyName, this.propertyValue, this.newValue};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, (String)"TXT_WebservicesProjectMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
            if (this.data != null) {
                ep.setProperty(this.propertyName, this.newValue);
            }
            this.helper.putProperties("nbproject/project.properties", ep);
            Project project = null;
            try {
                project = ProjectManager.getDefault().findProject(this.helper.getProjectDirectory());
                ProjectManager.getDefault().saveProject(project);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                // empty if block
            }
        }
    }

    public final class WebservicesConfigXmlInterfaceMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        private DataObject data = null;

        public WebservicesConfigXmlInterfaceMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
            this.data = data;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, (String)"TXT_WebservicesConfigXmlInterfaceMoveClass"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject wsConfigXmlFO = this.data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (wsConfigXmlDD != null) {
                    err.log("perform external change: WebservicesConfigXmlInterfaceMoveClassRefactoringElement");
                    Service service = wsConfigXmlDD.getService();
                    Interface[] interfaces = service.getInterface();
                    err.log("Interfaces: " + interfaces);
                    if (interfaces != null && interfaces.length > 0) {
                        for (int ii = 0; ii < interfaces.length; ++ii) {
                            Interface iface = interfaces[ii];
                            String interf = iface.getName();
                            err.log("Interface: " + interf);
                            if (interf == null || !interf.equals(this.oldName)) continue;
                            iface.setName(this.newName);
                        }
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject wsConfigXmlFO = this.data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (wsConfigXmlDD != null) {
                    err.log("undo external change: WebservicesConfigXmlInterfaceMoveClassRefactoringElement");
                    Service service = wsConfigXmlDD.getService();
                    Interface[] interfaces = service.getInterface();
                    err.log("Interfaces: " + interfaces);
                    if (interfaces != null && interfaces.length > 0) {
                        for (int ii = 0; ii < interfaces.length; ++ii) {
                            Interface iface = interfaces[ii];
                            String interf = iface.getName();
                            err.log("Interface: " + interf);
                            if (interf == null || !interf.equals(this.newName)) continue;
                            iface.setName(this.oldName);
                        }
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public final class WebservicesConfigXmlServantMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        private DataObject data = null;

        public WebservicesConfigXmlServantMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.oldName = oldName;
            this.newName = newName;
            this.data = data;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, (String)"TXT_WebservicesConfigXmlServantMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performExternalChange() {
            if (this.data != null) {
                FileObject wsConfigXmlFO = this.data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (wsConfigXmlDD != null) {
                    err.log("perform external change: WebservicesConfigXmlServantMoveClassRefactoringElement");
                    Service service = wsConfigXmlDD.getService();
                    Interface[] interfaces = service.getInterface();
                    err.log("Interfaces: " + interfaces);
                    if (interfaces != null && interfaces.length > 0) {
                        for (int ii = 0; ii < interfaces.length; ++ii) {
                            Interface iface = interfaces[ii];
                            String servant = iface.getServantName();
                            err.log("Servant: " + servant);
                            if (servant == null || !servant.equals(this.oldName)) continue;
                            iface.setServantName(this.newName);
                        }
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                FileObject wsConfigXmlFO = this.data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (wsConfigXmlDD != null) {
                    err.log("undo external change: WebservicesConfigXmlServantMoveClassRefactoringElement");
                    Service service = wsConfigXmlDD.getService();
                    Interface[] interfaces = service.getInterface();
                    err.log("Interfaces: " + interfaces);
                    if (interfaces != null && interfaces.length > 0) {
                        for (int ii = 0; ii < interfaces.length; ++ii) {
                            Interface iface = interfaces[ii];
                            String servant = iface.getServantName();
                            err.log("Servant: " + servant);
                            if (servant == null || !servant.equals(this.newName)) continue;
                            iface.setServantName(this.oldName);
                        }
                        try {
                            wsConfigXmlDD.write(wsConfigXmlFO);
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public final class WebservicesConfigXmlMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        private DataObject data = null;
        private FileObject target = null;
        private FileObject originalFolder = null;
        private String targetPackageName;

        public WebservicesConfigXmlMoveClassRefactoringElement(DataObject data, FileObject targetClassPathRoot, String targetPackageName) {
            this.data = data;
            this.target = targetClassPathRoot;
            this.originalFolder = data.getPrimaryFile().getParent();
            this.targetPackageName = targetPackageName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile().getNameExt(), this.target.getPath() + "/" + this.targetPackageName.replace('.', '/')};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, (String)"TXT_WebservicesConfigXmlMoveClass"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                try {
                    DataFolder folder = DataFolder.findFolder((FileObject)FileUtil.createFolder((FileObject)this.target, (String)this.targetPackageName.replace('.', '/')));
                    this.data.move(folder);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, "Could not move file: " + ioe);
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                DataFolder folder = DataFolder.findFolder((FileObject)this.originalFolder);
                try {
                    this.data.move(folder);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().log(1, "Could not undo move file: " + ioe);
                }
            }
        }
    }

    public final class WebservicesConfigXmlPackageMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        private DataObject data = null;

        public WebservicesConfigXmlPackageMoveClassRefactoringElement(DataObject data, String oldName, String newName) {
            this.data = data;
            this.oldName = oldName;
            this.newName = newName;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.data.getPrimaryFile(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, (String)"TXT_WebservicesConfigXmlPackageMoveClass"), args);
        }

        public FileObject getParentFile() {
            if (this.data != null) {
                return this.data.getPrimaryFile();
            }
            return null;
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.data != null) {
                Service service;
                FileObject wsConfigXmlFO = this.data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (wsConfigXmlDD != null && (service = wsConfigXmlDD.getService()) != null) {
                    service.setPackageName(this.newName);
                    try {
                        wsConfigXmlDD.write(wsConfigXmlFO);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
        }

        public void undoExternalChange() {
            if (this.data != null) {
                Service service;
                FileObject wsConfigXmlFO = this.data.getPrimaryFile();
                Configuration wsConfigXmlDD = null;
                try {
                    wsConfigXmlDD = DDProvider.getDefault().getDDRoot(wsConfigXmlFO);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (wsConfigXmlDD != null && (service = wsConfigXmlDD.getService()) != null) {
                    service.setPackageName(this.oldName);
                    try {
                        wsConfigXmlDD.write(wsConfigXmlFO);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public final class WebservicesHandlerMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected Webservices webservicesXmlDD;
        private PortComponentHandler handler;

        public WebservicesHandlerMoveClassRefactoringElement(Webservices webservicesXmlDD, String oldName, String newName, PortComponentHandler handler, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.handler = handler;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, (String)"TXT_WebservicesXmlHandlerMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            this.handler.setHandlerClass(this.newName);
            this.write();
        }

        public void undoExternalChange() {
            this.handler.setHandlerClass(this.oldName);
            this.write();
        }

        private void write() {
            try {
                this.webservicesXmlDD.write(this.parentFile);
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    public final class WebservicesSEIMoveClassRefactoringElement
    extends AbstractMoveClassRefactoringElement
    implements ExternalChange {
        protected Webservices webservicesXmlDD;
        private PortComponent pc;

        public WebservicesSEIMoveClassRefactoringElement(Webservices webservicesXmlDD, String oldName, String newName, PortComponent pc, FileObject parentFile) {
            this.webservicesXmlDD = webservicesXmlDD;
            this.pc = pc;
            this.oldName = oldName;
            this.newName = newName;
            this.parentFile = parentFile;
        }

        public String getDisplayText() {
            Object[] args = new Object[]{this.parentFile.getNameExt(), this.oldName, this.newName};
            return MessageFormat.format(NbBundle.getMessage(WebservicesXmlMoveClassRefactoring.class, (String)"TXT_WebservicesXmlSEIMoveClass"), args);
        }

        public void performChange() {
            JavaMetamodel.getManager().registerExtChange((ExternalChange)this);
        }

        public void performExternalChange() {
            if (this.pc != null) {
                this.pc.setServiceEndpointInterface(this.newName);
                try {
                    this.webservicesXmlDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void undoExternalChange() {
            if (this.pc != null) {
                this.pc.setServiceEndpointInterface(this.oldName);
                try {
                    this.webservicesXmlDD.write(this.parentFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

