/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import javax.swing.JList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.websvc.editor.completion.WSPaintComponent;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;

public abstract class WSResultItem
implements CompletionQuery.ResultItem,
CompletionItem {
    protected int substituteOffset = -1;
    public static final String COMPLETION_SUBSTITUTE_TEXT = "completion-substitute-text";
    static String toAdd;

    public abstract String getItemText();

    public void setSubstituteOffset(int substituteOffset) {
        this.substituteOffset = substituteOffset;
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return false;
    }

    public Object getAssociatedObject() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
        BaseDocument doc = (BaseDocument)c.getDocument();
        String text = this.getItemText();
        if (text != null) {
            if (toAdd != null && !toAdd.equals("\n")) {
                text = text + toAdd;
            }
            doc.atomicLock();
            try {
                String textToReplace = doc.getText(offset, len);
                if (text.equals(textToReplace)) {
                    boolean bl = false;
                    return bl;
                }
                doc.remove(offset, len);
                doc.insertString(offset, text, null);
            }
            catch (BadLocationException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                doc.atomicUnlock();
            }
            return true;
        }
        return false;
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        Component ret = this.getPaintComponent(isSelected);
        if (ret == null) {
            return null;
        }
        if (isSelected) {
            ret.setBackground(list.getSelectionBackground());
            ret.setForeground(list.getSelectionForeground());
        } else {
            ret.setBackground(list.getBackground());
            ret.setForeground(list.getForeground());
        }
        ret.getAccessibleContext().setAccessibleName(this.getItemText());
        ret.getAccessibleContext().setAccessibleDescription(this.getItemText());
        return ret;
    }

    public abstract Component getPaintComponent(boolean var1);

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = this.getPaintComponent(false);
        return renderComponent.getPreferredSize().width;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        Component renderComponent = this.getPaintComponent(selected);
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        ((WSPaintComponent)renderComponent).paintComponent(g);
    }

    public String toString() {
        return this.getItemText();
    }

    public void processKeyEvent(KeyEvent evt) {
        if (evt.getID() == 400) {
            Completion completion = Completion.get();
            switch (evt.getKeyChar()) {
                case ' ': {
                    if (evt.getModifiers() != 0) break;
                    completion.hideCompletion();
                    completion.hideDocumentation();
                    break;
                }
                case '(': 
                case ',': 
                case ';': {
                    completion.hideCompletion();
                    completion.hideDocumentation();
                }
                case '.': {
                    if (!this.defaultAction((JTextComponent)evt.getSource(), Character.toString(evt.getKeyChar()))) break;
                    evt.consume();
                }
            }
        }
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent c) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(c);
        return true;
    }

    public void defaultAction(JTextComponent component) {
        Completion completion = Completion.get();
        completion.hideCompletion();
        completion.hideDocumentation();
        this.defaultAction(component, "");
    }

    private boolean defaultAction(JTextComponent component, String addText) {
        int substOffset = this.substituteOffset;
        if (substOffset == -1) {
            substOffset = component.getCaret().getDot();
        }
        toAdd = addText;
        return this.substituteText(component, substOffset, component.getCaret().getDot() - substOffset, false);
    }

    static class FileProtocolResultItem
    extends WSResultItem {
        private boolean quoted;

        public FileProtocolResultItem(boolean quoted) {
            this.quoted = quoted;
        }

        public String getDisplayname() {
            return "file://";
        }

        public String getItemText() {
            return (this.quoted ? "" : "\"") + this.getDisplayname() + (this.quoted ? "" : "\"");
        }

        public boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
            boolean substituted = super.substituteText(c, offset, len, shift);
            if (substituted && !this.quoted) {
                c.setCaretPosition(c.getCaretPosition() - 1);
            }
            return substituted;
        }

        public int getSortPriority() {
            return 100;
        }

        public Component getPaintComponent(boolean isSelected) {
            WSPaintComponent.FileProtocolItemPaintComponent pc = new WSPaintComponent.FileProtocolItemPaintComponent();
            pc.setString(this.getDisplayname());
            return pc;
        }
    }

    static class FileResultItem
    extends FileAttributeValue {
        private Image icon;

        public FileResultItem(String name, Image icon) {
            super(name);
            this.icon = icon;
        }

        public Component getPaintComponent(boolean isSelected) {
            WSPaintComponent.FileItemPaintComponent pc = new WSPaintComponent.FileItemPaintComponent(this.icon);
            pc.setString(this.getItemText());
            return pc;
        }
    }

    static class PackageResultItem
    extends FileAttributeValue {
        public PackageResultItem(String name) {
            super(name);
        }

        public int getSortPriority() {
            return 9;
        }

        public Component getPaintComponent(boolean isSelected) {
            WSPaintComponent.PackageItemPaintComponent pc = new WSPaintComponent.PackageItemPaintComponent();
            pc.setString(this.getItemText());
            return pc;
        }
    }

    private static abstract class FileAttributeValue
    extends WSResultItem {
        private String name;

        public FileAttributeValue(String name) {
            this.name = name;
        }

        public String getItemText() {
            return this.name;
        }

        public int getSortPriority() {
            return 10;
        }
    }
}

