/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.client.wizard;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.core.client.wizard.ClientBuilder;
import org.netbeans.modules.websvc.core.client.wizard.WebProxySetter;
import org.netbeans.modules.websvc.core.client.wizard.WebServiceClientWizardIterator;
import org.netbeans.modules.websvc.core.client.wizard.WsdlRetriever;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WebServiceClientCreator {
    private static WebServiceClientCreator instance;
    private Project project;
    private WizardDescriptor wiz;
    private static final boolean DEBUG = false;
    private static final int JSE_PROJECT_TYPE = 0;
    private static final int WEB_PROJECT_TYPE = 1;
    private static final int EJB_PROJECT_TYPE = 2;
    private static final int CAR_PROJECT_TYPE = 3;

    public WebServiceClientCreator(Project project, WizardDescriptor wiz) {
        this.project = project;
        this.wiz = wiz;
    }

    public Set create() throws IOException {
        final boolean isJsr109Supported = this.isJsr109Supported();
        boolean isJsr109OldSupported = this.isJsr109OldSupported();
        final boolean isJWSDPSupported = this.isJWSDPSupported();
        final boolean isWsitSupported = this.isWsitSupported();
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(WebServiceClientCreator.class, (String)"MSG_WizCreateClient"));
        Runnable r = new Runnable(){

            public void run() {
                try {
                    String jaxVersion = (String)WebServiceClientCreator.this.wiz.getProperty("jaxVersion");
                    if (jaxVersion.equals("JAX-WS")) {
                        handle.start();
                        WebServiceClientCreator.this.generate15Client(isJsr109Supported || isJWSDPSupported || isWsitSupported && Util.isJavaEE5orHigher((Project)WebServiceClientCreator.this.project), handle);
                    } else {
                        handle.start(100);
                        WebServiceClientCreator.this.generate14Client(handle);
                    }
                }
                catch (IOException exc) {
                    handle.finish();
                    ErrorManager.getDefault().notify(4096, (Throwable)exc);
                }
            }
        };
        RequestProcessor.getDefault().post(r);
        return Collections.EMPTY_SET;
    }

    private void generate15Client(boolean isJsr109Platform, ProgressHandle handle) throws IOException {
        String packageName;
        JAXWSClientSupport jaxWsClientSupport = null;
        if (this.project != null) {
            jaxWsClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.project.getProjectDirectory());
        }
        if (jaxWsClientSupport == null) {
            String mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_NoWebServiceClientSupport");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        }
        String wsdlUrl = (String)this.wiz.getProperty("wsdlDownloadUrl");
        String filePath = (String)this.wiz.getProperty("wsdlFilePath");
        if (wsdlUrl == null) {
            wsdlUrl = FileUtil.toFileObject((File)new File(filePath)).getURL().toExternalForm();
        }
        if ((packageName = (String)this.wiz.getProperty("wsdlPackageName")) != null && packageName.length() == 0) {
            packageName = null;
        }
        jaxWsClientSupport.addServiceClient(this.getWsdlName(wsdlUrl), wsdlUrl, packageName, isJsr109Platform);
        handle.finish();
    }

    private String getWsdlName(String wsdlUrl) {
        String wsdlName;
        int ind = wsdlUrl.lastIndexOf("/");
        String string = wsdlName = ind >= 0 ? wsdlUrl.substring(ind + 1) : wsdlUrl;
        if (wsdlName.toUpperCase().endsWith("?WSDL")) {
            wsdlName = wsdlName.substring(0, wsdlName.length() - 5);
        }
        if ((ind = wsdlName.lastIndexOf(".wsdl")) > 0) {
            wsdlName = wsdlName.substring(0, ind);
        }
        return this.convertAllSpecialChars(wsdlName);
    }

    private String convertAllSpecialChars(String resultStr) {
        StringBuffer sb = new StringBuffer(resultStr);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '/' || c == '.' || c == '_' || c == ' ' || c == '-') continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate14Client(final ProgressHandle handle) throws IOException {
        SourceGroup[] sgs;
        ClassPath classPath;
        FileObject wscompileFO;
        String sourceUrl;
        WebServicesClientSupport clientSupport = null;
        if (this.project != null) {
            clientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.project.getProjectDirectory());
        }
        if (clientSupport == null) {
            String mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_NoWebServiceClientSupport");
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            return;
        }
        final byte[] sourceWsdlDownload = (byte[])this.wiz.getProperty("wsdlDownloadedWsdl");
        List downloadedSchemas = (List)this.wiz.getProperty("wsdlDownloadedSchemas");
        String wsdlFilePath = (String)this.wiz.getProperty("wsdlFilePath");
        String packageName = (String)this.wiz.getProperty("wsdlPackageName");
        ClientStubDescriptor stubDescriptor = (ClientStubDescriptor)this.wiz.getProperty("clientStubType");
        FileObject sourceWsdlFile = null;
        if (sourceWsdlDownload == null) {
            File normalizedWsdlFilePath = FileUtil.normalizeFile((File)new File(wsdlFilePath));
            sourceUrl = normalizedWsdlFilePath.toString();
            sourceWsdlFile = FileUtil.toFileObject((File)normalizedWsdlFilePath);
            if (sourceWsdlFile == null) {
                String mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_WsdlFileNotFound", (Object)normalizedWsdlFilePath);
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                return;
            }
        } else {
            block30: {
                File wsdlFile = new File(System.getProperty("java.io.tmpdir"), wsdlFilePath);
                if (!wsdlFile.exists()) {
                    try {
                        wsdlFile.createNewFile();
                    }
                    catch (IOException ex) {
                        String mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_UnableToCreateTempFile", (Object)wsdlFile.getPath());
                        NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        return;
                    }
                }
                sourceUrl = (String)this.wiz.getProperty("wsdlDownloadUrl");
                sourceWsdlFile = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)wsdlFile));
                if (sourceWsdlFile != null) {
                    FileLock wsdlLock = sourceWsdlFile.lock();
                    try {
                        OutputStream out = sourceWsdlFile.getOutputStream(wsdlLock);
                        try {
                            out.write(sourceWsdlDownload);
                            out.flush();
                            break block30;
                        }
                        finally {
                            if (out != null) {
                                out.close();
                            }
                        }
                    }
                    finally {
                        wsdlLock.releaseLock();
                    }
                }
                String mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_UnableToCreateTempFile", (Object)wsdlFile.getPath());
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                return;
            }
            if (downloadedSchemas != null) {
                for (WsdlRetriever.SchemaInfo schemaInfo : downloadedSchemas) {
                    NotifyDescriptor.Message desc;
                    String mes;
                    File schemalFile = new File(System.getProperty("java.io.tmpdir"), schemaInfo.getSchemaName());
                    try {
                        schemalFile.createNewFile();
                    }
                    catch (IOException ex) {
                        mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_UnableToCreateTempFile", (Object)schemalFile.getPath());
                        desc = new NotifyDescriptor.Message((Object)mes, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        return;
                    }
                    FileObject schemaFo = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)schemalFile));
                    if (schemaFo != null) {
                        FileLock lock = schemaFo.lock();
                        try {
                            OutputStream out = schemaFo.getOutputStream(lock);
                            try {
                                out.write(schemaInfo.getSchemaContent());
                                out.flush();
                                continue;
                            }
                            finally {
                                if (out != null) {
                                    out.close();
                                }
                                continue;
                            }
                        }
                        finally {
                            lock.releaseLock();
                            continue;
                        }
                    }
                    mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_UnableToCreateTempFile", (Object)schemalFile.getPath());
                    desc = new NotifyDescriptor.Message((Object)mes, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                    return;
                }
            }
        }
        if ((wscompileFO = (classPath = ClassPath.getClassPath((FileObject)(sgs = WebServiceClientCreator.getJavaSourceGroups(this.project))[0].getRootFolder(), (String)"classpath/compile")).findResource("com/sun/xml/rpc/tools/ant/Wscompile.class")) == null) {
            ProjectClassPathExtender pce = (ProjectClassPathExtender)this.project.getLookup().lookup(ProjectClassPathExtender.class);
            Library jaxrpclib = LibraryManager.getDefault().getLibrary("jaxrpc16");
            if (pce != null && jaxrpclib != null) {
                pce.addLibrary(jaxrpclib);
            }
        }
        clientSupport.setProxyJVMOptions(WebProxySetter.getInstance().getProxyHost(), WebProxySetter.getInstance().getProxyPort());
        final ClientBuilder builder = new ClientBuilder(this.project, clientSupport, sourceWsdlFile, packageName, sourceUrl, stubDescriptor);
        final FileObject sourceWsdlFileTmp = sourceWsdlFile;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    builder.generate(handle);
                    if (sourceWsdlDownload != null) {
                        try {
                            sourceWsdlFileTmp.delete();
                        }
                        catch (FileAlreadyLockedException ex) {
                            String mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_TempFileLocked", (Object)sourceWsdlFileTmp.getNameExt());
                            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        }
                        catch (IOException ex) {
                            String mes = NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"ERR_TempFileNotDeleted", (Object)sourceWsdlFileTmp.getNameExt());
                            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)mes, 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        }
                    }
                    handle.progress(NbBundle.getMessage(WebServiceClientWizardIterator.class, (String)"MSG_WizDone"), 99);
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    static SourceGroup[] getJavaSourceGroups(Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        Set testGroups = WebServiceClientCreator.getTestSourceGroups(project, sourceGroups);
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (testGroups.contains(sourceGroups[i])) continue;
            result.add(sourceGroups[i]);
        }
        return result.toArray(new SourceGroup[result.size()]);
    }

    private static Set getTestSourceGroups(Project project, SourceGroup[] sourceGroups) {
        Map foldersToSourceGroupsMap = WebServiceClientCreator.createFoldersToSourceGroupsMap(sourceGroups);
        HashSet testGroups = new HashSet();
        for (int i = 0; i < sourceGroups.length; ++i) {
            testGroups.addAll(WebServiceClientCreator.getTestTargets(sourceGroups[i], foldersToSourceGroupsMap));
        }
        return testGroups;
    }

    private static List getTestTargets(SourceGroup sourceGroup, Map foldersToSourceGroupsMap) {
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (rootURLs.length == 0) {
            return new ArrayList();
        }
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>();
        List sourceRoots = WebServiceClientCreator.getFileObjects(rootURLs);
        for (int i = 0; i < sourceRoots.size(); ++i) {
            FileObject sourceRoot = (FileObject)sourceRoots.get(i);
            SourceGroup srcGroup = (SourceGroup)foldersToSourceGroupsMap.get(sourceRoot);
            if (srcGroup == null) continue;
            result.add(srcGroup);
        }
        return result;
    }

    private static Map createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        HashMap<FileObject, SourceGroup> result;
        if (sourceGroups.length == 0) {
            result = Collections.EMPTY_MAP;
        } else {
            result = new HashMap<FileObject, SourceGroup>(2 * sourceGroups.length, 0.5f);
            for (int i = 0; i < sourceGroups.length; ++i) {
                SourceGroup sourceGroup = sourceGroups[i];
                result.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        return result;
    }

    private static List getFileObjects(URL[] urls) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        for (int i = 0; i < urls.length; ++i) {
            FileObject sourceRoot = URLMapper.findFileObject((URL)urls[i]);
            if (sourceRoot != null) {
                result.add(sourceRoot);
                continue;
            }
            int severity = 1;
            if (!ErrorManager.getDefault().isNotifiable(severity)) continue;
            ErrorManager.getDefault().notify(severity, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + urls[i]));
        }
        return result;
    }

    private J2eePlatform getJ2eePlatform() {
        String serverInstanceID;
        J2eeModuleProvider provider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (provider != null && (serverInstanceID = provider.getServerInstanceID()) != null && serverInstanceID.length() > 0) {
            return Deployment.getDefault().getJ2eePlatform(serverInstanceID);
        }
        return null;
    }

    private boolean isJWSDPSupported() {
        J2eePlatform j2eePlatform = this.getJ2eePlatform();
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("jwsdp");
        }
        return false;
    }

    private boolean isWsitSupported() {
        J2eePlatform j2eePlatform = this.getJ2eePlatform();
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("wsit");
        }
        return false;
    }

    private boolean isJsr109Supported() {
        J2eePlatform j2eePlatform = this.getJ2eePlatform();
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("jsr109");
        }
        return false;
    }

    private boolean isJsr109OldSupported() {
        J2eePlatform j2eePlatform = this.getJ2eePlatform();
        if (j2eePlatform != null) {
            return j2eePlatform.isToolSupported("wscompile");
        }
        return false;
    }
}

