/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.wsclient;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.websvc.api.client.ClientStubDescriptor;
import org.netbeans.modules.websvc.api.client.WsCompileClientEditorSupport;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportImpl;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class J2SEProjectWebServicesClientSupport
implements WebServicesClientSupportImpl {
    private J2SEProject project;
    private AntProjectHelper helper;
    private ReferenceHelper referenceHelper;
    private String proxyHost;
    private String proxyPort;
    public static final String WSDL_FOLDER = "wsdl";
    private static final String[] WSCOMPILE_CLIENT_FEATURES;
    private static final List allClientFeatures;
    private static final String[] WSCOMPILE_KEY_CLIENT_FEATURES;
    private static final List importantClientFeatures;
    private static final JAXRPCClientStubDescriptor jaxrpcClientStub;
    private static final String PROXY_HOST_OPTION = "-Dhttp.proxyHost";
    private static final String PROXY_PORT_OPTION = "-Dhttp.proxyPort";
    private static final String NON_PROXY_HOSTS_OPTION = "-Dhttp.nonProxyHosts";
    static final /* synthetic */ boolean $assertionsDisabled;

    public J2SEProjectWebServicesClientSupport(J2SEProject project, AntProjectHelper helper, ReferenceHelper referenceHelper) {
        this.project = project;
        this.helper = helper;
        this.referenceHelper = referenceHelper;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.referenceHelper;
    }

    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor) {
        this.addServiceClient(serviceName, packageName, sourceUrl, configFile, stubDescriptor, null);
    }

    public void addServiceClient(String serviceName, String packageName, String sourceUrl, FileObject configFile, ClientStubDescriptor stubDescriptor, String[] wscompileFeatures) {
        String packagePropertyName;
        String oldPackageName;
        String oldFeatures;
        boolean needsSave = false;
        boolean modifiedProjectProperties = false;
        boolean modifiedPrivateProperties = false;
        Element data = this.helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nodes = data.getElementsByTagName("web-service-clients");
        Element clientElements = null;
        if (nodes.getLength() == 0) {
            clientElements = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "web-service-clients");
            NodeList srcRoots = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
            if (!$assertionsDisabled && srcRoots.getLength() != 1) {
                throw new AssertionError((Object)"Invalid project.xml.");
            }
            data.insertBefore(clientElements, srcRoots.item(0));
        } else {
            clientElements = (Element)nodes.item(0);
        }
        boolean serviceAlreadyAdded = false;
        NodeList clientNameList = clientElements.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "web-service-client-name");
        for (int i = 0; i < clientNameList.getLength(); ++i) {
            Node n;
            Element clientNameElement = (Element)clientNameList.item(i);
            NodeList nl = clientNameElement.getChildNodes();
            if (nl.getLength() < 1 || (n = nl.item(0)).getNodeType() != 3 || !serviceName.equalsIgnoreCase(n.getNodeValue())) continue;
            serviceAlreadyAdded = true;
        }
        if (!serviceAlreadyAdded) {
            Element clientElement = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "web-service-client");
            clientElements.appendChild(clientElement);
            Element clientElementName = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "web-service-client-name");
            clientElement.appendChild(clientElementName);
            clientElementName.appendChild(doc.createTextNode(serviceName));
            Element clientElementStubType = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "web-service-stub-type");
            clientElement.appendChild(clientElementStubType);
            clientElementStubType.appendChild(doc.createTextNode(stubDescriptor.getName()));
            Element clientElementSourceUrl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "client-source-url");
            clientElement.appendChild(clientElementSourceUrl);
            clientElementSourceUrl.appendChild(doc.createTextNode(sourceUrl));
            this.helper.putPrimaryConfigurationData(data, true);
            needsSave = true;
        }
        EditableProperties projectProperties = this.helper.getProperties("nbproject/project.properties");
        EditableProperties privateProperties = this.helper.getProperties("nbproject/private/private.properties");
        String featurePropertyName = "wscompile.client." + serviceName + ".features";
        String defaultFeatures = "wsi, strict";
        if (stubDescriptor instanceof JAXRPCClientStubDescriptor) {
            JAXRPCClientStubDescriptor stubDesc = (JAXRPCClientStubDescriptor)stubDescriptor;
            if (wscompileFeatures != null) {
                stubDesc.setDefaultFeatures(wscompileFeatures);
            }
            defaultFeatures = stubDesc.getDefaultFeaturesAsArgument();
        }
        if (!defaultFeatures.equals(oldFeatures = projectProperties.getProperty(featurePropertyName))) {
            projectProperties.put((Object)featurePropertyName, (Object)defaultFeatures);
            modifiedProjectProperties = true;
        }
        if (!packageName.equals(oldPackageName = projectProperties.getProperty(packagePropertyName = "wscompile.client." + serviceName + ".package"))) {
            projectProperties.put((Object)packagePropertyName, (Object)packageName);
            modifiedProjectProperties = true;
        }
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            String oldProxyProperty;
            String proxyProperty;
            boolean modif = this.addJVMProxyOptions(projectProperties, this.proxyHost, this.proxyPort);
            if (modif) {
                modifiedProjectProperties = true;
            }
            if (!(proxyProperty = "wscompile.client." + serviceName + ".proxy").equals(oldProxyProperty = privateProperties.getProperty(proxyProperty))) {
                privateProperties.put((Object)proxyProperty, (Object)(this.proxyHost + ":" + (this.proxyPort == null ? "8080" : this.proxyPort)));
                modifiedPrivateProperties = true;
            }
        }
        if (modifiedProjectProperties) {
            this.helper.putProperties("nbproject/project.properties", projectProperties);
            needsSave = true;
        }
        if (modifiedPrivateProperties) {
            this.helper.putProperties("nbproject/private/private.properties", privateProperties);
            needsSave = true;
        }
        if (this.updateWsCompileProperties(serviceName)) {
            needsSave = true;
        }
        if (needsSave) {
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)J2SEProjectWebServicesClientSupport.class, (String)"MSG_ErrorSavingOnWSClientAdd", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }

    public void addInfrastructure(String implBeanClass, FileObject pkg) {
    }

    public FileObject getDeploymentDescriptor() {
        return null;
    }

    private FileObject getFileObject(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFileObject(prop);
        }
        return null;
    }

    private boolean updateWsCompileProperties(String serviceName) {
        boolean globalPropertiesChanged = false;
        EditableProperties globalProperties = PropertyUtils.getGlobalProperties();
        if (globalProperties.getProperty("wscompile.tools.classpath") == null) {
            globalProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            try {
                PropertyUtils.putGlobalProperties((EditableProperties)globalProperties);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)J2SEProjectWebServicesClientSupport.class, (String)"MSG_ErrorSavingGlobalProperties", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            globalPropertiesChanged = true;
        }
        boolean projectPropertiesChanged = false;
        EditableProperties projectProperties = this.helper.getProperties("nbproject/project.properties");
        HashSet wscJars = new HashSet();
        boolean newWscJars = false;
        String wscClientClasspath = projectProperties.getProperty("wscompile.classpath");
        if (wscClientClasspath == null) {
            wscClientClasspath = "${wscompile.tools.classpath}:${javac.classpath}";
            projectProperties.put((Object)"wscompile.classpath", (Object)wscClientClasspath);
            projectPropertiesChanged = true;
        }
        if (projectProperties.getProperty("wscompile.tools.classpath") == null) {
            projectProperties.setProperty("wscompile.tools.classpath", "${java.home}\\..\\lib\\tools.jar");
            projectPropertiesChanged = true;
        }
        if (projectPropertiesChanged) {
            this.helper.putProperties("nbproject/project.properties", projectProperties);
        }
        return globalPropertiesChanged || projectPropertiesChanged;
    }

    public void removeServiceClient(String serviceName) {
        boolean needsSave = false;
        boolean needsSave1 = false;
        String featureProperty = "wscompile.client." + serviceName + ".features";
        String packageProperty = "wscompile.client." + serviceName + ".package";
        String proxyProperty = "wscompile.client." + serviceName + ".proxy";
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        EditableProperties ep1 = this.helper.getProperties("nbproject/private/private.properties");
        if (ep.getProperty(featureProperty) != null) {
            ep.remove((Object)featureProperty);
            needsSave = true;
        }
        if (ep.getProperty(packageProperty) != null) {
            ep.remove((Object)packageProperty);
            needsSave = true;
        }
        if (ep1.getProperty(proxyProperty) != null) {
            ep1.remove((Object)proxyProperty);
            needsSave1 = true;
        }
        if (needsSave) {
            this.helper.putProperties("nbproject/project.properties", ep);
        }
        if (needsSave1) {
            this.helper.putProperties("nbproject/private/private.properties", ep1);
        }
        Element data = this.helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nodes = data.getElementsByTagName("web-service-clients");
        Element clientElements = null;
        if (nodes.getLength() >= 1) {
            clientElements = (Element)nodes.item(0);
            NodeList clientNameList = clientElements.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "web-service-client-name");
            for (int i = 0; i < clientNameList.getLength(); ++i) {
                Node n;
                Element clientNameElement = (Element)clientNameList.item(i);
                NodeList nl = clientNameElement.getChildNodes();
                if (nl.getLength() != 1 || (n = nl.item(0)).getNodeType() != 3 || !serviceName.equalsIgnoreCase(n.getNodeValue())) continue;
                Node serviceNode = clientNameElement.getParentNode();
                clientElements.removeChild(serviceNode);
                this.helper.putPrimaryConfigurationData(data, true);
                needsSave = true;
            }
        }
        if (needsSave || needsSave1) {
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)J2SEProjectWebServicesClientSupport.class, (String)"MSG_ErrorSavingOnWSClientRemove", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }

    public FileObject getWsdlFolder(boolean create) throws IOException {
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        String metaInfStr = this.helper.getStandardPropertyEvaluator().getProperty("meta.inf.dir");
        String wsdlFolderStr = metaInfStr + "/" + WSDL_FOLDER;
        FileObject wsdlFolder = this.project.getProjectDirectory().getFileObject(wsdlFolderStr);
        if (wsdlFolder == null && create) {
            wsdlFolder = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)wsdlFolderStr);
        }
        return wsdlFolder;
    }

    public List getStubDescriptors() {
        ArrayList<JAXRPCClientStubDescriptor> stubs = new ArrayList<JAXRPCClientStubDescriptor>(2);
        stubs.add(jaxrpcClientStub);
        return stubs;
    }

    private boolean isProjectOpened() {
        Project[] projects = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projects.length; ++i) {
            if (!projects[i].equals(this.project)) continue;
            return true;
        }
        return false;
    }

    public List getServiceClients() {
        ArrayList<WsCompileClientEditorSupport.ServiceSettings> serviceNames = new ArrayList<WsCompileClientEditorSupport.ServiceSettings>();
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodes = data.getElementsByTagName("web-service-clients");
        EditableProperties projectProperties = this.helper.getProperties("nbproject/project.properties");
        if (nodes.getLength() != 0) {
            Element clientElements = (Element)nodes.item(0);
            NodeList clientNameList = clientElements.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "web-service-client-name");
            for (int i = 0; i < clientNameList.getLength(); ++i) {
                Node n;
                Element clientNameElement = (Element)clientNameList.item(i);
                NodeList nl = clientNameElement.getChildNodes();
                if (nl.getLength() != 1 || (n = nl.item(0)).getNodeType() != 3) continue;
                String serviceName = n.getNodeValue();
                String currentFeatures = projectProperties.getProperty("wscompile.client." + serviceName + ".features");
                if (currentFeatures == null) {
                    currentFeatures = "wsi, strict";
                }
                ClientStubDescriptor stubType = this.getClientStubDescriptor(clientNameElement.getParentNode());
                boolean propVerbose = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".verbose"));
                boolean propDebug = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".debug"));
                boolean propPrintStackTrace = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".xPrintStackTrace"));
                boolean propExtensible = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".xSerializable"));
                boolean propOptimize = "true".equalsIgnoreCase(projectProperties.getProperty("wscompile.client." + serviceName + ".optimize"));
                boolean[] options = new boolean[]{propVerbose, propDebug, propPrintStackTrace, propExtensible, propOptimize};
                WsCompileClientEditorSupport.ServiceSettings settings = new WsCompileClientEditorSupport.ServiceSettings(serviceName, stubType, options, currentFeatures, allClientFeatures, importantClientFeatures);
                serviceNames.add(settings);
            }
        }
        return serviceNames;
    }

    private ClientStubDescriptor getClientStubDescriptor(Node parentNode) {
        String stubName;
        Node n;
        Element clientStubElement;
        NodeList nl;
        Element parentElement;
        NodeList clientNameList;
        JAXRPCClientStubDescriptor result = null;
        if (parentNode instanceof Element && (clientNameList = (parentElement = (Element)parentNode).getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "web-service-stub-type")).getLength() == 1 && (nl = (clientStubElement = (Element)clientNameList.item(0)).getChildNodes()).getLength() == 1 && (n = nl.item(0)).getNodeType() == 3 && "jaxrpc_static_client".equals(stubName = n.getNodeValue())) {
            result = jaxrpcClientStub;
        }
        return result;
    }

    public String getWsdlSource(String serviceName) {
        Node n;
        Element fromWsdlElement;
        NodeList nl;
        NodeList fromWsdlList;
        Element data = this.helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        String wsdlSource = null;
        Element clientElement = this.getWebServiceClientNode(data, serviceName);
        if (clientElement != null && (fromWsdlList = clientElement.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "client-source-url")).getLength() == 1 && (nl = (fromWsdlElement = (Element)fromWsdlList.item(0)).getChildNodes()).getLength() == 1 && (n = nl.item(0)).getNodeType() == 3) {
            wsdlSource = n.getNodeValue();
        }
        return wsdlSource;
    }

    public void setWsdlSource(String serviceName, String wsdlSource) {
        Element data = this.helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        boolean needsSave = false;
        Element clientElement = this.getWebServiceClientNode(data, serviceName);
        if (clientElement != null) {
            NodeList fromWsdlList = clientElement.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "client-source-url");
            if (fromWsdlList.getLength() > 0) {
                Element fromWsdlElement = (Element)fromWsdlList.item(0);
                NodeList nl = fromWsdlElement.getChildNodes();
                if (nl.getLength() > 0) {
                    Node n = nl.item(0);
                    n.setNodeValue(wsdlSource);
                } else {
                    fromWsdlElement.appendChild(doc.createTextNode(wsdlSource));
                }
            } else {
                Element clientElementSourceUrl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "client-source-url");
                clientElement.appendChild(clientElementSourceUrl);
                clientElementSourceUrl.appendChild(doc.createTextNode(wsdlSource));
            }
            needsSave = true;
        }
        if (needsSave) {
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException ex) {
                NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)J2SEProjectWebServicesClientSupport.class, (String)"MSG_ErrorSavingOnWSClientAdd", (Object)serviceName, (Object)ex.getMessage()), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
        }
    }

    private Element getWebServiceClientNode(Element data, String serviceName) {
        Element clientElement = null;
        NodeList nodes = data.getElementsByTagName("web-service-clients");
        if (nodes.getLength() != 0) {
            Element clientElements = (Element)nodes.item(0);
            NodeList clientNameList = clientElements.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", "web-service-client-name");
            for (int i = 0; i < clientNameList.getLength(); ++i) {
                String name;
                Node n;
                Element clientNameElement = (Element)clientNameList.item(i);
                NodeList nl = clientNameElement.getChildNodes();
                if (nl.getLength() != 1 || (n = nl.item(0)).getNodeType() != 3 || !serviceName.equals(name = n.getNodeValue())) continue;
                Node node = clientNameElement.getParentNode();
                clientElement = node instanceof Element ? (Element)node : null;
                break;
            }
        }
        return clientElement;
    }

    public void addServiceClientReference(String serviceName, String fqServiceName, String relativeWsdlPath, String relativeMappingPath, String[] portSEIInfo) {
    }

    public void setProxyJVMOptions(String proxyHost, String proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    private boolean addJVMProxyOptions(EditableProperties prop, String proxyHost, String proxyPort) {
        String jvmOptions = prop.getProperty("run.jvmargs");
        boolean modif = false;
        String localHosts = "localhost";
        try {
            localHosts = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ex) {
            // empty catch block
        }
        if (!"localhost".equals(localHosts)) {
            localHosts = "\"" + localHosts + "|localhost\"";
        }
        if (jvmOptions == null || jvmOptions.length() == 0) {
            jvmOptions = "-Dhttp.proxyHost=" + proxyHost + " " + PROXY_PORT_OPTION + "=" + proxyPort + " " + NON_PROXY_HOSTS_OPTION + "=" + localHosts;
            modif = true;
        } else {
            if (jvmOptions.indexOf(PROXY_HOST_OPTION) < 0) {
                jvmOptions = jvmOptions + " -Dhttp.proxyHost=" + proxyHost;
                modif = true;
            }
            if (jvmOptions.indexOf(PROXY_PORT_OPTION) < 0) {
                jvmOptions = jvmOptions + " -Dhttp.proxyPort=" + proxyPort;
                modif = true;
            }
            if (jvmOptions.indexOf(NON_PROXY_HOSTS_OPTION) < 0) {
                jvmOptions = jvmOptions + " -Dhttp.nonProxyHosts=" + localHosts;
                modif = true;
            }
        }
        if (modif) {
            prop.setProperty("run.jvmargs", jvmOptions);
        }
        return modif;
    }

    public String getServiceRefName(String serviceName) {
        return null;
    }

    static {
        $assertionsDisabled = !J2SEProjectWebServicesClientSupport.class.desiredAssertionStatus();
        WSCOMPILE_CLIENT_FEATURES = new String[]{"datahandleronly", "explicitcontext", "jaxbenumtype", "nodatabinding", "noencodedtypes", "nomultirefs", "norpcstructures", "novalidation", "resolveidref", "searchschema", "serializeinterfaces", "strict", "wsi", "unwrap", "donotoverride", "donotunwrap"};
        allClientFeatures = Arrays.asList(WSCOMPILE_CLIENT_FEATURES);
        WSCOMPILE_KEY_CLIENT_FEATURES = new String[]{"wsi", "strict", "norpcstructures", "unwrap", "donotunwrap", "donotoverride", "datahandleronly", "nodatabinding", "novalidation", "searchschema"};
        importantClientFeatures = Arrays.asList(WSCOMPILE_KEY_CLIENT_FEATURES);
        jaxrpcClientStub = new JAXRPCClientStubDescriptor("jaxrpc_static_client", NbBundle.getMessage((Class)J2SEProjectWebServicesClientSupport.class, (String)"LBL_JAXRPCStaticClientStub"), new String[]{"wsi", "strict"});
    }

    private static class JAXRPCClientStubDescriptor
    extends ClientStubDescriptor {
        private String[] defaultFeatures;

        public JAXRPCClientStubDescriptor(String name, String displayName, String[] defaultFeatures) {
            super(name, displayName);
            this.defaultFeatures = defaultFeatures;
        }

        public String[] getDefaultFeatures() {
            return this.defaultFeatures;
        }

        public String getDefaultFeaturesAsArgument() {
            StringBuffer buf = new StringBuffer(this.defaultFeatures.length * 32);
            for (int i = 0; i < this.defaultFeatures.length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(this.defaultFeatures[i]);
            }
            return buf.toString();
        }

        void setDefaultFeatures(String[] defaultFeatures) {
            this.defaultFeatures = defaultFeatures;
        }
    }
}

