/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.libraries;

import java.beans.Customizer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.j2seplatform.libraries.J2SEVolumeCustomizer;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class J2SELibraryTypeProvider
implements LibraryTypeProvider {
    private static final String LIB_PREFIX = "libs.";
    public static final String LIBRARY_TYPE = "j2se";
    public static final String VOLUME_TYPE_CLASSPATH = "classpath";
    public static final String VOLUME_TYPE_SRC = "src";
    public static final String VOLUME_TYPE_JAVADOC = "javadoc";
    public static final String[] VOLUME_TYPES;
    static final /* synthetic */ boolean $assertionsDisabled;

    private J2SELibraryTypeProvider() {
    }

    public String getLibraryType() {
        return LIBRARY_TYPE;
    }

    public String getDisplayName() {
        return NbBundle.getMessage((Class)J2SELibraryTypeProvider.class, (String)"TXT_J2SELibraryType");
    }

    public String[] getSupportedVolumeTypes() {
        return VOLUME_TYPES;
    }

    public LibraryImplementation createLibrary() {
        return LibrariesSupport.createLibraryImplementation((String)LIBRARY_TYPE, (String[])VOLUME_TYPES);
    }

    public void libraryCreated(final LibraryImplementation libraryImpl) {
        if (!$assertionsDisabled && libraryImpl == null) {
            throw new AssertionError();
        }
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    boolean save = J2SELibraryTypeProvider.addLibraryIntoBuild(libraryImpl, props);
                    if (save) {
                        PropertyUtils.putGlobalProperties((EditableProperties)props);
                    }
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        });
    }

    public void libraryDeleted(final LibraryImplementation libraryImpl) {
        if (!$assertionsDisabled && libraryImpl == null) {
            throw new AssertionError();
        }
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                try {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    for (int i = 0; i < VOLUME_TYPES.length; ++i) {
                        String property = J2SELibraryTypeProvider.LIB_PREFIX + libraryImpl.getName() + '.' + VOLUME_TYPES[i];
                        props.remove((Object)property);
                    }
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        });
    }

    public Customizer getCustomizer(String volumeType) {
        if (VOLUME_TYPES[0].equals(volumeType) || VOLUME_TYPES[1].equals(volumeType) || VOLUME_TYPES[2].equals(volumeType)) {
            return new J2SEVolumeCustomizer(volumeType);
        }
        return null;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public static LibraryTypeProvider create() {
        return new J2SELibraryTypeProvider();
    }

    private static boolean addLibraryIntoBuild(LibraryImplementation impl, EditableProperties props) {
        boolean modified = false;
        for (int i = 0; i < VOLUME_TYPES.length; ++i) {
            String propName = LIB_PREFIX + impl.getName() + '.' + VOLUME_TYPES[i];
            List roots = impl.getContent(VOLUME_TYPES[i]);
            if (roots == null) continue;
            StringBuffer propValue = new StringBuffer();
            boolean first = true;
            Iterator rootsIt = roots.iterator();
            while (rootsIt.hasNext()) {
                URI uri;
                URL url = (URL)rootsIt.next();
                if ("jar".equals(url.getProtocol())) {
                    url = FileUtil.getArchiveFile((URL)url);
                }
                File f = null;
                FileObject fo = URLMapper.findFileObject((URL)url);
                if (fo != null) {
                    f = FileUtil.toFile((FileObject)fo);
                } else if ("file".equals(url.getProtocol()) && (uri = URI.create(url.toExternalForm())) != null) {
                    f = new File(uri);
                }
                if (f != null) {
                    if (!first) {
                        propValue.append(File.pathSeparatorChar);
                    }
                    first = false;
                    f = FileUtil.normalizeFile((File)f);
                    propValue.append(f.getAbsolutePath());
                    continue;
                }
                ErrorManager.getDefault().log("J2SELibraryTypeProvider: Can not resolve URL: " + url);
            }
            String oldValue = props.getProperty(propName);
            String newValue = propValue.toString();
            if (newValue.equals(oldValue)) continue;
            props.setProperty(propName, newValue);
            modified = true;
        }
        return modified;
    }

    static {
        $assertionsDisabled = !J2SELibraryTypeProvider.class.desiredAssertionStatus();
        VOLUME_TYPES = new String[]{VOLUME_TYPE_CLASSPATH, VOLUME_TYPE_SRC, VOLUME_TYPE_JAVADOC};
    }
}

