/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.archive.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.archive.project.ArchiveProject;
import org.netbeans.modules.j2ee.archive.project.ArchiveProjectProperties;
import org.netbeans.modules.j2ee.archive.ui.ConfigFilesNode;
import org.netbeans.modules.j2ee.archive.ui.ModuleNode;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.ErrorManager;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class RootNode
extends AbstractNode {
    public RootNode(ArchiveProject ap) {
        super((Children)new LogicalViewChildren(ap), RootNode.createLookup(ap));
        super.setName(ProjectUtils.getInformation((Project)ap).getDisplayName());
        this.setIconBaseWithExtension("org/netbeans/modules/j2ee/archive/project/resources/application_assembler_16.gif");
        ArchiveProjectProperties app = ap.getArchiveProjectProperties();
        String sourceArchive = ap.getPropertyEvaluator().evaluate((String)app.get("source.archive"));
        this.setShortDescription(NbBundle.getMessage(RootNode.class, (String)"LBL_ProjectToolTip", (Object)sourceArchive));
    }

    public Action[] getActions(boolean context) {
        Action[] retVal = context ? super.getActions(true) : this.getAdditionalActions();
        return retVal;
    }

    private Action[] getAdditionalActions() {
        ResourceBundle bundle = NbBundle.getBundle(RootNode.class);
        ArrayList<Action> actions = new ArrayList<Action>(30);
        actions.add(CommonProjectActions.newFileAction());
        actions.add(null);
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"build", (String)bundle.getString("LBL_BuildAction_Name"), null));
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"verify", (String)bundle.getString("LBL_VerifyAction_Name"), null));
        actions.add(ProjectSensitiveActions.projectCommandAction((String)"run", (String)bundle.getString("LBL_RunAction_Name"), null));
        actions.add(null);
        actions.add(CommonProjectActions.setAsMainProjectAction());
        actions.add(CommonProjectActions.openSubprojectsAction());
        actions.add(CommonProjectActions.closeProjectAction());
        actions.add(null);
        actions.add(CommonProjectActions.renameProjectAction());
        actions.add(CommonProjectActions.moveProjectAction());
        actions.add(CommonProjectActions.copyProjectAction());
        actions.add(CommonProjectActions.deleteProjectAction());
        actions.add(null);
        actions.add((Action)SystemAction.get(FindAction.class));
        try {
            Repository repository = Repository.getDefault();
            FileSystem sfs = repository.getDefaultFileSystem();
            FileObject fo = sfs.findResource("Projects/Actions");
            if (fo != null) {
                DataObject dobj = DataObject.find((FileObject)fo);
                FolderLookup actionRegistry = new FolderLookup((DataObject.Container)((DataFolder)dobj));
                Lookup.Template query = new Lookup.Template(Object.class);
                Lookup lookup = actionRegistry.getLookup();
                Iterator it = lookup.lookup(query).allInstances().iterator();
                if (it.hasNext()) {
                    actions.add(null);
                }
                while (it.hasNext()) {
                    Object next = it.next();
                    if (next instanceof Action) {
                        actions.add((Action)next);
                        continue;
                    }
                    if (!(next instanceof JSeparator)) continue;
                    actions.add(null);
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        actions.add(CommonProjectActions.customizeProjectAction());
        return actions.toArray(new Action[actions.size()]);
    }

    private static Lookup createLookup(Project project) {
        DataFolder rootFolder = DataFolder.findFolder((FileObject)project.getProjectDirectory());
        return Lookups.fixed((Object[])new Object[]{project, rootFolder});
    }

    static final class LogicalViewChildren
    extends Children.Keys
    implements FileChangeListener {
        private static final String KEY_DOC_BASE = "docBase";
        private static final String KEY_SETUP_DIR = "setupDir";
        private ArchiveProject project;

        public LogicalViewChildren(ArchiveProject project) {
            assert (project != null);
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)this);
            this.createNodes();
        }

        private void createNodes() {
            ArrayList<Object> l = new ArrayList<Object>();
            DataFolder docBaseDir = this.getFolder((String)this.project.getArchiveProjectProperties().get("proxy.project.dir"));
            if (docBaseDir != null) {
                l.add(KEY_DOC_BASE);
            }
            l.add(KEY_SETUP_DIR);
            String dir = (String)this.project.getArchiveProjectProperties().get("proxy.project.dir");
            FileObject fo = this.project.getProjectDirectory().getFileObject("subarchives");
            if (null != fo) {
                FileObject[] subarchives;
                for (FileObject innerFo : subarchives = fo.getChildren()) {
                    DataFolder folder;
                    FileObject innerProj = null;
                    if (null != innerFo) {
                        innerProj = innerFo.getFileObject("tmpproj");
                    }
                    if (null == innerProj || !innerProj.isFolder() || null == (folder = this.getFolder("subarchives/" + innerFo.getName() + "/" + dir))) continue;
                    ModuleNode n = new ModuleNode(folder, NbBundle.getMessage(RootNode.class, (String)"LBL_ModuleNode", (Object)this.project.getEarPath(innerFo.getName())));
                    l.add((Object)n);
                }
            }
            this.setKeys(l);
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            this.project.getProjectDirectory().removeFileChangeListener((FileChangeListener)this);
            super.removeNotify();
        }

        protected Node[] createNodes(Object key) {
            Node[] nodeArray;
            Object n = null;
            n = key == KEY_DOC_BASE ? new ConfigFilesNode(this.getFolder((String)this.project.getArchiveProjectProperties().get("proxy.project.dir"))) : (key == KEY_SETUP_DIR ? J2eeProjectView.createServerResourcesNode((Project)this.project) : (Node)key);
            if (n == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = n;
            }
            return nodeArray;
        }

        private DataFolder getFolder(String dir) {
            FileObject fo = this.project.getProjectDirectory();
            if (null == dir) {
                return null;
            }
            if (null != fo) {
                fo = fo.getFileObject(dir);
            }
            if (null == fo) {
                return null;
            }
            if (null != (fo = fo.getFileObject("web"))) {
                if ((fo = fo.getFileObject("WEB-INF")) != null) {
                    DataFolder df = DataFolder.findFolder((FileObject)fo);
                    return df;
                }
                return null;
            }
            fo = this.project.getProjectDirectory().getFileObject(dir);
            if (null == fo) {
                return null;
            }
            if (null == (fo = fo.getFileObject("src"))) {
                return null;
            }
            if (null == (fo = fo.getFileObject("conf"))) {
                return null;
            }
            return DataFolder.findFolder((FileObject)fo);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
            this.createNodes();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.createNodes();
        }
    }
}

