/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.spi.HelpIDFragmentProvider;
import org.netbeans.modules.ant.freeform.spi.ProjectNature;
import org.netbeans.modules.ant.freeform.spi.TargetDescriptor;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.web.freeform.WebFreeFormActionProvider;
import org.netbeans.modules.web.freeform.WebModules;
import org.netbeans.modules.web.freeform.ui.WebClasspathPanel;
import org.netbeans.modules.web.freeform.ui.WebLocationsPanel;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.w3c.dom.Element;

public class WebProjectNature
implements ProjectNature {
    public static final String NS_WEB = "http://www.netbeans.org/ns/freeform-project-web/1";
    private static final String SCHEMA = "nbres:/org/netbeans/modules/web/freeform/resources/freeform-project-web.xsd";
    private static final String HELP_ID_FRAGMENT = "web";
    private static final WeakHashMap lookupCache = new WeakHashMap();
    private List schemas = new ArrayList();

    public Lookup getLookup(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
        Object lookup;
        WeakReference wr = (WeakReference)lookupCache.get(project);
        Lookup lookup2 = lookup = wr != null ? (Lookup)wr.get() : null;
        if (lookup == null) {
            lookup = new ProjectLookup(project, projectHelper, projectEvaluator, aux);
            lookupCache.put(project, new WeakReference<Lookup>((Lookup)lookup));
        }
        return lookup;
    }

    public Set getCustomizerPanels(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
        HashSet<Object> l = new HashSet<Object>();
        if (!WebProjectNature.isMyProject(aux)) {
            return l;
        }
        WebLocationsPanel.Panel web = new WebLocationsPanel.Panel(project, projectHelper, projectEvaluator, aux);
        l.add(web);
        l.add(new WebClasspathPanel.Panel(project, projectHelper, projectEvaluator, aux));
        return l;
    }

    public List getExtraTargets(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
        ArrayList<TargetDescriptor> l = new ArrayList<TargetDescriptor>();
        if (!WebProjectNature.isMyProject(aux)) {
            return l;
        }
        l.add(WebProjectNature.getExtraTarget());
        return l;
    }

    public Set getSchemas() {
        return Collections.singleton(SCHEMA);
    }

    public Set getSourceFolderViewStyles() {
        return Collections.EMPTY_SET;
    }

    public Node createSourceFolderView(Project project, FileObject folder, String style, String name, String displayName) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    public Node findSourceFolderViewPath(Project project, Node root, Object target) {
        return null;
    }

    private static boolean isMyProject(AuxiliaryConfiguration aux) {
        return aux.getConfigurationFragment("web-data", NS_WEB, true) != null;
    }

    public static TargetDescriptor getExtraTarget() {
        return new TargetDescriptor("redeploy", Arrays.asList("deploy", ".*deploy.*"), NbBundle.getMessage((Class)WebProjectNature.class, (String)"LBL_TargetMappingPanel_Deploy"), NbBundle.getMessage((Class)WebProjectNature.class, (String)"ACSD_TargetMappingPanel_Deploy"));
    }

    private static Lookup initLookup(Project project, AntProjectHelper projectHelper, PropertyEvaluator projectEvaluator, AuxiliaryConfiguration aux) {
        WebClasspath webcp = new WebClasspath(projectHelper, projectEvaluator, aux, project);
        return Lookups.fixed((Object[])new Object[]{new ProjectOpenedHookImpl(webcp), new PrivilegedTemplatesImpl(), new WebModules(project, projectHelper, projectEvaluator), new WebFreeFormActionProvider(project, projectHelper, aux), new HelpIDFragmentProviderImpl()});
    }

    private static final class PrivilegedTemplatesImpl
    implements PrivilegedTemplates,
    RecommendedTemplates {
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/JSP_Servlet/JSP.jsp", "Templates/JSP_Servlet/Html.html", "Templates/JSP_Servlet/Servlet.java", "Templates/Classes/Class.java"};
        private static final String[] RECOMENDED_TYPES = new String[]{"java-classes", "java-main-class", "java-beans", "oasis-XML-catalogs", "XML", "wsdl", "ant-script", "ant-task", "servlet-types", "web-types", "j2ee-types", "junit", "simple-files"};

        private PrivilegedTemplatesImpl() {
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }

        public String[] getRecommendedTypes() {
            return RECOMENDED_TYPES;
        }
    }

    private static final class ProjectLookup
    extends ProxyLookup
    implements AntProjectListener {
        private AntProjectHelper helper;
        private PropertyEvaluator evaluator;
        private Project project;
        private AuxiliaryConfiguration aux;
        private boolean isMyProject;

        public ProjectLookup(Project project, AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
            super(new Lookup[0]);
            this.project = project;
            this.helper = helper;
            this.evaluator = evaluator;
            this.aux = aux;
            this.isMyProject = WebProjectNature.isMyProject(aux);
            this.updateLookup();
            helper.addAntProjectListener((AntProjectListener)this);
        }

        private void updateLookup() {
            Lookup l = Lookup.EMPTY;
            if (this.isMyProject) {
                l = WebProjectNature.initLookup(this.project, this.helper, this.evaluator, this.aux);
            }
            this.setLookups(new Lookup[]{l});
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            if (WebProjectNature.isMyProject(this.aux) != this.isMyProject) {
                this.isMyProject = !this.isMyProject;
                this.updateLookup();
            }
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }
    }

    public static final class WebClasspath
    implements AntProjectListener,
    PropertyChangeListener {
        private ClassPath[] registeredCP = new ClassPath[0];
        private List registeredRoots = Collections.EMPTY_LIST;
        private AntProjectHelper helper;
        private PropertyEvaluator evaluator;
        private AuxiliaryConfiguration aux;
        private Project project;
        private PropertyChangeSupport pcs;
        private boolean prjClosed = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        public WebClasspath(AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux, Project proj) {
            this.helper = helper;
            this.evaluator = evaluator;
            this.aux = aux;
            this.project = proj;
            helper.addAntProjectListener((AntProjectListener)this);
            evaluator.addPropertyChangeListener((PropertyChangeListener)this);
            this.pcs = new PropertyChangeSupport(this);
        }

        public void prjOpened() {
            this.registeredRoots = this.getWebRoots(this.aux, this.project, this.evaluator);
            FileObject[] fos = new FileObject[this.registeredRoots.size()];
            ClassPath cp = ClassPathSupport.createClassPath((FileObject[])this.registeredRoots.toArray(fos));
            this.registeredCP = new ClassPath[]{cp};
            GlobalPathRegistry.getDefault().register("classpath/source", this.registeredCP);
            this.prjClosed = false;
        }

        public void prjClosed() {
            if (!this.registeredRoots.isEmpty()) {
                GlobalPathRegistry.getDefault().unregister("classpath/source", this.registeredCP);
            }
            this.registeredRoots = Collections.EMPTY_LIST;
            this.prjClosed = true;
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            this.updateClasspath();
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            this.updateClasspath();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        private synchronized void updateClasspath() {
            List newRoots;
            if (!this.prjClosed && !((Object)(newRoots = this.getWebRoots(this.aux, this.project, this.evaluator))).equals(this.registeredRoots)) {
                FileObject[] fos = new FileObject[newRoots.size()];
                ClassPath cp = ClassPathSupport.createClassPath((FileObject[])newRoots.toArray(fos));
                GlobalPathRegistry.getDefault().unregister("classpath/source", this.registeredCP);
                this.registeredCP = new ClassPath[]{cp};
                this.registeredRoots = newRoots;
                GlobalPathRegistry.getDefault().register("classpath/source", this.registeredCP);
                this.pcs.firePropertyChange("resources", null, null);
            }
        }

        private List getWebRoots(AuxiliaryConfiguration aux, Project proj, PropertyEvaluator evaluator) {
            Element web = aux.getConfigurationFragment("web-data", WebProjectNature.NS_WEB, true);
            if (web == null) {
                return null;
            }
            List webModules = Util.findSubElements((Element)web);
            Iterator it = webModules.iterator();
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            while (it.hasNext()) {
                Element webModulesEl = (Element)it.next();
                if (!$assertionsDisabled && !webModulesEl.getLocalName().equals("web-module")) {
                    throw new AssertionError(webModulesEl);
                }
                roots.add(FileUtil.toFileObject((File)this.getFile(webModulesEl, "doc-root", proj, evaluator)));
            }
            return roots;
        }

        private File getFile(Element parent, String fileElName, Project proj, PropertyEvaluator evaluator) {
            Element el = Util.findElement((Element)parent, (String)fileElName, (String)WebProjectNature.NS_WEB);
            return Util.resolveFile((PropertyEvaluator)evaluator, (File)FileUtil.toFile((FileObject)proj.getProjectDirectory()), (String)Util.findText((Element)el));
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$web$freeform$WebProjectNature == null ? (class$org$netbeans$modules$web$freeform$WebProjectNature = WebProjectNature.class$("org.netbeans.modules.web.freeform.WebProjectNature")) : class$org$netbeans$modules$web$freeform$WebProjectNature).desiredAssertionStatus();
        }
    }

    private static class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private final WebClasspath webcp;

        public ProjectOpenedHookImpl(WebClasspath wcp) {
            this.webcp = wcp;
        }

        protected void projectOpened() {
            this.webcp.prjOpened();
        }

        protected void projectClosed() {
            this.webcp.prjClosed();
        }
    }

    private static final class HelpIDFragmentProviderImpl
    implements HelpIDFragmentProvider {
        private HelpIDFragmentProviderImpl() {
        }

        public String getHelpIDFragment() {
            return WebProjectNature.HELP_ID_FRAGMENT;
        }
    }
}

