/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui.customizer;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JButton;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.j2ee.common.ui.BrokenServerSupport;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.dd.api.application.Web;
import org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.earproject.BrokenProjectSupport;
import org.netbeans.modules.j2ee.earproject.EarProject;
import org.netbeans.modules.j2ee.earproject.EarProjectGenerator;
import org.netbeans.modules.j2ee.earproject.UpdateHelper;
import org.netbeans.modules.j2ee.earproject.ui.customizer.VisualClassPathItem;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EarProjectProperties {
    public static final String J2EE_SPEC_14_LABEL = NbBundle.getMessage(EarProjectProperties.class, (String)"J2EESpecLevel_14");
    public static final String JAVA_EE_SPEC_50_LABEL = NbBundle.getMessage(EarProjectProperties.class, (String)"JavaEESpecLevel_50");
    public static final String WEB_PROJECT_NAME = "web.project.name";
    public static final String JAVA_PLATFORM = "platform.active";
    public static final String J2EE_PLATFORM = "j2ee.platform";
    public static final String SOURCE_ROOT = "source.root";
    public static final String BUILD_FILE = "buildfile";
    public static final String LIBRARIES_DIR = "lib.dir";
    public static final String DIST_DIR = "dist.dir";
    public static final String DIST_JAR = "dist.jar";
    public static final String JAVAC_CLASSPATH = "javac.classpath";
    public static final String DEBUG_CLASSPATH = "debug.classpath";
    public static final String RUN_CLASSPATH = "run.classpath";
    public static final String JAR_NAME = "jar.name";
    public static final String JAR_COMPRESS = "jar.compress";
    public static final String JAR_CONTENT_ADDITIONAL = "jar.content.additional";
    public static final String APPLICATION_CLIENT = "app.client";
    public static final String APPCLIENT_MAIN_CLASS = "main.class";
    public static final String APPCLIENT_ARGS = "application.args";
    public static final String APPCLIENT_JVM_OPTIONS = "j2ee.appclient.jvmoptions";
    public static final String APPCLIENT_MAINCLASS_ARGS = "j2ee.appclient.mainclass.args";
    public static final String LAUNCH_URL_RELATIVE = "client.urlPart";
    public static final String DISPLAY_BROWSER = "display.browser";
    public static final String CLIENT_MODULE_URI = "client.module.uri";
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String J2EE_SERVER_TYPE = "j2ee.server.type";
    public static final String JAVAC_SOURCE = "javac.source";
    public static final String JAVAC_DEBUG = "javac.debug";
    public static final String JAVAC_DEPRECATION = "javac.deprecation";
    public static final String JAVAC_TARGET = "javac.target";
    public static final String META_INF = "meta.inf";
    public static final String RESOURCE_DIR = "resource.dir";
    public static final String WEB_DOCBASE_DIR = "web.docbase.dir";
    public static final String BUILD_DIR = "build.dir";
    public static final String BUILD_ARCHIVE_DIR = "build.archive.dir";
    public static final String BUILD_GENERATED_DIR = "build.generated.dir";
    public static final String BUILD_CLASSES_DIR = "build.classes.dir";
    public static final String BUILD_CLASSES_EXCLUDES = "build.classes.excludes";
    public static final String DIST_JAVADOC_DIR = "dist.javadoc.dir";
    public static final String NO_DEPENDENCIES = "no.dependencies";
    public static final String JAVADOC_PRIVATE = "javadoc.private";
    public static final String JAVADOC_NO_TREE = "javadoc.notree";
    public static final String JAVADOC_USE = "javadoc.use";
    public static final String JAVADOC_NO_NAVBAR = "javadoc.nonavbar";
    public static final String JAVADOC_NO_INDEX = "javadoc.noindex";
    public static final String JAVADOC_SPLIT_INDEX = "javadoc.splitindex";
    public static final String JAVADOC_AUTHOR = "javadoc.author";
    public static final String JAVADOC_VERSION = "javadoc.version";
    public static final String JAVADOC_WINDOW_TITLE = "javadoc.windowtitle";
    public static final String JAVADOC_ENCODING = "javadoc.encoding";
    public static final String JAVADOC_PREVIEW = "javadoc.preview";
    public static final String COMPILE_JSPS = "compile.jsps";
    public static final String CLIENT_NAME = "j2ee.clientName";
    public static final String APPCLIENT_TOOL_RUNTIME = "j2ee.appclient.tool.runtime";
    public static final String APPCLIENT_TOOL_MAINCLASS = "j2ee.appclient.tool.mainclass";
    public static final String APPCLIENT_TOOL_JVMOPTS = "j2ee.appclient.tool.jvmoptions";
    public static final String APPCLIENT_TOOL_ARGS = "j2ee.appclient.tool.args";
    private static final String J2EE_PLATFORM_APPCLIENT_ARGS = "j2ee.appclient.args";
    static final String APPCLIENT_WA_COPY_CLIENT_JAR_FROM = "wa.copy.client.jar.from";
    private static final String PROJECT = "nbproject/project.properties";
    private static final String PRIVATE = "nbproject/private/private.properties";
    public static final String TAG_WEB_MODULE_LIBRARIES = "web-module-libraries";
    public static final String TAG_WEB_MODULE__ADDITIONAL_LIBRARIES = "web-module-additional-libraries";
    public static final String DEPLOY_ANT_PROPS_FILE = "deploy.ant.properties.file";
    public static final String ANT_DEPLOY_BUILD_SCRIPT = "nbproject/ant-deploy.xml";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";
    static final PropertyParser STRING_PARSER = new StringParser();
    private static final BooleanParser BOOLEAN_PARSER = new BooleanParser();
    private static final InverseBooleanParser INVERSE_BOOLEAN_PARSER = new InverseBooleanParser();
    private final PropertyParser PATH_PARSER = new PathParser();
    private final PropertyParser JAVAC_CLASSPATH_PARSER = new PathParser("web-module-libraries");
    private final PropertyParser JAR_CONTENT_ADDITIONAL_PARSER = new PathParser("web-module-additional-libraries");
    private static final PlatformParser PLATFORM_PARSER = new PlatformParser();
    private final PropertyDescriptor[] PROPERTY_DESCRIPTORS = new PropertyDescriptor[]{new PropertyDescriptor("web.project.name", null, STRING_PARSER), new PropertyDescriptor("j2ee.platform", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("source.root", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("buildfile", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("lib.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("dist.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("dist.jar", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("javac.classpath", "nbproject/project.properties", this.JAVAC_CLASSPATH_PARSER), new PropertyDescriptor("compile.jsps", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("debug.classpath", "nbproject/project.properties", this.PATH_PARSER), new PropertyDescriptor("run.classpath", "nbproject/project.properties", this.PATH_PARSER), new PropertyDescriptor("jar.name", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("jar.compress", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("jar.content.additional", "nbproject/project.properties", this.JAR_CONTENT_ADDITIONAL_PARSER), new PropertyDescriptor("app.client", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("main.class", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("j2ee.appclient.jvmoptions", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("application.args", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("client.urlPart", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("client.module.uri", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("display.browser", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("j2ee.server.type", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("j2ee.server.instance", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("javac.source", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("javac.debug", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javac.deprecation", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javac.target", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("resource.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("build.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("build.classes.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("build.classes.excludes", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("dist.javadoc.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("web.docbase.dir", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("no.dependencies", "nbproject/project.properties", INVERSE_BOOLEAN_PARSER), new PropertyDescriptor("platform.active", "nbproject/project.properties", PLATFORM_PARSER), new PropertyDescriptor("deploy.ant.properties.file", "nbproject/private/private.properties", STRING_PARSER), new PropertyDescriptor("javadoc.private", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.notree", "nbproject/project.properties", INVERSE_BOOLEAN_PARSER), new PropertyDescriptor("javadoc.use", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.nonavbar", "nbproject/project.properties", INVERSE_BOOLEAN_PARSER), new PropertyDescriptor("javadoc.noindex", "nbproject/project.properties", INVERSE_BOOLEAN_PARSER), new PropertyDescriptor("javadoc.splitindex", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.author", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.version", "nbproject/project.properties", BOOLEAN_PARSER), new PropertyDescriptor("javadoc.windowtitle", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("javadoc.encoding", "nbproject/project.properties", STRING_PARSER), new PropertyDescriptor("javadoc.preview", "nbproject/project.properties", BOOLEAN_PARSER)};
    private final Map<String, PropertyInfo> properties;
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper refHelper;
    private final AntBasedProjectType abpt;
    private final UpdateHelper updateHelper;
    private final EarProject earProject;
    private final GeneratedFilesHelper genFilesHelper;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final SpecificationVersion JDKSpec13 = new SpecificationVersion("1.3");
    private static final String LIBRARY_PREFIX = "${libs.";
    private static final String ANT_ARTIFACT_PREFIX = "${reference.";
    private static final String[][] WELL_KNOWN_PATHS = new String[][]{{"javac.classpath", NbBundle.getMessage(EarProjectProperties.class, (String)"LBL_JavacClasspath_DisplayName")}, {"build.classes.dir", NbBundle.getMessage(EarProjectProperties.class, (String)"LBL_BuildClassesDir_DisplayName")}};

    public EarProjectProperties(EarProject project, ReferenceHelper refHelper, AntBasedProjectType abpt) {
        this.earProject = project;
        this.properties = new HashMap<String, PropertyInfo>();
        this.updateHelper = project.getUpdateHelper();
        this.antProjectHelper = this.updateHelper.getAntProjectHelper();
        this.refHelper = refHelper;
        this.abpt = abpt;
        this.genFilesHelper = project.getGeneratedFilesHelper();
        this.read();
    }

    void updateContentDependency(Set<VisualClassPathItem> oldContent, Set<VisualClassPathItem> newContent) {
        Application app = null;
        try {
            app = DDProvider.getDefault().getDDRoot(this.earProject.getAppModule().getDeploymentDescriptor());
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().log(ioe.getLocalizedMessage());
        }
        HashSet<VisualClassPathItem> deleted = new HashSet<VisualClassPathItem>(oldContent);
        deleted.removeAll(newContent);
        HashSet<VisualClassPathItem> added = new HashSet<VisualClassPathItem>(newContent);
        added.removeAll(oldContent);
        boolean same = true;
        if (deleted.size() == added.size()) {
            Iterator deletedIterator = deleted.iterator();
            Iterator addedIterator = added.iterator();
            while (deletedIterator.hasNext() && addedIterator.hasNext()) {
                VisualClassPathItem del = (VisualClassPathItem)deletedIterator.next();
                VisualClassPathItem add = (VisualClassPathItem)addedIterator.next();
                if (del == null || add == null || del.equals(add)) continue;
                same = false;
                break;
            }
        } else {
            same = false;
        }
        boolean saveNeeded = false;
        if (null != app && !same) {
            for (VisualClassPathItem vcpi : deleted) {
                this.removeItemFromAppDD(app, vcpi);
            }
            for (VisualClassPathItem vcpi : added) {
                this.addItemToAppDD(app, vcpi);
            }
            saveNeeded = true;
        }
        for (VisualClassPathItem vcpi : newContent) {
            if (vcpi.getPathInEAR().equals(vcpi.getOrigPathInEAR())) continue;
            this.removeItemFromAppDD(app, vcpi, vcpi.getCompletePathInArchive(true));
            this.addItemToAppDD(app, vcpi);
            saveNeeded = true;
        }
        if (saveNeeded) {
            try {
                app.write(this.earProject.getAppModule().getDeploymentDescriptor());
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().log(ioe.getLocalizedMessage());
            }
        }
    }

    private void removeItemFromAppDD(Application dd, VisualClassPathItem vcpi) {
        this.removeItemFromAppDD(dd, vcpi, vcpi.getCompletePathInArchive());
    }

    private void removeItemFromAppDD(Application dd, VisualClassPathItem vcpi, String pathInEAR) {
        Module m = this.searchForModule(dd, pathInEAR);
        if (null != m) {
            J2eeModule jm;
            AntArtifact aa;
            Project p;
            J2eeModuleProvider jmp;
            dd.removeModule(m);
            this.setClientModuleUri("");
            Object obj = vcpi.getObject();
            if (obj instanceof AntArtifact && null != (jmp = (J2eeModuleProvider)(p = (aa = (AntArtifact)obj).getProject()).getLookup().lookup(J2eeModuleProvider.class)) && null != (jm = jmp.getJ2eeModule())) {
                this.earProject.getAppModule().removeModuleProvider(jmp, pathInEAR);
            }
        }
    }

    private Module searchForModule(Application dd, String path) {
        Module[] mods = dd.getModule();
        int len = 0;
        if (null != mods) {
            len = mods.length;
        }
        for (int i = 0; i < len; ++i) {
            String val = mods[i].getEjb();
            if (null != val && val.equals(path)) {
                return mods[i];
            }
            val = mods[i].getConnector();
            if (null != val && val.equals(path)) {
                return mods[i];
            }
            val = mods[i].getJava();
            if (null != val && val.equals(path)) {
                return mods[i];
            }
            Web w = mods[i].getWeb();
            val = null;
            if (null != w) {
                val = w.getWebUri();
            }
            if (null == val || !val.equals(path)) continue;
            return mods[i];
        }
        return null;
    }

    public void addItemToAppDD(Application dd, VisualClassPathItem vcpi) {
        Module prevMod;
        Object obj = vcpi.getObject();
        String path = vcpi.getCompletePathInArchive();
        Module mod = null;
        if (obj instanceof AntArtifact) {
            mod = this.getModFromAntArtifact((AntArtifact)obj, dd, path);
        } else if (obj instanceof File) {
            mod = this.getModFromFile((File)obj, dd, path);
        }
        if (mod != null && mod.getWeb() != null) {
            this.replaceEmptyClientModuleUri(path);
        }
        if (null == (prevMod = this.searchForModule(dd, path)) && null != mod) {
            dd.addModule(mod);
        }
    }

    private Module getModFromAntArtifact(AntArtifact aa, Application dd, String path) {
        Project p = aa.getProject();
        Module mod = null;
        try {
            J2eeModuleProvider jmp = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
            if (null != jmp) {
                jmp.setServerInstanceID(this.earProject.getServerInstanceID());
                J2eeModule jm = jmp.getJ2eeModule();
                if (null == jm) {
                    return null;
                }
                this.earProject.getAppModule().addModuleProvider(jmp, path);
                mod = (Module)dd.createBean("Module");
                if (jm.getModuleType() == J2eeModule.EJB) {
                    mod.setEjb(path);
                } else if (jm.getModuleType() == J2eeModule.WAR) {
                    Web w = mod.newWeb();
                    w.setWebUri(path);
                    FileObject tmp = aa.getScriptFile();
                    if (null != tmp) {
                        tmp = tmp.getParent().getFileObject("web/WEB-INF/web.xml");
                    }
                    WebModule wm = null;
                    if (null != tmp) {
                        wm = WebModule.getWebModule((FileObject)tmp);
                    }
                    String contextPath = null;
                    if (null != wm) {
                        contextPath = wm.getContextPath();
                    }
                    if (contextPath == null) {
                        int endex = path.length() - 4;
                        if (endex < 1) {
                            endex = path.length();
                        }
                        contextPath = path.substring(0, endex);
                    }
                    w.setContextRoot(contextPath);
                    mod.setWeb(w);
                } else if (jm.getModuleType() == J2eeModule.CONN) {
                    mod.setConnector(path);
                } else if (jm.getModuleType() == J2eeModule.CLIENT) {
                    mod.setJava(path);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            ErrorManager.getDefault().notify((Throwable)cnfe);
        }
        return mod;
    }

    private void setClientModuleUri(String newVal) {
        this.put(CLIENT_MODULE_URI, newVal);
    }

    private void replaceEmptyClientModuleUri(String path) {
        Object current = this.get(CLIENT_MODULE_URI);
        if (null == current) {
            this.setClientModuleUri(path);
        }
        if (current instanceof String && ((String)current).length() < 1) {
            this.setClientModuleUri(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Module getModFromFile(File f, Application dd, String path) {
        JarFile jar = null;
        Module mod = null;
        try {
            jar = new JarFile(f);
            JarEntry ddf = jar.getJarEntry("META-INF/ejb-jar.xml");
            if (null != ddf) {
                mod = (Module)dd.createBean("Module");
                mod.setEjb(path);
            }
            if (null != (ddf = jar.getJarEntry("META-INF/ra.xml")) && null == mod) {
                mod = (Module)dd.createBean("Module");
                mod.setConnector(path);
            } else if (null != ddf && null != mod) {
                Module module = null;
                return module;
            }
            ddf = jar.getJarEntry("META-INF/application-client.xml");
            if (null != ddf && null == mod) {
                mod = (Module)dd.createBean("Module");
                mod.setJava(path);
            } else if (null != ddf && null != mod) {
                Module module = null;
                return module;
            }
            ddf = jar.getJarEntry("WEB-INF/web.xml");
            if (null != ddf && null == mod) {
                mod = (Module)dd.createBean("Module");
                Web w = mod.newWeb();
                w.setWebUri(path);
                int endex = path.length() - 4;
                if (endex < 1) {
                    endex = path.length();
                }
                w.setContextRoot("/" + path.substring(0, endex));
                mod.setWeb(w);
            } else if (null != ddf && null != mod) {
                Module module = null;
                return module;
            }
            ddf = jar.getJarEntry("META-INF/application.xml");
            if (null == ddf) return mod;
            Module module = null;
            return module;
        }
        catch (ClassNotFoundException cnfe) {
            ErrorManager.getDefault().log(cnfe.getLocalizedMessage());
            return mod;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().log(ioe.getLocalizedMessage());
            return mod;
        }
        finally {
            try {
                if (null != jar) {
                    jar.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public List<VisualClassPathItem> getJarContentAdditional() {
        List vcpis = Collections.emptyList();
        PropertyInfo o = this.properties.get(JAR_CONTENT_ADDITIONAL);
        if (o instanceof PropertyInfo) {
            PropertyInfo pi = o;
            Object value = pi.getValue();
            assert (value instanceof List) : "jar.content.additional is not a List: " + value.getClass();
            vcpis = (List)value;
        }
        return vcpis;
    }

    public Map<String, J2eeModuleProvider> getModuleMap() {
        HashMap<String, J2eeModuleProvider> mods = new HashMap<String, J2eeModuleProvider>();
        for (VisualClassPathItem vcpi : this.getJarContentAdditional()) {
            J2eeModule jm;
            AntArtifact aa;
            Project p;
            J2eeModuleProvider jmp;
            Object obj = vcpi.getObject();
            if (!(obj instanceof AntArtifact) || null == (jmp = (J2eeModuleProvider)(p = (aa = (AntArtifact)obj).getProject()).getLookup().lookup(J2eeModuleProvider.class)) || null == (jm = jmp.getJ2eeModule())) continue;
            String path = vcpi.getCompletePathInArchive();
            mods.put(path, jmp);
        }
        return mods;
    }

    public void addJ2eeSubprojects(Project[] moduleProjects) {
        ArrayList<AntArtifact> artifactList = new ArrayList<AntArtifact>();
        for (int i = 0; i < moduleProjects.length; ++i) {
            AntArtifact[] artifacts = AntArtifactQuery.findArtifactsByType((Project)moduleProjects[i], (String)"j2ee_ear_archive");
            if (null == artifacts) continue;
            artifactList.addAll(Arrays.asList(artifacts));
        }
        ArrayList<VisualClassPathItem> newVCPIs = new ArrayList<VisualClassPathItem>();
        BrokenProjectSupport bps = (BrokenProjectSupport)this.earProject.getLookup().lookup(BrokenProjectSupport.class);
        for (AntArtifact art : artifactList) {
            VisualClassPathItem vcpi = VisualClassPathItem.createArtifact(art);
            vcpi.setRaw(JAR_CONTENT_ADDITIONAL);
            newVCPIs.add(vcpi);
            bps.watchAntArtifact(art);
        }
        List<VisualClassPathItem> vcpis = this.getJarContentAdditional();
        newVCPIs.addAll(vcpis);
        this.put(JAR_CONTENT_ADDITIONAL, newVCPIs);
        this.store();
    }

    Module[] getApplicationModules() {
        Module[] mods = null;
        try {
            Application app = DDProvider.getDefault().getDDRoot(this.earProject.getAppModule().getDeploymentDescriptor());
            mods = app.getModule();
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().log(ioe.getLocalizedMessage());
        }
        if (mods == null) {
            mods = new Module[]{};
        }
        return mods;
    }

    public String[] getWebUris() {
        Module[] mods = this.getApplicationModules();
        TreeSet<String> result = new TreeSet<String>();
        for (int i = 0; i < mods.length; ++i) {
            Web w = mods[i].getWeb();
            if (w == null) continue;
            result.add(w.getWebUri());
        }
        return result.toArray(new String[result.size()]);
    }

    public String[] getAppClientUris() {
        Module[] mods = this.getApplicationModules();
        TreeSet<String> result = new TreeSet<String>();
        for (int i = 0; i < mods.length; ++i) {
            if (mods[i].getJava() == null) continue;
            String jarName = mods[i].getJava();
            String name = jarName.endsWith(".jar") ? jarName.substring(0, jarName.length() - 4) : jarName;
            result.add(name);
        }
        return result.toArray(new String[result.size()]);
    }

    boolean isWebUri(String uri) {
        return uri != null && Arrays.binarySearch(this.getWebUris(), uri) >= 0;
    }

    boolean isAppClientUri(String uri) {
        return Arrays.binarySearch(this.getAppClientUris(), uri) >= 0;
    }

    static String getAntPropertyName(String property) {
        if (property != null && property.startsWith("${") && property.endsWith("}")) {
            return property.substring(2, property.length() - 1);
        }
        return property;
    }

    static boolean isAntProperty(String string) {
        return string != null && string.startsWith("${") && string.endsWith("}");
    }

    public void put(String propertyName, Object value) {
        assert (propertyName != null) : "Unknown property " + propertyName;
        PropertyInfo pi = this.properties.get(propertyName);
        pi.setValue(value);
        if (J2EE_SERVER_INSTANCE.equals(propertyName)) {
            this.put(J2EE_SERVER_TYPE, Deployment.getDefault().getServerID((String)value));
        }
    }

    public Object get(String propertyName) {
        assert (propertyName != null) : "Unknown property " + propertyName;
        PropertyInfo pi = this.properties.get(propertyName);
        return pi == null ? null : pi.getValue();
    }

    public boolean isModified(String propertyName) {
        PropertyInfo pi = this.properties.get(propertyName);
        assert (propertyName != null) : "Unknown property " + propertyName;
        return pi.isModified();
    }

    public List getSortedSubprojectsList() {
        ArrayList<Project> subprojects = new ArrayList<Project>();
        this.addSubprojects(this.earProject, subprojects);
        String[] displayNames = new String[subprojects.size()];
        for (int i = 0; i < subprojects.size(); ++i) {
            displayNames[i] = ProjectUtils.getInformation((Project)((Project)subprojects.get(i))).getDisplayName();
        }
        Arrays.sort(displayNames, Collator.getInstance());
        return Arrays.asList(displayNames);
    }

    public EarProject getProject() {
        return this.earProject;
    }

    private void addSubprojects(Project project, List<Project> result) {
        SubprojectProvider spp = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (spp == null) {
            return;
        }
        for (Project sp : spp.getSubprojects()) {
            if (ProjectUtils.hasSubprojectCycles((Project)project, (Project)sp)) {
                ErrorManager.getDefault().log(16, "There would be cyclic dependencies if the " + sp + " would be added. Skipping...");
                continue;
            }
            if (!result.contains(sp)) {
                result.add(sp);
            }
            this.addSubprojects(sp, result);
        }
    }

    private void read() {
        HashMap<String, EditableProperties> eProps = new HashMap<String, EditableProperties>(2);
        eProps.put(PROJECT, this.updateHelper.getProperties(PROJECT));
        eProps.put(PRIVATE, this.updateHelper.getProperties(PRIVATE));
        for (int i = 0; i < this.PROPERTY_DESCRIPTORS.length; ++i) {
            PropertyDescriptor pd = this.PROPERTY_DESCRIPTORS[i];
            String propertyName = pd.name;
            if (pd.dest == null) {
                if (!WEB_PROJECT_NAME.equals(propertyName)) continue;
                String projectName = ProjectUtils.getInformation((Project)this.earProject).getDisplayName();
                PropertyInfo pi = this.properties.get(propertyName);
                if (null == pi) {
                    this.properties.put(propertyName, new PropertyInfo(pd, projectName, projectName));
                    continue;
                }
                pi.update(pd, projectName, projectName);
                continue;
            }
            String raw = ((EditableProperties)eProps.get(pd.dest)).getProperty(propertyName);
            String eval = this.antProjectHelper.getStandardPropertyEvaluator().getProperty(propertyName);
            PropertyInfo pi = this.properties.get(propertyName);
            if (null == pi) {
                PropertyInfo propertyInfo = new PropertyInfo(pd, raw, eval);
                this.properties.put(propertyName, propertyInfo);
                continue;
            }
            pi.update(pd, raw, eval);
        }
    }

    void initProperty(String propertyName, PropertyInfo propertyInfo) {
        this.properties.put(propertyName, propertyInfo);
    }

    public void store() {
        try {
            Boolean result = (Boolean)ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                public Object run() throws IOException {
                    URL buildImplXSL = EarProject.class.getResource("resources/build-impl.xsl");
                    int state = EarProjectProperties.this.genFilesHelper.getBuildScriptState("nbproject/build-impl.xml", buildImplXSL);
                    if ((state & 4) == 4) {
                        if (EarProjectProperties.showModifiedMessage(NbBundle.getMessage(EarProjectProperties.class, (String)"TXT_ModifiedTitle"))) {
                            FileObject fo = EarProjectProperties.this.updateHelper.getAntProjectHelper().getProjectDirectory().getFileObject("nbproject/build-impl.xml");
                            if (fo != null) {
                                fo.delete();
                                EarProjectProperties.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", buildImplXSL, false);
                            }
                        } else {
                            return false;
                        }
                    }
                    EarProjectProperties.this.storeProperties();
                    return true;
                }
            });
            if (result.booleanValue()) {
                ProjectManager.getDefault().saveProject((Project)this.earProject);
            }
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)((IOException)e.getException()));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private void storeProperties() {
        PropertyDescriptor pd;
        this.resolveProjectDependencies();
        Boolean defaultPlatform = null;
        for (PropertyInfo pi : this.properties.values()) {
            PropertyDescriptor pd2 = pi.getPropertyDescriptor();
            pi.encode();
            String newValueEncoded = pi.getNewValueEncoded();
            if (pd2.saver != null) {
                pd2.saver.save(pi);
            }
            if (pd2.dest == null && newValueEncoded != null && WEB_PROJECT_NAME.equals(pd2.name)) assert (false) : "No support yet for changing name of J2SEProject; cf. J2SEProject.setName";
            if (!JAVA_PLATFORM.equals(pd2.name) || newValueEncoded == null) continue;
            defaultPlatform = pi.getNewValueEncoded().equals(JavaPlatformManager.getDefault().getDefaultPlatform().getProperties().get("platform.ant.name"));
            this.setPlatform(defaultPlatform, pi.getNewValueEncoded());
        }
        HashMap<String, EditableProperties> eProps = new HashMap<String, EditableProperties>(2);
        eProps.put(PROJECT, this.updateHelper.getProperties(PROJECT));
        eProps.put(PRIVATE, this.updateHelper.getProperties(PRIVATE));
        for (PropertyInfo pi : this.properties.values()) {
            Object piValue;
            pd = pi.getPropertyDescriptor();
            if (!JAR_CONTENT_ADDITIONAL.equals(pd.name) || (piValue = pi.newValue != null ? pi.newValue : pd.parser.decode(pi.evaluatedValue, this.antProjectHelper, this.refHelper)) == null) continue;
            Iterator<VisualClassPathItem> newItems = ((List)piValue).iterator();
            Iterator<VisualClassPathItem> oldItems = ((List)pi.value).iterator();
            EarProjectProperties.storeLibrariesLocations(newItems, oldItems, (EditableProperties)eProps.get(PRIVATE));
            break;
        }
        for (PropertyInfo pi : this.properties.values()) {
            pd = pi.getPropertyDescriptor();
            String newValueEncoded = pi.getNewValueEncoded();
            if (newValueEncoded == null || pd.dest == null) continue;
            EditableProperties ep = (EditableProperties)eProps.get(pd.dest);
            if (pd.parser instanceof PathParser) {
                String[] items = PropertyUtils.tokenizePath((String)newValueEncoded);
                int i = 0;
                while (i < items.length - 1) {
                    int n = i++;
                    items[n] = items[n] + File.pathSeparatorChar;
                }
                ep.setProperty(pd.name, items);
                continue;
            }
            if (NO_DEPENDENCIES.equals(pd.name) && newValueEncoded.equals("false")) {
                ep.remove((Object)pd.name);
                continue;
            }
            if (CLIENT_MODULE_URI.equals(pd.name)) {
                if (this.isWebUri(newValueEncoded)) {
                    ep.setProperty(CLIENT_MODULE_URI, newValueEncoded);
                    ep.remove((Object)APPLICATION_CLIENT);
                    continue;
                }
                if (this.isAppClientUri(newValueEncoded)) {
                    ep.setProperty(APPLICATION_CLIENT, newValueEncoded);
                    ep.setProperty(CLIENT_MODULE_URI, this.getClientModuleUriForAppClient());
                    continue;
                }
                ep.remove((Object)APPLICATION_CLIENT);
                ep.remove((Object)CLIENT_MODULE_URI);
                continue;
            }
            if (JAVA_PLATFORM.equals(pd.name)) {
                assert (defaultPlatform != null);
                this.updateSourceLevel(defaultPlatform, newValueEncoded, ep);
            } else if (JAVAC_CLASSPATH.equals(pd.name)) {
                this.writeWebLibraries(this.refHelper, (List)pi.getValue(), TAG_WEB_MODULE_LIBRARIES);
            } else if (JAR_CONTENT_ADDITIONAL.equals(pd.name)) {
                this.writeWebLibraries(this.refHelper, (List)pi.getValue(), TAG_WEB_MODULE__ADDITIONAL_LIBRARIES);
            } else if (J2EE_SERVER_INSTANCE.equals(pd.name)) {
                String serverInstanceID = (String)pi.getValue();
                File projectFolder = FileUtil.toFile((FileObject)this.earProject.getProjectDirectory());
                try {
                    AntDeploymentHelper.writeDeploymentScript((File)new File(projectFolder, ANT_DEPLOY_BUILD_SCRIPT), (Object)J2eeModule.EAR, (String)serverInstanceID);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
                File deployAntPropsFile = AntDeploymentHelper.getDeploymentPropertiesFile((String)serverInstanceID);
                if (deployAntPropsFile == null) {
                    ep.remove((Object)DEPLOY_ANT_PROPS_FILE);
                } else {
                    ep.setProperty(DEPLOY_ANT_PROPS_FILE, deployAntPropsFile.getAbsolutePath());
                }
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID);
                EarProjectProperties.setACProperties(j2eePlatform, (EditableProperties)eProps.get(PROJECT));
                EarProjectProperties.setACPrivateProperties(j2eePlatform, serverInstanceID, (EditableProperties)eProps.get(PRIVATE));
            }
            ep.setProperty(pd.name, newValueEncoded);
        }
        this.updateHelper.putProperties(PROJECT, (EditableProperties)eProps.get(PROJECT));
        this.updateHelper.putProperties(PRIVATE, (EditableProperties)eProps.get(PRIVATE));
    }

    String getClientModuleUriForAppClient() {
        PropertyInfo earNamePI = this.properties.get(JAR_NAME);
        assert (earNamePI != null);
        String earName = (String)earNamePI.getValue();
        assert (earName != null);
        if (earName.endsWith(".ear")) {
            earName = earName.substring(0, earName.length() - 4);
        }
        return earName + "/${" + APPLICATION_CLIENT + '}';
    }

    public static void setACProperties(J2eePlatform j2eePlatform, EditableProperties ep) {
        String mainClassArgs = j2eePlatform.getToolProperty("appClientRuntime", "main.class.args");
        if (mainClassArgs != null && !mainClassArgs.equals("")) {
            ep.put((Object)APPCLIENT_MAINCLASS_ARGS, (Object)mainClassArgs);
            ep.remove((Object)CLIENT_NAME);
        } else {
            mainClassArgs = j2eePlatform.getToolProperty("appClientRuntime", CLIENT_NAME);
            if (mainClassArgs != null) {
                ep.put((Object)CLIENT_NAME, (Object)mainClassArgs);
                ep.remove((Object)APPCLIENT_MAINCLASS_ARGS);
            } else {
                ep.remove((Object)APPCLIENT_MAINCLASS_ARGS);
                ep.remove((Object)CLIENT_NAME);
            }
        }
    }

    private void setAndSaveACPrivateProperties(final String servInstIDs, final J2eePlatform platform) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                try {
                    EditableProperties priv = EarProjectProperties.this.updateHelper.getProperties(EarProjectProperties.PRIVATE);
                    EarProjectProperties.setACPrivateProperties(platform, servInstIDs, priv);
                    EarProjectProperties.this.updateHelper.putProperties(EarProjectProperties.PRIVATE, priv);
                    ProjectManager.getDefault().saveProject((Project)EarProjectProperties.this.earProject);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    public static void setACPrivateProperties(J2eePlatform j2eePlatform, String serverInstanceID, EditableProperties ep) {
        String args;
        String jvmOpts;
        if (!j2eePlatform.getSupportedModuleTypes().contains(J2eeModule.CLIENT)) {
            return;
        }
        File[] accrt = j2eePlatform.getToolClasspathEntries("appClientRuntime");
        ep.setProperty(APPCLIENT_TOOL_RUNTIME, EarProjectGenerator.toClasspathString(accrt));
        String mainClass = j2eePlatform.getToolProperty("appClientRuntime", APPCLIENT_MAIN_CLASS);
        if (mainClass != null) {
            ep.setProperty(APPCLIENT_TOOL_MAINCLASS, mainClass);
        }
        if ((jvmOpts = j2eePlatform.getToolProperty("appClientRuntime", "jvm.opts")) != null) {
            ep.setProperty(APPCLIENT_TOOL_JVMOPTS, jvmOpts);
        }
        if ((args = j2eePlatform.getToolProperty("appClientRuntime", J2EE_PLATFORM_APPCLIENT_ARGS)) != null) {
            ep.setProperty(APPCLIENT_TOOL_ARGS, args);
        }
        String classpath = EarProjectGenerator.toClasspathString(j2eePlatform.getClasspathEntries());
        ep.setProperty("j2ee.platform.classpath", classpath);
        File asRoot = j2eePlatform.getPlatformRoots()[0];
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)serverInstanceID);
        if (ip != null && new File(asRoot, "lib/admin-cli.jar").exists()) {
            File exFile = new File(asRoot, "lib/javaee.jar");
            if (exFile.exists()) {
                ep.setProperty(APPCLIENT_WA_COPY_CLIENT_JAR_FROM, new File(ip.getProperty("LOCATION"), ip.getProperty("DOMAIN") + "/generated/xml/j2ee-apps").getAbsolutePath());
            } else {
                ep.setProperty(APPCLIENT_WA_COPY_CLIENT_JAR_FROM, new File(ip.getProperty("LOCATION"), ip.getProperty("DOMAIN") + "/applications/j2ee-apps").getAbsolutePath());
            }
        } else {
            ep.remove((Object)APPCLIENT_WA_COPY_CLIENT_JAR_FROM);
        }
    }

    private void updateSourceLevel(boolean defaultPlatform, String platform, EditableProperties ep) {
        if (defaultPlatform) {
            ep.setProperty(JAVAC_SOURCE, "${default.javac.source}");
            ep.setProperty(JAVAC_TARGET, "${default.javac.target}");
        } else {
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                Specification spec = platforms[i].getSpecification();
                if (!"j2se".equalsIgnoreCase(spec.getName()) || !platform.equals(platforms[i].getProperties().get("platform.ant.name"))) continue;
                String ver = platforms[i].getSpecification().getVersion().toString();
                ep.setProperty(JAVAC_SOURCE, ver);
                ep.setProperty(JAVAC_TARGET, ver);
                return;
            }
        }
    }

    private void setPlatform(boolean isDefault, String platformAntID) {
        Element pcd = this.updateHelper.getPrimaryConfigurationData(true);
        NodeList sps = pcd.getElementsByTagName("explicit-platform");
        if (isDefault && sps.getLength() > 0) {
            pcd.removeChild(sps.item(0));
        } else if (!isDefault) {
            Element el;
            if (sps.getLength() == 0) {
                el = pcd.getOwnerDocument().createElement("explicit-platform");
                pcd.appendChild(el);
            } else {
                el = (Element)sps.item(0);
            }
            boolean explicitSource = true;
            JavaPlatform platform = EarProjectProperties.findPlatform(platformAntID);
            if (platform != null && platform.getSpecification().getVersion().compareTo((Object)this.JDKSpec13) <= 0 || platform == null) {
                explicitSource = false;
            }
            el.setAttribute("explicit-source-supported", explicitSource ? "true" : "false");
        }
        this.updateHelper.putPrimaryConfigurationData(pcd, true);
    }

    public void ensurePlatformIsSet(boolean showAlert) throws IOException {
        final String servInstID = (String)this.get(J2EE_SERVER_INSTANCE);
        J2eePlatform platform = Deployment.getDefault().getJ2eePlatform(servInstID);
        if (platform == null) {
            String[] servInstIDs;
            String serverType = (String)this.get(J2EE_SERVER_TYPE);
            if (serverType != null && (servInstIDs = Deployment.getDefault().getInstancesOfServer(serverType)).length > 0) {
                EarProjectProperties.setServerInstance(this.earProject, this.earProject.getUpdateHelper(), servInstIDs[0]);
                platform = Deployment.getDefault().getJ2eePlatform(servInstIDs[0]);
                if (platform != null) {
                    this.setAndSaveACPrivateProperties(servInstIDs[0], platform);
                }
            }
            if (showAlert && platform == null) {
                BrokenServerSupport.showAlert();
            }
        } else {
            ProjectManager.mutex().writeAccess(new Runnable(){

                public void run() {
                    EditableProperties privateProps = EarProjectProperties.this.updateHelper.getProperties(EarProjectProperties.PRIVATE);
                    boolean changed = EarProjectProperties.generateAntDeploymentSupport(privateProps, EarProjectProperties.this.earProject.getProjectDirectory(), servInstID, false);
                    if (changed) {
                        EarProjectProperties.this.updateHelper.putProperties(EarProjectProperties.PRIVATE, privateProps);
                        try {
                            ProjectManager.getDefault().saveProject((Project)EarProjectProperties.this.earProject);
                        }
                        catch (IOException e) {
                            ErrorManager.getDefault().notify((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    private static boolean generateAntDeploymentSupport(EditableProperties privateProps, FileObject projectDirectory, String serverInstanceID, boolean force) {
        try {
            File projectDir = FileUtil.toFile((FileObject)projectDirectory);
            File antDeploymentScript = new File(projectDir, ANT_DEPLOY_BUILD_SCRIPT);
            if (force || !antDeploymentScript.exists()) {
                AntDeploymentHelper.writeDeploymentScript((File)antDeploymentScript, (Object)J2eeModule.EAR, (String)serverInstanceID);
            }
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify(1, (Throwable)ioe);
        }
        File deployAntPropsFile = AntDeploymentHelper.getDeploymentPropertiesFile((String)serverInstanceID);
        String newDeployAntPropsFilePath = deployAntPropsFile == null ? null : deployAntPropsFile.getAbsolutePath();
        String oldDeployAntPropsFilePath = privateProps.getProperty(DEPLOY_ANT_PROPS_FILE);
        if (oldDeployAntPropsFilePath != null && newDeployAntPropsFilePath == null) {
            privateProps.remove((Object)DEPLOY_ANT_PROPS_FILE);
        } else if (newDeployAntPropsFilePath != null && !newDeployAntPropsFilePath.equals(oldDeployAntPropsFilePath)) {
            privateProps.setProperty(DEPLOY_ANT_PROPS_FILE, newDeployAntPropsFilePath);
        } else {
            return false;
        }
        return true;
    }

    public static void setServerInstance(final Project project, final UpdateHelper helper, final String serverInstanceID) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                try {
                    EditableProperties projectProps = helper.getProperties(EarProjectProperties.PROJECT);
                    EditableProperties privateProps = helper.getProperties(EarProjectProperties.PRIVATE);
                    projectProps.setProperty(EarProjectProperties.J2EE_SERVER_TYPE, Deployment.getDefault().getServerID(serverInstanceID));
                    privateProps.setProperty(EarProjectProperties.J2EE_SERVER_INSTANCE, serverInstanceID);
                    EarProjectProperties.generateAntDeploymentSupport(privateProps, project.getProjectDirectory(), serverInstanceID, true);
                    helper.putProperties(EarProjectProperties.PROJECT, projectProps);
                    helper.putProperties(EarProjectProperties.PRIVATE, privateProps);
                    ProjectManager.getDefault().saveProject(project);
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
    }

    private void resolveProjectDependencies() {
        String[] allPaths = new String[]{JAVAC_CLASSPATH, JAR_CONTENT_ADDITIONAL, RUN_CLASSPATH};
        HashSet oldArtifacts = new HashSet();
        HashSet newArtifacts = new HashSet();
        for (int i = 0; i < allPaths.length; ++i) {
            List newList;
            PropertyInfo pi = this.properties.get(allPaths[i]);
            List oldList = (List)pi.getOldValue();
            if (oldList != null) {
                oldArtifacts.addAll(oldList);
            }
            if ((newList = (List)pi.getValue()) == null) continue;
            newArtifacts.addAll(newList);
        }
        HashSet removed = new HashSet(oldArtifacts);
        removed.removeAll(newArtifacts);
        HashSet added = new HashSet(newArtifacts);
        added.removeAll(oldArtifacts);
        HashSet<VisualClassPathItem> oldContent = new HashSet<VisualClassPathItem>((List)this.properties.get(JAR_CONTENT_ADDITIONAL).getOldValue());
        HashSet<VisualClassPathItem> newContent = new HashSet<VisualClassPathItem>((List)this.properties.get(JAR_CONTENT_ADDITIONAL).getValue());
        this.updateContentDependency(oldContent, newContent);
        for (VisualClassPathItem vcpi : removed) {
            PropertyInfo pi;
            List values;
            if (vcpi.getType() != VisualClassPathItem.Type.ARTIFACT && vcpi.getType() != VisualClassPathItem.Type.JAR) continue;
            boolean used = false;
            block2: for (int i = 0; i < allPaths.length && (values = (List)(pi = this.properties.get(allPaths[i])).getValue()) != null; ++i) {
                for (VisualClassPathItem valcpi : values) {
                    if (valcpi.getRaw().indexOf(vcpi.getRaw()) <= -1) continue;
                    used = true;
                    continue block2;
                }
            }
            if (used) continue;
            this.refHelper.destroyReference(vcpi.getRaw());
        }
        EditableProperties ep = this.updateHelper.getProperties(PROJECT);
        boolean changed = false;
        for (VisualClassPathItem vcpi : removed) {
            if (vcpi.getType() != VisualClassPathItem.Type.LIBRARY) continue;
            String prop = vcpi.getRaw();
            prop = prop.substring(2, prop.length() - 1);
            ep.remove((Object)prop);
            changed = true;
        }
        File projDir = FileUtil.toFile((FileObject)this.antProjectHelper.getProjectDirectory());
        for (VisualClassPathItem vcpi : added) {
            if (vcpi.getType() != VisualClassPathItem.Type.LIBRARY) continue;
            String prop = vcpi.getRaw();
            String value = this.relativizeLibraryClasspath(prop = prop.substring(2, prop.length() - 1), projDir);
            if (value == null) continue;
            ep.setProperty(prop, value);
            ep.setComment(prop, new String[]{"# Property " + prop + " is set here just to make sharing of project simpler.", "# The library definition has always preference over this property."}, false);
            changed = true;
        }
        if (changed) {
            this.updateHelper.putProperties(PROJECT, ep);
        }
    }

    private String relativizeLibraryClasspath(String property, File projectDir) {
        String value = PropertyUtils.getGlobalProperties().getProperty(property);
        if (value == null) {
            return null;
        }
        String[] paths = PropertyUtils.tokenizePath((String)value);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            File f = this.antProjectHelper.resolveFile(paths[i]);
            if (!CollocationQuery.areCollocated((File)f, (File)projectDir)) {
                return null;
            }
            sb.append(PropertyUtils.relativizeFile((File)projectDir, (File)f));
            if (i + 1 >= paths.length) continue;
            sb.append(File.pathSeparatorChar);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    private static String findText(Node parent) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    private static JavaPlatform findPlatform(String platformAntID) {
        JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
        for (int i = 0; i < platforms.length; ++i) {
            String normalizedName = (String)platforms[i].getProperties().get("platform.ant.name");
            if (normalizedName == null || !normalizedName.equals(platformAntID)) continue;
            return platforms[i];
        }
        return null;
    }

    private void writeWebLibraries(ReferenceHelper refHelper, List value, String elementName) {
        Element data = this.updateHelper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element webModuleLibs = (Element)data.getElementsByTagNameNS(this.abpt.getPrimaryConfigurationDataElementNamespace(true), elementName).item(0);
        if (webModuleLibs == null) {
            webModuleLibs = doc.createElementNS(this.abpt.getPrimaryConfigurationDataElementNamespace(true), elementName);
            data.appendChild(webModuleLibs);
        }
        while (webModuleLibs.hasChildNodes()) {
            webModuleLibs.removeChild(webModuleLibs.getChildNodes().item(0));
        }
        for (VisualClassPathItem vcpi : value) {
            String library_tag_value = "";
            if (vcpi == null) {
                return;
            }
            switch (vcpi.getType()) {
                case JAR: {
                    String reference;
                    String raw = vcpi.getRaw();
                    if (raw == null) {
                        File file = (File)vcpi.getObject();
                        library_tag_value = reference = refHelper.createForeignFileReference(file, "jar");
                        break;
                    }
                    library_tag_value = raw;
                    break;
                }
                case LIBRARY: {
                    library_tag_value = vcpi.getRaw();
                    break;
                }
                case ARTIFACT: {
                    String reference;
                    AntArtifact aa = (AntArtifact)vcpi.getObject();
                    library_tag_value = reference = refHelper.addReference(aa, aa.getArtifactLocations()[0]);
                    break;
                }
                case CLASSPATH: {
                    library_tag_value = vcpi.getRaw();
                    break;
                }
                default: {
                    assert (false) : "Unknown VisualClassPathItem type: " + (Object)((Object)vcpi.getType());
                    break;
                }
            }
            Element library = doc.createElementNS(this.abpt.getPrimaryConfigurationDataElementNamespace(true), "library");
            webModuleLibs.appendChild(library);
            Element webFile = doc.createElementNS(this.abpt.getPrimaryConfigurationDataElementNamespace(true), "file");
            library.appendChild(webFile);
            webFile.appendChild(doc.createTextNode(library_tag_value));
            String piw = vcpi.getPathInEAR();
            if (piw == VisualClassPathItem.PATH_IN_EAR_NONE) continue;
            Element pathInEar = doc.createElementNS(this.abpt.getPrimaryConfigurationDataElementNamespace(true), "path-in-war");
            pathInEar.appendChild(doc.createTextNode(vcpi.getPathInEAR()));
            library.appendChild(pathInEar);
        }
        this.updateHelper.putPrimaryConfigurationData(data, true);
    }

    public static void storeLibrariesLocations(Iterator<VisualClassPathItem> classpath, Iterator<VisualClassPathItem> oldClasspath, EditableProperties privateProps) {
        ArrayList<String> exLibs = new ArrayList<String>();
        for (String key : privateProps.keySet()) {
            if (!key.endsWith(".libdirs") && !key.endsWith(".libfiles") && key.indexOf(".libdir.") <= 0 && key.indexOf(".libfile.") <= 0) continue;
            exLibs.add(key);
        }
        while (classpath.hasNext()) {
            String key;
            File f;
            int i;
            VisualClassPathItem item = classpath.next();
            if (item.getObject() == null) continue;
            ArrayList<File> files = new ArrayList<File>();
            ArrayList<File> dirs = new ArrayList<File>();
            EarProjectProperties.getFilesForItem(item, files, dirs);
            String ref = item.getRaw();
            if (files.size() > 1 || files.size() > 0 && dirs.size() > 0) {
                for (i = 0; i < files.size(); ++i) {
                    f = (File)files.get(i);
                    key = EarProjectProperties.getAntPropertyName(ref) + ".libfile." + (i + 1);
                    privateProps.setProperty(key, "" + f.getAbsolutePath());
                    exLibs.remove(key);
                }
            }
            if (dirs.size() <= 1 && (files.size() <= 0 || dirs.size() <= 0)) continue;
            for (i = 0; i < dirs.size(); ++i) {
                f = (File)dirs.get(i);
                key = EarProjectProperties.getAntPropertyName(ref) + ".libdir." + (i + 1);
                privateProps.setProperty(key, "" + f.getAbsolutePath());
                exLibs.remove(key);
            }
        }
        Iterator unused = exLibs.iterator();
        while (unused.hasNext()) {
            privateProps.remove(unused.next());
        }
    }

    public static final void getFilesForItem(VisualClassPathItem item, List<File> files, List<File> dirs) {
        AntArtifact artifact;
        File root;
        if (item.getType() == VisualClassPathItem.Type.LIBRARY) {
            List roots = ((Library)item.getObject()).getContent("classpath");
            for (URL rootUrl : roots) {
                File f;
                FileObject root2 = URLMapper.findFileObject((URL)rootUrl);
                if ("jar".equals(rootUrl.getProtocol())) {
                    root2 = FileUtil.getArchiveFile((FileObject)root2);
                }
                if ((f = FileUtil.toFile((FileObject)root2)) == null) continue;
                if (f.isFile()) {
                    files.add(f);
                    continue;
                }
                dirs.add(f);
            }
        }
        if (item.getType() == VisualClassPathItem.Type.JAR && (root = (File)item.getObject()) != null) {
            if (root.isFile()) {
                files.add(root);
            } else {
                dirs.add(root);
            }
        }
        if (item.getType() == VisualClassPathItem.Type.ARTIFACT && (artifact = (AntArtifact)item.getObject()) != null) {
            String artifactFolder = artifact.getScriptLocation().getParent();
            URI[] roots = artifact.getArtifactLocations();
            for (int i = 0; i < roots.length; ++i) {
                String root3 = artifactFolder + File.separator + roots[i];
                if (root3.endsWith(File.separator)) {
                    dirs.add(new File(root3));
                    continue;
                }
                files.add(new File(root3));
            }
        }
    }

    private static boolean showModifiedMessage(String title) {
        String message = NbBundle.getMessage(EarProjectProperties.class, (String)"TXT_Regenerate");
        JButton regenerateButton = new JButton(NbBundle.getMessage(EarProjectProperties.class, (String)"CTL_RegenerateButton"));
        regenerateButton.setDefaultCapable(true);
        regenerateButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EarProjectProperties.class, (String)"AD_RegenerateButton"));
        NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)message, 2);
        d.setTitle(title);
        d.setOptionType(2);
        d.setOptions(new Object[]{regenerateButton, NotifyDescriptor.CANCEL_OPTION});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == regenerateButton;
    }

    private static class PlatformParser
    extends PropertyParser {
        private PlatformParser() {
        }

        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            JavaPlatform platform = EarProjectProperties.findPlatform(raw);
            if (platform != null) {
                return platform.getDisplayName();
            }
            return raw;
        }

        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms((String)value, new Specification("j2se", null));
            if (platforms.length == 0) {
                return (String)value;
            }
            return (String)platforms[0].getProperties().get("platform.ant.name");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PathParser
    extends PropertyParser {
        private final String webLibraryElementName;
        private static final String TAG_PATH_IN_EAR = "path-in-war";
        private static final String TAG_FILE = "file";
        private static final String TAG_LIBRARY = "library";

        public PathParser() {
            this(null);
        }

        public PathParser(String webLibraryElementName) {
            this.webLibraryElementName = webLibraryElementName;
        }

        @Override
        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            Map<String, String> earIncludesMap = this.createEarIncludesMap();
            if (raw != null) {
                String[] pe = PropertyUtils.tokenizePath((String)raw);
                for (int i = 0; i < pe.length; ++i) {
                    String pathItem = pe[i];
                    if (earIncludesMap.containsKey(pathItem)) continue;
                    earIncludesMap.put(pathItem, "/");
                }
            }
            ArrayList<VisualClassPathItem> cpItems = new ArrayList<VisualClassPathItem>(earIncludesMap.size());
            for (Map.Entry<String, String> entry : earIncludesMap.entrySet()) {
                cpItems.add(this.createVisualClassPathItem(antProjectHelper, refHelper, entry.getKey(), entry.getValue()));
            }
            return cpItems;
        }

        @Override
        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            Element data = null;
            Element webModuleLibs = null;
            Document doc = null;
            if (this.webLibraryElementName != null) {
                String ns = EarProjectProperties.this.abpt.getPrimaryConfigurationDataElementNamespace(true);
                data = EarProjectProperties.this.updateHelper.getPrimaryConfigurationData(true);
                doc = data.getOwnerDocument();
                webModuleLibs = (Element)data.getElementsByTagNameNS(ns, this.webLibraryElementName).item(0);
                if (webModuleLibs == null) {
                    webModuleLibs = doc.createElementNS(ns, this.webLibraryElementName);
                    data.appendChild(webModuleLibs);
                }
                while (webModuleLibs.hasChildNodes()) {
                    webModuleLibs.removeChild(webModuleLibs.getChildNodes().item(0));
                }
            }
            StringBuffer sb = new StringBuffer();
            Iterator it = ((List)value).iterator();
            while (it.hasNext()) {
                VisualClassPathItem visualClassPathItem = (VisualClassPathItem)it.next();
                String pathItem = this.getPathItem(visualClassPathItem, refHelper);
                if (this.webLibraryElementName != null) {
                    webModuleLibs.appendChild(this.createLibraryElement(doc, pathItem, visualClassPathItem));
                }
                sb.append(pathItem);
                if (!it.hasNext()) continue;
                sb.append(File.pathSeparatorChar);
            }
            if (this.webLibraryElementName != null) {
                EarProjectProperties.this.updateHelper.putPrimaryConfigurationData(data, true);
            }
            return sb.toString();
        }

        private Element createLibraryElement(Document doc, String pathItem, VisualClassPathItem visualClassPathItem) {
            String ns = EarProjectProperties.this.abpt.getPrimaryConfigurationDataElementNamespace(true);
            Element libraryElement = doc.createElementNS(ns, TAG_LIBRARY);
            ArrayList<File> files = new ArrayList<File>();
            ArrayList<File> dirs = new ArrayList<File>();
            EarProjectProperties.getFilesForItem(visualClassPathItem, files, dirs);
            if (files.size() > 0) {
                libraryElement.setAttribute(EarProjectProperties.ATTR_FILES, "" + files.size());
            }
            if (dirs.size() > 0) {
                libraryElement.setAttribute(EarProjectProperties.ATTR_DIRS, "" + dirs.size());
            }
            Element webFile = doc.createElementNS(ns, TAG_FILE);
            libraryElement.appendChild(webFile);
            webFile.appendChild(doc.createTextNode(pathItem));
            if (visualClassPathItem.getPathInEAR() != VisualClassPathItem.PATH_IN_EAR_NONE) {
                Element pathInEar = doc.createElementNS(ns, TAG_PATH_IN_EAR);
                pathInEar.appendChild(doc.createTextNode(visualClassPathItem.getPathInEAR()));
                libraryElement.appendChild(pathInEar);
            }
            return libraryElement;
        }

        private Map<String, String> createEarIncludesMap() {
            String ns;
            Element data;
            Element webModuleLibs;
            LinkedHashMap<String, String> earIncludesMap = new LinkedHashMap<String, String>();
            if (this.webLibraryElementName != null && (webModuleLibs = (Element)(data = EarProjectProperties.this.updateHelper.getPrimaryConfigurationData(true)).getElementsByTagNameNS(ns = EarProjectProperties.this.abpt.getPrimaryConfigurationDataElementNamespace(true), this.webLibraryElementName).item(0)) != null) {
                NodeList ch = webModuleLibs.getChildNodes();
                for (int i = 0; i < ch.getLength(); ++i) {
                    if (ch.item(i).getNodeType() != 1) continue;
                    Element library = (Element)ch.item(i);
                    Node webFile = library.getElementsByTagNameNS(ns, TAG_FILE).item(0);
                    NodeList pathInEarElements = library.getElementsByTagNameNS(ns, TAG_PATH_IN_EAR);
                    earIncludesMap.put(EarProjectProperties.findText(webFile), pathInEarElements.getLength() > 0 ? EarProjectProperties.findText(pathInEarElements.item(0)) : VisualClassPathItem.PATH_IN_EAR_NONE);
                }
            }
            return earIncludesMap;
        }

        private VisualClassPathItem createVisualClassPathItem(AntProjectHelper antProjectHelper, ReferenceHelper refHelper, String raw, String pathInEAR) {
            for (int j = 0; j < WELL_KNOWN_PATHS.length; ++j) {
                String[] wellKnownPath = WELL_KNOWN_PATHS[j];
                if (!wellKnownPath[0].equals(EarProjectProperties.getAntPropertyName(raw))) continue;
                return new VisualClassPathItem(raw, VisualClassPathItem.Type.CLASSPATH, raw, wellKnownPath[1], pathInEAR);
            }
            if (raw.startsWith(EarProjectProperties.LIBRARY_PREFIX)) {
                String eval = raw.substring(EarProjectProperties.LIBRARY_PREFIX.length(), raw.lastIndexOf(46));
                Library lib = LibraryManager.getDefault().getLibrary(eval);
                if (lib != null) {
                    return new VisualClassPathItem(lib, VisualClassPathItem.Type.LIBRARY, raw, eval, pathInEAR);
                }
                return new VisualClassPathItem(null, VisualClassPathItem.Type.LIBRARY, raw, null, pathInEAR);
            }
            if (raw.startsWith(EarProjectProperties.ANT_ARTIFACT_PREFIX)) {
                AntArtifact artifact = (AntArtifact)refHelper.findArtifactAndLocation(raw)[0];
                if (artifact != null) {
                    return VisualClassPathItem.createArtifact(artifact, raw, pathInEAR);
                }
                return VisualClassPathItem.createArtifact(null, raw, null, pathInEAR);
            }
            String eval = EarProjectProperties.isAntProperty(raw) ? antProjectHelper.getStandardPropertyEvaluator().getProperty(EarProjectProperties.getAntPropertyName(raw)) : raw;
            File f = eval == null ? null : antProjectHelper.resolveFile(eval);
            return VisualClassPathItem.createJAR(f, raw, pathInEAR, eval);
        }

        private String getPathItem(VisualClassPathItem vcpi, ReferenceHelper refHelper) {
            switch (vcpi.getType()) {
                case JAR: {
                    String pathItem = vcpi.getRaw();
                    if (pathItem == null) {
                        return refHelper.createForeignFileReference((File)vcpi.getObject(), "jar");
                    }
                    return pathItem;
                }
                case ARTIFACT: {
                    if (vcpi.getObject() != null) {
                        AntArtifact aa = (AntArtifact)vcpi.getObject();
                        return refHelper.addReference(aa, aa.getArtifactLocations()[0]);
                    }
                    return vcpi.getRaw();
                }
                case LIBRARY: 
                case CLASSPATH: {
                    return vcpi.getRaw();
                }
            }
            assert (false) : "Unknown VisualClassPathItem type: " + (Object)((Object)vcpi.getType());
            return null;
        }
    }

    private static class InverseBooleanParser
    extends BooleanParser {
        private InverseBooleanParser() {
        }

        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return (Boolean)super.decode(raw, antProjectHelper, refHelper) != false ? Boolean.FALSE : Boolean.TRUE;
        }

        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return super.encode((Boolean)value != false ? Boolean.FALSE : Boolean.TRUE, antProjectHelper, refHelper);
        }
    }

    private static class BooleanParser
    extends PropertyParser {
        private BooleanParser() {
        }

        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            String lowecaseRaw;
            if (raw != null && ((lowecaseRaw = raw.toLowerCase()).equals("true") || lowecaseRaw.equals("yes") || lowecaseRaw.equals("enabled"))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return (Boolean)value != false ? "true" : "false";
        }
    }

    private static class StringParser
    extends PropertyParser {
        private StringParser() {
        }

        public Object decode(String raw, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return raw;
        }

        public String encode(Object value, AntProjectHelper antProjectHelper, ReferenceHelper refHelper) {
            return (String)value;
        }
    }

    private static abstract class PropertyParser {
        private PropertyParser() {
        }

        public abstract Object decode(String var1, AntProjectHelper var2, ReferenceHelper var3);

        public abstract String encode(Object var1, AntProjectHelper var2, ReferenceHelper var3);
    }

    static class PropertyDescriptor {
        final PropertyParser parser;
        final String name;
        final String dest;
        final Saver saver;

        PropertyDescriptor(String name, String dest, PropertyParser parser, Saver saver) {
            this.name = name;
            this.dest = dest;
            this.saver = saver;
            this.parser = parser;
        }

        PropertyDescriptor(String name, String dest, PropertyParser parser) {
            this(name, dest, parser, null);
        }

        static interface Saver {
            public void save(PropertyInfo var1);
        }
    }

    private class PropertyInfo {
        private PropertyDescriptor propertyDesciptor;
        private Object value;
        private String evaluatedValue;
        private Object newValue;
        private String newValueEncoded;

        public PropertyInfo(PropertyDescriptor propertyDescriptor, String rawValue, String evaluatedValue) {
            this.update(propertyDescriptor, rawValue, evaluatedValue);
        }

        final void update(PropertyDescriptor propertyDescriptor, String rawValue, String evaluatedValue) {
            this.propertyDesciptor = propertyDescriptor;
            this.evaluatedValue = evaluatedValue;
            this.value = this.propertyDesciptor.parser.decode(rawValue, EarProjectProperties.this.antProjectHelper, EarProjectProperties.this.refHelper);
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.propertyDesciptor;
        }

        public void encode() {
            this.newValueEncoded = this.isModified() ? this.propertyDesciptor.parser.encode(this.newValue, EarProjectProperties.this.antProjectHelper, EarProjectProperties.this.refHelper) : null;
        }

        public Object getValue() {
            return this.isModified() ? this.newValue : this.value;
        }

        public void setValue(Object value) {
            this.newValue = value;
        }

        public String getNewValueEncoded() {
            return this.newValueEncoded;
        }

        public boolean isModified() {
            return this.newValue != null;
        }

        public Object getOldValue() {
            return this.value;
        }
    }
}

