/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.classpath;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PlatformClassPathProvider
implements ClassPathProvider {
    private FileObject lastUsedRoot;
    private JavaPlatform lastUsedPlatform;
    private ClassPath emptyCp;

    public ClassPath findClassPath(FileObject fo, String type) {
        JavaPlatform[] platforms;
        if (fo == null || type == null) {
            throw new IllegalArgumentException();
        }
        JavaPlatform lp = this.getLastUsedPlatform(fo);
        if (lp != null) {
            platforms = new JavaPlatform[]{lp};
        } else {
            JavaPlatformManager manager = JavaPlatformManager.getDefault();
            platforms = manager.getInstalledPlatforms();
        }
        for (int i = 0; i < platforms.length; ++i) {
            ClassPath bootClassPath = platforms[i].getBootstrapLibraries();
            ClassPath libraryPath = platforms[i].getStandardLibraries();
            ClassPath sourcePath = platforms[i].getSourceFolders();
            FileObject root = null;
            if ("classpath/source".equals(type) && sourcePath != null && (root = sourcePath.findOwnerRoot(fo)) != null) {
                this.setLastUsedPlatform(root, platforms[i]);
                return sourcePath;
            }
            if ("classpath/boot".equals(type) && (bootClassPath != null && (root = bootClassPath.findOwnerRoot(fo)) != null || sourcePath != null && (root = sourcePath.findOwnerRoot(fo)) != null || libraryPath != null && (root = libraryPath.findOwnerRoot(fo)) != null)) {
                this.setLastUsedPlatform(root, platforms[i]);
                return bootClassPath;
            }
            if (!"classpath/compile".equals(type)) continue;
            if (libraryPath != null && (root = libraryPath.findOwnerRoot(fo)) != null) {
                this.setLastUsedPlatform(root, platforms[i]);
                return libraryPath;
            }
            if ((bootClassPath == null || (root = bootClassPath.findOwnerRoot(fo)) == null) && (sourcePath == null || (root = sourcePath.findOwnerRoot(fo)) == null)) continue;
            return this.getEmptyClassPath();
        }
        return null;
    }

    private synchronized ClassPath getEmptyClassPath() {
        if (this.emptyCp == null) {
            this.emptyCp = ClassPathSupport.createClassPath((List)Collections.EMPTY_LIST);
        }
        return this.emptyCp;
    }

    private synchronized void setLastUsedPlatform(FileObject root, JavaPlatform platform) {
        this.lastUsedRoot = root;
        this.lastUsedPlatform = platform;
    }

    private synchronized JavaPlatform getLastUsedPlatform(FileObject file) {
        if (this.lastUsedRoot != null && FileUtil.isParentOf((FileObject)this.lastUsedRoot, (FileObject)file)) {
            return this.lastUsedPlatform;
        }
        return null;
    }
}

