/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.Format;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.IconBases;
import org.netbeans.modules.beans.ModePropertyEditor;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.PropertyTypeEditor;
import org.netbeans.modules.java.ui.nodes.SourceNodes;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Utilities;

public class PropertyPatternNode
extends PatternNode
implements IconBases {
    public PropertyPatternNode(PropertyPattern pattern, boolean writeable) {
        super(pattern, Children.LEAF, writeable);
        this.superSetName(pattern.getName());
    }

    protected String resolveIconBase() {
        switch (((PropertyPattern)this.pattern).getMode()) {
            case 1: {
                return "org/netbeans/modules/beans/resources/propertyRW";
            }
            case 2: {
                return "org/netbeans/modules/beans/resources/propertyRO";
            }
            case 4: {
                return "org/netbeans/modules/beans/resources/propertyWO";
            }
        }
        return null;
    }

    String getTypeForHint() {
        return PatternNode.getString("HINT_Property");
    }

    public String getShortDescription() {
        String mode;
        switch (((PropertyPattern)this.pattern).getMode()) {
            case 1: {
                mode = PatternNode.getString("HINT_ReadWriteProperty");
                break;
            }
            case 2: {
                mode = PatternNode.getString("HINT_ReadOnlyProperty");
                break;
            }
            case 4: {
                mode = PatternNode.getString("HINT_WriteOnlyProperty");
                break;
            }
            default: {
                mode = "";
            }
        }
        return mode + " " + this.getTypeForHint() + " : " + this.getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createNameProperty(this.writeable));
        ps.put(this.createTypeProperty(this.writeable));
        ps.put(this.createModeProperty(this.writeable));
        ps.put(this.createGetterProperty(false));
        ps.put(this.createSetterProperty(false));
        ps.put(this.createFieldProperty(false));
        return sheet;
    }

    public Node cloneNode() {
        return new PropertyPatternNode((PropertyPattern)this.pattern, this.writeable);
    }

    protected void setPatternName(String name) throws JmiException {
        if (this.pattern.getName().equals(name)) {
            return;
        }
        if (this.testNameValidity(name)) {
            ((PropertyPattern)this.pattern).setName(name);
        }
    }

    boolean testNameValidity(String name) {
        if (!Utilities.isJavaIdentifier((String)name)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)PatternNode.getString("MSG_Not_Valid_Identifier"), 0));
            return false;
        }
        return true;
    }

    protected Node.Property createTypeProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("type", Type.class, canW){

            public Object getValue() {
                return ((PropertyPattern)PropertyPatternNode.this.pattern).getType();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                try {
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                    ((PropertyPattern)PropertyPatternNode.this.pattern).setType((Type)val);
                }
                catch (JmiException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new PropertyTypeEditor();
            }
        };
    }

    void fire() {
        this.firePropertyChange(null, null, null);
    }

    protected Node.Property createModeProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("mode", Integer.TYPE, canW){

            public Object getValue() {
                return new Integer(((PropertyPattern)PropertyPatternNode.this.pattern).getMode());
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Integer)) {
                    throw new IllegalArgumentException();
                }
                PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                try {
                    ((PropertyPattern)PropertyPatternNode.this.pattern).setMode((Integer)val);
                }
                catch (JmiException e) {
                    throw new InvocationTargetException(e);
                }
                catch (GenerateBeanException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    PropertyPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                }
                PropertyPatternNode.this.setIconBase(PropertyPatternNode.this.resolveIconBase());
            }

            public PropertyEditor getPropertyEditor() {
                return new ModePropertyEditor();
            }
        };
    }

    protected Node.Property createGetterProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("getter", String.class, canW){

            public Object getValue() {
                Method method = ((PropertyPattern)PropertyPatternNode.this.pattern).getGetterMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }

    protected Node.Property createSetterProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("setter", String.class, canW){

            public Object getValue() {
                Method method = ((PropertyPattern)PropertyPatternNode.this.pattern).getSetterMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }

    protected Node.Property createFieldProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("estimatedField", String.class, canW){

            public Object getValue() {
                Format fmt = SourceNodes.createElementFormat((String)"{t} {n}");
                Field field = ((PropertyPattern)PropertyPatternNode.this.pattern).getEstimatedField();
                String name = null;
                try {
                    if (field != null) {
                        name = fmt.format(field);
                    }
                }
                catch (IllegalArgumentException e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
                return name != null ? name : PatternNode.getString("LAB_NoField");
            }
        };
    }
}

