/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.CompletionView;
import org.netbeans.editor.ext.ExtCompletionPane;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSettingsDefaults;
import org.netbeans.editor.ext.ExtUtilities;
import org.netbeans.editor.ext.JDCPopupPanel;

public class ScrollCompletionPane
extends JScrollPane
implements ExtCompletionPane,
PropertyChangeListener,
SettingsChangeListener {
    private ExtEditorUI extEditorUI;
    private JComponent view;
    private JLabel topLabel;
    private Dimension minSize;
    private Dimension maxSize;
    private ViewMouseListener viewMouseL;
    private Dimension scrollBarSize;
    private Dimension minSizeDefault;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScrollCompletionPane(ExtEditorUI extEditorUI) {
        this.extEditorUI = extEditorUI;
        Dimension smallSize = this.getPreferredSize();
        this.setHorizontalScrollBarPolicy(32);
        this.setVerticalScrollBarPolicy(22);
        this.scrollBarSize = this.getPreferredSize();
        this.scrollBarSize.width -= smallSize.width;
        this.scrollBarSize.height -= smallSize.height;
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        super.setVisible(false);
        this.installTitleComponent();
        CompletionView completionView = extEditorUI.getCompletion().getView();
        if (completionView instanceof JComponent) {
            this.view = (JComponent)((Object)completionView);
            this.setViewportView(this.view);
        }
        this.getViewport().setMinimumSize(new Dimension(4, 4));
        Settings.addSettingsChangeListener(this);
        this.viewMouseL = new ViewMouseListener();
        Object object = extEditorUI.getComponentLock();
        synchronized (object) {
            JTextComponent component = extEditorUI.getComponent();
            if (component != null) {
                this.propertyChange(new PropertyChangeEvent(extEditorUI, "component", null, component));
            }
            extEditorUI.addPropertyChangeListener(this);
        }
        this.putClientProperty("HelpID", ScrollCompletionPane.class.getName());
    }

    public void settingsChange(SettingsChangeEvent evt) {
        Class kitClass = Utilities.getKitClass(this.extEditorUI.getComponent());
        if (kitClass != null) {
            this.minSize = (Dimension)SettingsUtil.getValue(kitClass, "completion-pane-min-size", ExtSettingsDefaults.defaultCompletionPaneMinSize);
            this.minSizeDefault = new Dimension(this.minSize);
            this.setMinimumSize(this.minSize);
            this.maxSize = (Dimension)SettingsUtil.getValue(kitClass, "completion-pane-max-size", ExtSettingsDefaults.defaultCompletionPaneMaxSize);
            this.setMaximumSize(this.maxSize);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("component".equals(propName)) {
            if (evt.getNewValue() != null) {
                this.settingsChange(null);
                if (this.view != null) {
                    this.view.addMouseListener(this.viewMouseL);
                }
            } else if (this.view != null) {
                this.view.removeMouseListener(this.viewMouseL);
            }
        }
    }

    public void setVisible(boolean visible) {
        if (this.view instanceof JList) {
            JList listView = (JList)this.view;
            listView.ensureIndexIsVisible(listView.getSelectedIndex());
        }
        super.setVisible(visible);
    }

    public void refresh() {
        if (this.view instanceof JList) {
            JList listView = (JList)this.view;
            listView.ensureIndexIsVisible(listView.getSelectedIndex());
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ScrollCompletionPane.this.isShowing()) {
                    ScrollCompletionPane.this.revalidate();
                }
            }
        });
    }

    public void setTitle(String title) {
        this.topLabel.setText(title);
    }

    protected void installTitleComponent() {
        this.topLabel = new JLabel();
        this.topLabel.setForeground(Color.blue);
        this.topLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.setColumnHeaderView(this.topLabel);
    }

    protected Dimension getTitleComponentPreferredSize() {
        return this.topLabel.getPreferredSize();
    }

    public void setSize(int width, int height) {
        boolean displayHorizontalScrollbar;
        int maxWidth = width;
        int maxHeight = height;
        this.minSize.width = this.minSizeDefault.width;
        this.minSize.height = this.minSizeDefault.height;
        this.setMinimumSize(this.minSize);
        Dimension ps = this.getPreferredSize();
        ps.width += this.scrollBarSize.width;
        ps.width = Math.max(Math.max(ps.width, this.minSize.width), this.getTitleComponentPreferredSize().width);
        maxWidth = Math.min(maxWidth, this.maxSize.width);
        maxHeight = Math.min(maxHeight, this.maxSize.height);
        boolean bl = displayHorizontalScrollbar = ps.width - this.scrollBarSize.width > maxWidth;
        if (ps.width > maxWidth) {
            ps.width = maxWidth;
            if (displayHorizontalScrollbar) {
                ps.height += this.scrollBarSize.height;
                this.minSize.height += this.scrollBarSize.height;
                this.setMinimumSize(this.minSize);
            }
        }
        ps.height = Math.min(Math.max(ps.height, this.minSize.height), maxHeight);
        super.setSize(ps.width, ps.height);
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public JComponent getComponent() {
        return this;
    }

    class ViewMouseListener
    extends MouseAdapter {
        ViewMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            Action a;
            JDCPopupPanel jdc;
            JTextComponent component;
            if (SwingUtilities.isLeftMouseButton(evt) && (component = ScrollCompletionPane.this.extEditorUI.getComponent()) != null && evt.getClickCount() == 2 && (jdc = ExtUtilities.getJDCPopupPanel(component)) != null && (a = jdc.getActionMap().get("completion-substitute-text")) != null) {
                a.actionPerformed(new ActionEvent(component, 1001, ""));
            }
        }
    }
}

