/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import org.netbeans.modules.project.libraries.WriteableLibraryProvider;
import org.netbeans.modules.project.libraries.ui.LibrariesCustomizer;
import org.netbeans.modules.project.libraries.ui.ProxyLibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

class LibrariesModel
extends AbstractListModel
implements PropertyChangeListener,
LookupListener {
    private List actualLibraries;
    private List addedLibraries = new ArrayList();
    private List removedLibraries = new ArrayList();
    private List changedLibraries = new ArrayList();
    private Collection currentStorages = Collections.EMPTY_SET;
    private Map storageByLib = new HashMap();
    private Lookup.Result lresult;
    private WriteableLibraryProvider writeableProvider;
    static /* synthetic */ Class class$org$netbeans$modules$project$libraries$ui$LibrariesModel;

    public LibrariesModel() {
        this.getLibraries();
    }

    public Object getElementAt(int index) {
        if (index < 0 || index >= this.actualLibraries.size()) {
            return null;
        }
        return this.actualLibraries.get(index);
    }

    public int getSize() {
        return this.actualLibraries.size();
    }

    public void addLibrary(LibraryImplementation impl) {
        Object tmp;
        int index;
        this.addedLibraries.add(impl);
        LibrariesComparator c = new LibrariesComparator();
        for (index = 0; index < this.actualLibraries.size() && c.compare(impl, tmp = this.actualLibraries.get(index)) >= 0; ++index) {
        }
        this.actualLibraries.add(index, impl);
        this.fireIntervalAdded(this, index, index);
    }

    public void removeLibrary(LibraryImplementation impl) {
        if (this.addedLibraries.contains(impl)) {
            this.addedLibraries.remove(impl);
        } else {
            this.removedLibraries.add(((ProxyLibraryImplementation)impl).getOriginal());
        }
        int index = this.actualLibraries.indexOf(impl);
        this.actualLibraries.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public void modifyLibrary(LibraryImplementation impl) {
        if (!this.addedLibraries.contains(impl) && !this.changedLibraries.contains(impl)) {
            this.changedLibraries.add(impl);
        }
        int index = this.actualLibraries.indexOf(impl);
        this.fireContentsChanged(this, index, index);
    }

    public boolean isLibraryEditable(LibraryImplementation impl) {
        if (this.addedLibraries.contains(impl)) {
            return true;
        }
        LibraryProvider provider = (LibraryProvider)this.storageByLib.get(((ProxyLibraryImplementation)impl).getOriginal());
        return provider == this.writeableProvider;
    }

    public void apply() throws IOException {
        LibraryProvider storage;
        Iterator it = this.removedLibraries.iterator();
        while (it.hasNext()) {
            LibraryImplementation impl = (LibraryImplementation)it.next();
            storage = (LibraryProvider)this.storageByLib.get(impl);
            if (storage == this.writeableProvider) {
                this.writeableProvider.removeLibrary(impl);
                continue;
            }
            ErrorManager.getDefault().log("Can not find storage for library: " + impl.getName());
        }
        if (this.writeableProvider != null) {
            it = this.addedLibraries.iterator();
            while (it.hasNext()) {
                this.writeableProvider.addLibrary((LibraryImplementation)it.next());
            }
        } else {
            ErrorManager.getDefault().log("Can not add libraries, no WriteableProvider.");
        }
        it = this.changedLibraries.iterator();
        while (it.hasNext()) {
            ProxyLibraryImplementation proxy = (ProxyLibraryImplementation)it.next();
            storage = (LibraryProvider)this.storageByLib.get(proxy.getOriginal());
            if (storage == this.writeableProvider) {
                this.writeableProvider.updateLibrary(proxy.getOriginal(), proxy);
                continue;
            }
            ErrorManager.getDefault().log("Can not find storage for library: " + proxy.getOriginal().getName());
        }
        this.cleanUp();
    }

    public void cancel() {
        this.cleanUp();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.storagesChanged();
    }

    public void resultChanged(LookupEvent ev) {
        this.storagesChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storagesChanged() {
        int oldSize;
        LibrariesModel librariesModel = this;
        synchronized (librariesModel) {
            oldSize = this.actualLibraries == null ? 0 : this.actualLibraries.size();
            this.getLibraries();
        }
        this.fireContentsChanged(this, 0, Math.max(oldSize, this.actualLibraries.size()));
    }

    private LibraryImplementation findModified(LibraryImplementation impl) {
        Iterator it = this.changedLibraries.iterator();
        while (it.hasNext()) {
            ProxyLibraryImplementation proxy = (ProxyLibraryImplementation)it.next();
            if (!proxy.getOriginal().equals(impl)) continue;
            return proxy;
        }
        return null;
    }

    private synchronized void cleanUp() {
        this.addedLibraries.clear();
        this.removedLibraries.clear();
        this.changedLibraries.clear();
        Iterator it = this.currentStorages.iterator();
        while (it.hasNext()) {
            ((LibraryProvider)it.next()).removePropertyChangeListener(this);
        }
        this.currentStorages = Collections.EMPTY_SET;
    }

    private synchronized void getLibraries() {
        ArrayList<LibraryImplementation> libraries = new ArrayList<LibraryImplementation>();
        if (this.lresult == null) {
            this.lresult = Lookup.getDefault().lookup(new Lookup.Template(LibraryProvider.class));
            this.lresult.addLookupListener((LookupListener)this);
        }
        Collection instances = this.lresult.allInstances();
        HashSet toAdd = new HashSet(instances);
        toAdd.removeAll(this.currentStorages);
        HashSet toRemove = new HashSet(this.currentStorages);
        toRemove.removeAll(instances);
        this.currentStorages = instances;
        this.storageByLib.clear();
        Iterator it = instances.iterator();
        while (it.hasNext()) {
            LibraryProvider storage = (LibraryProvider)it.next();
            if (this.writeableProvider == null && storage instanceof WriteableLibraryProvider) {
                this.writeableProvider = (WriteableLibraryProvider)storage;
            }
            LibraryImplementation[] impls = storage.getLibraries();
            for (int i = 0; i < impls.length; ++i) {
                LibraryImplementation lib = impls[i];
                LibraryImplementation proxy = null;
                if (this.removedLibraries.contains(lib)) {
                    this.storageByLib.put(lib, storage);
                    continue;
                }
                proxy = this.findModified(lib);
                if (proxy != null) {
                    libraries.add(proxy);
                    this.storageByLib.put(lib, storage);
                    continue;
                }
                libraries.add(new ProxyLibraryImplementation(lib, this));
                this.storageByLib.put(lib, storage);
            }
        }
        libraries.addAll(this.addedLibraries);
        Collections.sort(libraries, new LibrariesComparator());
        it = toRemove.iterator();
        while (it.hasNext()) {
            ((LibraryProvider)it.next()).removePropertyChangeListener(this);
        }
        it = toAdd.iterator();
        while (it.hasNext()) {
            ((LibraryProvider)it.next()).addPropertyChangeListener(this);
        }
        this.actualLibraries = libraries;
    }

    private static class LibrariesComparator
    implements Comparator {
        static final /* synthetic */ boolean $assertionsDisabled;

        private LibrariesComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!($assertionsDisabled || o1 instanceof LibraryImplementation && o2 instanceof LibraryImplementation)) {
                throw new AssertionError();
            }
            LibraryImplementation lib1 = (LibraryImplementation)o1;
            LibraryImplementation lib2 = (LibraryImplementation)o2;
            String name1 = LibrariesCustomizer.getLocalizedString(lib1.getLocalizingBundle(), lib1.getName());
            String name2 = LibrariesCustomizer.getLocalizedString(lib2.getLocalizingBundle(), lib2.getName());
            return name1.compareToIgnoreCase(name2);
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$project$libraries$ui$LibrariesModel == null ? (class$org$netbeans$modules$project$libraries$ui$LibrariesModel = LibrariesModel.class$("org.netbeans.modules.project.libraries.ui.LibrariesModel")) : class$org$netbeans$modules$project$libraries$ui$LibrariesModel).desiredAssertionStatus();
        }
    }
}

