/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import org.netbeans.modules.viewmodel.TreeModelNode;
import org.netbeans.modules.viewmodel.TreeTable;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;

public class TreeModelRoot
implements ModelListener {
    static final long serialVersionUID = -1259352660663524178L;
    private Models.CompoundModel model;
    private TreeModelNode rootNode;
    private WeakHashMap objectToNode = new WeakHashMap();
    private TreeTable treeTable;
    private TreeModelNode.LazyEvaluator childrenEvaluator;
    private TreeModelNode.LazyEvaluator valuesEvaluator;

    public TreeModelRoot(Models.CompoundModel model, TreeTable treeTable) {
        this.model = model;
        this.treeTable = treeTable;
        model.addModelListener(this);
    }

    public TreeTable getTreeTable() {
        return this.treeTable;
    }

    public TreeModelNode getRootNode() {
        if (this.rootNode == null) {
            this.rootNode = new TreeModelNode(this.model, this, this.model.getRoot());
        }
        return this.rootNode;
    }

    void registerNode(Object o, TreeModelNode n) {
        this.objectToNode.put(o, new WeakReference<TreeModelNode>(n));
    }

    TreeModelNode findNode(Object o) {
        WeakReference wr = (WeakReference)this.objectToNode.get(o);
        if (wr == null) {
            return null;
        }
        return (TreeModelNode)((Object)wr.get());
    }

    public void modelChanged(final ModelEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ModelEvent.NodeChanged nchEvent;
                TreeModelNode tmNode;
                ModelEvent.TableValueChanged tvEvent;
                Object node;
                if (TreeModelRoot.this.model == null) {
                    return;
                }
                if (event instanceof ModelEvent.TableValueChanged && (node = (tvEvent = (ModelEvent.TableValueChanged)event).getNode()) != null && (tmNode = TreeModelRoot.this.findNode(node)) != null) {
                    String column = tvEvent.getColumnID();
                    if (column != null) {
                        tmNode.refreshColumn(column);
                    } else {
                        tmNode.refresh();
                    }
                    return;
                }
                if (event instanceof ModelEvent.NodeChanged && (node = (nchEvent = (ModelEvent.NodeChanged)event).getNode()) != null && (tmNode = TreeModelRoot.this.findNode(node)) != null) {
                    tmNode.refresh(nchEvent.getChange());
                    return;
                }
                TreeModelRoot.this.rootNode.setObject(TreeModelRoot.this.model.getRoot());
            }
        });
    }

    synchronized TreeModelNode.LazyEvaluator getChildrenEvaluator() {
        if (this.childrenEvaluator == null) {
            this.childrenEvaluator = new TreeModelNode.LazyEvaluator();
        }
        return this.childrenEvaluator;
    }

    synchronized TreeModelNode.LazyEvaluator getValuesEvaluator() {
        if (this.valuesEvaluator == null) {
            this.valuesEvaluator = new TreeModelNode.LazyEvaluator();
        }
        return this.valuesEvaluator;
    }

    public void destroy() {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = null;
        this.objectToNode = new WeakHashMap();
    }
}

