/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.ConversionManager;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.identitymaps.CacheKey;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ChangeRecord;
import oracle.toplink.essentials.internal.sessions.DirectToFieldChangeRecord;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.sessions.Session;

public class ObjectChangeSet
implements Serializable,
oracle.toplink.essentials.changesets.ObjectChangeSet {
    protected Vector changes;
    protected Hashtable attributesToChanges;
    protected boolean shouldBeDeleted;
    protected CacheKey cacheKey;
    protected transient Class classType;
    protected String className;
    protected boolean isNew;
    protected boolean isAggregate;
    protected Object oldKey;
    protected Object newKey;
    protected UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected transient OptimisticLockingPolicy optimisticLockingPolicy;
    protected Object initialWriteLockValue;
    protected Object writeLockValue;
    protected boolean isInvalid;
    protected transient Object cloneObject;
    protected boolean hasVersionChange;
    protected Boolean shouldModifyVersionField;
    protected boolean hasCmpPolicyForcedUpdate;
    protected boolean hasChangesFromCascadeLocking;
    protected transient HashSet deferredSet;

    public ObjectChangeSet() {
    }

    public ObjectChangeSet(Object cloneObject, UnitOfWorkChangeSet parent, boolean isNew) {
        this.cloneObject = cloneObject;
        this.shouldBeDeleted = false;
        this.classType = cloneObject.getClass();
        this.className = this.classType.getName();
        this.unitOfWorkChangeSet = parent;
        this.isNew = isNew;
    }

    public ObjectChangeSet(Vector primaryKey, Object cloneObject, UnitOfWorkChangeSet parent, boolean isNew) {
        this.cloneObject = cloneObject;
        this.isNew = isNew;
        this.shouldBeDeleted = false;
        if (primaryKey != null && !Helper.containsNull(primaryKey, 0)) {
            this.cacheKey = new CacheKey(primaryKey);
        }
        this.classType = cloneObject.getClass();
        this.className = this.classType.getName();
        this.unitOfWorkChangeSet = parent;
        this.isAggregate = false;
    }

    public void clear() {
        this.shouldBeDeleted = false;
        this.setOldKey(null);
        this.setNewKey(null);
        this.changes = null;
        this.attributesToChanges = null;
    }

    public void addChange(ChangeRecord changeRecord) {
        if (changeRecord == null) {
            return;
        }
        ChangeRecord existingChangeRecord = (ChangeRecord)this.getAttributesToChanges().get(changeRecord.getAttribute());
        if (existingChangeRecord != null) {
            this.getChanges().remove(existingChangeRecord);
        }
        this.getChanges().addElement(changeRecord);
        this.getAttributesToChanges().put(changeRecord.getAttribute(), changeRecord);
        this.updateUOWChangeSet();
    }

    public void deferredDetectionRequiredOn(String attributeName) {
        this.getDeferredSet().add(attributeName);
    }

    public boolean containsChangesFromSynchronization() {
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectChangeSet) {
            return this.equals((ObjectChangeSet)object);
        }
        return false;
    }

    public boolean equals(oracle.toplink.essentials.changesets.ObjectChangeSet objectChange) {
        if (this == objectChange) {
            return true;
        }
        if (this.getCacheKey() == null) {
            return false;
        }
        return this.getCacheKey().equals(((ObjectChangeSet)objectChange).getCacheKey());
    }

    public Hashtable getAttributesToChanges() {
        if (this.attributesToChanges == null) {
            this.attributesToChanges = new Hashtable(2);
        }
        return this.attributesToChanges;
    }

    public oracle.toplink.essentials.changesets.ChangeRecord getChangesForAttributeNamed(String attributeName) {
        return (ChangeRecord)this.getAttributesToChanges().get(attributeName);
    }

    public CacheKey getCacheKey() {
        return this.cacheKey;
    }

    public Vector getChangedAttributeNames() {
        Vector<String> names = new Vector<String>();
        Enumeration attributes = this.getChanges().elements();
        while (attributes.hasMoreElements()) {
            names.addElement(((ChangeRecord)attributes.nextElement()).getAttribute());
        }
        return names;
    }

    public Vector getChanges() {
        if (this.changes == null) {
            this.changes = new Vector(1);
        }
        return this.changes;
    }

    public Class getClassType(Session session) {
        if (this.classType == null) {
            this.classType = (Class)((AbstractSession)session).getDatasourcePlatform().getConversionManager().convertObject(this.getClassName(), ClassConstants.CLASS);
        }
        return this.classType;
    }

    public String getClassName() {
        return this.className;
    }

    public Object getInitialWriteLockValue() {
        return this.initialWriteLockValue;
    }

    public Object getOldKey() {
        return this.oldKey;
    }

    public Object getNewKey() {
        return this.newKey;
    }

    public Vector getPrimaryKeys() {
        if (this.getCacheKey() == null) {
            return null;
        }
        return this.getCacheKey().getKey();
    }

    public Object getTargetVersionOfSourceObject(AbstractSession session) {
        return this.getTargetVersionOfSourceObject(session, false);
    }

    public Object getTargetVersionOfSourceObject(AbstractSession session, boolean shouldRead) {
        Object attributeValue = null;
        ClassDescriptor descriptor = session.getDescriptor(this.getClassType(session));
        attributeValue = session.isUnitOfWork() ? (((UnitOfWorkImpl)session).getLifecycle() == 4 ? ((UnitOfWorkImpl)session).getOriginalVersionOfObjectOrNull(((UnitOfWorkChangeSet)this.getUOWChangeSet()).getObjectChangeSetToUOWClone().get(this)) : ((UnitOfWorkChangeSet)this.getUOWChangeSet()).getObjectChangeSetToUOWClone().get(this)) : session.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(this.getPrimaryKeys(), this.getClassType(session), descriptor);
        if (attributeValue == null && shouldRead) {
            ReadObjectQuery query = new ReadObjectQuery();
            query.setShouldUseWrapperPolicy(false);
            query.setReferenceClass(this.getClassType(session));
            query.setSelectionKey(this.getPrimaryKeys());
            attributeValue = session.executeQuery(query);
        }
        return attributeValue;
    }

    public Object getUnitOfWorkClone() {
        return this.cloneObject;
    }

    public oracle.toplink.essentials.changesets.UnitOfWorkChangeSet getUOWChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    public boolean hasChangeFor(String attributeName) {
        Enumeration attributes = this.getChanges().elements();
        while (attributes.hasMoreElements()) {
            if (!((ChangeRecord)attributes.nextElement()).getAttribute().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChanges() {
        return this.hasVersionChange || !this.getChanges().isEmpty();
    }

    public boolean hasForcedChanges() {
        return this.shouldModifyVersionField != null || this.hasCmpPolicyForcedUpdate;
    }

    public void setShouldModifyVersionField(Boolean shouldModifyVersionField) {
        this.shouldModifyVersionField = shouldModifyVersionField;
        if (shouldModifyVersionField != null && shouldModifyVersionField.booleanValue()) {
            this.hasVersionChange = true;
        }
    }

    public Boolean shouldModifyVersionField() {
        return this.shouldModifyVersionField;
    }

    public void setHasCmpPolicyForcedUpdate(boolean hasCmpPolicyForcedUpdate) {
        this.hasCmpPolicyForcedUpdate = hasCmpPolicyForcedUpdate;
    }

    public boolean hasCmpPolicyForcedUpdate() {
        return this.hasCmpPolicyForcedUpdate;
    }

    public boolean hasForcedChangesFromCascadeLocking() {
        return this.hasChangesFromCascadeLocking;
    }

    public void setHasForcedChangesFromCascadeLocking(boolean newValue) {
        this.setShouldModifyVersionField(Boolean.TRUE);
        this.hasChangesFromCascadeLocking = newValue;
    }

    public int hashCode() {
        if (this.getCacheKey() == null) {
            return System.identityHashCode(this);
        }
        return this.getCacheKey().hashCode();
    }

    public boolean hasKeys() {
        return this.newKey != null || this.oldKey != null;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isInvalid() {
        return this.isInvalid;
    }

    public void mergeObjectChanges(ObjectChangeSet changeSetToMergeFrom, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        if (this == changeSetToMergeFrom || this.isInvalid()) {
            return;
        }
        if (changeSetToMergeFrom.optimisticLockingPolicy != null) {
            if (this.optimisticLockingPolicy == null) {
                this.optimisticLockingPolicy = changeSetToMergeFrom.optimisticLockingPolicy;
                this.initialWriteLockValue = changeSetToMergeFrom.initialWriteLockValue;
                this.writeLockValue = changeSetToMergeFrom.writeLockValue;
            } else {
                Object writeLockValueToCompare = this.writeLockValue;
                if (writeLockValueToCompare == null) {
                    writeLockValueToCompare = this.initialWriteLockValue;
                }
                if (this.optimisticLockingPolicy.compareWriteLockValues(writeLockValueToCompare, changeSetToMergeFrom.initialWriteLockValue) != 0) {
                    this.isInvalid = true;
                    return;
                }
                this.writeLockValue = changeSetToMergeFrom.writeLockValue;
            }
        }
        for (int index = 0; index < changeSetToMergeFrom.getChanges().size(); ++index) {
            ChangeRecord record = (ChangeRecord)changeSetToMergeFrom.getChanges().get(index);
            ChangeRecord thisRecord = (ChangeRecord)this.getChangesForAttributeNamed(record.getAttribute());
            if (thisRecord == null) {
                record.updateReferences(mergeToChangeSet, mergeFromChangeSet);
                this.addChange(record);
                continue;
            }
            thisRecord.mergeRecord(record, mergeToChangeSet, mergeFromChangeSet);
        }
        this.shouldBeDeleted = changeSetToMergeFrom.shouldBeDeleted;
        this.setOldKey(changeSetToMergeFrom.oldKey);
        this.setNewKey(changeSetToMergeFrom.newKey);
        this.hasVersionChange = changeSetToMergeFrom.hasVersionChange;
        this.shouldModifyVersionField = changeSetToMergeFrom.shouldModifyVersionField;
        this.hasCmpPolicyForcedUpdate = changeSetToMergeFrom.hasCmpPolicyForcedUpdate;
        this.hasChangesFromCascadeLocking = changeSetToMergeFrom.hasChangesFromCascadeLocking;
    }

    public void prepareChangeRecordsForSynchronization(AbstractSession session) {
        Enumeration records = this.getChanges().elements();
        while (records.hasMoreElements()) {
            ((ChangeRecord)records.nextElement()).prepareForSynchronization(session);
        }
    }

    public void readCompleteChangeSet(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.readIdentityInformation(stream);
        this.changes = (Vector)stream.readObject();
        this.setOldKey(stream.readObject());
        this.newKey = stream.readObject();
    }

    public void readIdentityInformation(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.cacheKey = (CacheKey)stream.readObject();
        this.className = (String)stream.readObject();
        this.writeLockValue = stream.readObject();
    }

    public void setCacheKey(CacheKey cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void setChanges(Vector changesList) {
        this.changes = changesList;
        this.updateUOWChangeSet();
    }

    public void setClassType(Class newValue) {
        this.classType = newValue;
    }

    public void setClassName(String newValue) {
        this.className = newValue;
    }

    public void setIsAggregate(boolean isAggregate) {
        this.isAggregate = isAggregate;
    }

    protected void setIsNew(boolean newIsNew) {
        this.isNew = newIsNew;
    }

    public void setOldKey(Object key) {
        if (key == null || this.oldKey == null) {
            this.oldKey = key;
        }
    }

    public void setNewKey(Object key) {
        this.newKey = key;
    }

    public void setShouldBeDeleted(boolean newValue) {
        this.shouldBeDeleted = newValue;
    }

    public void setUOWChangeSet(UnitOfWorkChangeSet newUnitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = newUnitOfWorkChangeSet;
    }

    public void setOptimisticLockingPolicyAndInitialWriteLockValue(OptimisticLockingPolicy optimisticLockingPolicy, AbstractSession session) {
        this.optimisticLockingPolicy = optimisticLockingPolicy;
        this.initialWriteLockValue = optimisticLockingPolicy.getWriteLockValue(this.cloneObject, this.getPrimaryKeys(), session);
    }

    public void setWriteLockValue(Object newWriteLockValue) {
        this.writeLockValue = newWriteLockValue;
        this.hasVersionChange = true;
        this.updateUOWChangeSet();
    }

    public void setInitialWriteLockValue(Object initialWriteLockValue) {
        if (this.initialWriteLockValue == null) {
            this.initialWriteLockValue = initialWriteLockValue;
        }
    }

    public boolean shouldBeDeleted() {
        return this.shouldBeDeleted;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.getClassName() + ")" + this.getChanges().toString();
    }

    public void updateChangeRecordForAttribute(String attributeName, Object value) {
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(attributeName);
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(value);
        }
    }

    public void updateChangeRecordForAttributeWithMappedObject(String attributeName, Object value, AbstractSession session) {
        ClassDescriptor descriptor;
        ObjectChangeSet referenceChangeSet = (ObjectChangeSet)this.getUOWChangeSet().getObjectChangeSetForClone(value);
        if (referenceChangeSet == null && (descriptor = session.getDescriptor(value.getClass())) != null) {
            referenceChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(value, (UnitOfWorkChangeSet)this.getUOWChangeSet(), false, session);
        }
        this.updateChangeRecordForAttribute(attributeName, (Object)referenceChangeSet);
    }

    public void updateChangeRecordForAttribute(DatabaseMapping mapping, Object value) {
        String attributeName = mapping.getAttributeName();
        ChangeRecord changeRecord = (ChangeRecord)this.getChangesForAttributeNamed(attributeName);
        value = ConversionManager.getDefaultManager().convertObject(value, mapping.getAttributeClassification());
        if (changeRecord != null) {
            changeRecord.updateChangeRecordWithNewValue(value);
        } else if (mapping.isDirectToFieldMapping()) {
            changeRecord = new DirectToFieldChangeRecord(this);
            changeRecord.setAttribute(attributeName);
            changeRecord.setMapping(mapping);
            ((DirectToFieldChangeRecord)changeRecord).setNewValue(value);
            this.addChange(changeRecord);
        }
    }

    public void updateReferences(UnitOfWorkChangeSet localChangeSet, UnitOfWorkChangeSet mergingChangeSet) {
        for (int index = 0; index < this.getChanges().size(); ++index) {
            ((ChangeRecord)this.getChanges().get(index)).updateReferences(localChangeSet, mergingChangeSet);
        }
    }

    public void writeIdentityInformation(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.cacheKey);
        stream.writeObject(this.className);
        stream.writeObject(this.writeLockValue);
    }

    public void writeCompleteChangeSet(ObjectOutputStream stream) throws IOException {
        this.writeIdentityInformation(stream);
        stream.writeObject(this.changes);
        stream.writeObject(this.oldKey);
        stream.writeObject(this.newKey);
    }

    public void setPrimaryKeys(Vector key) {
        if (key == null) {
            return;
        }
        if (this.getCacheKey() == null) {
            this.setCacheKey(new CacheKey(key));
        } else {
            this.getCacheKey().setKey(key);
        }
    }

    public HashSet getDeferredSet() {
        if (this.deferredSet == null) {
            this.deferredSet = new HashSet();
        }
        return this.deferredSet;
    }

    public boolean hasDeferredAttributes() {
        return this.deferredSet != null && !this.deferredSet.isEmpty();
    }

    protected void updateUOWChangeSet() {
        if (this.getUOWChangeSet() != null) {
            ((UnitOfWorkChangeSet)this.getUOWChangeSet()).setHasChanges(this.hasChanges());
        }
    }

    public void removeChange(String attributeName) {
        oracle.toplink.essentials.changesets.ChangeRecord record = this.getChangesForAttributeNamed(attributeName);
        if (record != null) {
            this.getChanges().removeElement(record);
        }
    }

    protected void removeFromIdentityMap(AbstractSession session) {
        session.getIdentityMapAccessor().removeFromIdentityMap(this.getPrimaryKeys(), this.getClassType(session));
    }

    public boolean shouldInvalidateObject(Object original, AbstractSession session) {
        if (this.optimisticLockingPolicy == null) {
            return false;
        }
        if (this.isInvalid()) {
            return true;
        }
        Object originalWriteLockValue = this.optimisticLockingPolicy.getWriteLockValue(original, this.getPrimaryKeys(), session);
        return this.optimisticLockingPolicy.compareWriteLockValues(this.initialWriteLockValue, originalWriteLockValue) != 0;
    }
}

