/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sequencing;

import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.internal.sequencing.SequencingLogInOut;

class PreallocationHandler
implements SequencingLogInOut {
    protected Hashtable preallocatedSequences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getPreallocatedSequences(String seqName) {
        Vector sequencesForName;
        Hashtable hashtable = this.preallocatedSequences;
        synchronized (hashtable) {
            sequencesForName = (Vector)this.preallocatedSequences.get(seqName);
            if (sequencesForName == null) {
                sequencesForName = new Vector();
                this.preallocatedSequences.put(seqName, sequencesForName);
            }
        }
        return sequencesForName;
    }

    public void onConnect() {
        this.initializePreallocated();
    }

    public void onDisconnect() {
        this.preallocatedSequences = null;
    }

    public boolean isConnected() {
        return this.preallocatedSequences != null;
    }

    public void initializePreallocated() {
        this.preallocatedSequences = new Hashtable(20);
    }

    public void initializePreallocated(String seqName) {
        this.preallocatedSequences.remove(seqName);
    }

    public Vector getPreallocated(String seqName) {
        return this.getPreallocatedSequences(seqName);
    }

    public void setPreallocated(String seqName, Vector sequences) {
        this.getPreallocatedSequences(seqName).addAll(sequences);
    }
}

