/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.StructHandler;
import org.openide.ErrorManager;
import org.openide.text.PositionBounds;

public class PropertiesStructure
extends Element {
    private Map items;
    private StructHandler handler;
    static final long serialVersionUID = -78380271920882131L;

    public PropertiesStructure(PositionBounds bounds, Map items) {
        super(bounds);
        Iterator it = items.values().iterator();
        while (it.hasNext()) {
            ((Element.ItemElem)it.next()).setParent(this);
        }
        this.items = items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(PropertiesStructure struct) {
        StructHandler structHandler = this.getParent();
        synchronized (structHandler) {
            BundleStructure bundleStructure = this.getParentBundleStructure();
            synchronized (bundleStructure) {
                boolean structChanged = false;
                Map new_items = struct.items;
                HashMap<String, Element.ItemElem> changed = new HashMap<String, Element.ItemElem>();
                HashMap<String, Element.ItemElem> inserted = new HashMap<String, Element.ItemElem>();
                Map deleted = new HashMap();
                Iterator it = new_items.values().iterator();
                while (it.hasNext()) {
                    Element.ItemElem curItem = (Element.ItemElem)it.next();
                    curItem.setParent(this);
                    Element.ItemElem oldItem = this.getItem(curItem.getKey());
                    if (oldItem == null) {
                        inserted.put(curItem.getKey(), curItem);
                        continue;
                    }
                    if (!curItem.equals(oldItem)) {
                        changed.put(curItem.getKey(), curItem);
                    }
                    this.items.remove(oldItem.getKey());
                }
                deleted = this.items;
                if (deleted.size() > 0 || inserted.size() > 0) {
                    structChanged = true;
                }
                this.items = new_items;
                this.bounds = struct.getBounds();
                if (structChanged) {
                    this.structureChanged(changed, inserted, deleted);
                } else {
                    it = changed.values().iterator();
                    while (it.hasNext()) {
                        this.itemChanged((Element.ItemElem)it.next());
                    }
                }
            }
        }
    }

    void setParent(StructHandler parent) {
        this.handler = parent;
    }

    public StructHandler getParent() {
        if (this.handler == null) {
            throw new IllegalStateException();
        }
        return this.handler;
    }

    private BundleStructure getParentBundleStructure() {
        PropertiesDataObject dataObj = (PropertiesDataObject)this.getParent().getEntry().getDataObject();
        return dataObj.getBundleStructure();
    }

    public String getDocumentString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.items.values().iterator();
        while (it.hasNext()) {
            Element.ItemElem item = (Element.ItemElem)it.next();
            sb.append(item.getDocumentString());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.items.values().iterator();
        while (it.hasNext()) {
            Element.ItemElem item = (Element.ItemElem)it.next();
            sb.append(item.toString());
            sb.append("- - -\n");
        }
        return sb.toString();
    }

    public Element.ItemElem getItem(String key) {
        return (Element.ItemElem)this.items.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameItem(String oldKey, String newKey) {
        StructHandler structHandler = this.getParent();
        synchronized (structHandler) {
            BundleStructure bundleStructure = this.getParentBundleStructure();
            synchronized (bundleStructure) {
                Element.ItemElem item = this.getItem(newKey);
                if (item == null) {
                    item = this.getItem(oldKey);
                    if (item == null) {
                        return false;
                    }
                    this.items.remove(oldKey);
                    this.items.put(newKey, item);
                    item.setKey(newKey);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteItem(String key) {
        StructHandler structHandler = this.getParent();
        synchronized (structHandler) {
            BundleStructure bundleStructure = this.getParentBundleStructure();
            synchronized (bundleStructure) {
                Element.ItemElem item = this.getItem(key);
                if (item == null) {
                    return false;
                }
                try {
                    item.getBounds().setText("");
                    this.items.remove(key);
                    this.structureChanged();
                    return true;
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return false;
                }
                catch (BadLocationException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addItem(String key, String value, String comment) {
        Element.ItemElem item = this.getItem(key);
        if (item != null) {
            return false;
        }
        item = new Element.ItemElem(null, new Element.KeyElem(null, key), new Element.ValueElem(null, value), new Element.CommentElem(null, comment));
        try {
            StructHandler structHandler = this.getParent();
            synchronized (structHandler) {
                BundleStructure bundleStructure = this.getParentBundleStructure();
                synchronized (bundleStructure) {
                    PositionBounds itemBounds;
                    PositionBounds pos = this.getBounds();
                    item.bounds = itemBounds = pos.insertAfter("\n").insertAfter(item.getDocumentString());
                    item.setParent(this);
                    this.items.put(key, item);
                    this.structureChanged();
                    return true;
                }
            }
        }
        catch (IOException ioe) {
            return false;
        }
        catch (BadLocationException ble) {
            return false;
        }
    }

    public Iterator allItems() {
        return this.items.values().iterator();
    }

    void itemChanged(Element.ItemElem elem) {
        this.getParentBundleStructure().notifyItemChanged(this, elem);
    }

    void structureChanged() {
        this.getParentBundleStructure().notifyOneFileChanged(this.getParent());
    }

    void structureChanged(Map changed, Map inserted, Map deleted) {
        this.getParentBundleStructure().notifyOneFileChanged(this.getParent(), changed, inserted, deleted);
    }

    void itemKeyChanged(String oldKey, Element.ItemElem newElem) {
        HashMap<String, Element.ItemElem> changed = new HashMap<String, Element.ItemElem>();
        HashMap<String, Element.ItemElem> inserted = new HashMap<String, Element.ItemElem>();
        HashMap<String, Element.ItemElem> deleted = new HashMap<String, Element.ItemElem>();
        Element.ItemElem item = this.getItem(oldKey);
        if (item == null) {
            Element.ItemElem emptyItem = new Element.ItemElem(null, new Element.KeyElem(null, oldKey), new Element.ValueElem(null, ""), new Element.CommentElem(null, ""));
            deleted.put(oldKey, emptyItem);
        } else {
            changed.put(item.getKey(), item);
        }
        inserted.put(newElem.getKey(), newElem);
        this.structureChanged(changed, inserted, deleted);
    }
}

