/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.properties.BundleNodeCustomizer;
import org.netbeans.modules.properties.LocalePanel;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEditorSupport;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesLocaleNode;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class PropertiesDataNode
extends DataNode {
    private final transient PropertyChangeListener dataObjectListener;
    static /* synthetic */ Class class$org$openide$loaders$DataObject;
    static /* synthetic */ Class class$org$netbeans$modules$properties$PropertiesEditorSupport;

    public PropertiesDataNode(DataObject dataObject, Children children) {
        super(dataObject, children);
        this.setIconBaseWithExtension("org/netbeans/modules/properties/propertiesObject.png");
        this.dataObjectListener = new NameUpdater();
        dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.dataObjectListener, (Object)dataObject));
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewLocaleType()};
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new BundleNodeCustomizer((PropertiesDataObject)this.getDataObject());
    }

    public void createPasteTypes(Transferable transferable, List types) {
        PropertiesFileEntry entry;
        super.createPasteTypes(transferable, types);
        int mode = 1;
        Node node = NodeTransfer.node((Transferable)transferable, (int)mode);
        if (node == null || !(node instanceof PropertiesLocaleNode)) {
            mode = 6;
            node = NodeTransfer.node((Transferable)transferable, (int)mode);
            if (node == null || !(node instanceof PropertiesLocaleNode)) {
                return;
            }
            entry = (PropertiesFileEntry)((PropertiesLocaleNode)node).getFileEntry();
            if (((PropertiesDataObject)this.getDataObject()).files().contains(entry.getFile())) {
                return;
            }
        }
        entry = (PropertiesFileEntry)((PropertiesLocaleNode)node).getFileEntry();
        types.add(new EntryPasteType(entry, mode));
    }

    private static void notifyError(String locale) {
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle((Class)PropertiesDataNode.class).getString("MSG_LangExists"), locale), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    private class NewLocaleType
    extends NewType {
        private NewLocaleType() {
        }

        public String getName() {
            return NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$PropertiesDataNode == null ? (class$org$netbeans$modules$properties$PropertiesDataNode = PropertiesDataNode.class$("org.netbeans.modules.properties.PropertiesDataNode")) : class$org$netbeans$modules$properties$PropertiesDataNode)).getString("LAB_NewLocaleAction");
        }

        public void create() throws IOException {
            final DataObject propertiesDataObject = (DataObject)PropertiesDataNode.this.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = PropertiesDataNode.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            final Dialog[] dialog = new Dialog[1];
            final LocalePanel panel = new LocalePanel();
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getBundle((Class)(class$org$netbeans$modules$properties$PropertiesDataNode == null ? (class$org$netbeans$modules$properties$PropertiesDataNode = PropertiesDataNode.class$("org.netbeans.modules.properties.PropertiesDataNode")) : class$org$netbeans$modules$properties$PropertiesDataNode)).getString("CTL_NewLocaleTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    block10: {
                        if (evt.getSource() == DialogDescriptor.OK_OPTION) {
                            dialog[0].setVisible(false);
                            dialog[0].dispose();
                            String locale = panel.getLocale().toString();
                            try {
                                if (locale.length() == 0) {
                                    PropertiesDataNode.notifyError(locale);
                                    return;
                                }
                                final String newName = '_' + locale;
                                if (propertiesDataObject == null) break block10;
                                final FileObject folder = propertiesDataObject.getPrimaryFile().getParent();
                                final FileObject defaultFile = propertiesDataObject.getPrimaryFile();
                                final PropertiesEditorSupport editor = (PropertiesEditorSupport)propertiesDataObject.getCookie(class$org$netbeans$modules$properties$PropertiesEditorSupport == null ? (class$org$netbeans$modules$properties$PropertiesEditorSupport = PropertiesDataNode.class$("org.netbeans.modules.properties.PropertiesEditorSupport")) : class$org$netbeans$modules$properties$PropertiesEditorSupport);
                                if (editor != null && editor.isDocumentLoaded()) {
                                    final StyledDocument document = editor.getDocument();
                                    final String[] buffer = new String[1];
                                    document.render(new Runnable(){

                                        public void run() {
                                            try {
                                                buffer[0] = document.getText(0, document.getLength());
                                            }
                                            catch (BadLocationException ble) {
                                                ble.printStackTrace();
                                            }
                                        }
                                    });
                                    if (buffer[0] != null) {
                                        folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public void run() throws IOException {
                                                FileObject newFile = folder.createData(defaultFile.getName() + newName, "properties");
                                                FileLock lock = newFile.lock();
                                                try {
                                                    PropertiesEditorSupport.NewLineWriter writer = new PropertiesEditorSupport.NewLineWriter(newFile.getOutputStream(lock), editor.getNewLineType());
                                                    writer.write(buffer[0]);
                                                    ((Writer)writer).flush();
                                                    ((Writer)writer).close();
                                                }
                                                finally {
                                                    lock.releaseLock();
                                                }
                                            }
                                        });
                                    }
                                }
                                if (folder.getFileObject(defaultFile.getName() + newName, "properties") == null) {
                                    folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                                        public void run() throws IOException {
                                            defaultFile.copy(folder, defaultFile.getName() + newName, "properties");
                                        }
                                    });
                                }
                            }
                            catch (IOException ioe) {
                                if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                                    ioe.printStackTrace();
                                }
                                PropertiesDataNode.notifyError(locale);
                            }
                        } else if (evt.getSource() == DialogDescriptor.CANCEL_OPTION) {
                            dialog[0].setVisible(false);
                            dialog[0].dispose();
                        }
                    }
                }
            });
            dialog[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog[0].show();
        }
    }

    private class EntryPasteType
    extends PasteType {
        private PropertiesFileEntry entry;
        private int flag;

        public EntryPasteType(PropertiesFileEntry entry, int flag) {
            this.entry = entry;
            this.flag = flag;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Transferable paste() throws IOException {
            DataFolder dataFolder = PropertiesDataNode.this.getDataObject().getFolder();
            if (dataFolder == null) {
                return null;
            }
            FileObject folder = dataFolder.getPrimaryFile();
            String newName = PropertiesDataNode.this.getDataObject().getPrimaryFile().getName() + Util.getLocaleSuffix((MultiDataObject.Entry)this.entry);
            int entryIndex = ((PropertiesDataObject)PropertiesDataNode.this.getDataObject()).getBundleStructure().getEntryIndexByFileName(newName);
            if (entryIndex != -1) {
                newName = FileUtil.findFreeFileName((FileObject)folder, (String)newName, (String)this.entry.getFile().getExt());
            }
            if (this.flag == 1) {
                FileObject fileObject = this.entry.getFile();
                fileObject.copy(folder, newName, fileObject.getExt());
            } else if (this.flag == 6) {
                FileObject fileObject = this.entry.getFile();
                FileLock lock = this.entry.takeLock();
                ((PropertiesDataObject)this.entry.getDataObject()).removeSecondaryEntry2((MultiDataObject.Entry)this.entry);
                try {
                    FileObject fo2 = fileObject.move(lock, folder, newName, fileObject.getExt());
                    try {
                        DataObject.find((FileObject)fo2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                finally {
                    lock.releaseLock();
                }
            }
            return null;
        }
    }

    final class NameUpdater
    implements PropertyChangeListener {
        NameUpdater() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if ("files".equals(e.getPropertyName())) {
                ((PropertiesDataObject)PropertiesDataNode.this.getDataObject()).fireNameChange();
            }
        }
    }
}

