/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.share.configbean.customizers.common;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public abstract class MethodTableModel
extends AbstractTableModel {
    protected List ddMethods;
    protected List methods;
    private Map methodToDDMethodMap;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MethodTableModel(List methods, List ddMethods) {
        int i;
        if (methods != null) {
            this.methods = new ArrayList();
            for (i = 0; i < methods.size(); ++i) {
                this.methods.add(methods.get(i));
            }
        }
        if (ddMethods != null) {
            this.ddMethods = new ArrayList();
            for (i = 0; i < ddMethods.size(); ++i) {
                this.ddMethods.add(ddMethods.get(i));
            }
        }
        this.setMap();
        this.fireTableDataChanged();
    }

    public void setData(List methods, List ddMethods) {
        int i;
        if (methods != null) {
            this.methods = new ArrayList();
            for (i = 0; i < methods.size(); ++i) {
                this.methods.add(methods.get(i));
            }
        }
        if (ddMethods != null) {
            this.ddMethods = new ArrayList();
            for (i = 0; i < ddMethods.size(); ++i) {
                this.ddMethods.add(ddMethods.get(i));
            }
        }
        this.setMap();
        this.fireTableDataChanged();
    }

    public MethodTableModel(List methods) {
        this(methods, null);
    }

    protected MethodTableModel() {
    }

    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    public String getColumnName(int column) {
        return this.getColumnNames()[column];
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        return this.getColumnType(column);
    }

    public int getRowCount() {
        if (this.methods != null) {
            return this.methods.size();
        }
        return 0;
    }

    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                Object method = this.methods.get(row);
                if (method != null) {
                    return this.getValueAt(col, method, row);
                }
                return null;
            }
            case 1: {
                if (this.methodToDDMethodMap != null && this.methodToDDMethodMap.containsKey(this.methods.get(row))) {
                    return new Boolean("true");
                }
                return new Boolean("false");
            }
        }
        if (this.methodToDDMethodMap != null) {
            Object ddMethod = this.methodToDDMethodMap.get(this.methods.get(row));
            if (ddMethod != null) {
                return this.getDDValueAt(col, ddMethod);
            }
        } else {
            return null;
        }
        return null;
    }

    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 0: {
                break;
            }
            case 1: {
                Boolean enable;
                Object method = this.methods.get(row);
                Object ddMethod = null;
                if (this.methodToDDMethodMap != null) {
                    ddMethod = this.methodToDDMethodMap.get(method);
                }
                if ((enable = (Boolean)value).toString().equals("true")) {
                    if (ddMethod != null) break;
                    this.enableMethod(method);
                    break;
                }
                if (ddMethod == null) break;
                this.disableMethod(method, ddMethod);
                break;
            }
            default: {
                Object ddMethod;
                if (this.methodToDDMethodMap == null || (ddMethod = this.methodToDDMethodMap.get(this.methods.get(row))) == null) break;
                this.setDDValueAt(col, ddMethod, value);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    protected abstract String[] getColumnNames();

    protected abstract Class getColumnType(int var1);

    protected abstract Object getValueAt(int var1, Object var2, int var3);

    protected abstract Object getDDValueAt(int var1, Object var2);

    protected abstract void setDDValueAt(int var1, Object var2, Object var3);

    protected abstract Object getDDMethod(Object var1);

    protected abstract void addDDMethod(Object var1);

    protected abstract void removeDDMethod(Object var1);

    protected abstract boolean areEqual(Object var1, Object var2);

    protected void setMap() {
        this.methodToDDMethodMap = new Hashtable();
        if (this.methods == null) {
            return;
        }
        Object method = null;
        if (this.ddMethods != null) {
            for (int i = 0; i < this.ddMethods.size(); ++i) {
                Object ddMethod = this.ddMethods.get(i);
                method = this.getMethod(ddMethod, this.methods);
                if (!$assertionsDisabled && method == null) {
                    throw new AssertionError();
                }
                if (method == null) continue;
                this.methodToDDMethodMap.put(method, ddMethod);
            }
        }
    }

    private void enableMethod(Object method) {
        Object ddMethod = this.getDDObject(method);
        if (this.methodToDDMethodMap == null) {
            this.methodToDDMethodMap = new Hashtable();
        }
        this.methodToDDMethodMap.put(method, ddMethod);
        this.addDDMethod(ddMethod);
        this.fireTableDataChanged();
    }

    private Object getDDObject(Object method) {
        return this.getDDMethod(method);
    }

    private void disableMethod(Object method, Object ddMethod) {
        if (this.methodToDDMethodMap != null) {
            this.methodToDDMethodMap.remove(method);
            this.removeDDMethod(ddMethod);
        }
        this.fireTableDataChanged();
    }

    private Object getMethod(Object ddMethod, List methods) {
        for (int i = 0; i < methods.size(); ++i) {
            if (!this.areEqual(ddMethod, methods.get(i))) continue;
            return methods.get(i);
        }
        return null;
    }

    private void printList(List list) {
        if (list != null) {
            System.out.println("printList list --" + list);
            System.out.println("printList list toString -- " + list.toString());
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                System.out.println("printList item no: i -- " + list.get(i));
                System.out.println("printList item no: i toSring() -- " + list.get(i).toString());
            }
        }
    }

    static {
        $assertionsDisabled = !MethodTableModel.class.desiredAssertionStatus();
    }
}

