/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.colors;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.modules.options.colors.CategoryComparator;
import org.netbeans.modules.options.colors.CategoryRenderer;
import org.netbeans.modules.options.colors.ColorComboBox;
import org.netbeans.modules.options.colors.ColorModel;
import org.netbeans.modules.options.colors.FontAndColorsPanel;
import org.netbeans.modules.options.colors.SyntaxColoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AnnotationsPanel
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private ColorModel colorModel;
    private JList lCategories = new JList();
    private ColorComboBox foregroundColorChooser = new ColorComboBox();
    private ColorComboBox backgroundColorChooser = new ColorComboBox();
    private ColorComboBox waveUnderlinedColorChooser = new ColorComboBox();
    private boolean listen = false;
    private String currentScheme;
    private Map schemes = new HashMap();
    private Set toBeSaved = new HashSet();
    private boolean changed = false;

    public AnnotationsPanel(FontAndColorsPanel fontAndColorsPanel) {
        this.foregroundColorChooser.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Foreground_Chooser"));
        this.foregroundColorChooser.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Foreground_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Background_Chooser"));
        this.backgroundColorChooser.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Background_Chooser"));
        this.waveUnderlinedColorChooser.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Wave_Underlined"));
        this.waveUnderlinedColorChooser.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Wave_Underlined"));
        this.lCategories.getAccessibleContext().setAccessibleName(AnnotationsPanel.loc("AN_Categories"));
        this.lCategories.getAccessibleContext().setAccessibleDescription(AnnotationsPanel.loc("AD_Categories"));
        this.lCategories.setSelectionMode(0);
        this.lCategories.setVisibleRowCount(3);
        this.lCategories.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!AnnotationsPanel.this.listen) {
                    return;
                }
                AnnotationsPanel.this.refreshUI();
            }
        });
        this.lCategories.setCellRenderer(new CategoryRenderer());
        this.foregroundColorChooser.addPropertyChangeListener(this);
        this.backgroundColorChooser.addPropertyChangeListener(this);
        this.waveUnderlinedColorChooser.addPropertyChangeListener(this);
        JLabel lCategory = new JLabel();
        AnnotationsPanel.loc(lCategory, "CTL_Category");
        lCategory.setLabelFor(this.lCategories);
        FormLayout layout = new FormLayout("p:g, 10dlu, p, 3dlu, p:g", "p, 3dlu, p, 3dlu, p, 3dlu, p, p:g");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        CellConstraints lc = new CellConstraints();
        builder.setDefaultDialogBorder();
        builder.add((Component)lCategory, lc.xy(1, 1));
        builder.add((Component)new JScrollPane(this.lCategories), cc.xywh(1, 3, 1, 6));
        builder.addLabel(AnnotationsPanel.loc("CTL_Foreground_label"), lc.xy(3, 3), (Component)this.foregroundColorChooser, cc.xy(5, 3));
        builder.addLabel(AnnotationsPanel.loc("CTL_Background_label"), lc.xy(3, 5), (Component)this.backgroundColorChooser, cc.xy(5, 5));
        builder.addLabel(AnnotationsPanel.loc("CTL_Wave_underlined_label"), lc.xy(3, 7), (Component)this.waveUnderlinedColorChooser, cc.xy(5, 7));
    }

    public void actionPerformed(ActionEvent evt) {
        if (!this.listen) {
            return;
        }
        this.updateData();
        this.changed = true;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.listen) {
            return;
        }
        if (evt.getPropertyName() != "color") {
            return;
        }
        this.updateData();
    }

    void update(ColorModel colorModel) {
        this.colorModel = colorModel;
        this.listen = false;
        this.currentScheme = colorModel.getCurrentProfile();
        this.lCategories.setListData(this.getAnnotations(this.currentScheme));
        if (this.lCategories.getModel().getSize() > 0) {
            this.lCategories.setSelectedIndex(0);
        }
        this.refreshUI();
        this.listen = true;
        this.changed = false;
    }

    void cancel() {
        this.toBeSaved = new HashSet();
        this.schemes = new HashMap();
        this.changed = false;
    }

    void applyChanges() {
        if (this.colorModel == null) {
            return;
        }
        Iterator it = this.toBeSaved.iterator();
        while (it.hasNext()) {
            String scheme = (String)it.next();
            this.colorModel.setAnnotations(scheme, this.getAnnotations(scheme));
        }
        this.toBeSaved = new HashSet();
        this.schemes = new HashMap();
    }

    boolean isChanged() {
        return this.changed;
    }

    public void setCurrentProfile(String currentScheme) {
        String oldScheme = this.currentScheme;
        this.currentScheme = currentScheme;
        Vector v = this.getAnnotations(currentScheme);
        if (v == null) {
            v = this.getAnnotations(oldScheme);
            this.schemes.put(currentScheme, new Vector(v));
            this.toBeSaved.add(currentScheme);
            v = this.getAnnotations(currentScheme);
        }
        this.lCategories.setListData(v);
        if (this.lCategories.getModel().getSize() > 0) {
            this.lCategories.setSelectedIndex(0);
        }
        this.refreshUI();
    }

    void deleteProfile(String scheme) {
    }

    private static String loc(String key) {
        return NbBundle.getMessage((Class)SyntaxColoringPanel.class, (String)key);
    }

    private static void loc(Component c, String key) {
        if (c instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)c), (String)AnnotationsPanel.loc(key));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)c), (String)AnnotationsPanel.loc(key));
        }
    }

    private void updateData() {
        Vector annotations = this.getAnnotations(this.currentScheme);
        SimpleAttributeSet c = (SimpleAttributeSet)annotations.get(this.lCategories.getSelectedIndex());
        if (this.backgroundColorChooser.getColor() != null) {
            c.addAttribute(StyleConstants.Background, this.backgroundColorChooser.getColor());
        } else {
            c.removeAttribute(StyleConstants.Background);
        }
        if (this.foregroundColorChooser.getColor() != null) {
            c.addAttribute(StyleConstants.Foreground, this.foregroundColorChooser.getColor());
        } else {
            c.removeAttribute(StyleConstants.Foreground);
        }
        if (this.waveUnderlinedColorChooser.getColor() != null) {
            c.addAttribute(EditorStyleConstants.WaveUnderlineColor, this.waveUnderlinedColorChooser.getColor());
        } else {
            c.removeAttribute(EditorStyleConstants.WaveUnderlineColor);
        }
        this.toBeSaved.add(this.currentScheme);
    }

    private void refreshUI() {
        int index = this.lCategories.getSelectedIndex();
        if (index < 0) {
            this.foregroundColorChooser.setEnabled(false);
            this.backgroundColorChooser.setEnabled(false);
            this.waveUnderlinedColorChooser.setEnabled(false);
            return;
        }
        this.foregroundColorChooser.setEnabled(true);
        this.backgroundColorChooser.setEnabled(true);
        this.waveUnderlinedColorChooser.setEnabled(true);
        this.listen = false;
        Vector annotations = this.getAnnotations(this.currentScheme);
        AttributeSet c = (AttributeSet)annotations.get(index);
        this.foregroundColorChooser.setColor((Color)c.getAttribute(StyleConstants.Foreground));
        this.backgroundColorChooser.setColor((Color)c.getAttribute(StyleConstants.Background));
        this.waveUnderlinedColorChooser.setColor((Color)c.getAttribute(EditorStyleConstants.WaveUnderlineColor));
        this.listen = true;
    }

    private Vector getAnnotations(String scheme) {
        if (!this.schemes.containsKey(scheme)) {
            Collection c = this.colorModel.getAnnotations(this.currentScheme);
            if (c == null) {
                return null;
            }
            ArrayList l = new ArrayList(c);
            Collections.sort(l, new CategoryComparator());
            this.schemes.put(scheme, new Vector(l));
        }
        return (Vector)this.schemes.get(scheme);
    }
}

