/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.reflect.RefObject;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Constructor;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.Initializer;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Variable;
import org.netbeans.modules.java.ui.nodes.elements.IconResolver;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.InvalidationListener;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.refactoring.UndoWatcher;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.ui.ParametersPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.ui.CheckNode;
import org.netbeans.modules.refactoring.ui.CheckNodeListener;
import org.netbeans.modules.refactoring.ui.CheckRenderer;
import org.netbeans.modules.refactoring.ui.RefactoringPanelContainer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

public class RefactoringPanel
extends JPanel
implements InvalidationListener {
    private transient JTree tree = null;
    private transient JButton refreshButton = null;
    private transient JToggleButton expandButton = null;
    private JToolBar toolBar = null;
    private transient JButton refactorButton = null;
    private transient JButton cancelButton = null;
    private transient ButtonL buttonListener = null;
    private transient JButton rerunButton = null;
    private final RefactoringUI ui;
    private final boolean isQuery;
    private transient boolean isVisible = false;
    private transient RefactoringSession session = null;
    private transient ParametersPanel parametersPanel = null;
    private transient JScrollPane scrollPane = null;
    private transient JPanel southPanel;
    private Action callback = null;
    private static final int MAX_ROWS = 50;
    private transient JToggleButton logicalViewButton = null;
    private transient JToggleButton physicalViewButton = null;
    private transient ProgressListener progressListener;
    private transient JButton prevMatch = null;
    private transient JButton nextMatch = null;
    private WeakReference refCallerTC;
    static Image PACKAGE_BADGE;
    private static final byte LOGICAL = 0;
    private static final byte PHYSICAL = 1;
    private byte currentView = 0;
    RequestProcessor rp = new RequestProcessor();
    static final /* synthetic */ boolean $assertionsDisabled;

    public RefactoringPanel(RefactoringUI ui) {
        this(ui, null);
    }

    public RefactoringPanel(RefactoringUI ui, TopComponent caller) {
        if (caller != null) {
            this.refCallerTC = new WeakReference<TopComponent>(caller);
        }
        this.ui = ui;
        this.isQuery = ui.isQuery();
        this.initialize();
        this.refresh(true);
    }

    public RefactoringPanel(RefactoringUI ui, RefactoringSession session, Action callback) {
        this.session = session;
        this.ui = ui;
        this.isQuery = ui.isQuery();
        this.callback = callback;
        this.initialize();
        this.refresh(false);
    }

    public static void checkEventThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("This must happen in event thread!"));
        }
    }

    private void initialize() {
        JToolBar toolBar;
        GridBagConstraints c;
        RefactoringPanel.checkEventThread();
        this.setFocusCycleRoot(true);
        this.setLayout(new BorderLayout());
        JButton[] buttons = this.getButtons();
        this.southPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < buttons.length; ++i) {
            c = new GridBagConstraints();
            c.gridy = 0;
            c.insets = new Insets(5, 5, 5, 0);
            this.southPanel.add((Component)buttons[i], c);
        }
        JPanel pp = new JPanel(new BorderLayout());
        c = new GridBagConstraints();
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        c.weightx = 1.0;
        c.fill = 2;
        this.southPanel.add((Component)pp, c);
        if (!this.isQuery || this.callback != null) {
            this.add((Component)this.southPanel, "South");
        }
        if ((toolBar = this.getToolBar()) != null) {
            this.add((Component)toolBar, "West");
        }
        this.validate();
    }

    private JToolBar getToolBar() {
        RefactoringPanel.checkEventThread();
        this.refreshButton = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/refresh.png")));
        Dimension dim = new Dimension(24, 24);
        this.refreshButton.setMaximumSize(dim);
        this.refreshButton.setMinimumSize(dim);
        this.refreshButton.setPreferredSize(dim);
        this.refreshButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_refresh"));
        this.refreshButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_refresh").charAt(0));
        this.refreshButton.addActionListener(this.getButtonListener());
        this.expandButton = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/expandTree.png")));
        this.expandButton.setSelectedIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/colapseTree.png")));
        this.expandButton.setMaximumSize(dim);
        this.expandButton.setMinimumSize(dim);
        this.expandButton.setPreferredSize(dim);
        this.expandButton.setSelected(true);
        this.expandButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_expandAll"));
        this.expandButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_expandAll").charAt(0));
        this.expandButton.addActionListener(this.getButtonListener());
        this.toolBar = new JToolBar(1);
        this.toolBar.setFloatable(false);
        this.logicalViewButton = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/logical_view.png")));
        this.logicalViewButton.setMaximumSize(dim);
        this.logicalViewButton.setMinimumSize(dim);
        this.logicalViewButton.setPreferredSize(dim);
        this.logicalViewButton.setSelected(true);
        this.logicalViewButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_logicalView"));
        this.logicalViewButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_logicalView").charAt(0));
        this.logicalViewButton.addActionListener(this.getButtonListener());
        this.physicalViewButton = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/file_view.png")));
        this.physicalViewButton.setMaximumSize(dim);
        this.physicalViewButton.setMinimumSize(dim);
        this.physicalViewButton.setPreferredSize(dim);
        this.physicalViewButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_physicalView"));
        this.physicalViewButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_physicalView").charAt(0));
        this.physicalViewButton.addActionListener(this.getButtonListener());
        this.nextMatch = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/nextmatch.png")));
        this.nextMatch.setMaximumSize(dim);
        this.nextMatch.setMinimumSize(dim);
        this.nextMatch.setPreferredSize(dim);
        this.nextMatch.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_nextMatch"));
        this.nextMatch.addActionListener(this.getButtonListener());
        this.prevMatch = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/refactoring/resources/prevmatch.png")));
        this.prevMatch.setMaximumSize(dim);
        this.prevMatch.setMinimumSize(dim);
        this.prevMatch.setPreferredSize(dim);
        this.prevMatch.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_prevMatch"));
        this.prevMatch.addActionListener(this.getButtonListener());
        this.toolBar.add(this.refreshButton);
        this.toolBar.add(this.expandButton);
        this.toolBar.add(this.logicalViewButton);
        this.toolBar.add(this.physicalViewButton);
        this.toolBar.add(this.prevMatch);
        this.toolBar.add(this.nextMatch);
        return this.toolBar;
    }

    private JButton[] getButtons() {
        RefactoringPanel.checkEventThread();
        if (this.isQuery) {
            this.refactorButton = null;
            if (this.callback == null) {
                return new JButton[0];
            }
            this.rerunButton = new JButton((String)this.callback.getValue("Name"));
            this.rerunButton.addActionListener(this.getButtonListener());
            return new JButton[]{this.rerunButton};
        }
        this.refactorButton = new JButton(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"LBL_DoRefactor"));
        this.refactorButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_DoRefactor"));
        this.refactorButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_DoRefactor").charAt(0));
        this.refactorButton.addActionListener(this.getButtonListener());
        this.cancelButton = new JButton(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"LBL_CancelRefactor"));
        this.cancelButton.setMnemonic(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"MNEM_CancelRefactor").charAt(0));
        this.cancelButton.setToolTipText(NbBundle.getMessage((Class)RefactoringPanel.class, (String)"HINT_CancelRefactor"));
        this.cancelButton.addActionListener(this.getButtonListener());
        return new JButton[]{this.refactorButton, this.cancelButton};
    }

    void switchToLogicalView() {
        this.logicalViewButton.setSelected(true);
        if (this.currentView == 0) {
            return;
        }
        this.currentView = 0;
        this.physicalViewButton.setSelected(false);
        this.refresh(false);
    }

    void switchToPhysicalView() {
        this.physicalViewButton.setSelected(true);
        if (this.currentView == 1) {
            return;
        }
        this.currentView = 1;
        this.logicalViewButton.setSelected(false);
        this.refresh(false);
    }

    private CheckNode createNode(Object representedObject, HashMap nodes, CheckNode root) {
        FileObject file;
        boolean isLogical = this.currentView == 0;
        CheckNode node = null;
        node = representedObject instanceof SourceGroup ? (CheckNode)nodes.get(((SourceGroup)representedObject).getRootFolder()) : (CheckNode)nodes.get(representedObject);
        if (node != null) {
            return node;
        }
        Object parent = null;
        String resourceID = null;
        String displayName = null;
        Icon icon = null;
        boolean cannotEnable = false;
        if (representedObject instanceof Project) {
            ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)representedObject));
            displayName = pi.getDisplayName();
            icon = pi.getIcon();
        } else if (representedObject instanceof SourceGroup) {
            SourceGroup gr = (SourceGroup)representedObject;
            icon = gr.getIcon(false);
            if (icon == null) {
                try {
                    Image image = DataObject.find((FileObject)gr.getRootFolder()).getNodeDelegate().getIcon(1);
                    image = Utilities.mergeImages((Image)image, (Image)PACKAGE_BADGE, (int)7, (int)7);
                    icon = new ImageIcon(image);
                }
                catch (DataObjectNotFoundException d) {
                    // empty catch block
                }
            }
            displayName = gr.getDisplayName();
            parent = FileOwnerQuery.getOwner((FileObject)gr.getRootFolder());
        } else if (representedObject instanceof RefactoringElement) {
            int status;
            RefactoringElement re = (RefactoringElement)representedObject;
            displayName = re.getDisplayText();
            if (!(this.isQuery || (status = re.getStatus()) != 2 && status != 3)) {
                String bundleKey = status == 2 ? "LBL_InGuardedBlock" : "LBL_InReadOnlyFile";
                displayName = displayName + " [<font color=#CC0000>" + NbBundle.getMessage((Class)RefactoringPanel.class, (String)bundleKey) + "</font>]";
                cannotEnable = true;
            }
            displayName = RefactoringPanel.normalize(displayName);
            Element element = re.getJavaElement();
            if (isLogical) {
                String prefix = null;
                if (element == null) {
                    parent = re.getParentFile();
                } else {
                    parent = element;
                    while ((parent = ((RefObject)parent).refImmediateComposite()) != null && !(parent instanceof Feature) && !(parent instanceof Resource)) {
                    }
                    if (element instanceof Feature) {
                        resourceID = IconResolver.getIconBase((Feature)((Feature)element));
                    }
                    if ((prefix = this.getPrefix(element)) == null) {
                        List classifiers;
                        resourceID = null;
                        parent = element;
                        if (element instanceof Resource && !(classifiers = ((Resource)element).getClassifiers()).isEmpty()) {
                            parent = classifiers.get(0);
                        }
                    } else {
                        displayName = prefix + displayName;
                    }
                }
            } else {
                parent = element != null ? element.getResource() : re.getParentFile();
                resourceID = null;
            }
        } else if (representedObject instanceof Feature) {
            if (isLogical) {
                parent = representedObject;
                while ((parent = ((RefObject)parent).refImmediateComposite()) != null && !(parent instanceof Feature) && !(parent instanceof Resource)) {
                }
                if (parent instanceof Resource) {
                    file = JavaModel.getFileObject((Resource)((Resource)parent));
                    parent = file.getParent();
                }
            } else {
                ((NamedElement)representedObject).getResource();
            }
            if (representedObject instanceof JavaClass) {
                JavaClass jc = (JavaClass)representedObject;
                displayName = jc.getSimpleName();
            } else {
                displayName = ((NamedElement)representedObject).getName();
            }
            resourceID = IconResolver.getIconBase((Feature)((Feature)representedObject));
            if (representedObject instanceof Constructor) {
                displayName = ((JavaClass)((Constructor)representedObject).getDeclaringClass()).getSimpleName();
            } else if (representedObject instanceof Initializer) {
                displayName = RefactoringPanel.getString("LBL_Initializer");
            }
        } else if (representedObject instanceof JavaPackage) {
            resourceID = "org/netbeans/modules/refactoring/resources/package";
            displayName = ((JavaPackage)representedObject).getName();
            if ("".equals(displayName)) {
                displayName = NbBundle.getMessage((Class)RefactoringPanel.class, (String)"LBL_DefaultPackage");
            }
            parent = null;
        } else if (representedObject instanceof ClassDefinition) {
            displayName = RefactoringPanel.getString("LBL_AnonymousClass");
            parent = isLogical ? JavaModelUtil.getDeclaringFeature((Element)((ClassDefinition)representedObject)) : ((Element)representedObject).getResource();
        } else if (representedObject instanceof Resource) {
            resourceID = "org/netbeans/modules/java/resources/class";
            String relativeName = ((Resource)representedObject).getName();
            displayName = relativeName.substring(relativeName.lastIndexOf(47) + 1);
            FileObject file2 = JavaModel.getFileObject((Resource)((Resource)representedObject));
            parent = isLogical ? file2.getParent() : FileOwnerQuery.getOwner((FileObject)file2);
        } else if (representedObject instanceof FileObject) {
            DataObject dob;
            file = (FileObject)representedObject;
            try {
                dob = DataObject.find((FileObject)((FileObject)representedObject));
            }
            catch (DataObjectNotFoundException notFound) {
                throw (RuntimeException)new RuntimeException().initCause(notFound);
            }
            if (!$assertionsDisabled && dob == null) {
                throw new AssertionError();
            }
            Node n = dob.getNodeDelegate();
            if (!$assertionsDisabled && n == null) {
                throw new AssertionError();
            }
            if (file.isFolder()) {
                resourceID = "org/netbeans/modules/refactoring/resources/package";
                parent = this.getSourceGroup(file);
                displayName = ClassPath.getClassPath((FileObject)file, (String)"classpath/source").getResourceName(file).replace('/', '.');
                if ("".equals(displayName)) {
                    displayName = NbBundle.getMessage((Class)RefactoringPanel.class, (String)"LBL_DefaultPackage");
                }
            } else {
                icon = new ImageIcon(n.getIcon(1));
                if (isLogical) {
                    if (this.getSourceGroup(file) == null) {
                        parent = FileOwnerQuery.getOwner((FileObject)file);
                        displayName = parent != null ? FileUtil.getRelativePath((FileObject)((Project)parent).getProjectDirectory(), (FileObject)file) : ClassPath.getClassPath((FileObject)file, (String)"classpath/source").getResourceName(file);
                    } else {
                        parent = file.getParent();
                        displayName = n.getDisplayName();
                    }
                } else {
                    parent = FileOwnerQuery.getOwner((FileObject)file);
                    displayName = n.getDisplayName();
                }
            }
        } else if (representedObject instanceof Variable) {
            displayName = ((NamedElement)representedObject).getName();
            resourceID = IconResolver.getIconBaseForVariable((Variable)((Variable)representedObject));
            parent = isLogical ? JavaModelUtil.getDeclaringFeature((Element)((Variable)representedObject)) : ((Element)representedObject).getResource();
        }
        node = new CheckNode(representedObject, displayName, (Icon)(resourceID == null ? (icon == null ? null : icon) : new ImageIcon(Utilities.loadImage((String)(resourceID + ".gif")))));
        if (cannotEnable) {
            node.setDisabled();
        }
        CheckNode parentNode = parent == null ? root : this.createNode(parent, nodes, root);
        parentNode.add(node);
        if (representedObject instanceof SourceGroup) {
            nodes.put(((SourceGroup)representedObject).getRootFolder(), node);
        } else {
            nodes.put(representedObject, node);
        }
        return node;
    }

    private String getPrefix(Element element) {
        if (element instanceof Constructor) {
            return ((JavaClass)((Constructor)element).getDeclaringClass()).getSimpleName() + "() ... ";
        }
        if (element instanceof Method) {
            return ((NamedElement)element).getName() + "() ... ";
        }
        if (element instanceof Initializer) {
            return RefactoringPanel.getString("LBL_Initializer") + " ... ";
        }
        if (element instanceof Field) {
            return ((NamedElement)element).getName() + " ... ";
        }
        return null;
    }

    private static final String getString(String key) {
        return NbBundle.getMessage((Class)RefactoringPanel.class, (String)key);
    }

    private SourceGroup getSourceGroup(FileObject file) {
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        if (prj == null) {
            return null;
        }
        Sources src = ProjectUtils.getSources((Project)prj);
        SourceGroup[] groups = src.getSourceGroups("java");
        for (int i = 0; i < groups.length; ++i) {
            if (!groups[i].getRootFolder().equals(file) && !FileUtil.isParentOf((FileObject)groups[i].getRootFolder(), (FileObject)file)) continue;
            return groups[i];
        }
        return null;
    }

    protected void updateTitle() {
    }

    private void refactor() {
        RefactoringPanel.checkEventThread();
        RefactoringPanel.disableComponents(this);
        this.progressListener = new ProgressL();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RefactoringPanel.this.session.addProgressListener(RefactoringPanel.this.progressListener);
                    RefactoringPanel.this.session.doRefactoring(true);
                    RefactoringPanel.this.session.removeProgressListener(RefactoringPanel.this.progressListener);
                }
                catch (Throwable throwable) {
                    RefactoringPanel.this.session.removeProgressListener(RefactoringPanel.this.progressListener);
                    RefactoringPanel.this.progressListener = null;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            RefactoringPanel.this.close();
                        }
                    });
                    throw throwable;
                }
                RefactoringPanel.this.progressListener = null;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private int cancel() {
        RefactoringPanel.checkEventThread();
        this.close();
        return 0;
    }

    void close() {
        if (this.isQuery) {
            RefactoringPanelContainer.getUsagesComponent().removePanel(this);
        } else {
            RefactoringPanelContainer.getRefactoringComponent().removePanel(this);
        }
        this.closeNotify();
    }

    private ButtonL getButtonListener() {
        if (this.buttonListener == null) {
            this.buttonListener = new ButtonL();
        }
        return this.buttonListener;
    }

    public void expandAll() {
        RefactoringPanel.checkEventThread();
        final Cursor old = this.getCursor();
        this.expandButton.setEnabled(false);
        this.scrollPane.getViewport().remove(this.tree);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.rp.post(new Runnable(){

            public void run() {
                for (int row = 0; row < RefactoringPanel.this.tree.getRowCount(); ++row) {
                    RefactoringPanel.this.tree.expandRow(row);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RefactoringPanel.this.scrollPane.setViewportView(RefactoringPanel.this.tree);
                        RefactoringPanel.this.setCursor(old);
                        RefactoringPanel.this.expandButton.setEnabled(true);
                        RefactoringPanel.this.expandButton.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"HINT_collapseAll"));
                        RefactoringPanel.this.requestFocus();
                    }
                });
            }
        });
    }

    public void collapseAll() {
        RefactoringPanel.checkEventThread();
        this.expandButton.setEnabled(false);
        final Cursor old = this.getCursor();
        this.scrollPane.getViewport().remove(this.tree);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.rp.post(new Runnable(){

            public void run() {
                for (int row = RefactoringPanel.this.tree.getRowCount() - 1; row > 0; --row) {
                    RefactoringPanel.this.tree.collapseRow(row);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        RefactoringPanel.this.scrollPane.setViewportView(RefactoringPanel.this.tree);
                        RefactoringPanel.this.setCursor(old);
                        RefactoringPanel.this.expandButton.setEnabled(true);
                        RefactoringPanel.this.expandButton.setToolTipText(NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"HINT_expandAll"));
                        RefactoringPanel.this.requestFocus();
                    }
                });
            }
        });
    }

    public void invalidateObject() {
        if (this.isQuery) {
            return;
        }
        Runnable invalidate = new Runnable(){

            public void run() {
                RefactoringPanel.this.setRefactoringEnabled(false, false);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            invalidate.run();
        } else {
            SwingUtilities.invokeLater(invalidate);
        }
    }

    private void refresh(final boolean showParametersPanel) {
        RefactoringPanel.checkEventThread();
        if (!this.isQuery) {
            JavaMetamodel.getUndoManager().saveAll();
        }
        if (showParametersPanel) {
            RefactoringSession tempSession;
            if (this.parametersPanel == null) {
                this.parametersPanel = new ParametersPanel(this.ui);
            }
            if ((tempSession = this.parametersPanel.showDialog()) == null) {
                return;
            }
            this.session = tempSession;
        }
        final String description = this.ui.getDescription();
        this.setToolTipText("<html>" + description + "</html>");
        final Collection elements = this.session.getRefactoringElements();
        this.setName(this.ui.getName());
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)RefactoringPanel.class, (String)(this.isQuery ? "LBL_PreparingUsagesTree" : "LBL_PreparingRefactoringTree")));
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HashSet<CloneableEditorSupport> editorSupports = new HashSet<CloneableEditorSupport>();
                int errorsNum = 0;
                if (!RefactoringPanel.this.isQuery) {
                    Iterator iter = elements.iterator();
                    while (iter.hasNext()) {
                        RefactoringElement elem = (RefactoringElement)iter.next();
                        if (elem.getStatus() != 2 && elem.getStatus() != 3) continue;
                        ++errorsNum;
                    }
                }
                int occurencesNum = elements.size();
                StringBuffer errorsDesc = new StringBuffer();
                errorsDesc.append(" [" + occurencesNum);
                errorsDesc.append(' ');
                errorsDesc.append(occurencesNum == 1 ? NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_Occurence") : NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_Occurences"));
                if (errorsNum > 0) {
                    errorsDesc.append(',');
                    errorsDesc.append(' ');
                    errorsDesc.append("<font color=#CC0000>" + errorsNum);
                    errorsDesc.append(' ');
                    errorsDesc.append(errorsNum == 1 ? NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_Error") : NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_Errors"));
                    errorsDesc.append("</font>");
                }
                errorsDesc.append(']');
                final CheckNode root = new CheckNode(null, description + errorsDesc.toString(), new ImageIcon(Utilities.loadImage((String)("org/netbeans/modules/refactoring/resources/" + (RefactoringPanel.this.isQuery ? "findusages.png" : "refactoring.gif")))));
                HashMap nodes = new HashMap();
                Cursor old = RefactoringPanel.this.getCursor();
                RefactoringPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                progressHandle.start(elements.size() / 10);
                int i = 0;
                try {
                    JavaModel.getJavaRepository().beginTrans(false);
                    try {
                        Iterator it = elements.iterator();
                        while (it.hasNext()) {
                            RefactoringElement e = (RefactoringElement)it.next();
                            RefactoringPanel.this.createNode(e, nodes, root);
                            PositionBounds pb = e.getPosition();
                            if (pb != null) {
                                CloneableEditorSupport ces = pb.getBegin().getCloneableEditorSupport();
                                editorSupports.add(ces);
                            }
                            if (i % 10 == 0) {
                                progressHandle.progress(i / 10);
                            }
                            ++i;
                        }
                    }
                    finally {
                        JavaModel.getJavaRepository().endTrans();
                    }
                    JavaMetamodel.getUndoManager().watch(editorSupports, (InvalidationListener)RefactoringPanel.this);
                }
                finally {
                    progressHandle.finish();
                    RefactoringPanel.this.setCursor(old);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (RefactoringPanel.this.tree == null) {
                            RefactoringPanel.this.tree = new JTree(root){

                                public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
                                    try {
                                        return super.getNextMatch(prefix, startingRow, bias);
                                    }
                                    catch (NullPointerException e) {
                                        return null;
                                    }
                                }
                            };
                            ToolTipManager.sharedInstance().registerComponent(RefactoringPanel.this.tree);
                            RefactoringPanel.this.tree.setCellRenderer(new CheckRenderer(RefactoringPanel.this.isQuery));
                            String s = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"ACSD_usagesTree");
                            RefactoringPanel.this.tree.getAccessibleContext().setAccessibleDescription(s);
                            RefactoringPanel.this.tree.getAccessibleContext().setAccessibleName(s);
                            CheckNodeListener l = new CheckNodeListener(RefactoringPanel.this.isQuery);
                            RefactoringPanel.this.tree.addMouseListener(l);
                            RefactoringPanel.this.tree.addKeyListener(l);
                            RefactoringPanel.this.tree.setToggleClickCount(0);
                            RefactoringPanel.this.scrollPane = new JScrollPane(RefactoringPanel.this.tree);
                            RefactoringPanel.this.add((Component)RefactoringPanel.this.scrollPane, "Center");
                            RefactoringPanel.this.validate();
                        } else {
                            RefactoringPanel.this.tree.setModel(new DefaultTreeModel(root));
                        }
                        RefactoringPanel.this.tree.setRowHeight((int)((CheckRenderer)RefactoringPanel.this.tree.getCellRenderer()).getPreferredSize().getHeight());
                        if (showParametersPanel) {
                            if (elements.size() < 50) {
                                RefactoringPanel.this.expandAll();
                            } else {
                                RefactoringPanel.this.expandButton.setSelected(false);
                            }
                        } else if (RefactoringPanel.this.expandButton.isSelected()) {
                            RefactoringPanel.this.expandAll();
                        } else {
                            RefactoringPanel.this.expandButton.setSelected(false);
                        }
                        RefactoringPanel.this.tree.setSelectionRow(0);
                        RefactoringPanel.this.requestFocus();
                        RefactoringPanel.this.setRefactoringEnabled(true, true);
                    }
                });
            }
        });
        if (!this.isVisible) {
            RefactoringPanelContainer cont = this.isQuery ? RefactoringPanelContainer.getUsagesComponent() : RefactoringPanelContainer.getRefactoringComponent();
            cont.open();
            cont.requestActive();
            cont.addPanel(this);
            this.isVisible = true;
        }
        this.setRefactoringEnabled(false, true);
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.refactorButton != null) {
            this.refactorButton.requestFocus();
        } else if (this.tree != null) {
            this.tree.requestFocus();
        }
    }

    void setRefactoringEnabled(boolean enabled, boolean isRefreshing) {
        RefactoringPanel.checkEventThread();
        if (this.tree != null) {
            if (!enabled) {
                CheckNode c = (CheckNode)this.tree.getModel().getRoot();
                if (!isRefreshing) {
                    c.setNeedsRefresh();
                } else {
                    c.setDisabled();
                }
                this.tree.setModel(new DefaultTreeModel(c, false));
            }
            this.tree.setEnabled(enabled);
            if (this.refactorButton != null) {
                this.refactorButton.setEnabled(enabled);
            }
        }
    }

    private static void disableComponents(Container c) {
        RefactoringPanel.checkEventThread();
        Component[] children = c.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isEnabled()) {
                children[i].setEnabled(false);
            }
            if (!(children[i] instanceof Container)) continue;
            RefactoringPanel.disableComponents((Container)children[i]);
        }
    }

    void selectNextUsage() {
        this.selectNextPrev(true);
    }

    void selectPrevUsage() {
        this.selectNextPrev(false);
    }

    private void selectNextPrev(boolean next) {
        CheckNode node;
        int newRow = this.getSelectedRow();
        int maxcount = this.tree.getRowCount();
        do {
            TreePath path;
            if (next) {
                if (++newRow >= maxcount) {
                    newRow = 0;
                }
            } else if (--newRow < 0) {
                newRow = maxcount - 1;
            }
            if ((node = (CheckNode)(path = this.tree.getPathForRow(newRow)).getLastPathComponent()).isLeaf()) continue;
            this.tree.expandRow(newRow);
            maxcount = this.tree.getRowCount();
        } while (!node.isLeaf());
        this.tree.setSelectionRow(newRow);
        CheckNodeListener.findInSource(node);
    }

    private int getSelectedRow() {
        int[] rows = this.tree.getSelectionRows();
        if (rows == null || rows.length == 0) {
            return 0;
        }
        return rows[0];
    }

    private static String normalize(String input) {
        int size = input.length();
        char[] c = new char[size];
        input.getChars(0, size, c, 0);
        boolean wb = false;
        int pos = 0;
        char[] nc = new char[size];
        for (int i = 0; i < size; ++i) {
            if (Character.isWhitespace(c[i])) {
                if (wb) continue;
                nc[pos++] = 32;
                wb = true;
                continue;
            }
            nc[pos++] = c[i];
            wb = false;
        }
        return new String(nc, 0, pos);
    }

    protected void closeNotify() {
        TopComponent tc;
        UndoWatcher.stopWatching(this);
        if (this.tree != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.tree);
            if (this.scrollPane != null) {
                this.scrollPane.getViewport().remove(this.tree);
            }
        }
        if (this.scrollPane != null) {
            this.scrollPane.setViewport(null);
        }
        if (this.refCallerTC != null && (tc = (TopComponent)this.refCallerTC.get()) != null && tc.isShowing()) {
            tc.requestActive();
        }
    }

    static {
        $assertionsDisabled = !RefactoringPanel.class.desiredAssertionStatus();
        PACKAGE_BADGE = Utilities.loadImage((String)"org/netbeans/spi/java/project/support/ui/packageBadge.gif");
    }

    private static class ProgressL
    implements ProgressListener {
        private ProgressHandle handle;
        private Dialog d;
        private int counter;

        private ProgressL() {
        }

        public void start(final ProgressEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressL.this.counter = 0;
                    String lab = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_RefactorProgressLabel");
                    ProgressL.this.handle = ProgressHandleFactory.createHandle((String)lab);
                    JComponent progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)ProgressL.this.handle);
                    JPanel component = new JPanel();
                    component.setLayout(new BorderLayout());
                    component.setBorder(new EmptyBorder(12, 12, 11, 11));
                    JLabel label = new JLabel(lab);
                    label.setBorder(new EmptyBorder(0, 0, 6, 0));
                    component.add((Component)label, "North");
                    component.add((Component)progress, "Center");
                    DialogDescriptor desc = new DialogDescriptor((Object)component, NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$ui$RefactoringPanel == null ? (class$org$netbeans$modules$refactoring$ui$RefactoringPanel = RefactoringPanel.class$("org.netbeans.modules.refactoring.ui.RefactoringPanel")) : class$org$netbeans$modules$refactoring$ui$RefactoringPanel), (String)"LBL_RefactoringInProgress"), true, new Object[0], null, 0, null, null);
                    desc.setLeaf(true);
                    ProgressL.this.d = DialogDisplayer.getDefault().createDialog(desc);
                    ((JDialog)ProgressL.this.d).setDefaultCloseOperation(0);
                    ProgressL.this.handle.start(event.getCount());
                    ProgressL.this.d.show();
                }
            });
        }

        public void step(ProgressEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressL.this.handle.progress(++ProgressL.this.counter);
                }
            });
        }

        public void stop(ProgressEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressL.this.handle.finish();
                    try {
                        Thread.currentThread();
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ProgressL.this.d.hide();
                }
            });
        }
    }

    private class ButtonL
    implements ActionListener {
        private ButtonL() {
        }

        public void actionPerformed(ActionEvent event) {
            Object o = event.getSource();
            if (o == RefactoringPanel.this.cancelButton) {
                RefactoringPanel.this.cancel();
            } else if (o == RefactoringPanel.this.refactorButton) {
                RefactoringPanel.this.refactor();
            } else if (o == RefactoringPanel.this.rerunButton) {
                RefactoringPanel.this.close();
                RefactoringPanel.this.callback.actionPerformed(event);
            } else if (o == RefactoringPanel.this.expandButton && RefactoringPanel.this.tree != null) {
                if (RefactoringPanel.this.expandButton.isSelected()) {
                    RefactoringPanel.this.expandAll();
                } else {
                    RefactoringPanel.this.collapseAll();
                }
            } else if (o == RefactoringPanel.this.refreshButton) {
                RefactoringPanel.this.refresh(true);
            } else if (o == RefactoringPanel.this.physicalViewButton) {
                RefactoringPanel.this.switchToPhysicalView();
            } else if (o == RefactoringPanel.this.logicalViewButton) {
                RefactoringPanel.this.switchToLogicalView();
            } else if (o == RefactoringPanel.this.nextMatch) {
                RefactoringPanel.this.selectNextUsage();
            } else if (o == RefactoringPanel.this.prevMatch) {
                RefactoringPanel.this.selectPrevUsage();
            }
        }
    }
}

